/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.kgga.command.task;

import edu.sysu.pmglab.annotation.VarGeneFeatureType;
import edu.sysu.pmglab.annotation.database.gene.IGeneFeature;
import edu.sysu.pmglab.bytecode.ASCIIUtility;
import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.ccf.field.FieldGroupMeta;
import edu.sysu.pmglab.ccf.field.FieldMeta;
import edu.sysu.pmglab.ccf.toolkit.Processor;
import edu.sysu.pmglab.ccf.toolkit.converter.Variant2TextRecord;
import edu.sysu.pmglab.ccf.toolkit.input.GTBInputOption;
import edu.sysu.pmglab.ccf.toolkit.listener.InputOutputListener;
import edu.sysu.pmglab.ccf.toolkit.output.TextOutputOption;
import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.indexable.LinkedSet;
import edu.sysu.pmglab.container.list.IntList;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.container.list.ShortList;
import edu.sysu.pmglab.executor.Context;
import edu.sysu.pmglab.executor.ITask;
import edu.sysu.pmglab.executor.Status;
import edu.sysu.pmglab.executor.track.ITrack;
import edu.sysu.pmglab.gtb.GTBManager;
import edu.sysu.pmglab.gtb.GTBReaderOption;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.io.FileUtils;
import edu.sysu.pmglab.io.text.TextRecord;
import edu.sysu.pmglab.io.text.writer.IHeaderFormatter;
import edu.sysu.pmglab.kgga.command.SetupApplication;
import edu.sysu.pmglab.kgga.command.TaskTracker;
import edu.sysu.pmglab.kgga.command.pipeline.GeneralIOOptions;
import edu.sysu.pmglab.kgga.io.InputOutputFileSet;
import java.io.File;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.Optional;
import java.util.function.BiConsumer;

public class OutputVariants2TSVTask
implements ITask {
    File outputFile;
    String[] otherOutputFields;
    boolean toOutputGeneFeature = false;
    boolean standardOutput = true;
    boolean addGeneFeatureDetails = true;
    boolean hasGeneFeature = true;
    String[] customizedGroups;
    int threadNum = 4;

    public OutputVariants2TSVTask(File outputDir, int threadNum) {
        this.outputFile = FileUtils.getSubFile(outputDir, InputOutputFileSet.getOutputFileName());
        this.threadNum = threadNum;
    }

    public OutputVariants2TSVTask(File outputDir, boolean hasGeneFeature, int threadNum) {
        this.outputFile = FileUtils.getSubFile(outputDir, InputOutputFileSet.getOutputFileName());
        this.threadNum = threadNum;
        this.hasGeneFeature = hasGeneFeature;
    }

    public OutputVariants2TSVTask(File outputDir, String[] customizedGroups, String[] otherOutputFields) {
        this.outputFile = FileUtils.getSubFile(outputDir, InputOutputFileSet.getOutputFileName());
        this.otherOutputFields = otherOutputFields;
        this.customizedGroups = customizedGroups;
        this.standardOutput = false;
    }

    public OutputVariants2TSVTask(GeneralIOOptions inputsOptions, File outputDir, String[] otherOutputFields, boolean toOutputGeneFeature) {
        this.outputFile = FileUtils.getSubFile(outputDir, InputOutputFileSet.getOutputFileName());
        this.otherOutputFields = otherOutputFields;
        this.toOutputGeneFeature = toOutputGeneFeature;
    }

    private IndexableSet<String> defineCustomizedOutputFields(GTBManager inputManager, IndexableSet<String> customizedOutputFieldsNoGroup) {
        LinkedSet<String> customizedOutputFields = new LinkedSet<String>();
        if (this.customizedGroups != null) {
            for (String groupName : this.customizedGroups) {
                FieldGroupMeta fields = inputManager.getFieldGroup(groupName);
                for (FieldMeta field : fields) {
                    ((AbstractCollection)customizedOutputFields).add(field.simpleName());
                }
            }
        }
        if (this.otherOutputFields != null) {
            customizedOutputFields.addAll(this.otherOutputFields);
        }
        for (String field : customizedOutputFields) {
            int index = field.lastIndexOf(":");
            if (index >= 0) {
                customizedOutputFieldsNoGroup.add(field.substring(index + 1));
                continue;
            }
            customizedOutputFieldsNoGroup.add(field);
        }
        return customizedOutputFields;
    }

    private String variantClassification(IndexableSet<String> alleles, int id) {
        if (id == 0) {
            if (alleles.valueOf(0).length() > alleles.valueOf(1).length()) {
                return "Frame_Shift_Del";
            }
            return "Frame_Shift_Ins";
        }
        if (id == 1) {
            if (alleles.valueOf(0).length() > alleles.valueOf(1).length()) {
                return "In_Frame_Del";
            }
            return "In_Frame_Ins";
        }
        if (id == 2) {
            return "Translation_Start_Site";
        }
        if (id == 3) {
            return "Nonstop_Mutation";
        }
        if (id == 4) {
            return "Nonsense_Mutation";
        }
        if (id == 5) {
            return "Splice_Site";
        }
        if (id == 6) {
            return "Missense_Mutation";
        }
        if (id == 7) {
            return "Silent";
        }
        if (id == 8) {
            return "Exon";
        }
        if (id == 9) {
            return "5'UTR";
        }
        if (id == 10) {
            return "3'UTR";
        }
        if (id == 11) {
            return "Intron";
        }
        if (id == 12) {
            return "5'Flank";
        }
        if (id == 13) {
            return "3'Flank";
        }
        if (id == 14) {
            return "RNA";
        }
        if (id == 15) {
            return "IGR";
        }
        return "Unknown";
    }

    private TextOutputOption defineCustomizedOutputOptions(GTBManager inputManager, IndexableSet<String> customizedOutputFields, IndexableSet<String> customizedOutputFieldsNoGroup, Context context) {
        IndexableSet geneSymbolMap = (IndexableSet)context.cast("geneSymbolIDMap");
        IndexableSet geneIDMap = (IndexableSet)context.cast("geneIDMap");
        IndexableSet transcriptIDMap = (IndexableSet)context.cast("transcriptIDMap");
        boolean hasRefGene = inputManager.containsField("GeneFeature@RefGene");
        boolean hasGEncode = inputManager.containsField("GeneFeature@GENCODE");
        boolean hasKnownGene = inputManager.containsField("GeneFeature@KnownGene");
        TextOutputOption outputOption = new TextOutputOption(this.outputFile).setHeaderFormatter(IHeaderFormatter.DIRECTLY);
        for (String field : customizedOutputFields) {
            if (field.equals("MarkFeatureGene")) continue;
            outputOption.addField(field);
        }
        return outputOption;
    }

    private IndexableSet<String> defineStandardInputFields(GTBManager inputManager) {
        LinkedSet<String> standardGtbInputFields = this.hasGeneFeature ? new LinkedSet<String>(new String[]{"CHROM", "POS", "REF", "ALT", "MarkFeatureGene", "MarkGeneFeature", "HitGenes", "HitGeneFeatures"}) : new LinkedSet<String>(new String[]{"CHROM", "POS", "REF", "ALT"});
        if (this.addGeneFeatureDetails) {
            if (inputManager.containsField("GeneFeature@RefGene")) {
                ((AbstractCollection)standardGtbInputFields).add("GeneFeature@RefGene");
            }
            if (inputManager.containsField("GeneFeature@GENCODE")) {
                ((AbstractCollection)standardGtbInputFields).add("GeneFeature@GENCODE");
            }
            if (inputManager.containsField("GeneFeature@KnownGene")) {
                ((AbstractCollection)standardGtbInputFields).add("GeneFeature@KnownGene");
            }
        }
        if (this.otherOutputFields == null) {
            Iterable<FieldGroupMeta> allFieldGroups = inputManager.getAllFieldGroups();
            for (FieldGroupMeta fieldGroup : allFieldGroups) {
                for (FieldMeta field : fieldGroup) {
                    if (field.fullName().startsWith("GeneFeature@") || field.fullName().startsWith("SOURCE@") && !field.fullName().endsWith("_CHROM") && !field.fullName().endsWith("_POS")) continue;
                    ((AbstractCollection)standardGtbInputFields).add(field.fullName());
                }
            }
        } else {
            standardGtbInputFields.addAll((String[])this.otherOutputFields);
        }
        return standardGtbInputFields;
    }

    private void standardOutput(GTBManager inputManager, IndexableSet<String> gtbInputFields, Context context) throws IOException {
        IndexableSet geneSymbolMap = (IndexableSet)context.cast("geneSymbolIDMap");
        IndexableSet geneIDMap = (IndexableSet)context.cast("geneIDMap");
        IndexableSet transcriptIDMap = (IndexableSet)context.cast("transcriptIDMap");
        boolean hasRefGene = inputManager.containsField("GeneFeature@RefGene");
        boolean hasGEncode = inputManager.containsField("GeneFeature@GENCODE");
        boolean hasKnownGene = inputManager.containsField("GeneFeature@KnownGene");
        LinkedSet<String> compulsoryOutputFields = List.wrap("CHROM", "POS", "REF", "ALT", "MarkFeatureGene", "MarkGeneFeature", "HitGenes", "HitGeneFeatures", "GeneFeatureDetails").toIndexableSet();
        List<String> diffOutputFields = new List<String>();
        for (String name : gtbInputFields) {
            if (name.startsWith("GeneFeature@") || ((IndexableSet)compulsoryOutputFields).contains(name)) continue;
            diffOutputFields.add(name);
        }
        TextOutputOption outputOption = new TextOutputOption(this.outputFile).addField("CHROM").addField("POS").addField("REF").addField("ALT").addMeta(inputManager.getMeta()).dropDuplicateMeta();
        List<BiConsumer<Variant, TextRecord>> valueGetters = new List<BiConsumer<Variant, TextRecord>>();
        valueGetters.add((variant, output) -> output.set("CHROM", variant.getChromosome().toBytes()));
        valueGetters.add((variant, output) -> output.set("POS", new Bytes(ASCIIUtility.toASCII(variant.getPosition()))));
        valueGetters.add((variant, output) -> output.set("REF", variant.numOfAlleles() >= 1 ? variant.alleleOfIndex(0) : "."));
        valueGetters.add((variant, output) -> {
            if (variant.numOfAlleles() <= 1) {
                output.set("ALT", ".");
            } else {
                ByteStream container = ByteStream.getThreadInstance();
                for (int i = 1; i < variant.numOfAlleles(); ++i) {
                    container.writeChar(variant.alleleOfIndex(i));
                    container.write(44);
                }
                container.wSeek(container.wTell() - 1);
                output.set("ALT", container.toBytes(true));
            }
        });
        if (this.hasGeneFeature) {
            outputOption.addField("GeneFeature@MarkFeatureGene");
            outputOption.addField("GeneFeature@MarkGeneFeature");
            valueGetters.add((variant, output) -> {
                if (variant.getProperty("GeneFeature@MarkFeatureGene") == null) {
                    output.set("GeneFeature@MarkFeatureGene", ".");
                } else {
                    int geneIndex = (Integer)variant.getProperty("GeneFeature@MarkFeatureGene");
                    if (geneIndex < 0) {
                        output.set("GeneFeature@MarkFeatureGene", ".");
                    } else {
                        output.set("GeneFeature@MarkFeatureGene", (String)geneSymbolMap.valueOf(geneIndex));
                    }
                }
            });
            valueGetters.add((variant, output) -> {
                if (variant.getProperty("GeneFeature@MarkGeneFeature") == null) {
                    output.set("GeneFeature@MarkGeneFeature", ".");
                } else {
                    int geneIndex = (Integer)variant.getProperty("GeneFeature@MarkGeneFeature");
                    if (geneIndex < 0) {
                        output.set("GeneFeature@MarkGeneFeature", ".");
                    } else {
                        output.set("GeneFeature@MarkGeneFeature", VarGeneFeatureType.getFeatureName((Integer)variant.getProperty("GeneFeature@MarkGeneFeature")));
                    }
                }
            });
            if (this.addGeneFeatureDetails) {
                outputOption.addField("GeneFeature@GeneFeatureDetails");
                valueGetters.add((variant, output) -> {
                    ByteStream cache = ByteStream.getThreadInstance();
                    if (hasRefGene) {
                        for (IGeneFeature geneFeature : IGeneFeature.instancesOf((List)variant.getProperty("GeneFeature@RefGene"))) {
                            cache.write(geneFeature.toDetail(geneSymbolMap, geneIDMap, transcriptIDMap));
                            cache.write(59);
                        }
                    }
                    if (hasGEncode) {
                        for (IGeneFeature geneFeature : IGeneFeature.instancesOf((List)variant.getProperty("GeneFeature@GENCODE"))) {
                            cache.write(geneFeature.toDetail(geneSymbolMap, geneIDMap, transcriptIDMap));
                            cache.write(59);
                        }
                    }
                    if (hasKnownGene) {
                        for (IGeneFeature geneFeature : IGeneFeature.instancesOf((List)variant.getProperty("GeneFeature@KnownGene"))) {
                            cache.write(geneFeature.toDetail(geneSymbolMap, geneIDMap, transcriptIDMap));
                            cache.write(59);
                        }
                    }
                    if (cache.length() == 0) {
                        output.set("GeneFeature@GeneFeatureDetails", ".");
                    } else {
                        cache.wSeek(cache.wTell() - 1);
                        output.set("GeneFeature@GeneFeatureDetails", cache.toBytes(true));
                    }
                });
            }
            outputOption.addField("GeneFeature@HitGenes");
            valueGetters.add((variant, output) -> {
                ThreadLocal<ByteStream> caches = ThreadLocal.withInitial(ByteStream::new);
                if (variant.getProperty("GeneFeature@HitGenes") == null) {
                    output.set("GeneFeature@HitGenes", ".");
                } else {
                    ByteStream cache = caches.get();
                    cache.clear();
                    IntList indexes = (IntList)variant.getProperty("GeneFeature@HitGenes");
                    for (int i = 0; i < indexes.size(); ++i) {
                        int index = indexes.fastGet(i);
                        if (index < 0) continue;
                        cache.write(((String)geneSymbolMap.valueOf(index)).getBytes());
                        cache.write(44);
                    }
                    if (cache.length() == 0) {
                        output.set("GeneFeature@HitGenes", ".");
                    } else {
                        cache.wSeek(cache.wTell() - 1);
                        output.set("GeneFeature@HitGenes", cache.toBytes(true));
                    }
                }
            });
            outputOption.addField("GeneFeature@HitGeneFeatures");
            valueGetters.add((variant, output) -> {
                ThreadLocal<ByteStream> caches = ThreadLocal.withInitial(ByteStream::new);
                if (variant.getProperty("GeneFeature@HitGeneFeatures") == null) {
                    output.set("GeneFeature@HitGeneFeatures", ".");
                } else {
                    ByteStream cache = caches.get();
                    cache.clear();
                    ShortList indexes = (ShortList)variant.getProperty("GeneFeature@HitGeneFeatures");
                    for (int i = 0; i < indexes.size(); ++i) {
                        short index = indexes.fastGet(i);
                        if (index < 0) continue;
                        cache.write(this.variantClassification(variant.getAlleles(), index).getBytes());
                        cache.write(44);
                    }
                    if (cache.length() == 0) {
                        output.set("GeneFeature@HitGeneFeatures", ".");
                    } else {
                        cache.wSeek(cache.wTell() - 1);
                        output.set("GeneFeature@HitGeneFeatures", cache.toBytes(true));
                    }
                }
            });
        }
        outputOption.addFields(diffOutputFields);
        Processor.setInput(new GTBInputOption(new GTBReaderOption(inputManager, false, true))).setOutput(outputOption).bridge(new Variant2TextRecord((IndexableSet<String>)outputOption.getAllFields()).setValue((input, output) -> {
            for (String field : output.keys()) {
                output.set(field, input.getPropertyAsString(field));
            }
            for (BiConsumer valueGetter : valueGetters) {
                valueGetter.accept(input, output);
            }
            return true;
        })).setListener(new InputOutputListener()).submit(this.threadNum);
    }

    @Override
    public void execute(Status status, Context context) throws Exception, Error {
        ITrack track = context.getTracker();
        File liveFile = (File)context.cast("AnnotationBaseVariantSet");
        GTBManager inputManager = new GTBManager(liveFile);
        Boolean updatedVariantSet = (Boolean)context.cast("UpdatedBaseVariantSet");
        if (updatedVariantSet == null) {
            updatedVariantSet = false;
        }
        TaskTracker.TaskResult completeTaskResult = new TaskTracker.TaskResult(this.getClass().getName(), String.valueOf(inputManager.hashCode()), this.digest());
        Optional<File> outputPathOpt = SetupApplication.GlobalTaskTracker.checkTask(completeTaskResult);
        outputPathOpt.ifPresent(file -> {
            this.outputFile = file;
        });
        if (updatedVariantSet.booleanValue() || !this.outputFile.exists() || !outputPathOpt.isPresent()) {
            IndexableSet<String> gtbInputFields;
            if (inputManager.numOfVariants() == 0L) {
                SetupApplication.GlobalLogger.info("No variants are retained for output finally!");
                return;
            }
            String[] inputFieldNames = null;
            LinkedSet<String> customizedOutputFieldsNoHead = new LinkedSet<String>();
            if (this.standardOutput) {
                gtbInputFields = this.defineStandardInputFields(inputManager);
                this.standardOutput(inputManager, gtbInputFields, context);
            } else {
                gtbInputFields = this.defineCustomizedOutputFields(inputManager, customizedOutputFieldsNoHead);
                TextOutputOption textOutputOption = this.defineCustomizedOutputOptions(inputManager, gtbInputFields, customizedOutputFieldsNoHead, context);
            }
            inputFieldNames = gtbInputFields.toArray(new String[0]);
            completeTaskResult.setOutputPath(this.outputFile);
            SetupApplication.GlobalTaskTracker.recordTaskCompletion(completeTaskResult);
        }
        SetupApplication.GlobalLogger.info("{} retained variants and annotations are saved in {}.", (Object)inputManager.numOfVariants(), (Object)this.outputFile);
    }

    private String digest() {
        StringBuilder sb = new StringBuilder(256);
        sb.append("OutputTSV");
        return ITrack.digest(sb.toString());
    }
}

