/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.kgga.command.task;

import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.list.IntList;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.executor.Context;
import edu.sysu.pmglab.executor.ITask;
import edu.sysu.pmglab.executor.Status;
import edu.sysu.pmglab.executor.track.ITrack;
import edu.sysu.pmglab.gtb.GTBManager;
import edu.sysu.pmglab.io.FileUtils;
import edu.sysu.pmglab.io.writer.WriterStream;
import edu.sysu.pmglab.kgga.command.SetupApplication;
import edu.sysu.pmglab.kgga.command.Utility;
import edu.sysu.pmglab.kgga.command.pipeline.AnnotationOptions;
import edu.sysu.pmglab.kgga.command.pipeline.GeneralIOOptions;
import edu.sysu.pmglab.kgga.command.pipeline.SimulationOptions;
import edu.sysu.pmglab.kgga.command.setting.PhenotypeCausalSetting;
import edu.sysu.pmglab.kgga.command.setting.PhenotypeVariantSetting;
import edu.sysu.pmglab.kgga.command.setting.SamplingGroupSetting;
import edu.sysu.pmglab.kgga.command.setting.SamplingSetting;
import edu.sysu.pmglab.kgga.io.GlobalPedIndividuals;
import edu.sysu.pmglab.simulation.LiabilitySimulator;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Random;

public class PhenotypeSimulateTask
implements ITask {
    final File outputFolder;
    SimulationOptions simulationOptions;
    AnnotationOptions annotationOptions;
    GeneralIOOptions generalIOOptions;

    public PhenotypeSimulateTask(GeneralIOOptions generalIOOptions, AnnotationOptions annotationOptions, SimulationOptions simulationOptions, File outputDir, boolean makeDir) {
        if (makeDir) {
            outputDir = FileUtils.getSubFile(outputDir, this.getClass().getSimpleName());
            outputDir.mkdirs();
        }
        this.outputFolder = outputDir;
        this.simulationOptions = simulationOptions;
        this.annotationOptions = annotationOptions;
        this.generalIOOptions = generalIOOptions;
    }

    @Override
    public void execute(Status status, Context context) throws Exception, Error {
        long randomSeed;
        ITrack track = context.getTracker();
        File inputFile = (File)context.cast("AnnotationBaseVariantSet");
        Boolean updatedVariantSet = (Boolean)context.cast("UpdatedBaseVariantSet");
        if (updatedVariantSet == null) {
            updatedVariantSet = false;
        }
        if ((randomSeed = this.generalIOOptions.randomSeed) == 0L) {
            randomSeed = System.nanoTime();
        }
        Random random = new Random(randomSeed);
        List<PhenotypeVariantSetting> phenotypeVariants = this.simulationOptions.phenotypeVariantSetting;
        PhenotypeVariantSetting phenotype1Variants = phenotypeVariants.get(0);
        PhenotypeVariantSetting phenotype2Variants = phenotypeVariants.size() > 1 ? phenotypeVariants.get(1) : null;
        IndexableSet<String> subjectsIDs = GlobalPedIndividuals.uniqueIDs();
        File outputFileLiability = new File(this.outputFolder + File.separator + "phenotype.ped");
        int threadNum = this.generalIOOptions.threads;
        PhenotypeCausalSetting causalSetting = this.simulationOptions.phenotypeCausalSetting;
        if (!(phenotype1Variants == null || !updatedVariantSet.booleanValue() && outputFileLiability.exists() && track.contains(this.digestPhenotype(inputFile, outputFileLiability)))) {
            float[][] liabilitiesAll;
            int index;
            double[] prevalence = new double[phenotypeVariants.size()];
            for (int t = 0; t < prevalence.length; ++t) {
                prevalence[t] = phenotypeVariants.get(t).getPrevalence();
            }
            String[] qtlNumStrs = phenotype1Variants.getQtlPattern().split(",");
            int[] qtlNum = new int[3];
            Arrays.fill(qtlNum, 0);
            for (String qtlNumStr : qtlNumStrs) {
                String[] sizeTypes = qtlNumStr.split("@");
                index = Integer.parseInt(sizeTypes[1]) - 1;
                qtlNum[index] = Integer.parseInt(sizeTypes[0]);
            }
            int susceptibilityVarNum = 0;
            for (int i = 0; i < qtlNumStrs.length; ++i) {
                susceptibilityVarNum += qtlNum[i];
            }
            LiabilitySimulator simulator = new LiabilitySimulator(random);
            IntList selectedIndexes = new IntList();
            float[][] genotypeCodes = Utility.sampleCentralizedGenotypes(inputFile, threadNum, susceptibilityVarNum, randomSeed * 2L, selectedIndexes);
            double[] availableVar = new double[]{0.0, 0.0, 0.0, 0.0};
            float[] liabilities = simulator.simuLiabilityP1(phenotype1Variants, genotypeCodes, qtlNum, availableVar);
            if (causalSetting != null) {
                qtlNumStrs = phenotype2Variants.getQtlPattern().split(",");
                int[] qtlNumUnique = new int[3];
                Arrays.fill(qtlNumUnique, 0);
                int[] qtlNumsShared = new int[3];
                Arrays.fill(qtlNumsShared, 0);
                double overlappedQTLProportion = causalSetting.getPleiotropyIVProportion();
                for (String qtlNumStr : qtlNumStrs) {
                    String[] sizeTypes = qtlNumStr.split("@");
                    index = Integer.parseInt(sizeTypes[1]) - 1;
                    qtlNumUnique[index] = Integer.parseInt(sizeTypes[0]);
                    qtlNumsShared[index] = (int)(overlappedQTLProportion * (double)qtlNumUnique[index]);
                    int n = index;
                    qtlNumUnique[n] = qtlNumUnique[n] - qtlNumsShared[index];
                }
                susceptibilityVarNum = 0;
                int sharedSusceptibilityVarNum = 0;
                for (int i = 0; i < qtlNumStrs.length; ++i) {
                    susceptibilityVarNum += qtlNumsShared[i];
                    sharedSusceptibilityVarNum += qtlNumsShared[i];
                    susceptibilityVarNum += qtlNumUnique[i];
                    if (i <= 0) continue;
                    int n = i;
                    qtlNumsShared[n] = qtlNumsShared[n] + qtlNumsShared[i - 1];
                    int n2 = i;
                    qtlNumUnique[n2] = qtlNumUnique[n2] + qtlNumUnique[i - 1];
                }
                liabilitiesAll = new float[2][];
                liabilitiesAll[0] = liabilities;
                GTBManager manager = new GTBManager(inputFile);
                int numRecords = Math.toIntExact(manager.numOfVariants());
                int selectSize = selectedIndexes.size();
                IntList retainedIndexes = new IntList(numRecords - selectSize);
                selectedIndexes.sort();
                int inc = 0;
                for (int i = 0; i < numRecords; ++i) {
                    if (inc < selectSize && i == selectedIndexes.get(inc)) {
                        ++inc;
                        continue;
                    }
                    retainedIndexes.add(i);
                }
                selectedIndexes = selectedIndexes.subList(0, sharedSusceptibilityVarNum);
                genotypeCodes = Utility.sampleCentralizedGenotypes(inputFile, threadNum, susceptibilityVarNum, randomSeed * 3L, selectedIndexes, retainedIndexes);
                liabilitiesAll[1] = causalSetting.getCausalEffect() == 0.0 ? simulator.simuLiabilityP2(causalSetting, phenotype2Variants, genotypeCodes, qtlNumsShared, qtlNumUnique, availableVar, sharedSusceptibilityVarNum, liabilities) : simulator.simuLiabilityP2(causalSetting, phenotype2Variants, genotypeCodes, qtlNumsShared, qtlNumUnique, liabilities, sharedSusceptibilityVarNum, availableVar);
            } else {
                liabilitiesAll = new float[][]{liabilities};
            }
            List<int[]> sampleCCIndexes = new List<int[]>();
            this.outputPhenotypes(subjectsIDs, liabilitiesAll, prevalence, outputFileLiability, sampleCCIndexes);
            track.add(this.getClass().getName(), this.digestPhenotype(inputFile, outputFileLiability));
            SetupApplication.GlobalLogger.info("{} subjects phenotypes according to {} susceptibility variants are generated and saved in {}.", subjectsIDs.size(), genotypeCodes.length, outputFileLiability.getCanonicalPath());
            List<SamplingSetting> ccSizes = this.simulationOptions.samplingSetting;
            SamplingGroupSetting samplingGroupSetting = this.simulationOptions.samplingGroupSetting;
            float sampleOverlappingRate = samplingGroupSetting.getOverlapping();
            if (ccSizes != null) {
                int groupSampleNumber = samplingGroupSetting.getGroupNum();
                int ccSizeNum = ccSizes.size();
                List<int[]> availableIndexes = new List<int[]>();
                for (int i = 0; i < groupSampleNumber; ++i) {
                    int caseSize;
                    int controlSize;
                    String outputPath;
                    int sampleSize = 0;
                    int overlappedSampleSize = 0;
                    int overlappedSizeCase = (int)(sampleOverlappingRate * (float)ccSizes.get(0).getCaseSampleSize().intValue());
                    int overlappedSizeControl = (int)(sampleOverlappingRate * (float)ccSizes.get(0).getControlSampleSize().intValue());
                    int maxIndex = 0;
                    IntList caseIndexes = new IntList();
                    IntList controlIndexes = new IntList();
                    IntList availableIndexes1 = new IntList();
                    int phenoIndex = 1;
                    if (ccSizes.get(0).isQuantitativeTrait()) {
                        sampleSize = ccSizes.get(0).getSampleSize();
                        overlappedSampleSize = (int)(sampleOverlappingRate * (float)sampleSize);
                        sampleCCIndexes.shuffle(randomSeed * (long)(4 + i));
                        outputPath = outputFileLiability.getCanonicalPath() + "." + i;
                        if (ccSizeNum > 1) {
                            outputPath = outputPath + ".0";
                        }
                        this.outputPhenotypes(subjectsIDs, liabilitiesAll, outputPath, (List<int[]>)sampleCCIndexes.subList(0, sampleSize));
                    } else {
                        sampleCCIndexes.shuffle(randomSeed * (long)(5 + i));
                        controlSize = ccSizes.get(0).getControlSampleSize();
                        caseSize = ccSizes.get(0).getCaseSampleSize();
                        outputPath = outputFileLiability.getCanonicalPath() + "." + i;
                        if (ccSizeNum > 1) {
                            outputPath = outputPath + ".0";
                        }
                        availableIndexes1.clear();
                        this.outputPhenotypes(subjectsIDs, outputPath, liabilitiesAll.length, 1, caseIndexes, controlIndexes, availableIndexes1, caseSize, controlSize, 0, sampleCCIndexes);
                    }
                    if (ccSizeNum <= 1) continue;
                    if (ccSizes.get(1).isQuantitativeTrait()) {
                        availableIndexes.clear();
                        availableIndexes.addAll(sampleCCIndexes.subList(0, overlappedSampleSize));
                        int caseSize2 = ccSizes.get(1).getSampleSize();
                        int endIndex = sampleSize + caseSize2 - overlappedSampleSize;
                        outputPath = outputFileLiability.getCanonicalPath() + "." + i + ".1";
                        availableIndexes.addAll(sampleCCIndexes.subList(sampleSize, Math.min(endIndex, sampleCCIndexes.size())));
                        this.outputPhenotypes(subjectsIDs, liabilitiesAll, outputPath, availableIndexes);
                        continue;
                    }
                    availableIndexes1.clear();
                    availableIndexes1.addAll(caseIndexes.subList(0, overlappedSizeCase));
                    availableIndexes1.addAll(controlIndexes.subList(0, overlappedSizeControl));
                    if (!caseIndexes.isEmpty() && !controlIndexes.isEmpty()) {
                        maxIndex = Math.max(caseIndexes.get(caseIndexes.size() - 1), controlIndexes.get(controlIndexes.size() - 1));
                    }
                    controlSize = ccSizes.get(1).getControlSampleSize();
                    caseSize = ccSizes.get(1).getCaseSampleSize();
                    phenoIndex = 2;
                    outputPath = outputFileLiability.getCanonicalPath() + "." + i + ".1";
                    this.outputPhenotypes(subjectsIDs, outputPath, liabilitiesAll.length, phenoIndex, caseIndexes, controlIndexes, availableIndexes1, caseSize, controlSize, maxIndex, sampleCCIndexes);
                    availableIndexes1.clear();
                    caseIndexes.clear();
                    controlIndexes.clear();
                }
            }
        } else {
            SetupApplication.GlobalLogger.info("{} is not regenerated!", (Object)outputFileLiability);
        }
    }

    public void outputPhenotypes(IndexableSet<String> subjectsIDs, String outputFilePath, int phenoNum, int indexPheno, IntList caseIndexes, IntList controlIndexes, IntList availableIndexes, int caseSize, int controlSize, int startIndex, List<int[]> caseControlIndexes) throws IOException {
        int j;
        int index;
        int[] indexes;
        int i;
        WriterStream fs = new WriterStream(new File(outputFilePath), WriterStream.Option.DEFAULT);
        fs.writeChar("fid\tiid\tpid\tmid\tsex");
        for (int j2 = 0; j2 < phenoNum; ++j2) {
            fs.writeChar("\tdisease" + j2);
        }
        fs.writeChar("\n");
        caseIndexes.clear();
        controlIndexes.clear();
        int size = availableIndexes.size();
        for (i = 0; i < size; ++i) {
            indexes = caseControlIndexes.get(availableIndexes.fastGet(i));
            index = indexes[0];
            if (indexes[indexPheno] == 1) {
                controlIndexes.add(i);
            } else if (indexes[indexPheno] == 2) {
                caseIndexes.add(i);
            }
            fs.writeChar(subjectsIDs.valueOf(index));
            fs.write(9);
            fs.writeChar(subjectsIDs.valueOf(index));
            fs.writeChar("\t0\t0\t1");
            for (j = 0; j < phenoNum; ++j) {
                fs.writeChar("\t" + indexes[j + 1]);
            }
            fs.writeChar("\n");
        }
        size = caseControlIndexes.size();
        for (i = startIndex; i < size; ++i) {
            indexes = caseControlIndexes.get(i);
            index = indexes[0];
            if (indexes[indexPheno] == 1) {
                if (controlIndexes.size() > controlSize) continue;
                controlIndexes.add(i);
            } else if (indexes[indexPheno] == 2) {
                if (caseIndexes.size() > caseSize) continue;
                caseIndexes.add(i);
            }
            fs.writeChar(subjectsIDs.valueOf(index));
            fs.write(9);
            fs.writeChar(subjectsIDs.valueOf(index));
            fs.writeChar("\t0\t0\t1");
            for (j = 0; j < phenoNum; ++j) {
                fs.writeChar("\t" + indexes[j + 1]);
            }
            fs.writeChar("\n");
            if (caseIndexes.size() >= caseSize && controlIndexes.size() >= controlSize) break;
        }
        if (caseIndexes.size() < caseSize) {
            SetupApplication.GlobalLogger.warn("The case sample size {} is less than the required {} in {}!", caseIndexes.size(), caseSize, outputFilePath);
        }
        if (controlIndexes.size() < controlSize) {
            SetupApplication.GlobalLogger.warn("The control sample size {} is less than the required {} in {}!", controlIndexes.size(), controlSize, outputFilePath);
        }
        fs.close();
    }

    public void outputPhenotypes(IndexableSet<String> subjectsIDs, float[][] liabilities, String outputFilePath, List<int[]> sampleIDs) throws IOException {
        int phenotypeNum = liabilities.length;
        WriterStream fs = new WriterStream(new File(outputFilePath), WriterStream.Option.DEFAULT);
        fs.writeChar("fid\tiid\tpid\tmid\tsex");
        for (int i = 0; i < phenotypeNum; ++i) {
            fs.writeChar("\ttrait" + i);
        }
        fs.writeChar("\n");
        int sampleSize = sampleIDs.size();
        for (int i = 0; i < sampleSize; ++i) {
            int[] indexes = sampleIDs.get(i);
            int index = indexes[0];
            fs.writeChar(subjectsIDs.valueOf(index));
            fs.write(9);
            fs.writeChar(subjectsIDs.valueOf(index));
            fs.writeChar("\t0\t0\t1");
            for (float[] liability : liabilities) {
                fs.writeChar("\t");
                fs.writeChar(liability[index]);
            }
            fs.write(10);
        }
        fs.close();
    }

    public void outputPhenotypes(IndexableSet<String> subjectsIDs, float[][] liabilities, double[] prevalence, File outputFile, List<int[]> caseControlIDs) throws IOException {
        int phenotypeNum = liabilities.length;
        float[] cuts = new float[phenotypeNum];
        boolean[] hasCut = new boolean[phenotypeNum];
        for (int i = 0; i < phenotypeNum; ++i) {
            float[] liabilitiesSorted = (float[])liabilities[i].clone();
            Arrays.sort(liabilitiesSorted);
            if (!Double.isNaN(prevalence[i])) {
                cuts[i] = liabilitiesSorted[(int)((1.0 - prevalence[i]) * (double)liabilitiesSorted.length)];
                hasCut[i] = true;
                continue;
            }
            cuts[i] = Float.NaN;
            hasCut[i] = false;
        }
        WriterStream fs = null;
        fs = new WriterStream(outputFile, WriterStream.Option.DEFAULT);
        fs.writeChar("fid\tiid\tpid\tmid\tsex");
        for (int j = 0; j < phenotypeNum; ++j) {
            fs.writeChar("\tdisease" + j);
        }
        fs.writeChar("\n");
        for (int i = 0; i < liabilities[0].length; ++i) {
            fs.writeChar(subjectsIDs.valueOf(i));
            fs.write(9);
            fs.writeChar(subjectsIDs.valueOf(i));
            fs.writeChar("\t0\t0\t1");
            int[] indexes = new int[phenotypeNum + 1];
            indexes[0] = i;
            for (int j = 0; j < phenotypeNum; ++j) {
                fs.writeChar("\t");
                if (hasCut[j]) {
                    if (liabilities[j][i] <= cuts[j]) {
                        fs.writeChar(1);
                        indexes[j + 1] = 1;
                        continue;
                    }
                    fs.writeChar(2);
                    indexes[j + 1] = 2;
                    continue;
                }
                indexes[j + 1] = 1;
                fs.writeChar("\t");
                fs.writeChar(liabilities[j][i]);
            }
            caseControlIDs.add(indexes);
            fs.write(10);
        }
        fs.close();
    }

    public String digestPhenotype(File inputFile, File outputFile) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append(inputFile.getCanonicalPath()).append("|").append(inputFile.length()).append("|").append(inputFile.lastModified()).append("|").append(outputFile.getCanonicalPath()).append("|").append(outputFile.length()).append("|").append(outputFile.lastModified()).append("|");
        for (PhenotypeVariantSetting pv : this.simulationOptions.phenotypeVariantSetting) {
            sb.append(pv.toString()).append("|");
        }
        sb.append(this.simulationOptions.samplingGroupSetting).append("|");
        sb.append(this.simulationOptions.samplingSetting == null ? "" : List.wrap(this.simulationOptions.samplingSetting.toString())).append("|");
        sb.append(this.simulationOptions.phenotypeCausalSetting == null ? "" : this.simulationOptions.phenotypeCausalSetting.toString()).append("|");
        return ITrack.digest(sb.toString());
    }
}

