/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.kgga.command.task;

import edu.sysu.pmglab.analysis.TNBRegressionResultSet;
import edu.sysu.pmglab.commandParser.CommandOptions;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.executor.Context;
import edu.sysu.pmglab.executor.ITask;
import edu.sysu.pmglab.executor.Status;
import edu.sysu.pmglab.executor.track.ITrack;
import edu.sysu.pmglab.internet.NCBIRetriever;
import edu.sysu.pmglab.io.FileUtils;
import edu.sysu.pmglab.kgga.command.SetupApplication;
import edu.sysu.pmglab.kgga.command.setting.PubMedFieldsSet;
import gnu.trove.map.hash.THashMap;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;

public class PubMedSearchTask
implements ITask {
    final File outputFolder;
    final PubMedFieldsSet pubmedMining;

    public PubMedSearchTask(File outputDir, boolean makeDir, PubMedFieldsSet pubmedMining) {
        if (makeDir) {
            outputDir = FileUtils.getSubFile(outputDir, this.getClass().getSimpleName());
            outputDir.mkdirs();
        }
        this.outputFolder = outputDir;
        this.pubmedMining = pubmedMining;
    }

    @Override
    public void execute(Status status, Context context) throws Exception, Error {
        ITrack track = context.getTracker();
        CommandOptions options = (CommandOptions)context.cast(CommandOptions.class);
        List inputFiles = (List)context.cast("MutationCountRegressionTaskOutput");
        Boolean updatedGeneSet = (Boolean)context.cast("UpdatedBaseGeneSet");
        if (this.pubmedMining == null) {
            return;
        }
        String[] phenotypeTerms = this.pubmedMining.getKeywords();
        if (phenotypeTerms == null) {
            return;
        }
        boolean[] hasFailed = new boolean[]{false};
        SetupApplication.GlobalLogger.info("Retrieving papers co-mentioning the gene and phenotypes in PubMed database.");
        List<TNBRegressionResultSet> resultSets = new List<TNBRegressionResultSet>();
        for (File fileSource : inputFiles) {
            String fileName = fileSource.getName();
            fileName = fileName.substring(0, fileName.lastIndexOf("."));
            String outputPrefix = this.outputFolder + File.separator + fileName + ".pubmed.xls";
            File outputFile = new File(outputPrefix);
            TNBRegressionResultSet resultSet = new TNBRegressionResultSet(fileSource, outputFile);
            resultSet.readData();
            resultSets.add(resultSet);
        }
        if (!resultSets.isEmpty()) {
            String fieldType = this.pubmedMining.getField();
            fieldType = "[" + fieldType + "]";
            fieldType = fieldType.replaceAll("\\+", "%20");
            Map<String, String[]> genePubMedIDs = this.pubmedSearch(fieldType, resultSets, phenotypeTerms, hasFailed);
            resultSets.sort((o1, o2) -> {
                int rank = Double.compare(o1.MLFC, o2.MLFC);
                if (Math.abs(o1.MLFC - o2.MLFC) < 0.03) {
                    rank = 0;
                }
                if (rank == 0) {
                    rank = o2.getGeneNumWithHitPaper() - o1.getGeneNumWithHitPaper();
                }
                if (rank == 0) {
                    rank = o2.getHitPaperNum() - o1.getHitPaperNum();
                }
                if (rank == 0) {
                    rank = o2.getSigGeneNum() - o1.getSigGeneNum();
                }
                return rank;
            });
            resultSets.get(0).appendOneColumn2ExcelFile("PubMedIDs", genePubMedIDs);
            SetupApplication.GlobalLogger.info("The gene-prioritization results are saved in {}", (Object)resultSets.get(0).toString());
            for (int i = 1; i < resultSets.size(); ++i) {
                resultSets.get(i).appendOneColumn2ExcelFile("PubMedIDs", genePubMedIDs);
            }
        }
        if (!hasFailed[0]) {
            // empty if block
        }
    }

    public Map<String, String[]> pubmedSearch(String fieldType, List<TNBRegressionResultSet> resultSets, String[] phenotypeTerms, boolean[] hasFailed) throws Exception {
        List<String> dl = new List<String>(Arrays.asList(phenotypeTerms));
        List<String> filter = new List<String>();
        filter.add("gene");
        filter.add("genes");
        filter.add("mRNA");
        filter.add("protein");
        filter.add("proteins");
        filter.add("transcription");
        filter.add("transcript");
        filter.add("transcripts");
        filter.add("expressed");
        filter.add("expression");
        filter.add("expressions");
        filter.add("locus");
        filter.add("loci");
        filter.add("SNP");
        List<String> geneNames = new List<String>();
        HashSet<String> allGenes = new HashSet<String>();
        for (int i = 0; i < resultSets.size(); ++i) {
            allGenes.addAll(resultSets.get(i).getSelectedGenes().keySet());
        }
        THashMap<String, String[]> genePubMedIDs = new THashMap<String, String[]>();
        for (String gene : allGenes) {
            geneNames.clear();
            geneNames.add(gene);
            boolean[] succeeded = new boolean[]{true};
            String[] ids = NCBIRetriever.pubMedIDESearch(fieldType, dl, geneNames, filter, 3, succeeded);
            if (ids != null && ids.length > 0) {
                genePubMedIDs.put(gene.replaceAll(" ", ";"), ids);
            }
            if (succeeded[0]) continue;
            hasFailed[0] = true;
        }
        for (int i = 0; i < resultSets.size(); ++i) {
            resultSets.get(i).countHitPaper(genePubMedIDs);
        }
        return genePubMedIDs;
    }

    public String digest(File inputFile, String[] weightedMutationScoreCountFields, CommandOptions options) throws IOException {
        StringBuilder fileInfor = new StringBuilder();
        for (String weightedMutationScoreCountField : weightedMutationScoreCountFields) {
            String outputPrefix = this.outputFolder.toString() + File.separator + weightedMutationScoreCountField.substring(weightedMutationScoreCountField.lastIndexOf(":") + 1) + ".";
            File file = new File(outputPrefix + "prioritizedGenes.PubMed.txt");
            fileInfor.append(file.getCanonicalPath());
            fileInfor.append(file.length());
            fileInfor.append(file.lastModified());
        }
        String[] phenotypeTerms = (String[])options.value("--pubmed-mining");
        StringBuilder sb = new StringBuilder();
        sb.append(inputFile.getCanonicalPath()).append("|").append(inputFile.length()).append("|").append(inputFile.lastModified()).append("|").append(fileInfor.toString()).append("|").append(phenotypeTerms);
        return sb.toString();
    }
}

