/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.kgga.command.task;

import edu.sysu.pmglab.executor.Context;
import edu.sysu.pmglab.executor.ITask;
import edu.sysu.pmglab.executor.Status;
import edu.sysu.pmglab.executor.track.ITrack;
import edu.sysu.pmglab.gtb.GTBManager;
import edu.sysu.pmglab.io.FileUtils;
import edu.sysu.pmglab.kgga.command.SetupApplication;
import edu.sysu.pmglab.kgga.command.pipeline.GeneralIOOptions;
import edu.sysu.pmglab.kgga.command.setting.ToolOptionsSet;
import edu.sysu.pmglab.kgga.io.InputOutputFileSet;
import edu.sysu.pmglab.kgga.io.InputType;
import edu.sysu.pmglab.utils.ShellUtils;
import java.io.File;
import java.io.IOException;

public class RunOtherToolTask
implements ITask {
    final File outputFile;
    InputType format;
    ToolOptionsSet plinkOptionsSet;
    ToolOptionsSet gctaOptionsSet;
    ToolOptionsSet plink2OptionsSet;
    String[] otherOutputFields;
    GeneralIOOptions inputsOptions;

    public RunOtherToolTask(GeneralIOOptions inputsOptions, File workSpace) {
        this.outputFile = FileUtils.getSubFile(workSpace, InputOutputFileSet.getAnnotationFileName());
        this.format = inputsOptions.outputGtyFormat;
        this.inputsOptions = inputsOptions;
        this.plinkOptionsSet = inputsOptions.plinkOptionsSet;
        this.plink2OptionsSet = inputsOptions.plink2OptionsSet;
        this.gctaOptionsSet = inputsOptions.gctaOptionsSet;
    }

    @Override
    public void execute(Status status, Context context) throws Exception, Error {
        ITrack track = context.getTracker();
        GTBManager inputManager = new GTBManager((File)context.cast("AnnotationBaseVariantSet"));
        String outputPath = this.outputFile.getCanonicalPath();
        outputPath = outputPath.substring(0, outputPath.length() - 4);
        if (!this.outputFile.exists() || !track.contains(this.digest(inputManager, this.outputFile))) {
            int n;
            String cmd;
            if (inputManager.numOfVariants() == 0L) {
                SetupApplication.GlobalLogger.info("No variants are retained for output finally!");
                return;
            }
            String gtyFilePath = FileUtils.getSubFile(this.outputFile.getParentFile().getCanonicalPath() + "/GenerateAnnotationBaseTask0/", InputOutputFileSet.getAnnotationGtyFileName());
            GTBManager gtyManger = new GTBManager(gtyFilePath);
            if (this.plinkOptionsSet != null) {
                cmd = this.plinkOptionsSet.getAppPath() + " --bfile " + outputPath + " --out " + outputPath + " " + this.plinkOptionsSet.getOptions();
                n = ShellUtils.execute(cmd);
            }
            if (this.gctaOptionsSet != null) {
                cmd = this.gctaOptionsSet.getAppPath() + " --bfile " + outputPath + " --out " + outputPath + " " + this.gctaOptionsSet.getOptions();
                n = ShellUtils.execute(cmd);
            }
            if (this.plink2OptionsSet != null) {
                cmd = this.plink2OptionsSet.getAppPath() + " --pfile " + outputPath + " --out " + outputPath + " " + this.plink2OptionsSet.getOptions();
                n = ShellUtils.execute(cmd);
            }
            track.add(this.getClass().getName(), this.digest(inputManager, this.outputFile));
        }
    }

    private String digest(GTBManager inputManager, File outputFile) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(inputManager.hashCode()).append("|");
        stringBuilder.append(outputFile.getCanonicalPath()).append("|");
        stringBuilder.append(outputFile.length()).append("|");
        stringBuilder.append(outputFile.lastModified());
        return stringBuilder.toString();
    }
}

