/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.kgga.command.task;

import edu.sysu.pmglab.annotation.database.GeneFeatureDBUtility;
import edu.sysu.pmglab.ccf.meta.ICCFOptions;
import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.rangelist.VarInt32RangeList;
import edu.sysu.pmglab.executor.Context;
import edu.sysu.pmglab.executor.ITask;
import edu.sysu.pmglab.executor.Status;
import edu.sysu.pmglab.gtb.GTBManager;
import edu.sysu.pmglab.kgga.command.pipeline.AnnotationOptions;
import gnu.trove.iterator.TIntIterator;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.io.File;
import java.util.Map;

public class SummarizeGeneIDSubRegionLengthTask
implements ITask {
    AnnotationOptions annotationOptions;
    int threadNum;

    public SummarizeGeneIDSubRegionLengthTask(AnnotationOptions annotationOptions, int threadNum) {
        this.annotationOptions = annotationOptions;
        this.threadNum = threadNum;
    }

    @Override
    public void execute(Status status, Context context) throws Exception, Error {
        int index;
        TIntHashSet selectedFeatures = new TIntHashSet();
        VarInt32RangeList featureIDDs = this.annotationOptions.geneFeatureIn;
        TIntIterator ids = featureIDDs.iterator();
        while (ids.hasNext()) {
            selectedFeatures.add(ids.next());
        }
        GeneFeatureDBUtility.INSTANCE.fillPathWithDefaultDatabases(this.annotationOptions.geneDatabase);
        File inputFile = (File)context.cast("AnnotationBaseVariantSet");
        GTBManager manager = new GTBManager(inputFile);
        ICCFOptions options = manager.getOptions();
        IndexableSet geneSymbolIDMap = (IndexableSet)options.get("$GeneSymbolIDMap");
        IndexableSet geneIDMap = (IndexableSet)options.get("$GeneIDMap");
        IndexableSet transcriptIDMap = (IndexableSet)options.get("$TranscriptIDMap");
        TIntSet canonicalTranscriptIDSet = (TIntSet)options.get("$CanonicalTranscriptIDSet");
        boolean containUTR = selectedFeatures.contains(9) || selectedFeatures.contains(10);
        boolean containCodingRegions = false;
        for (int i = 0; i <= 10; ++i) {
            if (!selectedFeatures.contains(i)) continue;
            containCodingRegions = true;
            break;
        }
        Map<String, int[]> geneExonLength = null;
        if (containCodingRegions) {
            geneExonLength = GeneFeatureDBUtility.INSTANCE.getGeneCodingLengthPoints(this.annotationOptions.geneDatabase, !containUTR, this.annotationOptions.splicingDis);
        }
        boolean containIntronRegions = false;
        if (selectedFeatures.contains(11)) {
            containIntronRegions = true;
        }
        boolean containNearGeneRegions = false;
        if (selectedFeatures.contains(12) || selectedFeatures.contains(13)) {
            containNearGeneRegions = true;
        }
        Map<String, Map<Integer, int[]>> geneNonCodingRegionLength = null;
        if (containIntronRegions || containNearGeneRegions) {
            geneNonCodingRegionLength = GeneFeatureDBUtility.INSTANCE.getGeneNonCodingLengthPoints(this.annotationOptions.geneDatabase, transcriptIDMap, canonicalTranscriptIDSet, this.annotationOptions.splicingDis, this.annotationOptions.upstreamDis, this.annotationOptions.downstreamDis);
        }
        THashMap<Integer, Object> geneSubRegionLength = new THashMap<Integer, Object>();
        if (geneNonCodingRegionLength != null) {
            for (Map.Entry<Object, Object> entry : geneNonCodingRegionLength.entrySet()) {
                index = geneSymbolIDMap.indexOf(entry.getKey());
                if (index < 0) {
                    throw new Exception("Unidentified gene symbol: " + (String)entry.getKey());
                }
                geneSubRegionLength.put(index, entry.getValue());
            }
        }
        if (geneExonLength != null) {
            for (Map.Entry<Object, Object> entry : geneExonLength.entrySet()) {
                index = geneSymbolIDMap.indexOf(entry.getKey());
                if (index < 0) {
                    throw new Exception("Unidentified gene symbol: " + (String)entry.getKey());
                }
                THashMap<Integer, Object> regionLenMap = (THashMap<Integer, Object>)geneSubRegionLength.get(index);
                if (regionLenMap == null) {
                    regionLenMap = new THashMap<Integer, Object>();
                    geneSubRegionLength.put(index, regionLenMap);
                }
                regionLenMap.put(0, entry.getValue());
            }
        }
        context.put("geneSubRegionLength", geneSubRegionLength);
    }
}

