/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.kgga.command.task;

import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.ccf.field.FieldGroupMeta;
import edu.sysu.pmglab.ccf.field.FieldGroupMetas;
import edu.sysu.pmglab.ccf.field.FieldMeta;
import edu.sysu.pmglab.ccf.field.IFieldCollection;
import edu.sysu.pmglab.ccf.record.BoxRecord;
import edu.sysu.pmglab.ccf.toolkit.annotator.PointerDatabase;
import edu.sysu.pmglab.ccf.toolkit.listener.AnnotationListener;
import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.container.list.DoubleList;
import edu.sysu.pmglab.container.list.IntList;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.executor.Context;
import edu.sysu.pmglab.executor.ITask;
import edu.sysu.pmglab.executor.Status;
import edu.sysu.pmglab.executor.track.ITrack;
import edu.sysu.pmglab.gtb.GTBManager;
import edu.sysu.pmglab.gtb.GTBReaderOption;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.genome.genotype.Genotype;
import edu.sysu.pmglab.gtb.genome.genotype.IGenotypes;
import edu.sysu.pmglab.gtb.toolkit.GTBAnnotator;
import edu.sysu.pmglab.io.FileUtils;
import edu.sysu.pmglab.kgga.command.SetupApplication;
import edu.sysu.pmglab.kgga.command.TaskTracker;
import edu.sysu.pmglab.kgga.command.Utility;
import edu.sysu.pmglab.kgga.command.pipeline.GeneralIOOptions;
import edu.sysu.pmglab.kgga.command.pipeline.LDPruneOptions;
import edu.sysu.pmglab.kgga.io.GlobalPedIndividuals;
import edu.sysu.pmglab.kgga.io.InputOutputFileSet;
import edu.sysu.pmglab.stat.ANOVA;
import edu.sysu.pmglab.stat.AssociationModel;
import edu.sysu.pmglab.stat.CCT;
import edu.sysu.pmglab.stat.ContingencyTable;
import edu.sysu.pmglab.stat.LinearRegressionGty;
import edu.sysu.pmglab.stat.LinearRegressionGtyFast;
import edu.sysu.pmglab.stat.LogisticRegressionGty;
import edu.sysu.pmglab.stat.LogisticRegressionGtyFast;
import edu.sysu.pmglab.stat.ModelAllelic;
import edu.sysu.pmglab.stat.ModelDominant;
import edu.sysu.pmglab.stat.ModelRecessive;
import edu.sysu.pmglab.stat.ModelTrend;
import edu.sysu.pmglab.stat.Summary;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;

public class VariantAssocTask
implements ITask {
    private static final int ADDITIVE = 0;
    private static final int DOMINANT = 1;
    private static final int RECESSIVE = 2;
    private static final ThreadLocal<AssociationModel> ASSOCIATION_MODEL_POOL = ThreadLocal.withInitial(AssociationModel::new);
    private static final ThreadLocal<List<double[]>> COV_TMP_POOL = ThreadLocal.withInitial(List::new);
    private static final ThreadLocal<List<Double>> NEW_ROW_POOL = ThreadLocal.withInitial(List::new);
    private static final ThreadLocal<double[]> TEMP_ARRAY_POOL = ThreadLocal.withInitial(() -> new double[1000]);
    private static ThreadLocal<LinearRegressionGty>[] LINEAR_REGRESSION_POOL;
    private static ThreadLocal<LinearRegressionGtyFast>[] LINEAR_REGRESSION_POOL_FAST;
    private static ThreadLocal<LogisticRegressionGty>[] LOGISTIC_REGRESSION_POOL;
    private static ThreadLocal<LogisticRegressionGtyFast>[] LOGISTIC_REGRESSION_POOL_FAST;
    GeneralIOOptions generalIOOptions;
    LDPruneOptions ldPruneOptions;
    double pCut;
    File outputFile;
    final FieldMeta Logistic_Add_P;
    final FieldMeta Logistic_Add_Beta;
    final FieldMeta Logistic_Add_Beta_SE;
    final FieldMeta Logistic_Add_OR;
    final FieldMeta Logistic_Add_Upper;
    final FieldMeta Logistic_Add_Lower;
    final FieldMeta Logistic_Dom_P;
    final FieldMeta Logistic_Dom_Beta;
    final FieldMeta Logistic_Dom_Beta_SE;
    final FieldMeta Logistic_Dom_OR;
    final FieldMeta Logistic_Dom_Upper;
    final FieldMeta Logistic_Dom_Lower;
    final FieldMeta Logistic_Rec_P;
    final FieldMeta Logistic_Rec_Beta;
    final FieldMeta Logistic_Rec_Beta_SE;
    final FieldMeta Logistic_Rec_OR;
    final FieldMeta Logistic_Rec_Upper;
    final FieldMeta Logistic_Rec_Lower;
    final FieldMeta Allelic_Assoc_P;
    final FieldMeta Model_Trend_P;
    final FieldMeta Model_Allelic_P;
    final FieldMeta Model_Dominant_P;
    final FieldMeta Model_Recessive_P;
    final FieldMeta Model_Genotypic_P;
    final FieldMeta ANOVA_P;
    final FieldMeta ANOVA_F;
    final FieldMeta ANOVA_DFB;
    final FieldMeta ANOVA_DFW;
    final FieldMeta CCT_P;
    final FieldMeta Linear_Add_P;
    final FieldMeta Linear_Add_Beta;
    final FieldMeta Linear_Add_Beta_SE;
    final FieldMeta Linear_Add_T;
    final FieldMeta Linear_Rec_P;
    final FieldMeta Linear_Rec_Beta;
    final FieldMeta Linear_Rec_Beta_SE;
    final FieldMeta Linear_Rec_T;
    final FieldMeta Linear_Dom_P;
    final FieldMeta Linear_Dom_Beta;
    final FieldMeta Linear_Dom_Beta_SE;
    final FieldMeta Linear_Dom_T;

    public VariantAssocTask(File outputDir, boolean makeDir, GeneralIOOptions generalIOOptions, LDPruneOptions ldPruneOptions) {
        String[] phenotypeNames = GlobalPedIndividuals.getPhenotypeNames();
        LOGISTIC_REGRESSION_POOL_FAST = new ThreadLocal[phenotypeNames.length];
        LINEAR_REGRESSION_POOL = new ThreadLocal[phenotypeNames.length];
        LINEAR_REGRESSION_POOL_FAST = new ThreadLocal[phenotypeNames.length];
        LOGISTIC_REGRESSION_POOL = new ThreadLocal[phenotypeNames.length];
        for (int i = 0; i < phenotypeNames.length; ++i) {
            VariantAssocTask.LOGISTIC_REGRESSION_POOL_FAST[i] = ThreadLocal.withInitial(LogisticRegressionGtyFast::new);
            VariantAssocTask.LINEAR_REGRESSION_POOL[i] = ThreadLocal.withInitial(LinearRegressionGty::new);
            VariantAssocTask.LINEAR_REGRESSION_POOL_FAST[i] = ThreadLocal.withInitial(LinearRegressionGtyFast::new);
            VariantAssocTask.LOGISTIC_REGRESSION_POOL[i] = ThreadLocal.withInitial(LogisticRegressionGty::new);
        }
        this.pCut = 1.0;
        this.Logistic_Add_P = FieldMeta.of("Logistic_Add_P", FieldType.float64);
        this.Logistic_Add_Beta = FieldMeta.of("Logistic_Add_Beta", FieldType.float64);
        this.Logistic_Add_Beta_SE = FieldMeta.of("Logistic_Add_Beta_SE", FieldType.float64);
        this.Logistic_Add_OR = FieldMeta.of("Logistic_Add_OR", FieldType.float64);
        this.Logistic_Add_Upper = FieldMeta.of("Logistic_Add_OR_Upper", FieldType.float64);
        this.Logistic_Add_Lower = FieldMeta.of("Logistic_Add_OR_Lower", FieldType.float64);
        this.Logistic_Dom_P = FieldMeta.of("Logistic_Dom_P", FieldType.float64);
        this.Logistic_Dom_Beta = FieldMeta.of("Logistic_Dom_Beta", FieldType.float64);
        this.Logistic_Dom_Beta_SE = FieldMeta.of("Logistic_Dom_Beta_SE", FieldType.float64);
        this.Logistic_Dom_OR = FieldMeta.of("Logistic_Dom_OR", FieldType.float64);
        this.Logistic_Dom_Upper = FieldMeta.of("Logistic_Dom_OR_Upper", FieldType.float64);
        this.Logistic_Dom_Lower = FieldMeta.of("Logistic_Dom_OR_Lower", FieldType.float64);
        this.Logistic_Rec_P = FieldMeta.of("Logistic_Rec_P", FieldType.float64);
        this.Logistic_Rec_Beta = FieldMeta.of("Logistic_Rec_Beta", FieldType.float64);
        this.Logistic_Rec_Beta_SE = FieldMeta.of("Logistic_Rec_Beta_SE", FieldType.float64);
        this.Logistic_Rec_OR = FieldMeta.of("Logistic_Rec_OR", FieldType.float64);
        this.Logistic_Rec_Upper = FieldMeta.of("Logistic_Rec_OR_Upper", FieldType.float64);
        this.Logistic_Rec_Lower = FieldMeta.of("Logistic_Rec_OR_Lower", FieldType.float64);
        this.Allelic_Assoc_P = FieldMeta.of("Allelic_Assoc_P", FieldType.float64);
        this.Model_Trend_P = FieldMeta.of("Trend_Model_P", FieldType.float64);
        this.Model_Allelic_P = FieldMeta.of("Allelic_Model_P", FieldType.float64);
        this.Model_Dominant_P = FieldMeta.of("Dominant_Model_P", FieldType.float64);
        this.Model_Recessive_P = FieldMeta.of("Recessive_Model_P", FieldType.float64);
        this.Model_Genotypic_P = FieldMeta.of("Genotypic_Model_P", FieldType.float64);
        this.ANOVA_P = FieldMeta.of("ANOVA_P", FieldType.float64);
        this.ANOVA_F = FieldMeta.of("ANOVA_FStatistic", FieldType.float64);
        this.ANOVA_DFB = FieldMeta.of("ANOVA_DFB", FieldType.float64);
        this.ANOVA_DFW = FieldMeta.of("ANOVA_DFW", FieldType.float64);
        this.CCT_P = FieldMeta.of("CCT_P", FieldType.float64);
        this.Linear_Add_P = FieldMeta.of("Linear_Add_P", FieldType.float64);
        this.Linear_Add_Beta = FieldMeta.of("Linear_Add_Beta", FieldType.float64);
        this.Linear_Add_Beta_SE = FieldMeta.of("Linear_Add_Beta_SE", FieldType.float64);
        this.Linear_Add_T = FieldMeta.of("Linear_Add_T", FieldType.float64);
        this.Linear_Rec_P = FieldMeta.of("Linear_Rec_P", FieldType.float64);
        this.Linear_Rec_Beta = FieldMeta.of("Linear_Rec_Beta", FieldType.float64);
        this.Linear_Rec_Beta_SE = FieldMeta.of("Linear_Rec_Beta_SE", FieldType.float64);
        this.Linear_Rec_T = FieldMeta.of("Linear_Rec_T", FieldType.float64);
        this.Linear_Dom_P = FieldMeta.of("Linear_Dom_P", FieldType.float64);
        this.Linear_Dom_Beta = FieldMeta.of("Linear_Dom_Beta", FieldType.float64);
        this.Linear_Dom_Beta_SE = FieldMeta.of("Linear_Dom_Beta_SE", FieldType.float64);
        this.Linear_Dom_T = FieldMeta.of("Linear_Dom_T", FieldType.float64);
        if (makeDir) {
            outputDir = FileUtils.getSubFile(outputDir, this.getClass().getSimpleName());
            outputDir.mkdirs();
        }
        this.outputFile = FileUtils.getSubFile(outputDir, InputOutputFileSet.getAnnotationFileName());
        this.generalIOOptions = generalIOOptions;
        this.ldPruneOptions = ldPruneOptions;
        this.pCut = ldPruneOptions.pruneP;
    }

    @Override
    public void execute(Status status, Context context) throws Exception, Error {
        File inputFile = (File)context.cast("AnnotationBaseVariantSet");
        GTBManager inputManager = new GTBManager(inputFile);
        Boolean updatedVariantSet = (Boolean)context.cast("UpdatedBaseVariantSet");
        if (updatedVariantSet == null) {
            updatedVariantSet = false;
        }
        TaskTracker.TaskResult completeTaskResult = new TaskTracker.TaskResult(this.getClass().getName(), Utility.MD5File(inputFile), this.digest());
        Optional<File> outputPathOpt = SetupApplication.GlobalTaskTracker.checkTask(completeTaskResult);
        outputPathOpt.ifPresent(file -> {
            this.outputFile = file;
        });
        if (updatedVariantSet.booleanValue() || !this.outputFile.exists() || !outputPathOpt.isPresent()) {
            final Set<String> filePathIDs = inputManager.getMeta().get("SOURCE@FILE_ID").apply(meta -> (String)meta.getValue()).toSet();
            HashSet<String> methods = new HashSet<String>(Arrays.asList(this.ldPruneOptions.associationOptionSet.getAssociationMethod()));
            final String[] phenotypeNames = GlobalPedIndividuals.getPhenotypeNames();
            boolean hadLogisticAdd = false;
            boolean hasLogisticDom = false;
            boolean hasLogisticRec = false;
            boolean hasAllelic = false;
            boolean hasModelGen = false;
            boolean hasModelTrend = false;
            boolean hasModelDom = false;
            boolean hasModelRec = false;
            boolean hasModelAll = false;
            boolean hasAnova = false;
            boolean hasLinearAdd = false;
            boolean hasLinearDom = false;
            boolean hasLinearRec = false;
            final int phenoNum = phenotypeNames.length;
            final FieldGroupMetas fieldsAll = new FieldGroupMetas();
            for (int i = 0; i < phenoNum; ++i) {
                String phenoName = phenotypeNames[i];
                String groupName = phenoName + "_Assoc";
                FieldGroupMeta fields = new FieldGroupMeta(groupName);
                if (methods.contains("logistic-add")) {
                    fields.addField(this.Logistic_Add_P.simpleName(), this.Logistic_Add_P.type());
                    fields.addField(this.Logistic_Add_Beta.simpleName(), FieldType.float64);
                    fields.addField(this.Logistic_Add_Beta_SE.simpleName(), FieldType.float64);
                    fields.addField(this.Logistic_Add_OR.simpleName(), FieldType.float64);
                    fields.addField(this.Logistic_Add_Lower.simpleName(), FieldType.float64);
                    fields.addField(this.Logistic_Add_Upper.simpleName(), FieldType.float64);
                    hadLogisticAdd = true;
                }
                if (methods.contains("logistic-dom")) {
                    fields.addField(this.Logistic_Dom_P.simpleName(), FieldType.float64);
                    fields.addField(this.Logistic_Dom_Beta.simpleName(), FieldType.float64);
                    fields.addField(this.Logistic_Dom_Beta_SE.simpleName(), FieldType.float64);
                    fields.addField(this.Logistic_Dom_OR.simpleName(), FieldType.float64);
                    fields.addField(this.Logistic_Dom_Lower.simpleName(), FieldType.float64);
                    fields.addField(this.Logistic_Dom_Upper.simpleName(), FieldType.float64);
                    hasLogisticDom = true;
                }
                if (methods.contains("logistic-rec")) {
                    fields.addField(this.Logistic_Rec_P.simpleName(), FieldType.float64);
                    fields.addField(this.Logistic_Rec_Beta.simpleName(), FieldType.float64);
                    fields.addField(this.Logistic_Rec_Beta_SE.simpleName(), FieldType.float64);
                    fields.addField(this.Logistic_Rec_OR.simpleName(), FieldType.float64);
                    fields.addField(this.Logistic_Rec_Lower.simpleName(), FieldType.float64);
                    fields.addField(this.Logistic_Rec_Upper.simpleName(), FieldType.float64);
                    hasLogisticRec = true;
                }
                if (methods.contains("linear-add")) {
                    fields.addField(this.Linear_Add_P.simpleName(), FieldType.float64);
                    fields.addField(this.Linear_Add_Beta.simpleName(), FieldType.float64);
                    fields.addField(this.Linear_Add_Beta_SE.simpleName(), FieldType.float64);
                    fields.addField(this.Linear_Add_T.simpleName(), FieldType.float64);
                    hasLinearAdd = true;
                }
                if (methods.contains("linear-rec")) {
                    fields.addField(this.Linear_Rec_P.simpleName(), FieldType.float64);
                    fields.addField(this.Linear_Rec_Beta.simpleName(), FieldType.float64);
                    fields.addField(this.Linear_Rec_Beta_SE.simpleName(), FieldType.float64);
                    fields.addField(this.Linear_Rec_T.simpleName(), FieldType.float64);
                    hasLinearRec = true;
                }
                if (methods.contains("linear-dom")) {
                    fields.addField(this.Linear_Dom_P.simpleName(), FieldType.float64);
                    fields.addField(this.Linear_Dom_Beta.simpleName(), FieldType.float64);
                    fields.addField(this.Linear_Dom_Beta_SE.simpleName(), FieldType.float64);
                    fields.addField(this.Linear_Dom_T.simpleName(), FieldType.float64);
                    hasLinearDom = true;
                }
                if (methods.contains("allelic")) {
                    fields.addField(this.Allelic_Assoc_P.simpleName(), FieldType.float64);
                    hasAllelic = true;
                }
                if (methods.contains("model-gen")) {
                    fields.addField(this.Model_Genotypic_P.simpleName(), FieldType.float64);
                    hasModelGen = true;
                }
                if (methods.contains("model-trend")) {
                    fields.addField(this.Model_Trend_P.simpleName(), FieldType.float64);
                    hasModelTrend = true;
                }
                if (methods.contains("model-dom")) {
                    fields.addField(this.Model_Dominant_P.simpleName(), FieldType.float64);
                    hasModelDom = true;
                }
                if (methods.contains("model-rec")) {
                    fields.addField(this.Model_Recessive_P.simpleName(), FieldType.float64);
                    hasModelRec = true;
                }
                if (methods.contains("model-all")) {
                    fields.addField(this.Model_Allelic_P.simpleName(), this.Model_Allelic_P.type());
                    hasModelAll = true;
                }
                if (methods.contains("anova")) {
                    fields.addField(this.ANOVA_P.simpleName(), this.ANOVA_P.type());
                    fields.addField(this.ANOVA_F.simpleName(), this.ANOVA_F.type());
                    fields.addField(this.ANOVA_DFB.simpleName(), this.ANOVA_DFB.type());
                    fields.addField(this.ANOVA_DFW.simpleName(), this.ANOVA_DFW.type());
                    hasAnova = true;
                }
                fields.addField(this.CCT_P.simpleName(), this.CCT_P.type());
                fieldsAll.addFields((Iterable)fields);
            }
            final boolean finalHadLogisticAdd = hadLogisticAdd;
            final boolean finalHasLogisticDom = hasLogisticDom;
            final boolean finalHasLogisticRec = hasLogisticRec;
            final boolean finalHasLinearAdd = hasLinearAdd;
            final boolean finalHasLinearDom = hasLinearDom;
            final boolean finalHasLinearRec = hasLinearRec;
            final boolean finalHasAllelic = hasAllelic;
            final boolean finalHasModelGen = hasModelGen;
            final boolean finalHasModelTrend = hasModelTrend;
            final boolean finalHasModelDom = hasModelDom;
            final boolean finalHasModelRec = hasModelRec;
            final boolean finalHasModelAll = hasModelAll;
            final boolean finalHasAnova = hasAnova;
            GTBAnnotator.setInput(new GTBReaderOption(inputManager, false, true)).setOutput(this.outputFile).addMeta(inputManager.getMeta()).setListener(new AnnotationListener<Variant>("Associated", "Variants")).addDatabase(new PointerDatabase<Variant>(){
                final boolean useInteraction;
                final boolean useSex;
                final boolean useCov;
                final int[] interaction;
                final boolean standardBeta;
                final int cell;
                double[][] allCov;
                double[][] allPhenotype;
                double[] allSex;
                IntList sampleIds;
                final double[][] combinedCov;
                final boolean[] isBinaryPhenotypes;
                {
                    this.useInteraction = VariantAssocTask.this.ldPruneOptions.associationOptionSet.isUseInter();
                    this.useSex = VariantAssocTask.this.ldPruneOptions.associationOptionSet.isUseSex();
                    this.useCov = VariantAssocTask.this.generalIOOptions.phenoFileSet.covariableNames != null;
                    this.interaction = VariantAssocTask.this.ldPruneOptions.associationOptionSet.getInteractionParameters();
                    this.standardBeta = VariantAssocTask.this.ldPruneOptions.associationOptionSet.getStandardBeta();
                    this.cell = VariantAssocTask.this.ldPruneOptions.associationOptionSet.getCell();
                    this.isBinaryPhenotypes = GlobalPedIndividuals.getIsBinaryPhenotypes();
                    this.processIndividualData();
                    this.combinedCov = this.combineCovariates(this.allSex, this.allCov, this.useSex, this.useCov);
                    if (finalHasLinearAdd || finalHasLinearDom || finalHasLinearRec) {
                        this.standardizePhenotypes(this.allPhenotype);
                    }
                    for (String filePath : filePathIDs) {
                        GTBManager gtbManager = new GTBManager(filePath);
                        this.addTable(filePath, new GTBReaderOption(gtbManager, true, false));
                    }
                }

                @Override
                public Object getSource(Variant variant) {
                    return variant.getProperty("SOURCE@FILE_ID");
                }

                @Override
                public long getPointer(Variant variant) {
                    return (Long)variant.getProperty("SOURCE@FILE_POINTER");
                }

                @Override
                public IFieldCollection getAllFields() {
                    return fieldsAll;
                }

                private void standardizePhenotypes(double[][] phenotypes) {
                    if (this.standardBeta) {
                        for (int t = 0; t < this.isBinaryPhenotypes.length; ++t) {
                            if (this.isBinaryPhenotypes[t]) continue;
                            double mean = Summary.mean(phenotypes[t]);
                            double sd = Summary.sd(phenotypes[t]);
                            if (!(sd > 0.0)) continue;
                            for (int i = 0; i < phenotypes.length; ++i) {
                                phenotypes[t][i] = (phenotypes[t][i] - mean) / sd;
                            }
                        }
                    }
                }

                private int processGenotypeData(double[] geno, double[] processedGeno, int mode) {
                    int countNonZero = 0;
                    for (int i = 0; i < geno.length; ++i) {
                        switch (mode) {
                            case 1: {
                                processedGeno[i] = geno[i] == 2.0 ? 1.0 : geno[i];
                                break;
                            }
                            case 2: {
                                processedGeno[i] = geno[i] == 1.0 ? 0.0 : (geno[i] == 2.0 ? 1.0 : geno[i]);
                                break;
                            }
                            default: {
                                processedGeno[i] = geno[i];
                            }
                        }
                        if (processedGeno[i] == 0.0) continue;
                        ++countNonZero;
                    }
                    return countNonZero;
                }

                private void processIndividualData() {
                    int i;
                    IntList idList = new IntList();
                    List<double[]> phenotypesTmp = new List<double[]>();
                    DoubleList sexTmp = new DoubleList();
                    List<double[]> covTmp = new List<double[]>();
                    int subjectNum = GlobalPedIndividuals.size();
                    for (i = 0; i < subjectNum; ++i) {
                        double[] vals = (double[])GlobalPedIndividuals.get(i, "phenotype");
                        if (this.hasNaN(vals)) continue;
                        double[] covCode = (double[])GlobalPedIndividuals.get(i, "covarTraits");
                        if (this.useCov && this.hasNaN(covCode)) continue;
                        int sexCode = (Integer)GlobalPedIndividuals.get(i, "SEX");
                        if (this.useSex && sexCode == 0) continue;
                        phenotypesTmp.add(vals);
                        idList.add(i);
                        covTmp.add(covCode);
                        sexTmp.add(sexCode);
                    }
                    this.allCov = (double[][])covTmp.toArray((T1[])new double[0][0]);
                    this.allPhenotype = new double[this.isBinaryPhenotypes.length][phenotypesTmp.size()];
                    subjectNum = phenotypesTmp.size();
                    for (i = 0; i < subjectNum; ++i) {
                        for (int j = 0; j < this.isBinaryPhenotypes.length; ++j) {
                            this.allPhenotype[j][i] = ((double[])phenotypesTmp.get(i))[j];
                        }
                    }
                    this.sampleIds = idList;
                    this.allSex = sexTmp.toArray();
                }

                private double[][] combineCovariates(double[] sex, double[][] cov, boolean isSexEnabled, boolean isCovEnabled) {
                    if (!isSexEnabled && !isCovEnabled) {
                        return new double[sex.length][];
                    }
                    if (!isSexEnabled) {
                        return cov;
                    }
                    if (!isCovEnabled) {
                        double[][] result = new double[sex.length][1];
                        for (int i = 0; i < sex.length; ++i) {
                            result[i][0] = sex[i];
                        }
                        return result;
                    }
                    double[][] combined = new double[sex.length][];
                    for (int i = 0; i < sex.length; ++i) {
                        double[] row = new double[1 + (cov != null && cov[i] != null ? cov[i].length : 0)];
                        row[0] = sex[i];
                        if (cov != null && cov[i] != null) {
                            System.arraycopy(cov[i], 0, row, 1, cov[i].length);
                        }
                        combined[i] = row;
                    }
                    return combined;
                }

                private boolean hasNaN(double[] array) {
                    if (array == null) {
                        return true;
                    }
                    for (double value : array) {
                        if (!Double.isNaN(value)) continue;
                        return true;
                    }
                    return false;
                }

                private boolean allNaN(double[] array) {
                    if (array == null) {
                        return true;
                    }
                    for (double value : array) {
                        if (Double.isNaN(value)) continue;
                        return false;
                    }
                    return true;
                }

                @Override
                public boolean annotate(List<BoxRecord> databaseRecords, long pointer, Variant variant) {
                    BoxRecord databaseRecord = databaseRecords.get(0);
                    IGenotypes fullGenotypes = IGenotypes.load((Bytes)databaseRecord.get(null, "GT"));
                    DoubleList genoTmp = new DoubleList();
                    int countNonZero = 0;
                    for (int i = 0; i < this.sampleIds.size(); ++i) {
                        int originalIndex = this.sampleIds.get(i);
                        Genotype genotypeForSample = fullGenotypes.get(originalIndex);
                        if (genotypeForSample.getAN() == 0) {
                            genoTmp.add(Double.NaN);
                            continue;
                        }
                        int ac = genotypeForSample.getAC();
                        genoTmp.add(ac);
                        if (ac == 0) continue;
                        ++countNonZero;
                    }
                    double[] geno = genoTmp.toArray();
                    int minNonZero = 3;
                    boolean muchZero = countNonZero <= 3;
                    DoubleList[] pValuesCCT = new DoubleList[phenoNum];
                    for (int t = 0; t < phenoNum; ++t) {
                        pValuesCCT[t] = new DoubleList();
                    }
                    if (finalHadLogisticAdd) {
                        this.runLogistic(variant, geno, this.combinedCov, this.allPhenotype, 0, 3, muchZero, pValuesCCT);
                    }
                    if (finalHasLogisticDom) {
                        this.runLogistic(variant, geno, this.combinedCov, this.allPhenotype, 1, 3, muchZero, pValuesCCT);
                    }
                    if (finalHasLogisticRec) {
                        this.runLogistic(variant, geno, this.combinedCov, this.allPhenotype, 2, 3, muchZero, pValuesCCT);
                    }
                    if (finalHasLinearAdd) {
                        this.runLinear(variant, geno, this.combinedCov, this.allPhenotype, 0, 3, muchZero, pValuesCCT);
                    }
                    if (finalHasLinearDom) {
                        this.runLinear(variant, geno, this.combinedCov, this.allPhenotype, 1, 3, muchZero, pValuesCCT);
                    }
                    if (finalHasLinearRec) {
                        this.runLinear(variant, geno, this.combinedCov, this.allPhenotype, 2, 3, muchZero, pValuesCCT);
                    }
                    boolean atLeastOneOK = false;
                    for (int t = 0; t < phenoNum; ++t) {
                        String groupName = phenotypeNames[t] + "_Assoc@";
                        if (finalHasAllelic || finalHasModelGen || finalHasModelTrend || finalHasModelDom || finalHasModelRec || finalHasModelAll || finalHasAnova) {
                            int AACase = (Integer)variant.getProperty(phenotypeNames[t] + "_GTYSUM@RefHomGtyNum_CASE");
                            int AaCase = (Integer)variant.getProperty(phenotypeNames[t] + "_GTYSUM@HetGtyNum_CASE");
                            int aaCase = (Integer)variant.getProperty(phenotypeNames[t] + "_GTYSUM@AltHomGtyNum_CASE");
                            int AAControl = (Integer)variant.getProperty(phenotypeNames[t] + "_GTYSUM@RefHomGtyNum_CONTROL");
                            int AaControl = (Integer)variant.getProperty(phenotypeNames[t] + "_GTYSUM@HetGtyNum_CONTROL");
                            int aaControl = (Integer)variant.getProperty(phenotypeNames[t] + "_GTYSUM@AltHomGtyNum_CONTROL");
                            int maxSize = geno.length * 2 + 10;
                            AssociationModel associationModel = (AssociationModel)ASSOCIATION_MODEL_POOL.get();
                            if (finalHasAllelic) {
                                long[][] counts = new long[2][2];
                                counts[0][0] = (long)AACase + (long)AACase + (long)AaCase;
                                counts[0][1] = (long)AaCase + (long)aaCase + (long)aaCase;
                                counts[1][0] = (long)AAControl + (long)AAControl + (long)AaControl;
                                counts[1][1] = (long)AaControl + (long)aaControl + (long)aaControl;
                                double p = ContingencyTable.chiSquareTest(counts);
                                variant.setProperty(groupName + VariantAssocTask.this.Allelic_Assoc_P.simpleName(), p);
                                pValuesCCT[0].add(p);
                            }
                            if (finalHasModelTrend) {
                                associationModel.setMethodStrategy(new ModelTrend());
                                associationModel.execute(AACase, AaCase, aaCase, AAControl, AaControl, aaControl, maxSize, this.cell);
                                variant.setProperty(groupName + VariantAssocTask.this.Model_Trend_P.simpleName(), associationModel.pVal);
                                pValuesCCT[0].add(associationModel.pVal);
                            }
                            if (finalHasModelDom) {
                                associationModel.setMethodStrategy(new ModelDominant());
                                associationModel.execute(AACase, AaCase, aaCase, AAControl, AaControl, aaControl, maxSize, this.cell);
                                variant.setProperty(groupName + VariantAssocTask.this.Model_Dominant_P.simpleName(), associationModel.pVal);
                                pValuesCCT[0].add(associationModel.pVal);
                            }
                            if (finalHasModelRec) {
                                associationModel.setMethodStrategy(new ModelRecessive());
                                associationModel.execute(AACase, AaCase, aaCase, AAControl, AaControl, aaControl, maxSize, this.cell);
                                variant.setProperty(groupName + VariantAssocTask.this.Model_Recessive_P.simpleName(), associationModel.pVal);
                                pValuesCCT[0].add(associationModel.pVal);
                            }
                            if (finalHasModelAll) {
                                associationModel.setMethodStrategy(new ModelAllelic());
                                associationModel.execute(AACase, AaCase, aaCase, AAControl, AaControl, aaControl, maxSize, this.cell);
                                variant.setProperty(groupName + VariantAssocTask.this.Model_Allelic_P.simpleName(), associationModel.pVal);
                                pValuesCCT[0].add(associationModel.pVal);
                            }
                        }
                        if (finalHasAnova) {
                            ANOVA anova = new ANOVA(this.cell);
                            if (!muchZero) {
                                anova.setConfig(geno, this.allPhenotype[t]);
                                anova.calculate();
                                variant.setProperty(groupName + VariantAssocTask.this.ANOVA_P.simpleName(), anova.getPVal());
                                variant.setProperty(groupName + VariantAssocTask.this.ANOVA_F.simpleName(), anova.getFStatistic());
                                variant.setProperty(groupName + VariantAssocTask.this.ANOVA_DFB.simpleName(), anova.getDfb());
                                variant.setProperty(groupName + VariantAssocTask.this.ANOVA_DFW.simpleName(), anova.getDfw());
                                pValuesCCT[t].add(anova.getPVal());
                            } else {
                                this.setAnovaNaNs(variant, groupName);
                            }
                        }
                        double minCCTP = 10.0;
                        double cctP = CCT.calculate(pValuesCCT[t], null);
                        if (!Double.isNaN(cctP) && cctP < minCCTP) {
                            minCCTP = cctP;
                        }
                        variant.setProperty(groupName + VariantAssocTask.this.CCT_P.simpleName(), cctP);
                        if (!(minCCTP <= VariantAssocTask.this.pCut)) continue;
                        atLeastOneOK = true;
                    }
                    return atLeastOneOK;
                }

                private void runLogistic(Variant variant, double[] originalGeno, double[][] cov, double[][] phenotypes, int mode, int minNonZero, boolean isMuchZero, DoubleList[] pValuesCCT) {
                    if (phenotypes[0].length < 2) {
                        return;
                    }
                    for (int t = 0; t < phenotypeNames.length; ++t) {
                        double[] betaSEP;
                        FieldMeta upperField;
                        FieldMeta lowerField;
                        FieldMeta orField;
                        FieldMeta seField;
                        FieldMeta betaField;
                        FieldMeta pField;
                        double[] genoToUse;
                        String groupName = phenotypeNames[t] + "_Assoc@";
                        if (mode == 0) {
                            genoToUse = originalGeno;
                            if (isMuchZero) {
                                this.setLogisticNaNs(variant, VariantAssocTask.this.Logistic_Add_P, VariantAssocTask.this.Logistic_Add_Beta, VariantAssocTask.this.Logistic_Add_Beta_SE, VariantAssocTask.this.Logistic_Add_OR, VariantAssocTask.this.Logistic_Add_Lower, VariantAssocTask.this.Logistic_Add_Upper, groupName);
                                return;
                            }
                            pField = VariantAssocTask.this.Logistic_Add_P;
                            betaField = VariantAssocTask.this.Logistic_Add_Beta;
                            seField = VariantAssocTask.this.Logistic_Add_Beta_SE;
                            orField = VariantAssocTask.this.Logistic_Add_OR;
                            lowerField = VariantAssocTask.this.Logistic_Add_Lower;
                            upperField = VariantAssocTask.this.Logistic_Add_Upper;
                        } else {
                            double[] processedGeno = new double[originalGeno.length];
                            int nonZeroCount = this.processGenotypeData(originalGeno, processedGeno, mode);
                            if (nonZeroCount <= minNonZero) {
                                if (mode == 1) {
                                    this.setLogisticNaNs(variant, VariantAssocTask.this.Logistic_Dom_P, VariantAssocTask.this.Logistic_Dom_Beta, VariantAssocTask.this.Logistic_Dom_Beta_SE, VariantAssocTask.this.Logistic_Dom_OR, VariantAssocTask.this.Logistic_Dom_Lower, VariantAssocTask.this.Logistic_Dom_Upper, groupName);
                                } else {
                                    this.setLogisticNaNs(variant, VariantAssocTask.this.Logistic_Rec_P, VariantAssocTask.this.Logistic_Rec_Beta, VariantAssocTask.this.Logistic_Rec_Beta_SE, VariantAssocTask.this.Logistic_Rec_OR, VariantAssocTask.this.Logistic_Rec_Lower, VariantAssocTask.this.Logistic_Rec_Upper, groupName);
                                }
                                return;
                            }
                            genoToUse = processedGeno;
                            if (mode == 1) {
                                pField = VariantAssocTask.this.Logistic_Dom_P;
                                betaField = VariantAssocTask.this.Logistic_Dom_Beta;
                                seField = VariantAssocTask.this.Logistic_Dom_Beta_SE;
                                orField = VariantAssocTask.this.Logistic_Dom_OR;
                                lowerField = VariantAssocTask.this.Logistic_Dom_Lower;
                                upperField = VariantAssocTask.this.Logistic_Dom_Upper;
                            } else {
                                pField = VariantAssocTask.this.Logistic_Rec_P;
                                betaField = VariantAssocTask.this.Logistic_Rec_Beta;
                                seField = VariantAssocTask.this.Logistic_Rec_Beta_SE;
                                orField = VariantAssocTask.this.Logistic_Rec_OR;
                                lowerField = VariantAssocTask.this.Logistic_Rec_Lower;
                                upperField = VariantAssocTask.this.Logistic_Rec_Upper;
                            }
                        }
                        Object transposedGty = this.useInteraction ? this.jointInteractiveGTY(genoToUse, cov, this.interaction) : (Object)new double[][]{genoToUse};
                        double p = Double.NaN;
                        LogisticRegressionGtyFast logisticRegression = (LogisticRegressionGtyFast)LOGISTIC_REGRESSION_POOL_FAST[t].get();
                        if (!logisticRegression.isPreCalculated()) {
                            logisticRegression.preCalculate(phenotypes[t], cov);
                        }
                        if ((p = (betaSEP = logisticRegression.testSnp((double[][])transposedGty)[0])[2]) > 0.05) {
                            variant.setProperty(groupName + pField.simpleName(), p);
                            variant.setProperty(groupName + betaField.simpleName(), betaSEP[0]);
                            variant.setProperty(groupName + seField.simpleName(), betaSEP[1]);
                            variant.setProperty(groupName + orField.simpleName(), Math.exp(betaSEP[0]));
                            double orL = Math.exp(betaSEP[0] - 1.96 * betaSEP[1]);
                            double orU = Math.exp(betaSEP[0] + 1.96 * betaSEP[1]);
                            variant.setProperty(groupName + lowerField.simpleName(), orL);
                            variant.setProperty(groupName + upperField.simpleName(), orU);
                        } else {
                            double[][] X2 = this.processData(genoToUse, cov, this.interaction, this.useInteraction, true);
                            double[] availablePhenotypes = this.screenGenotypeForPhenotypes(phenotypes[t], genoToUse);
                            LogisticRegressionGty logisticRegression1 = (LogisticRegressionGty)LOGISTIC_REGRESSION_POOL[t].get();
                            logisticRegression1.reset(X2, availablePhenotypes, false);
                            try {
                                logisticRegression1.fitLM5();
                                double[] coef = logisticRegression1.getCoefs();
                                double[] se = logisticRegression1.getSE();
                                double[] OR = logisticRegression1.getOR();
                                double[][] confidenceInterval = logisticRegression1.getORConfidenceInterval();
                                p = logisticRegression1.getCoefPValueWithTTest(1);
                                variant.setProperty(groupName + pField.simpleName(), p);
                                variant.setProperty(groupName + betaField.simpleName(), coef[1]);
                                variant.setProperty(groupName + seField.simpleName(), se[1]);
                                variant.setProperty(groupName + orField.simpleName(), OR[1]);
                                variant.setProperty(groupName + lowerField.simpleName(), confidenceInterval[1][0]);
                                variant.setProperty(groupName + upperField.simpleName(), confidenceInterval[1][1]);
                            }
                            catch (Exception e) {
                                this.setLogisticNaNs(variant, pField, betaField, seField, orField, lowerField, upperField, groupName);
                            }
                        }
                        pValuesCCT[t].add(p);
                    }
                }

                private void runLinear(Variant variant, double[] originalGeno, double[][] cov, double[][] phenotypes, int mode, int minNonZero, boolean isMuchZero, DoubleList[] pValuesCCT) {
                    if (phenotypes[0].length < 2) {
                        return;
                    }
                    for (int t = 0; t < phenotypeNames.length; ++t) {
                        Object transposedGty;
                        double[] betaSEP;
                        FieldMeta tField;
                        FieldMeta seField;
                        FieldMeta betaField;
                        FieldMeta pField;
                        double[] genoToUse;
                        String groupName = phenotypeNames[t] + "_Assoc@";
                        if (mode == 0) {
                            genoToUse = originalGeno;
                            if (isMuchZero) {
                                this.setLinearNaNs(variant, VariantAssocTask.this.Linear_Add_P, VariantAssocTask.this.Linear_Add_Beta, VariantAssocTask.this.Linear_Add_Beta_SE, VariantAssocTask.this.Linear_Add_T, groupName);
                                return;
                            }
                            pField = VariantAssocTask.this.Linear_Add_P;
                            betaField = VariantAssocTask.this.Linear_Add_Beta;
                            seField = VariantAssocTask.this.Linear_Add_Beta_SE;
                            tField = VariantAssocTask.this.Linear_Add_T;
                        } else {
                            double[] processedGeno = new double[originalGeno.length];
                            int nonZeroCount = this.processGenotypeData(originalGeno, processedGeno, mode);
                            if (nonZeroCount <= minNonZero) {
                                if (mode == 1) {
                                    this.setLinearNaNs(variant, VariantAssocTask.this.Linear_Dom_P, VariantAssocTask.this.Linear_Dom_Beta, VariantAssocTask.this.Linear_Dom_Beta_SE, VariantAssocTask.this.Linear_Dom_T, groupName);
                                } else {
                                    this.setLinearNaNs(variant, VariantAssocTask.this.Linear_Rec_P, VariantAssocTask.this.Linear_Rec_Beta, VariantAssocTask.this.Linear_Rec_Beta_SE, VariantAssocTask.this.Linear_Rec_T, groupName);
                                }
                                return;
                            }
                            genoToUse = processedGeno;
                            if (mode == 1) {
                                pField = VariantAssocTask.this.Linear_Dom_P;
                                betaField = VariantAssocTask.this.Linear_Dom_Beta;
                                seField = VariantAssocTask.this.Linear_Dom_Beta_SE;
                                tField = VariantAssocTask.this.Linear_Dom_T;
                            } else {
                                pField = VariantAssocTask.this.Linear_Rec_P;
                                betaField = VariantAssocTask.this.Linear_Rec_Beta;
                                seField = VariantAssocTask.this.Linear_Rec_Beta_SE;
                                tField = VariantAssocTask.this.Linear_Rec_T;
                            }
                        }
                        double p = Double.NaN;
                        LinearRegressionGtyFast linearRegression = (LinearRegressionGtyFast)LINEAR_REGRESSION_POOL_FAST[t].get();
                        if (!linearRegression.isPreCalculated()) {
                            linearRegression.preCalculate(phenotypes[t], cov);
                        }
                        if ((p = (betaSEP = linearRegression.testSnp((double[][])(transposedGty = this.useInteraction ? this.jointInteractiveGTY(genoToUse, cov, this.interaction) : (Object)new double[][]{genoToUse}))[0])[2]) > 0.05) {
                            variant.setProperty(groupName + pField.simpleName(), p);
                            variant.setProperty(groupName + betaField.simpleName(), betaSEP[0]);
                            variant.setProperty(groupName + seField.simpleName(), betaSEP[1]);
                            variant.setProperty(groupName + tField.simpleName(), betaSEP[0] / betaSEP[1]);
                        } else {
                            double[][] X2 = this.processData(genoToUse, cov, this.interaction, this.useInteraction, true);
                            double[] availablePhenotypes = this.screenGenotypeForPhenotypes(phenotypes[t], genoToUse);
                            LinearRegressionGty linearRegression1 = (LinearRegressionGty)LINEAR_REGRESSION_POOL[t].get();
                            linearRegression1.reset(X2, availablePhenotypes, false);
                            try {
                                linearRegression1.fit();
                                p = linearRegression1.calculatePValues()[1];
                                variant.setProperty(groupName + pField.simpleName(), p);
                                variant.setProperty(groupName + betaField.simpleName(), linearRegression1.beta(1));
                                variant.setProperty(groupName + seField.simpleName(), linearRegression1.getSE()[1]);
                                variant.setProperty(groupName + tField.simpleName(), linearRegression1.getTValues()[1]);
                            }
                            catch (Exception e) {
                                this.setLinearNaNs(variant, pField, betaField, seField, tField, groupName);
                            }
                        }
                        pValuesCCT[t].add(p);
                    }
                }

                private void setLogisticNaNs(Variant v, FieldMeta p, FieldMeta beta, FieldMeta se, FieldMeta or, FieldMeta lower, FieldMeta upper, String groupName) {
                    v.setProperty(groupName + p.simpleName(), Double.NaN);
                    v.setProperty(groupName + beta.simpleName(), Double.NaN);
                    v.setProperty(groupName + se.simpleName(), Double.NaN);
                    v.setProperty(groupName + or.simpleName(), Double.NaN);
                    v.setProperty(groupName + lower.simpleName(), Double.NaN);
                    v.setProperty(groupName + upper.simpleName(), Double.NaN);
                }

                private void setLinearNaNs(Variant v, FieldMeta p, FieldMeta beta, FieldMeta se, FieldMeta tv, String groupName) {
                    v.setProperty(groupName + p.simpleName(), Double.NaN);
                    v.setProperty(groupName + beta.simpleName(), Double.NaN);
                    v.setProperty(groupName + se.simpleName(), Double.NaN);
                    v.setProperty(groupName + tv.simpleName(), Double.NaN);
                }

                private void setAnovaNaNs(Variant v, String groupName) {
                    v.setProperty(groupName + VariantAssocTask.this.ANOVA_P.simpleName(), Double.NaN);
                    v.setProperty(groupName + VariantAssocTask.this.ANOVA_F.simpleName(), Double.NaN);
                    v.setProperty(groupName + VariantAssocTask.this.ANOVA_DFB.simpleName(), Double.NaN);
                    v.setProperty(groupName + VariantAssocTask.this.ANOVA_DFW.simpleName(), Double.NaN);
                }

                private double[][] processData(double[] geno, double[][] covData, int[] paraList, boolean hasInteraction, boolean addIntercept) {
                    List resultList = (List)COV_TMP_POOL.get();
                    resultList.clear();
                    List newRow = (List)NEW_ROW_POOL.get();
                    double[] temp = (double[])TEMP_ARRAY_POOL.get();
                    for (int i = 0; i < geno.length; ++i) {
                        double[] row;
                        newRow.clear();
                        double gty = geno[i];
                        if (Double.isNaN(gty)) continue;
                        double[] COV = covData[i];
                        if (COV == null || COV.length == 0) {
                            if (addIntercept) {
                                resultList.add(new double[]{1.0, gty});
                                continue;
                            }
                            resultList.add(new double[]{gty});
                            continue;
                        }
                        newRow.add(gty);
                        for (double covValue : COV) {
                            newRow.add(covValue);
                        }
                        if (hasInteraction) {
                            this.addInteractionTerms(gty, COV, paraList, newRow);
                        }
                        if (temp.length < newRow.size()) {
                            temp = new double[newRow.size()];
                            TEMP_ARRAY_POOL.set(temp);
                        }
                        for (int j = 0; j < newRow.size(); ++j) {
                            temp[j] = (Double)newRow.get(j);
                        }
                        if (addIntercept) {
                            row = new double[newRow.size() + 1];
                            row[0] = 1.0;
                            System.arraycopy(temp, 0, row, 1, newRow.size());
                        } else {
                            row = new double[newRow.size()];
                            System.arraycopy(temp, 0, row, 0, row.length);
                        }
                        resultList.add(row);
                    }
                    return (double[][])resultList.toArray((T1[])new double[resultList.size()][]);
                }

                private double[][] jointInteractiveGTY(double[] geno, double[][] covData, int[] paraList) {
                    double[][] newGty = new double[paraList.length + 1][geno.length];
                    System.arraycopy(geno, 0, newGty[0], 0, geno.length);
                    for (int i = 0; i < geno.length; ++i) {
                        int j;
                        double gty = geno[i];
                        double[] COV = covData[i];
                        if (Double.isNaN(gty) || COV == null || COV.length == 0) {
                            for (j = 0; j < paraList.length; ++j) {
                                newGty[j + 1][i] = Double.NaN;
                            }
                            continue;
                        }
                        for (j = 0; j < paraList.length; ++j) {
                            newGty[j + 1][i] = gty * COV[j];
                        }
                    }
                    return newGty;
                }

                private int[] screenGenotype0(double[] geno) {
                    IntList missingIndexes = new IntList();
                    for (int i = 0; i < geno.length; ++i) {
                        if (!Double.isNaN(geno[i])) continue;
                        missingIndexes.add(i);
                    }
                    return missingIndexes.toArray();
                }

                private double[] screenGenotypeForPhenotypes(double[] phenotypes, double[] geno) {
                    DoubleList availablePhenotypes = new DoubleList();
                    for (int i = 0; i < geno.length; ++i) {
                        if (Double.isNaN(geno[i])) continue;
                        availablePhenotypes.add(phenotypes[i]);
                    }
                    return availablePhenotypes.toArray();
                }

                private void addInteractionTerms(double SNP, double[] COV, int[] paraList, List<Double> newRow) {
                    if (paraList == null || paraList.length == 0) {
                        for (double covValue : COV) {
                            newRow.add(SNP * covValue);
                        }
                    } else {
                        for (int param : paraList) {
                            int index = param - 1;
                            if (index < 0 || index >= COV.length) continue;
                            newRow.add(SNP * COV[index]);
                        }
                    }
                }
            }).submit(this.generalIOOptions.threads);
            completeTaskResult.setOutputPath(this.outputFile);
            SetupApplication.GlobalTaskTracker.recordTaskCompletion(completeTaskResult);
            GTBManager outputManager = new GTBManager(this.outputFile);
            SetupApplication.GlobalLogger.info("{} out of {} variants are retained after pruning by association p value cutoff {}.", outputManager.numOfVariants(), inputManager.numOfVariants(), this.pCut);
            context.put("UpdatedBaseVariantSet", true);
        } else {
            context.put("UpdatedBaseVariantSet", false);
        }
        context.put("AnnotationBaseVariantSet", this.outputFile);
    }

    private String digest() {
        StringBuilder sb = new StringBuilder();
        sb.append(Arrays.toString(GlobalPedIndividuals.getPhenotypeNames())).append("|");
        sb.append(Arrays.toString(GlobalPedIndividuals.getCovariableNames())).append("|");
        sb.append(this.ldPruneOptions.associationOptionSet.hashCode());
        sb.append(",");
        sb.append(this.pCut);
        return ITrack.digest(sb.toString());
    }
}

