/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.kgga.command.task;

import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.ccf.field.FieldGroupMeta;
import edu.sysu.pmglab.ccf.field.FieldMeta;
import edu.sysu.pmglab.ccf.field.IFieldCollection;
import edu.sysu.pmglab.ccf.record.BoxRecord;
import edu.sysu.pmglab.ccf.toolkit.annotator.PointerDatabase;
import edu.sysu.pmglab.ccf.toolkit.listener.AnnotationListener;
import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.list.DoubleList;
import edu.sysu.pmglab.container.list.IntList;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.executor.Context;
import edu.sysu.pmglab.executor.ITask;
import edu.sysu.pmglab.executor.Status;
import edu.sysu.pmglab.executor.track.ITrack;
import edu.sysu.pmglab.gtb.GTBManager;
import edu.sysu.pmglab.gtb.GTBReaderOption;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.genome.genotype.IGenotypes;
import edu.sysu.pmglab.gtb.toolkit.GTBAnnotator;
import edu.sysu.pmglab.io.FileUtils;
import edu.sysu.pmglab.kgga.command.SetupApplication;
import edu.sysu.pmglab.kgga.command.TaskTracker;
import edu.sysu.pmglab.kgga.command.Utility;
import edu.sysu.pmglab.kgga.command.pipeline.GeneralIOOptions;
import edu.sysu.pmglab.kgga.command.pipeline.LDPruneOptions;
import edu.sysu.pmglab.kgga.io.GlobalPedIndividuals;
import edu.sysu.pmglab.kgga.io.InputOutputFileSet;
import edu.sysu.pmglab.stat.ANOVA;
import edu.sysu.pmglab.stat.AssociationModel;
import edu.sysu.pmglab.stat.CCT;
import edu.sysu.pmglab.stat.ContingencyTable;
import edu.sysu.pmglab.stat.LinearRegression;
import edu.sysu.pmglab.stat.LogisticRegression;
import edu.sysu.pmglab.stat.ModelAllelic;
import edu.sysu.pmglab.stat.ModelDominant;
import edu.sysu.pmglab.stat.ModelRecessive;
import edu.sysu.pmglab.stat.ModelTrend;
import edu.sysu.pmglab.stat.Summary;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;

public class VariantAssocTask0
implements ITask {
    private static final int ADDITIVE = 0;
    private static final int DOMINANT = 1;
    private static final int RECESSIVE = 2;
    private static final ThreadLocal<AssociationModel> ASSOCIATION_MODEL_POOL = ThreadLocal.withInitial(AssociationModel::new);
    private static final ThreadLocal<List<double[]>> COV_TMP_POOL = ThreadLocal.withInitial(List::new);
    private static final ThreadLocal<List<Double>> NEW_ROW_POOL = ThreadLocal.withInitial(List::new);
    private static final ThreadLocal<double[]> TEMP_ARRAY_POOL = ThreadLocal.withInitial(() -> new double[1000]);
    GeneralIOOptions generalIOOptions;
    LDPruneOptions ldPruneOptions;
    double pCut = 1.0;
    File outputFile;
    final FieldMeta Logistic_Add_P = FieldMeta.of("Assoc@Logistic_Add_P", FieldType.float64);
    final FieldMeta Logistic_Add_Beta = FieldMeta.of("Assoc@Logistic_Add_Beta", FieldType.float64);
    final FieldMeta Logistic_Add_Beta_SE = FieldMeta.of("Assoc@Logistic_Add_Beta_SE", FieldType.float64);
    final FieldMeta Logistic_Add_OR = FieldMeta.of("Assoc@Logistic_Add_OR", FieldType.float64);
    final FieldMeta Logistic_Add_Upper = FieldMeta.of("Assoc@Logistic_Add_OR_Upper", FieldType.float64);
    final FieldMeta Logistic_Add_Lower = FieldMeta.of("Assoc@Logistic_Add_OR_Lower", FieldType.float64);
    final FieldMeta Logistic_Dom_P = FieldMeta.of("Assoc@Logistic_Dom_P", FieldType.float64);
    final FieldMeta Logistic_Dom_Beta = FieldMeta.of("Assoc@Logistic_Dom_Beta", FieldType.float64);
    final FieldMeta Logistic_Dom_Beta_SE = FieldMeta.of("Assoc@Logistic_Dom_Beta_SE", FieldType.float64);
    final FieldMeta Logistic_Dom_OR = FieldMeta.of("Assoc@Logistic_Dom_OR", FieldType.float64);
    final FieldMeta Logistic_Dom_Upper = FieldMeta.of("Assoc@Logistic_Dom_OR_Upper", FieldType.float64);
    final FieldMeta Logistic_Dom_Lower = FieldMeta.of("Assoc@Logistic_Dom_OR_Lower", FieldType.float64);
    final FieldMeta Logistic_Rec_P = FieldMeta.of("Assoc@Logistic_Rec_P", FieldType.float64);
    final FieldMeta Logistic_Rec_Beta = FieldMeta.of("Assoc@Logistic_Rec_Beta", FieldType.float64);
    final FieldMeta Logistic_Rec_Beta_SE = FieldMeta.of("Assoc@Logistic_Rec_Beta_SE", FieldType.float64);
    final FieldMeta Logistic_Rec_OR = FieldMeta.of("Assoc@Logistic_Rec_OR", FieldType.float64);
    final FieldMeta Logistic_Rec_Upper = FieldMeta.of("Assoc@Logistic_Rec_OR_Upper", FieldType.float64);
    final FieldMeta Logistic_Rec_Lower = FieldMeta.of("Assoc@Logistic_Rec_OR_Lower", FieldType.float64);
    final FieldMeta Allelic_Assoc_P = FieldMeta.of("Assoc@Allelic_Assoc_P", FieldType.float64);
    final FieldMeta Model_Trend_P = FieldMeta.of("Assoc@Trend_Model_P", FieldType.float64);
    final FieldMeta Model_Allelic_P = FieldMeta.of("Assoc@Allelic_Model_P", FieldType.float64);
    final FieldMeta Model_Dominant_P = FieldMeta.of("Assoc@Dominant_Model_P", FieldType.float64);
    final FieldMeta Model_Recessive_P = FieldMeta.of("Assoc@Recessive_Model_P", FieldType.float64);
    final FieldMeta Model_Genotypic_P = FieldMeta.of("Assoc@Genotypic_Model_P", FieldType.float64);
    final FieldMeta ANOVA_P = FieldMeta.of("Assoc@ANOVA_P", FieldType.float64);
    final FieldMeta ANOVA_F = FieldMeta.of("Assoc@ANOVA_FStatistic", FieldType.float64);
    final FieldMeta ANOVA_DFB = FieldMeta.of("Assoc@ANOVA_DFB", FieldType.float64);
    final FieldMeta ANOVA_DFW = FieldMeta.of("Assoc@ANOVA_DFW", FieldType.float64);
    final FieldMeta CCT_P = FieldMeta.of("Assoc@CCT_P", FieldType.float64);
    final FieldMeta Linear_Add_P = FieldMeta.of("Assoc@Linear_Add_P", FieldType.float64);
    final FieldMeta Linear_Add_Beta = FieldMeta.of("Assoc@Linear_Add_Beta", FieldType.float64);
    final FieldMeta Linear_Add_Beta_SE = FieldMeta.of("Assoc@Linear_Add_Beta_SE", FieldType.float64);
    final FieldMeta Linear_Add_T = FieldMeta.of("Assoc@Linear_Add_T", FieldType.float64);
    final FieldMeta Linear_Rec_P = FieldMeta.of("Assoc@Linear_Rec_P", FieldType.float64);
    final FieldMeta Linear_Rec_Beta = FieldMeta.of("Assoc@Linear_Rec_Beta", FieldType.float64);
    final FieldMeta Linear_Rec_Beta_SE = FieldMeta.of("Assoc@Linear_Rec_Beta_SE", FieldType.float64);
    final FieldMeta Linear_Rec_T = FieldMeta.of("Assoc@Linear_Rec_T", FieldType.float64);
    final FieldMeta Linear_Dom_P = FieldMeta.of("Assoc@Linear_Dom_P", FieldType.float64);
    final FieldMeta Linear_Dom_Beta = FieldMeta.of("Assoc@Linear_Dom_Beta", FieldType.float64);
    final FieldMeta Linear_Dom_Beta_SE = FieldMeta.of("Assoc@Linear_Dom_Beta_SE", FieldType.float64);
    final FieldMeta Linear_Dom_T = FieldMeta.of("Assoc@Linear_Dom_T", FieldType.float64);

    public VariantAssocTask0(File outputDir, boolean makeDir, GeneralIOOptions generalIOOptions, LDPruneOptions ldPruneOptions) {
        if (makeDir) {
            outputDir = FileUtils.getSubFile(outputDir, this.getClass().getSimpleName());
            outputDir.mkdirs();
        }
        this.outputFile = FileUtils.getSubFile(outputDir, InputOutputFileSet.getAnnotationFileName());
        this.generalIOOptions = generalIOOptions;
        this.ldPruneOptions = ldPruneOptions;
        this.pCut = ldPruneOptions.pruneP;
    }

    @Override
    public void execute(Status status, Context context) throws Exception, Error {
        File inputFile = (File)context.cast("AnnotationBaseVariantSet");
        GTBManager inputManager = new GTBManager(inputFile);
        Boolean updatedVariantSet = (Boolean)context.cast("UpdatedBaseVariantSet");
        if (updatedVariantSet == null) {
            updatedVariantSet = false;
        }
        TaskTracker.TaskResult completeTaskResult = new TaskTracker.TaskResult(this.getClass().getName(), Utility.MD5File(inputFile), this.digest());
        Optional<File> outputPathOpt = SetupApplication.GlobalTaskTracker.checkTask(completeTaskResult);
        outputPathOpt.ifPresent(file -> {
            this.outputFile = file;
        });
        if (updatedVariantSet.booleanValue() || !this.outputFile.exists() || !outputPathOpt.isPresent()) {
            final Set<String> filePathIDs = inputManager.getMeta().get("SOURCE@FILE_ID").apply(meta -> (String)meta.getValue()).toSet();
            HashSet<String> methods = new HashSet<String>(Arrays.asList(this.ldPruneOptions.associationOptionSet.getAssociationMethod()));
            final FieldGroupMeta fields = new FieldGroupMeta("Assoc");
            boolean hadLogisticAdd = false;
            boolean hasLogisticDom = false;
            boolean hasLogisticRec = false;
            boolean hasAllelic = false;
            boolean hasModelGen = false;
            boolean hasModelTrend = false;
            boolean hasModelDom = false;
            boolean hasModelRec = false;
            boolean hasModelAll = false;
            boolean hasAnova = false;
            boolean hasLinearAdd = false;
            boolean hasLinearDom = false;
            boolean hasLinearRec = false;
            if (methods.contains("logistic-add")) {
                fields.addField(this.Logistic_Add_P);
                fields.addField(this.Logistic_Add_Beta);
                fields.addField(this.Logistic_Add_Beta_SE);
                fields.addField(this.Logistic_Add_OR);
                fields.addField(this.Logistic_Add_Lower);
                fields.addField(this.Logistic_Add_Upper);
                hadLogisticAdd = true;
            }
            if (methods.contains("logistic-dom")) {
                fields.addField(this.Logistic_Dom_P);
                fields.addField(this.Logistic_Dom_Beta);
                fields.addField(this.Logistic_Dom_Beta_SE);
                fields.addField(this.Logistic_Dom_OR);
                fields.addField(this.Logistic_Dom_Lower);
                fields.addField(this.Logistic_Dom_Upper);
                hasLogisticDom = true;
            }
            if (methods.contains("logistic-rec")) {
                fields.addField(this.Logistic_Rec_P);
                fields.addField(this.Logistic_Rec_Beta);
                fields.addField(this.Logistic_Rec_Beta_SE);
                fields.addField(this.Logistic_Rec_OR);
                fields.addField(this.Logistic_Rec_Lower);
                fields.addField(this.Logistic_Rec_Upper);
                hasLogisticRec = true;
            }
            if (methods.contains("linear-add")) {
                fields.addField(this.Linear_Add_P);
                fields.addField(this.Linear_Add_Beta);
                fields.addField(this.Linear_Add_Beta_SE);
                fields.addField(this.Linear_Add_T);
                hasLinearAdd = true;
            }
            if (methods.contains("linear-rec")) {
                fields.addField(this.Linear_Rec_P);
                fields.addField(this.Linear_Rec_Beta);
                fields.addField(this.Linear_Rec_Beta_SE);
                fields.addField(this.Linear_Rec_T);
                hasLinearRec = true;
            }
            if (methods.contains("linear-dom")) {
                fields.addField(this.Linear_Dom_P);
                fields.addField(this.Linear_Dom_Beta);
                fields.addField(this.Linear_Dom_Beta_SE);
                fields.addField(this.Linear_Dom_T);
                hasLinearDom = true;
            }
            if (methods.contains("allelic")) {
                fields.addField(this.Allelic_Assoc_P);
                hasAllelic = true;
            }
            if (methods.contains("model-gen")) {
                fields.addField(this.Model_Genotypic_P);
                hasModelGen = true;
            }
            if (methods.contains("model-trend")) {
                fields.addField(this.Model_Trend_P);
                hasModelTrend = true;
            }
            if (methods.contains("model-dom")) {
                fields.addField(this.Model_Dominant_P);
                hasModelDom = true;
            }
            if (methods.contains("model-rec")) {
                fields.addField(this.Model_Recessive_P);
                hasModelRec = true;
            }
            if (methods.contains("model-all")) {
                fields.addField(this.Model_Allelic_P);
                hasModelAll = true;
            }
            if (methods.contains("anova")) {
                fields.addField(this.ANOVA_P);
                fields.addField(this.ANOVA_F);
                fields.addField(this.ANOVA_DFB);
                fields.addField(this.ANOVA_DFW);
                hasAnova = true;
            }
            fields.addField(this.CCT_P);
            final boolean finalHadLogisticAdd = hadLogisticAdd;
            final boolean finalHasLogisticDom = hasLogisticDom;
            final boolean finalHasLogisticRec = hasLogisticRec;
            final boolean finalHasLinearAdd = hasLinearAdd;
            final boolean finalHasLinearDom = hasLinearDom;
            final boolean finalHasLinearRec = hasLinearRec;
            final boolean finalHasAllelic = hasAllelic;
            final boolean finalHasModelGen = hasModelGen;
            final boolean finalHasModelTrend = hasModelTrend;
            final boolean finalHasModelDom = hasModelDom;
            final boolean finalHasModelRec = hasModelRec;
            final boolean finalHasModelAll = hasModelAll;
            final boolean finalHasAnova = hasAnova;
            GTBAnnotator.setInput(new GTBReaderOption(inputManager, false, true)).setOutput(this.outputFile).addMeta(inputManager.getMeta()).setListener(new AnnotationListener<Variant>("Associated", "Variants")).addDatabase(new PointerDatabase<Variant>(){
                final boolean useInteraction;
                final boolean useSex;
                final boolean useCov;
                final int[] interaction;
                final boolean standardBeta;
                final int cell;
                double[][] allCov;
                double[] allPhenotype;
                double[] allSex;
                IntList sampleIds;
                boolean hasMissingPhenotypes;
                final boolean isContinuous;
                {
                    this.useInteraction = VariantAssocTask0.this.ldPruneOptions.associationOptionSet.isUseInter();
                    this.useSex = VariantAssocTask0.this.ldPruneOptions.associationOptionSet.isUseSex();
                    this.useCov = VariantAssocTask0.this.generalIOOptions.phenoFileSet.covariableNames != null;
                    this.interaction = VariantAssocTask0.this.ldPruneOptions.associationOptionSet.getInteractionParameters();
                    this.standardBeta = VariantAssocTask0.this.ldPruneOptions.associationOptionSet.getStandardBeta();
                    this.cell = VariantAssocTask0.this.ldPruneOptions.associationOptionSet.getCell();
                    this.hasMissingPhenotypes = false;
                    this.isContinuous = !GlobalPedIndividuals.isBinaryPhenotypes(0);
                    this.processIndividualData(this.isContinuous);
                    for (String filePath : filePathIDs) {
                        GTBManager gtbManager = new GTBManager(filePath);
                        this.addTable(filePath, new GTBReaderOption(gtbManager, true, false));
                    }
                }

                @Override
                public Object getSource(Variant variant) {
                    return variant.getProperty("SOURCE@FILE_ID");
                }

                @Override
                public long getPointer(Variant variant) {
                    return (Long)variant.getProperty("SOURCE@FILE_POINTER");
                }

                @Override
                public IFieldCollection getAllFields() {
                    return fields;
                }

                private void standardizePhenotypes(double[] phenotypes) {
                    if (VariantAssocTask0.this.ldPruneOptions.associationOptionSet.getStandardBeta()) {
                        double mean = Summary.mean(phenotypes);
                        double sd = Summary.sd(phenotypes);
                        for (int i = 0; i < phenotypes.length; ++i) {
                            phenotypes[i] = (phenotypes[i] - mean) / sd;
                        }
                    }
                }

                private int processGenotypeData(double[] geno, double[] processedGeno, int mode) {
                    int countNonZero = 0;
                    for (int i = 0; i < geno.length; ++i) {
                        switch (mode) {
                            case 1: {
                                processedGeno[i] = geno[i] == 2.0 ? 1.0 : geno[i];
                                break;
                            }
                            case 2: {
                                processedGeno[i] = geno[i] == 1.0 ? 0.0 : (geno[i] == 2.0 ? 1.0 : geno[i]);
                                break;
                            }
                            default: {
                                processedGeno[i] = geno[i];
                            }
                        }
                        if (processedGeno[i] == 0.0) continue;
                        ++countNonZero;
                    }
                    return countNonZero;
                }

                private void processIndividualData(boolean isContinuous) throws IOException {
                    IntList idList = new IntList();
                    DoubleList phenotypesTmp = new DoubleList();
                    DoubleList sexTmp = new DoubleList();
                    List<double[]> covTmp = new List<double[]>();
                    int subjectNum = GlobalPedIndividuals.size();
                    for (int i = 0; i < subjectNum; ++i) {
                        int sexCode;
                        double val = (Double)GlobalPedIndividuals.get(i, "phenotype");
                        if (Double.isNaN(val)) continue;
                        double[] covCode = (double[])GlobalPedIndividuals.get(i, "covarTraits");
                        if (this.useCov && this.hasNaN(covCode) || (sexCode = ((Integer)GlobalPedIndividuals.get(i, "SEX")).intValue()) == 0 && this.useSex) continue;
                        if (isContinuous) {
                            phenotypesTmp.add(val);
                            idList.add(i);
                            covTmp.add(covCode);
                            sexTmp.add(sexCode);
                            continue;
                        }
                        int affectedStatus = (int)val;
                        if (affectedStatus != 2 && affectedStatus != 1) continue;
                        phenotypesTmp.add(affectedStatus - 1);
                        idList.add(i);
                        covTmp.add(covCode);
                        sexTmp.add(sexCode);
                    }
                    if (idList.size() != subjectNum) {
                        this.hasMissingPhenotypes = true;
                    }
                    this.allCov = (double[][])covTmp.toArray((T1[])new double[0][0]);
                    this.allPhenotype = phenotypesTmp.toArray();
                    this.sampleIds = idList;
                    this.allSex = sexTmp.toArray();
                }

                private double[][] combineCovariates(double[] sex, double[][] cov, boolean isSexEnabled, boolean isCovEnabled) {
                    if (!isSexEnabled && !isCovEnabled) {
                        return new double[sex.length][];
                    }
                    if (!isSexEnabled && isCovEnabled) {
                        return cov;
                    }
                    if (isSexEnabled && !isCovEnabled) {
                        double[][] result = new double[sex.length][1];
                        for (int i = 0; i < sex.length; ++i) {
                            result[i][0] = sex[i];
                        }
                        return result;
                    }
                    List<double[]> covsList = new List<double[]>();
                    for (int i = 0; i < sex.length; ++i) {
                        double[] row = new double[1 + (cov != null ? cov[i].length : 0)];
                        row[0] = sex[i];
                        if (cov != null) {
                            System.arraycopy(cov[i], 0, row, 1, cov[i].length);
                        }
                        covsList.add(row);
                    }
                    return (double[][])covsList.toArray((T1[])new double[covsList.size()][]);
                }

                private boolean hasNaN(double[] array) {
                    for (double value : array) {
                        if (!Double.isNaN(value)) continue;
                        return true;
                    }
                    return false;
                }

                @Override
                public boolean annotate(List<BoxRecord> databaseRecords, long pointer, Variant variant) {
                    LinearRegression linearRegression;
                    Object se;
                    double[] OR;
                    double[][] confidenceInterval;
                    double[] se2;
                    LogisticRegression logisticRegression;
                    double[][] X2;
                    double[] sex;
                    double[][] cov;
                    double[] phenotypes;
                    double[] processedGeno;
                    int ac;
                    double[] geno;
                    int[][] genotypeCodes;
                    int currentAltIndex = 1;
                    BoxRecord databaseRecord = databaseRecords.get(0);
                    IndexableSet originAlleles = (IndexableSet)databaseRecord.get("ALLELE");
                    if (variant.numOfAlleles() == 2 && originAlleles.size() > 2) {
                        if (((String)originAlleles.valueOf(0)).length() == variant.alleleOfIndex(0).length()) {
                            currentAltIndex = originAlleles.indexOf(variant.alleleOfIndex(1));
                        } else {
                            ByteStream container = ByteStream.getThreadInstance();
                            container.writeChar(variant.alleleOfIndex(1));
                            container.writeChar(((String)originAlleles.valueOf(0)).substring(variant.alleleOfIndex(0).length()));
                            currentAltIndex = originAlleles.indexOf(container.getString(container.length()));
                        }
                    }
                    IGenotypes genotypes = IGenotypes.load((Bytes)databaseRecord.get(null, "GT"));
                    int countNonZero = 0;
                    int minNonZero = 3;
                    if (this.hasMissingPhenotypes) {
                        genotypes = genotypes.subGenotypes(this.sampleIds);
                        genotypeCodes = genotypes.getGenotypeCodes();
                    } else {
                        genotypeCodes = genotypes.getGenotypeCodes();
                    }
                    if (genotypes.counter().getAN() == this.allPhenotype.length) {
                        geno = new double[genotypeCodes[0].length];
                        for (int i = 0; i < genotypeCodes[0].length; ++i) {
                            if (genotypeCodes[0][i] == -1 && genotypeCodes[1][i] == -1) continue;
                            ac = genotypes.get(i).getAC();
                            geno[i] = ac;
                            if (ac == 0) continue;
                            ++countNonZero;
                        }
                        processedGeno = new double[geno.length];
                        phenotypes = this.allPhenotype;
                        cov = this.allCov;
                        sex = this.allSex;
                    } else {
                        DoubleList pheTmp = new DoubleList();
                        DoubleList sexTmp = new DoubleList();
                        List<double[]> covTmp = new List<double[]>();
                        DoubleList genoTmp = new DoubleList();
                        for (int i = 0; i < genotypeCodes[0].length; ++i) {
                            if (genotypeCodes[0][i] == -1 && genotypeCodes[1][i] == -1) continue;
                            ac = genotypes.get(i).getAC();
                            genoTmp.add(ac);
                            pheTmp.add(this.allPhenotype[i]);
                            covTmp.add(this.allCov[i]);
                            sexTmp.add(this.allSex[i]);
                            if (ac == 0) continue;
                            ++countNonZero;
                        }
                        geno = genoTmp.toArray();
                        processedGeno = new double[geno.length];
                        phenotypes = pheTmp.toArray();
                        cov = (double[][])covTmp.toArray((T1[])new double[0][0]);
                        sex = sexTmp.toArray();
                    }
                    cov = this.combineCovariates(sex, cov, this.useSex, this.useCov);
                    boolean muchZero = countNonZero <= minNonZero;
                    DoubleList pValuesCCT = new DoubleList();
                    if (finalHadLogisticAdd) {
                        if (!muchZero) {
                            X2 = VariantAssocTask0.this.processData(geno, cov, this.interaction, this.useInteraction);
                            logisticRegression = new LogisticRegression(X2, phenotypes, true);
                            double p = Double.NaN;
                            try {
                                logisticRegression.fitLM5();
                                double[] coef = logisticRegression.getCoefs();
                                se2 = logisticRegression.getSE();
                                double[] OR2 = logisticRegression.getOR();
                                confidenceInterval = logisticRegression.getORConfidenceInterval();
                                p = logisticRegression.getCoefPValueWithTTest(1);
                                variant.setProperty(VariantAssocTask0.this.Logistic_Add_P.fullName(), p);
                                variant.setProperty(VariantAssocTask0.this.Logistic_Add_Beta.fullName(), coef[1]);
                                variant.setProperty(VariantAssocTask0.this.Logistic_Add_Beta_SE.fullName(), se2[1]);
                                variant.setProperty(VariantAssocTask0.this.Logistic_Add_OR.fullName(), OR2[1]);
                                variant.setProperty(VariantAssocTask0.this.Logistic_Add_Lower.fullName(), confidenceInterval[1][0]);
                                variant.setProperty(VariantAssocTask0.this.Logistic_Add_Upper.fullName(), confidenceInterval[1][1]);
                            }
                            catch (Exception e) {
                                variant.setProperty(VariantAssocTask0.this.Logistic_Add_P.fullName(), Float.valueOf(Float.NaN));
                                variant.setProperty(VariantAssocTask0.this.Logistic_Add_Beta.fullName(), Float.valueOf(Float.NaN));
                                variant.setProperty(VariantAssocTask0.this.Logistic_Add_Beta_SE.fullName(), Float.valueOf(Float.NaN));
                                variant.setProperty(VariantAssocTask0.this.Logistic_Add_OR.fullName(), Float.valueOf(Float.NaN));
                                variant.setProperty(VariantAssocTask0.this.Logistic_Add_Upper.fullName(), Float.valueOf(Float.NaN));
                                variant.setProperty(VariantAssocTask0.this.Logistic_Add_Lower.fullName(), Float.valueOf(Float.NaN));
                            }
                            pValuesCCT.add(p);
                        } else {
                            variant.setProperty(VariantAssocTask0.this.Logistic_Add_P.fullName(), Float.valueOf(Float.NaN));
                            variant.setProperty(VariantAssocTask0.this.Logistic_Add_Beta.fullName(), Float.valueOf(Float.NaN));
                            variant.setProperty(VariantAssocTask0.this.Logistic_Add_Beta_SE.fullName(), Float.valueOf(Float.NaN));
                            variant.setProperty(VariantAssocTask0.this.Logistic_Add_OR.fullName(), Float.valueOf(Float.NaN));
                            variant.setProperty(VariantAssocTask0.this.Logistic_Add_Upper.fullName(), Float.valueOf(Float.NaN));
                            variant.setProperty(VariantAssocTask0.this.Logistic_Add_Lower.fullName(), Float.valueOf(Float.NaN));
                        }
                    }
                    if (finalHasLogisticDom) {
                        countNonZero = this.processGenotypeData(geno, processedGeno, 1);
                        if (countNonZero > minNonZero) {
                            X2 = VariantAssocTask0.this.processData(processedGeno, cov, this.interaction, this.useInteraction);
                            logisticRegression = new LogisticRegression(X2, phenotypes, true);
                            double p = Double.NaN;
                            try {
                                logisticRegression.fitLM5();
                                double[] coef = logisticRegression.getCoefs();
                                OR = logisticRegression.getOR();
                                se = logisticRegression.getSE();
                                confidenceInterval = logisticRegression.getORConfidenceInterval();
                                p = logisticRegression.getCoefPValueWithTTest(1);
                                variant.setProperty(VariantAssocTask0.this.Logistic_Dom_P.fullName(), p);
                                variant.setProperty(VariantAssocTask0.this.Logistic_Dom_Beta.fullName(), coef[1]);
                                variant.setProperty(VariantAssocTask0.this.Logistic_Dom_Beta_SE.fullName(), (double)se[1]);
                                variant.setProperty(VariantAssocTask0.this.Logistic_Dom_OR.fullName(), OR[1]);
                                variant.setProperty(VariantAssocTask0.this.Logistic_Dom_Lower.fullName(), confidenceInterval[1][0]);
                                variant.setProperty(VariantAssocTask0.this.Logistic_Dom_Upper.fullName(), confidenceInterval[1][1]);
                            }
                            catch (Exception e) {
                                variant.setProperty(VariantAssocTask0.this.Logistic_Dom_P.fullName(), Float.valueOf(Float.NaN));
                                variant.setProperty(VariantAssocTask0.this.Logistic_Dom_Beta.fullName(), Float.valueOf(Float.NaN));
                                variant.setProperty(VariantAssocTask0.this.Logistic_Dom_Beta_SE.fullName(), Float.valueOf(Float.NaN));
                                variant.setProperty(VariantAssocTask0.this.Logistic_Dom_OR.fullName(), Float.valueOf(Float.NaN));
                                variant.setProperty(VariantAssocTask0.this.Logistic_Dom_Upper.fullName(), Float.valueOf(Float.NaN));
                                variant.setProperty(VariantAssocTask0.this.Logistic_Dom_Lower.fullName(), Float.valueOf(Float.NaN));
                            }
                            pValuesCCT.add(p);
                        } else {
                            variant.setProperty(VariantAssocTask0.this.Logistic_Dom_P.fullName(), Float.valueOf(Float.NaN));
                            variant.setProperty(VariantAssocTask0.this.Logistic_Dom_Beta.fullName(), Float.valueOf(Float.NaN));
                            variant.setProperty(VariantAssocTask0.this.Logistic_Dom_Beta_SE.fullName(), Float.valueOf(Float.NaN));
                            variant.setProperty(VariantAssocTask0.this.Logistic_Dom_OR.fullName(), Float.valueOf(Float.NaN));
                            variant.setProperty(VariantAssocTask0.this.Logistic_Dom_Upper.fullName(), Float.valueOf(Float.NaN));
                            variant.setProperty(VariantAssocTask0.this.Logistic_Dom_Lower.fullName(), Float.valueOf(Float.NaN));
                        }
                    }
                    if (finalHasLogisticRec) {
                        countNonZero = this.processGenotypeData(geno, processedGeno, 2);
                        if (countNonZero > minNonZero) {
                            X2 = VariantAssocTask0.this.processData(processedGeno, cov, this.interaction, this.useInteraction);
                            logisticRegression = new LogisticRegression(X2, phenotypes, true);
                            double p = Double.NaN;
                            try {
                                logisticRegression.fitLM5();
                                double[] coef = logisticRegression.getCoefs();
                                OR = logisticRegression.getOR();
                                se = logisticRegression.getSE();
                                confidenceInterval = logisticRegression.getORConfidenceInterval();
                                p = logisticRegression.getCoefPValueWithTTest(1);
                                variant.setProperty(VariantAssocTask0.this.Logistic_Rec_P.fullName(), p);
                                variant.setProperty(VariantAssocTask0.this.Logistic_Rec_Beta.fullName(), coef[1]);
                                variant.setProperty(VariantAssocTask0.this.Logistic_Rec_Beta_SE.fullName(), (double)se[1]);
                                variant.setProperty(VariantAssocTask0.this.Logistic_Rec_OR.fullName(), OR[1]);
                                variant.setProperty(VariantAssocTask0.this.Logistic_Rec_Lower.fullName(), confidenceInterval[1][0]);
                                variant.setProperty(VariantAssocTask0.this.Logistic_Rec_Upper.fullName(), confidenceInterval[1][1]);
                            }
                            catch (Exception e) {
                                variant.setProperty(VariantAssocTask0.this.Logistic_Rec_P.fullName(), Float.valueOf(Float.NaN));
                                variant.setProperty(VariantAssocTask0.this.Logistic_Rec_Beta.fullName(), Float.valueOf(Float.NaN));
                                variant.setProperty(VariantAssocTask0.this.Logistic_Rec_Beta_SE.fullName(), Float.valueOf(Float.NaN));
                                variant.setProperty(VariantAssocTask0.this.Logistic_Rec_OR.fullName(), Float.valueOf(Float.NaN));
                                variant.setProperty(VariantAssocTask0.this.Logistic_Rec_Upper.fullName(), Float.valueOf(Float.NaN));
                                variant.setProperty(VariantAssocTask0.this.Logistic_Rec_Lower.fullName(), Float.valueOf(Float.NaN));
                            }
                            pValuesCCT.add(p);
                        } else {
                            variant.setProperty(VariantAssocTask0.this.Logistic_Rec_P.fullName(), Float.valueOf(Float.NaN));
                            variant.setProperty(VariantAssocTask0.this.Logistic_Rec_Beta.fullName(), Float.valueOf(Float.NaN));
                            variant.setProperty(VariantAssocTask0.this.Logistic_Rec_Beta_SE.fullName(), Float.valueOf(Float.NaN));
                            variant.setProperty(VariantAssocTask0.this.Logistic_Rec_OR.fullName(), Float.valueOf(Float.NaN));
                            variant.setProperty(VariantAssocTask0.this.Logistic_Rec_Upper.fullName(), Float.valueOf(Float.NaN));
                            variant.setProperty(VariantAssocTask0.this.Logistic_Rec_Lower.fullName(), Float.valueOf(Float.NaN));
                        }
                    }
                    if (this.standardBeta && (finalHasLinearAdd || finalHasLinearDom || finalHasLinearRec)) {
                        this.standardizePhenotypes(phenotypes);
                    }
                    if (finalHasLinearAdd && this.isContinuous) {
                        if (!muchZero) {
                            double p = Double.NaN;
                            X2 = VariantAssocTask0.this.processData(geno, cov, this.interaction, this.useInteraction);
                            try {
                                boolean sssss;
                                linearRegression = new LinearRegression(X2, phenotypes, true);
                                if (variant.getPosition() == 15956) {
                                    sssss = false;
                                    PrintWriter pw = new PrintWriter("debug.txt", "UTF-8");
                                    se = null;
                                    try {
                                        for (int i = 0; i < phenotypes.length; ++i) {
                                            pw.println(i + "\t" + X2[i][0] + "\t" + phenotypes[i]);
                                        }
                                    }
                                    catch (Throwable i) {
                                        se = i;
                                        throw i;
                                    }
                                    finally {
                                        if (pw != null) {
                                            if (se != null) {
                                                try {
                                                    pw.close();
                                                }
                                                catch (Throwable i) {
                                                    ((Throwable)se).addSuppressed(i);
                                                }
                                            } else {
                                                pw.close();
                                            }
                                        }
                                    }
                                }
                                linearRegression.fit();
                                p = linearRegression.calculatePValues()[1];
                                if (p < 0.1) {
                                    sssss = false;
                                }
                                double[] tValues = linearRegression.calculateTValues();
                                se2 = linearRegression.getSE();
                                variant.setProperty(VariantAssocTask0.this.Linear_Add_Beta.fullName(), linearRegression.beta(1));
                                variant.setProperty(VariantAssocTask0.this.Linear_Add_Beta_SE.fullName(), se2[1]);
                                variant.setProperty(VariantAssocTask0.this.Linear_Add_T.fullName(), tValues[1]);
                                variant.setProperty(VariantAssocTask0.this.Linear_Add_P.fullName(), p);
                            }
                            catch (Exception e) {
                                variant.setProperty(VariantAssocTask0.this.Linear_Add_Beta.fullName(), Float.valueOf(Float.NaN));
                                variant.setProperty(VariantAssocTask0.this.Linear_Add_Beta_SE.fullName(), Float.valueOf(Float.NaN));
                                variant.setProperty(VariantAssocTask0.this.Linear_Add_T.fullName(), Float.valueOf(Float.NaN));
                                variant.setProperty(VariantAssocTask0.this.Linear_Add_P.fullName(), Float.valueOf(Float.NaN));
                            }
                            pValuesCCT.add(p);
                        } else {
                            variant.setProperty(VariantAssocTask0.this.Linear_Add_Beta.fullName(), Float.valueOf(Float.NaN));
                            variant.setProperty(VariantAssocTask0.this.Linear_Add_Beta_SE.fullName(), Float.valueOf(Float.NaN));
                            variant.setProperty(VariantAssocTask0.this.Linear_Add_T.fullName(), Float.valueOf(Float.NaN));
                            variant.setProperty(VariantAssocTask0.this.Linear_Add_P.fullName(), Float.valueOf(Float.NaN));
                        }
                    }
                    if (finalHasLinearRec && this.isContinuous) {
                        countNonZero = this.processGenotypeData(geno, processedGeno, 2);
                        if (countNonZero > minNonZero) {
                            X2 = VariantAssocTask0.this.processData(processedGeno, cov, this.interaction, this.useInteraction);
                            double p = Double.NaN;
                            try {
                                linearRegression = new LinearRegression(X2, phenotypes, true);
                                linearRegression.fit();
                                p = linearRegression.calculatePValues()[1];
                                double[] tValues = linearRegression.calculateTValues();
                                se2 = linearRegression.getSE();
                                variant.setProperty(VariantAssocTask0.this.Linear_Rec_Beta.fullName(), linearRegression.beta(1));
                                variant.setProperty(VariantAssocTask0.this.Linear_Rec_Beta_SE.fullName(), se2[1]);
                                variant.setProperty(VariantAssocTask0.this.Linear_Rec_T.fullName(), tValues[1]);
                                variant.setProperty(VariantAssocTask0.this.Linear_Rec_P.fullName(), p);
                            }
                            catch (Exception e) {
                                variant.setProperty(VariantAssocTask0.this.Linear_Rec_Beta.fullName(), Float.valueOf(Float.NaN));
                                variant.setProperty(VariantAssocTask0.this.Linear_Rec_Beta_SE.fullName(), Float.valueOf(Float.NaN));
                                variant.setProperty(VariantAssocTask0.this.Linear_Rec_T.fullName(), Float.valueOf(Float.NaN));
                                variant.setProperty(VariantAssocTask0.this.Linear_Rec_P.fullName(), Float.valueOf(Float.NaN));
                            }
                            pValuesCCT.add(p);
                        } else {
                            variant.setProperty(VariantAssocTask0.this.Linear_Rec_Beta.fullName(), Float.valueOf(Float.NaN));
                            variant.setProperty(VariantAssocTask0.this.Linear_Rec_Beta_SE.fullName(), Float.valueOf(Float.NaN));
                            variant.setProperty(VariantAssocTask0.this.Linear_Rec_T.fullName(), Float.valueOf(Float.NaN));
                            variant.setProperty(VariantAssocTask0.this.Linear_Rec_P.fullName(), Float.valueOf(Float.NaN));
                        }
                    }
                    if (finalHasLinearDom && this.isContinuous) {
                        countNonZero = this.processGenotypeData(geno, processedGeno, 1);
                        if (countNonZero > minNonZero) {
                            X2 = VariantAssocTask0.this.processData(processedGeno, cov, this.interaction, this.useInteraction);
                            double p = Double.NaN;
                            try {
                                linearRegression = new LinearRegression(X2, phenotypes, true);
                                linearRegression.fit();
                                p = linearRegression.calculatePValues()[1];
                                double[] tValues = linearRegression.calculateTValues();
                                se2 = linearRegression.getSE();
                                variant.setProperty(VariantAssocTask0.this.Linear_Dom_Beta.fullName(), linearRegression.beta(1));
                                variant.setProperty(VariantAssocTask0.this.Linear_Dom_Beta_SE.fullName(), se2[1]);
                                variant.setProperty(VariantAssocTask0.this.Linear_Dom_T.fullName(), tValues[1]);
                                variant.setProperty(VariantAssocTask0.this.Linear_Dom_P.fullName(), p);
                            }
                            catch (Exception e) {
                                variant.setProperty(VariantAssocTask0.this.Linear_Dom_Beta.fullName(), Float.valueOf(Float.NaN));
                                variant.setProperty(VariantAssocTask0.this.Linear_Dom_Beta_SE.fullName(), Float.valueOf(Float.NaN));
                                variant.setProperty(VariantAssocTask0.this.Linear_Dom_T.fullName(), Float.valueOf(Float.NaN));
                                variant.setProperty(VariantAssocTask0.this.Linear_Dom_P.fullName(), Float.valueOf(Float.NaN));
                            }
                            pValuesCCT.add(p);
                        } else {
                            variant.setProperty(VariantAssocTask0.this.Linear_Dom_Beta.fullName(), Float.valueOf(Float.NaN));
                            variant.setProperty(VariantAssocTask0.this.Linear_Dom_Beta_SE.fullName(), Float.valueOf(Float.NaN));
                            variant.setProperty(VariantAssocTask0.this.Linear_Dom_T.fullName(), Float.valueOf(Float.NaN));
                            variant.setProperty(VariantAssocTask0.this.Linear_Dom_P.fullName(), Float.valueOf(Float.NaN));
                        }
                    }
                    int AACase = 0;
                    int AaCase = 0;
                    int aaCase = 0;
                    int AAControl = 0;
                    int AaControl = 0;
                    int aaControl = 0;
                    int allNum = 0;
                    int maxSize = 0;
                    int minCell = 0;
                    if (finalHasAllelic || finalHasModelGen || finalHasModelTrend || finalHasModelDom || finalHasModelRec || finalHasModelAll || finalHasAnova) {
                        AACase = (Integer)variant.getProperty("GTYSUM@RefHomGtyNum_CASE");
                        AaCase = (Integer)variant.getProperty("GTYSUM@HetGtyNum_CASE");
                        aaCase = (Integer)variant.getProperty("GTYSUM@AltHomGtyNum_CASE");
                        AAControl = (Integer)variant.getProperty("GTYSUM@RefHomGtyNum_CONTROL");
                        AaControl = (Integer)variant.getProperty("GTYSUM@HetGtyNum_CONTROL");
                        aaControl = (Integer)variant.getProperty("GTYSUM@AltHomGtyNum_CONTROL");
                        allNum = geno.length;
                        maxSize = allNum * 2 + 10;
                        minCell = this.cell;
                    }
                    if (finalHasAnova && this.isContinuous) {
                        if (!muchZero) {
                            ANOVA anova = new ANOVA(minCell);
                            anova.setConfig(geno, phenotypes);
                            anova.calculate();
                            variant.setProperty(VariantAssocTask0.this.ANOVA_P.fullName(), anova.getPVal());
                            variant.setProperty(VariantAssocTask0.this.ANOVA_F.fullName(), anova.getFStatistic());
                            variant.setProperty(VariantAssocTask0.this.ANOVA_DFB.fullName(), anova.getDfb());
                            variant.setProperty(VariantAssocTask0.this.ANOVA_DFW.fullName(), anova.getDfw());
                            pValuesCCT.add(anova.getPVal());
                        } else {
                            variant.setProperty(VariantAssocTask0.this.ANOVA_P.fullName(), Double.NaN);
                            variant.setProperty(VariantAssocTask0.this.ANOVA_F.fullName(), Double.NaN);
                            variant.setProperty(VariantAssocTask0.this.ANOVA_DFB.fullName(), Double.NaN);
                            variant.setProperty(VariantAssocTask0.this.ANOVA_DFW.fullName(), Double.NaN);
                        }
                    }
                    if (finalHasAllelic) {
                        long[][] counts = new long[2][2];
                        counts[0][0] = AACase + AACase + AaCase;
                        counts[0][1] = AaCase + aaCase + aaCase;
                        counts[1][0] = AAControl + AAControl + AaControl;
                        counts[1][1] = AaControl + aaControl + aaControl;
                        double p = ContingencyTable.chiSquareTest(counts);
                        if (Double.isNaN(p)) {
                            variant.setProperty(VariantAssocTask0.this.Allelic_Assoc_P.fullName(), Double.NaN);
                        } else {
                            variant.setProperty(VariantAssocTask0.this.Allelic_Assoc_P.fullName(), p);
                        }
                        pValuesCCT.add(p);
                    }
                    AssociationModel associationModel = (AssociationModel)ASSOCIATION_MODEL_POOL.get();
                    if (finalHasModelTrend) {
                        associationModel.setMethodStrategy(new ModelTrend());
                        associationModel.execute(AACase, AaCase, aaCase, AAControl, AaControl, aaControl, maxSize, minCell);
                        variant.setProperty(VariantAssocTask0.this.Model_Trend_P.fullName(), associationModel.pVal);
                        pValuesCCT.add(associationModel.pVal);
                    }
                    if (finalHasModelDom) {
                        associationModel.setMethodStrategy(new ModelDominant());
                        associationModel.execute(AACase, AaCase, aaCase, AAControl, AaControl, aaControl, maxSize, minCell);
                        variant.setProperty(VariantAssocTask0.this.Model_Dominant_P.fullName(), associationModel.pVal);
                        pValuesCCT.add(associationModel.pVal);
                    }
                    if (finalHasModelRec) {
                        associationModel.setMethodStrategy(new ModelRecessive());
                        associationModel.execute(AACase, AaCase, aaCase, AAControl, AaControl, aaControl, maxSize, minCell);
                        variant.setProperty(VariantAssocTask0.this.Model_Recessive_P.fullName(), associationModel.pVal);
                        pValuesCCT.add(associationModel.pVal);
                    }
                    if (finalHasModelAll) {
                        associationModel.setMethodStrategy(new ModelAllelic());
                        associationModel.execute(AACase, AaCase, aaCase, AAControl, AaControl, aaControl, maxSize, minCell);
                        variant.setProperty(VariantAssocTask0.this.Model_Allelic_P.fullName(), associationModel.pVal);
                        pValuesCCT.add(associationModel.pVal);
                    }
                    double cctP = CCT.calculate(pValuesCCT, null);
                    variant.setProperty(VariantAssocTask0.this.CCT_P.fullName(), cctP);
                    return !(cctP > VariantAssocTask0.this.pCut);
                }
            }).submit(this.generalIOOptions.threads);
            completeTaskResult.setOutputPath(this.outputFile);
            SetupApplication.GlobalTaskTracker.recordTaskCompletion(completeTaskResult);
            GTBManager outputManager = new GTBManager(this.outputFile);
            SetupApplication.GlobalLogger.info("{} out of {} variants are retained after pruning by association p value cutoff {}.", outputManager.numOfVariants(), inputManager.numOfVariants(), this.pCut);
            context.put("UpdatedBaseVariantSet", true);
        } else {
            context.put("UpdatedBaseVariantSet", false);
        }
        context.put("AnnotationBaseVariantSet", this.outputFile);
    }

    private String digest() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.ldPruneOptions.associationOptionSet.hashCode());
        return ITrack.digest(sb.toString());
    }

    private double[][] processData(double[] geno, double[][] covData, int[] paraList, boolean hasInteraction) {
        List<double[]> resultList = COV_TMP_POOL.get();
        resultList.clear();
        List<Double> newRow = NEW_ROW_POOL.get();
        double[] temp = TEMP_ARRAY_POOL.get();
        for (int i = 0; i < geno.length; ++i) {
            newRow.clear();
            double SNP = geno[i];
            double[] COV = covData[i];
            if (COV == null || COV.length == 0) {
                resultList.add(new double[]{SNP});
                continue;
            }
            newRow.add(SNP);
            for (double covValue : COV) {
                newRow.add(covValue);
            }
            if (hasInteraction) {
                this.addInteractionTerms(SNP, COV, paraList, newRow);
            }
            if (temp.length < newRow.size()) {
                temp = new double[newRow.size()];
                TEMP_ARRAY_POOL.set(temp);
            }
            for (int j = 0; j < newRow.size(); ++j) {
                temp[j] = newRow.get(j);
            }
            double[] row = new double[newRow.size()];
            System.arraycopy(temp, 0, row, 0, newRow.size());
            resultList.add(row);
        }
        return (double[][])resultList.toArray((T1[])new double[resultList.size()][]);
    }

    private void addInteractionTerms(double SNP, double[] COV, int[] paraList, List<Double> newRow) {
        if (paraList == null || paraList.length == 0) {
            for (double covValue : COV) {
                newRow.add(SNP * covValue);
            }
        } else {
            for (int param : paraList) {
                int index = param - 1;
                if (index < 0 || index >= COV.length) continue;
                newRow.add(SNP * COV[index]);
            }
        }
    }
}

