/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.kgga.command.task;

import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.ccf.field.FieldGroupMeta;
import edu.sysu.pmglab.ccf.field.FieldMeta;
import edu.sysu.pmglab.ccf.field.IFieldCollection;
import edu.sysu.pmglab.ccf.record.BoxRecord;
import edu.sysu.pmglab.ccf.toolkit.annotator.PointerDatabase;
import edu.sysu.pmglab.ccf.toolkit.listener.AnnotationListener;
import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.container.list.DoubleList;
import edu.sysu.pmglab.container.list.IntList;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.executor.Context;
import edu.sysu.pmglab.executor.ITask;
import edu.sysu.pmglab.executor.Status;
import edu.sysu.pmglab.executor.track.ITrack;
import edu.sysu.pmglab.gtb.GTBManager;
import edu.sysu.pmglab.gtb.GTBReaderOption;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.genome.genotype.Genotype;
import edu.sysu.pmglab.gtb.genome.genotype.IGenotypes;
import edu.sysu.pmglab.gtb.toolkit.GTBAnnotator;
import edu.sysu.pmglab.io.FileUtils;
import edu.sysu.pmglab.kgga.command.SetupApplication;
import edu.sysu.pmglab.kgga.command.TaskTracker;
import edu.sysu.pmglab.kgga.command.Utility;
import edu.sysu.pmglab.kgga.command.pipeline.GeneralIOOptions;
import edu.sysu.pmglab.kgga.command.pipeline.LDPruneOptions;
import edu.sysu.pmglab.kgga.io.GlobalPedIndividuals;
import edu.sysu.pmglab.kgga.io.InputOutputFileSet;
import edu.sysu.pmglab.stat.ANOVA;
import edu.sysu.pmglab.stat.AssociationModel;
import edu.sysu.pmglab.stat.CCT;
import edu.sysu.pmglab.stat.ContingencyTable;
import edu.sysu.pmglab.stat.LinearRegressionGty;
import edu.sysu.pmglab.stat.LogisticRegressionGty;
import edu.sysu.pmglab.stat.ModelAllelic;
import edu.sysu.pmglab.stat.ModelDominant;
import edu.sysu.pmglab.stat.ModelRecessive;
import edu.sysu.pmglab.stat.ModelTrend;
import edu.sysu.pmglab.stat.Summary;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;

public class VariantAssocTask1
implements ITask {
    private static final int ADDITIVE = 0;
    private static final int DOMINANT = 1;
    private static final int RECESSIVE = 2;
    private static final ThreadLocal<AssociationModel> ASSOCIATION_MODEL_POOL = ThreadLocal.withInitial(AssociationModel::new);
    private static final ThreadLocal<List<double[]>> COV_TMP_POOL = ThreadLocal.withInitial(List::new);
    private static final ThreadLocal<List<Double>> NEW_ROW_POOL = ThreadLocal.withInitial(List::new);
    private static final ThreadLocal<double[]> TEMP_ARRAY_POOL = ThreadLocal.withInitial(() -> new double[1000]);
    private static final ThreadLocal<LinearRegressionGty> LINEAR_REGRESSION_POOL = ThreadLocal.withInitial(LinearRegressionGty::new);
    private static final ThreadLocal<LogisticRegressionGty> LOGISTIC_REGRESSION_POOL = ThreadLocal.withInitial(LogisticRegressionGty::new);
    GeneralIOOptions generalIOOptions;
    LDPruneOptions ldPruneOptions;
    double pCut = 1.0;
    File outputFile;
    final FieldMeta Logistic_Add_P = FieldMeta.of("Assoc@Logistic_Add_P", FieldType.float64);
    final FieldMeta Logistic_Add_Beta = FieldMeta.of("Assoc@Logistic_Add_Beta", FieldType.float64);
    final FieldMeta Logistic_Add_Beta_SE = FieldMeta.of("Assoc@Logistic_Add_Beta_SE", FieldType.float64);
    final FieldMeta Logistic_Add_OR = FieldMeta.of("Assoc@Logistic_Add_OR", FieldType.float64);
    final FieldMeta Logistic_Add_Upper = FieldMeta.of("Assoc@Logistic_Add_OR_Upper", FieldType.float64);
    final FieldMeta Logistic_Add_Lower = FieldMeta.of("Assoc@Logistic_Add_OR_Lower", FieldType.float64);
    final FieldMeta Logistic_Dom_P = FieldMeta.of("Assoc@Logistic_Dom_P", FieldType.float64);
    final FieldMeta Logistic_Dom_Beta = FieldMeta.of("Assoc@Logistic_Dom_Beta", FieldType.float64);
    final FieldMeta Logistic_Dom_Beta_SE = FieldMeta.of("Assoc@Logistic_Dom_Beta_SE", FieldType.float64);
    final FieldMeta Logistic_Dom_OR = FieldMeta.of("Assoc@Logistic_Dom_OR", FieldType.float64);
    final FieldMeta Logistic_Dom_Upper = FieldMeta.of("Assoc@Logistic_Dom_OR_Upper", FieldType.float64);
    final FieldMeta Logistic_Dom_Lower = FieldMeta.of("Assoc@Logistic_Dom_OR_Lower", FieldType.float64);
    final FieldMeta Logistic_Rec_P = FieldMeta.of("Assoc@Logistic_Rec_P", FieldType.float64);
    final FieldMeta Logistic_Rec_Beta = FieldMeta.of("Assoc@Logistic_Rec_Beta", FieldType.float64);
    final FieldMeta Logistic_Rec_Beta_SE = FieldMeta.of("Assoc@Logistic_Rec_Beta_SE", FieldType.float64);
    final FieldMeta Logistic_Rec_OR = FieldMeta.of("Assoc@Logistic_Rec_OR", FieldType.float64);
    final FieldMeta Logistic_Rec_Upper = FieldMeta.of("Assoc@Logistic_Rec_OR_Upper", FieldType.float64);
    final FieldMeta Logistic_Rec_Lower = FieldMeta.of("Assoc@Logistic_Rec_OR_Lower", FieldType.float64);
    final FieldMeta Allelic_Assoc_P = FieldMeta.of("Assoc@Allelic_Assoc_P", FieldType.float64);
    final FieldMeta Model_Trend_P = FieldMeta.of("Assoc@Trend_Model_P", FieldType.float64);
    final FieldMeta Model_Allelic_P = FieldMeta.of("Assoc@Allelic_Model_P", FieldType.float64);
    final FieldMeta Model_Dominant_P = FieldMeta.of("Assoc@Dominant_Model_P", FieldType.float64);
    final FieldMeta Model_Recessive_P = FieldMeta.of("Assoc@Recessive_Model_P", FieldType.float64);
    final FieldMeta Model_Genotypic_P = FieldMeta.of("Assoc@Genotypic_Model_P", FieldType.float64);
    final FieldMeta ANOVA_P = FieldMeta.of("Assoc@ANOVA_P", FieldType.float64);
    final FieldMeta ANOVA_F = FieldMeta.of("Assoc@ANOVA_FStatistic", FieldType.float64);
    final FieldMeta ANOVA_DFB = FieldMeta.of("Assoc@ANOVA_DFB", FieldType.float64);
    final FieldMeta ANOVA_DFW = FieldMeta.of("Assoc@ANOVA_DFW", FieldType.float64);
    final FieldMeta CCT_P = FieldMeta.of("Assoc@CCT_P", FieldType.float64);
    final FieldMeta Linear_Add_P = FieldMeta.of("Assoc@Linear_Add_P", FieldType.float64);
    final FieldMeta Linear_Add_Beta = FieldMeta.of("Assoc@Linear_Add_Beta", FieldType.float64);
    final FieldMeta Linear_Add_Beta_SE = FieldMeta.of("Assoc@Linear_Add_Beta_SE", FieldType.float64);
    final FieldMeta Linear_Add_T = FieldMeta.of("Assoc@Linear_Add_T", FieldType.float64);
    final FieldMeta Linear_Rec_P = FieldMeta.of("Assoc@Linear_Rec_P", FieldType.float64);
    final FieldMeta Linear_Rec_Beta = FieldMeta.of("Assoc@Linear_Rec_Beta", FieldType.float64);
    final FieldMeta Linear_Rec_Beta_SE = FieldMeta.of("Assoc@Linear_Rec_Beta_SE", FieldType.float64);
    final FieldMeta Linear_Rec_T = FieldMeta.of("Assoc@Linear_Rec_T", FieldType.float64);
    final FieldMeta Linear_Dom_P = FieldMeta.of("Assoc@Linear_Dom_P", FieldType.float64);
    final FieldMeta Linear_Dom_Beta = FieldMeta.of("Assoc@Linear_Dom_Beta", FieldType.float64);
    final FieldMeta Linear_Dom_Beta_SE = FieldMeta.of("Assoc@Linear_Dom_Beta_SE", FieldType.float64);
    final FieldMeta Linear_Dom_T = FieldMeta.of("Assoc@Linear_Dom_T", FieldType.float64);

    public VariantAssocTask1(File outputDir, boolean makeDir, GeneralIOOptions generalIOOptions, LDPruneOptions ldPruneOptions) {
        if (makeDir) {
            outputDir = FileUtils.getSubFile(outputDir, this.getClass().getSimpleName());
            outputDir.mkdirs();
        }
        this.outputFile = FileUtils.getSubFile(outputDir, InputOutputFileSet.getAnnotationFileName());
        this.generalIOOptions = generalIOOptions;
        this.ldPruneOptions = ldPruneOptions;
        this.pCut = ldPruneOptions.pruneP;
    }

    @Override
    public void execute(Status status, Context context) throws Exception, Error {
        File inputFile = (File)context.cast("AnnotationBaseVariantSet");
        GTBManager inputManager = new GTBManager(inputFile);
        Boolean updatedVariantSet = (Boolean)context.cast("UpdatedBaseVariantSet");
        if (updatedVariantSet == null) {
            updatedVariantSet = false;
        }
        TaskTracker.TaskResult completeTaskResult = new TaskTracker.TaskResult(this.getClass().getName(), Utility.MD5File(inputFile), this.digest());
        Optional<File> outputPathOpt = SetupApplication.GlobalTaskTracker.checkTask(completeTaskResult);
        outputPathOpt.ifPresent(file -> {
            this.outputFile = file;
        });
        if (updatedVariantSet.booleanValue() || !this.outputFile.exists() || !outputPathOpt.isPresent()) {
            final Set<String> filePathIDs = inputManager.getMeta().get("SOURCE@FILE_ID").apply(meta -> (String)meta.getValue()).toSet();
            HashSet<String> methods = new HashSet<String>(Arrays.asList(this.ldPruneOptions.associationOptionSet.getAssociationMethod()));
            final FieldGroupMeta fields = new FieldGroupMeta("Assoc");
            boolean hadLogisticAdd = false;
            boolean hasLogisticDom = false;
            boolean hasLogisticRec = false;
            boolean hasAllelic = false;
            boolean hasModelGen = false;
            boolean hasModelTrend = false;
            boolean hasModelDom = false;
            boolean hasModelRec = false;
            boolean hasModelAll = false;
            boolean hasAnova = false;
            boolean hasLinearAdd = false;
            boolean hasLinearDom = false;
            boolean hasLinearRec = false;
            if (methods.contains("logistic-add")) {
                fields.addField(this.Logistic_Add_P);
                fields.addField(this.Logistic_Add_Beta);
                fields.addField(this.Logistic_Add_Beta_SE);
                fields.addField(this.Logistic_Add_OR);
                fields.addField(this.Logistic_Add_Lower);
                fields.addField(this.Logistic_Add_Upper);
                hadLogisticAdd = true;
            }
            if (methods.contains("logistic-dom")) {
                fields.addField(this.Logistic_Dom_P);
                fields.addField(this.Logistic_Dom_Beta);
                fields.addField(this.Logistic_Dom_Beta_SE);
                fields.addField(this.Logistic_Dom_OR);
                fields.addField(this.Logistic_Dom_Lower);
                fields.addField(this.Logistic_Dom_Upper);
                hasLogisticDom = true;
            }
            if (methods.contains("logistic-rec")) {
                fields.addField(this.Logistic_Rec_P);
                fields.addField(this.Logistic_Rec_Beta);
                fields.addField(this.Logistic_Rec_Beta_SE);
                fields.addField(this.Logistic_Rec_OR);
                fields.addField(this.Logistic_Rec_Lower);
                fields.addField(this.Logistic_Rec_Upper);
                hasLogisticRec = true;
            }
            if (methods.contains("linear-add")) {
                fields.addField(this.Linear_Add_P);
                fields.addField(this.Linear_Add_Beta);
                fields.addField(this.Linear_Add_Beta_SE);
                fields.addField(this.Linear_Add_T);
                hasLinearAdd = true;
            }
            if (methods.contains("linear-rec")) {
                fields.addField(this.Linear_Rec_P);
                fields.addField(this.Linear_Rec_Beta);
                fields.addField(this.Linear_Rec_Beta_SE);
                fields.addField(this.Linear_Rec_T);
                hasLinearRec = true;
            }
            if (methods.contains("linear-dom")) {
                fields.addField(this.Linear_Dom_P);
                fields.addField(this.Linear_Dom_Beta);
                fields.addField(this.Linear_Dom_Beta_SE);
                fields.addField(this.Linear_Dom_T);
                hasLinearDom = true;
            }
            if (methods.contains("allelic")) {
                fields.addField(this.Allelic_Assoc_P);
                hasAllelic = true;
            }
            if (methods.contains("model-gen")) {
                fields.addField(this.Model_Genotypic_P);
                hasModelGen = true;
            }
            if (methods.contains("model-trend")) {
                fields.addField(this.Model_Trend_P);
                hasModelTrend = true;
            }
            if (methods.contains("model-dom")) {
                fields.addField(this.Model_Dominant_P);
                hasModelDom = true;
            }
            if (methods.contains("model-rec")) {
                fields.addField(this.Model_Recessive_P);
                hasModelRec = true;
            }
            if (methods.contains("model-all")) {
                fields.addField(this.Model_Allelic_P);
                hasModelAll = true;
            }
            if (methods.contains("anova")) {
                fields.addField(this.ANOVA_P);
                fields.addField(this.ANOVA_F);
                fields.addField(this.ANOVA_DFB);
                fields.addField(this.ANOVA_DFW);
                hasAnova = true;
            }
            fields.addField(this.CCT_P);
            final boolean finalHadLogisticAdd = hadLogisticAdd;
            final boolean finalHasLogisticDom = hasLogisticDom;
            final boolean finalHasLogisticRec = hasLogisticRec;
            final boolean finalHasLinearAdd = hasLinearAdd;
            final boolean finalHasLinearDom = hasLinearDom;
            final boolean finalHasLinearRec = hasLinearRec;
            final boolean finalHasAllelic = hasAllelic;
            final boolean finalHasModelGen = hasModelGen;
            final boolean finalHasModelTrend = hasModelTrend;
            final boolean finalHasModelDom = hasModelDom;
            final boolean finalHasModelRec = hasModelRec;
            final boolean finalHasModelAll = hasModelAll;
            final boolean finalHasAnova = hasAnova;
            GTBAnnotator.setInput(new GTBReaderOption(inputManager, false, true)).setOutput(this.outputFile).addMeta(inputManager.getMeta()).setListener(new AnnotationListener<Variant>("Associated", "Variants")).addDatabase(new PointerDatabase<Variant>(){
                final boolean useInteraction;
                final boolean useSex;
                final boolean useCov;
                final int[] interaction;
                final boolean standardBeta;
                final int cell;
                double[][] allCov;
                double[] allPhenotype;
                double[] allSex;
                IntList sampleIds;
                final boolean isContinuous;
                {
                    this.useInteraction = VariantAssocTask1.this.ldPruneOptions.associationOptionSet.isUseInter();
                    this.useSex = VariantAssocTask1.this.ldPruneOptions.associationOptionSet.isUseSex();
                    this.useCov = VariantAssocTask1.this.generalIOOptions.phenoFileSet.covariableNames != null;
                    this.interaction = VariantAssocTask1.this.ldPruneOptions.associationOptionSet.getInteractionParameters();
                    this.standardBeta = VariantAssocTask1.this.ldPruneOptions.associationOptionSet.getStandardBeta();
                    this.cell = VariantAssocTask1.this.ldPruneOptions.associationOptionSet.getCell();
                    this.isContinuous = !GlobalPedIndividuals.isBinaryPhenotypes(0);
                    this.processIndividualData();
                    for (String filePath : filePathIDs) {
                        GTBManager gtbManager = new GTBManager(filePath);
                        this.addTable(filePath, new GTBReaderOption(gtbManager, true, false));
                    }
                }

                @Override
                public Object getSource(Variant variant) {
                    return variant.getProperty("SOURCE@FILE_ID");
                }

                @Override
                public long getPointer(Variant variant) {
                    return (Long)variant.getProperty("SOURCE@FILE_POINTER");
                }

                @Override
                public IFieldCollection getAllFields() {
                    return fields;
                }

                private void standardizePhenotypes(double[] phenotypes) {
                    if (this.standardBeta) {
                        double mean = Summary.mean(phenotypes);
                        double sd = Summary.sd(phenotypes);
                        if (sd > 0.0) {
                            for (int i = 0; i < phenotypes.length; ++i) {
                                phenotypes[i] = (phenotypes[i] - mean) / sd;
                            }
                        }
                    }
                }

                private int processGenotypeData(double[] geno, double[] processedGeno, int mode) {
                    int countNonZero = 0;
                    for (int i = 0; i < geno.length; ++i) {
                        switch (mode) {
                            case 1: {
                                processedGeno[i] = geno[i] == 2.0 ? 1.0 : geno[i];
                                break;
                            }
                            case 2: {
                                processedGeno[i] = geno[i] == 1.0 ? 0.0 : (geno[i] == 2.0 ? 1.0 : geno[i]);
                                break;
                            }
                            default: {
                                processedGeno[i] = geno[i];
                            }
                        }
                        if (processedGeno[i] == 0.0) continue;
                        ++countNonZero;
                    }
                    return countNonZero;
                }

                private void processIndividualData() {
                    IntList idList = new IntList();
                    DoubleList phenotypesTmp = new DoubleList();
                    DoubleList sexTmp = new DoubleList();
                    List<double[]> covTmp = new List<double[]>();
                    int subjectNum = GlobalPedIndividuals.size();
                    for (int i = 0; i < subjectNum; ++i) {
                        double val = (Double)GlobalPedIndividuals.get(i, "phenotype");
                        if (Double.isNaN(val)) continue;
                        double[] covCode = (double[])GlobalPedIndividuals.get(i, "covarTraits");
                        if (this.useCov && this.hasNaN(covCode)) continue;
                        int sexCode = (Integer)GlobalPedIndividuals.get(i, "SEX");
                        if (this.useSex && sexCode == 0) continue;
                        if (this.isContinuous) {
                            phenotypesTmp.add(val);
                            idList.add(i);
                            covTmp.add(covCode);
                            sexTmp.add(sexCode);
                            continue;
                        }
                        int affectedStatus = (int)val;
                        if (affectedStatus != 1 && affectedStatus != 2) continue;
                        phenotypesTmp.add(affectedStatus - 1);
                        idList.add(i);
                        covTmp.add(covCode);
                        sexTmp.add(sexCode);
                    }
                    this.allCov = (double[][])covTmp.toArray((T1[])new double[0][0]);
                    this.allPhenotype = phenotypesTmp.toArray();
                    this.sampleIds = idList;
                    this.allSex = sexTmp.toArray();
                }

                private double[][] combineCovariates(double[] sex, double[][] cov, boolean isSexEnabled, boolean isCovEnabled) {
                    if (!isSexEnabled && !isCovEnabled) {
                        return new double[sex.length][];
                    }
                    if (!isSexEnabled) {
                        return cov;
                    }
                    if (!isCovEnabled) {
                        double[][] result = new double[sex.length][1];
                        for (int i = 0; i < sex.length; ++i) {
                            result[i][0] = sex[i];
                        }
                        return result;
                    }
                    double[][] combined = new double[sex.length][];
                    for (int i = 0; i < sex.length; ++i) {
                        double[] row = new double[1 + (cov != null && cov[i] != null ? cov[i].length : 0)];
                        row[0] = sex[i];
                        if (cov != null && cov[i] != null) {
                            System.arraycopy(cov[i], 0, row, 1, cov[i].length);
                        }
                        combined[i] = row;
                    }
                    return combined;
                }

                private boolean hasNaN(double[] array) {
                    if (array == null) {
                        return true;
                    }
                    for (double value : array) {
                        if (!Double.isNaN(value)) continue;
                        return true;
                    }
                    return false;
                }

                @Override
                public boolean annotate(List<BoxRecord> databaseRecords, long pointer, Variant variant) {
                    double cctP;
                    BoxRecord databaseRecord = databaseRecords.get(0);
                    IGenotypes fullGenotypes = IGenotypes.load((Bytes)databaseRecord.get(null, "GT"));
                    DoubleList genoTmp = new DoubleList();
                    DoubleList pheTmp = new DoubleList();
                    List<double[]> covTmp = new List<double[]>();
                    DoubleList sexTmp = new DoubleList();
                    int countNonZero = 0;
                    for (int i = 0; i < this.sampleIds.size(); ++i) {
                        int originalIndex = this.sampleIds.get(i);
                        Genotype genotypeForSample = fullGenotypes.get(originalIndex);
                        if (genotypeForSample.getAN() == 0) continue;
                        int ac = genotypeForSample.getAC();
                        genoTmp.add(ac);
                        if (ac != 0) {
                            ++countNonZero;
                        }
                        pheTmp.add(this.allPhenotype[i]);
                        covTmp.add(this.allCov[i]);
                        sexTmp.add(this.allSex[i]);
                    }
                    double[] geno = genoTmp.toArray();
                    double[] phenotypes = pheTmp.toArray();
                    double[][] cov = (double[][])covTmp.toArray((T1[])new double[0][0]);
                    double[] sex = sexTmp.toArray();
                    cov = this.combineCovariates(sex, cov, this.useSex, this.useCov);
                    int minNonZero = 3;
                    boolean muchZero = countNonZero <= 3;
                    DoubleList pValuesCCT = new DoubleList();
                    if (this.isContinuous && (finalHasLinearAdd || finalHasLinearDom || finalHasLinearRec)) {
                        this.standardizePhenotypes(phenotypes);
                    }
                    if (finalHadLogisticAdd) {
                        this.runLogistic(variant, geno, cov, phenotypes, 0, 3, muchZero, pValuesCCT);
                    }
                    if (finalHasLogisticDom) {
                        this.runLogistic(variant, geno, cov, phenotypes, 1, 3, muchZero, pValuesCCT);
                    }
                    if (finalHasLogisticRec) {
                        this.runLogistic(variant, geno, cov, phenotypes, 2, 3, muchZero, pValuesCCT);
                    }
                    if (finalHasLinearAdd && this.isContinuous) {
                        this.runLinear(variant, geno, cov, phenotypes, 0, 3, muchZero, pValuesCCT);
                    }
                    if (finalHasLinearDom && this.isContinuous) {
                        this.runLinear(variant, geno, cov, phenotypes, 1, 3, muchZero, pValuesCCT);
                    }
                    if (finalHasLinearRec && this.isContinuous) {
                        this.runLinear(variant, geno, cov, phenotypes, 2, 3, muchZero, pValuesCCT);
                    }
                    if (finalHasAllelic || finalHasModelGen || finalHasModelTrend || finalHasModelDom || finalHasModelRec || finalHasModelAll || finalHasAnova) {
                        int AACase = (Integer)variant.getProperty("GTYSUM@RefHomGtyNum_CASE");
                        int AaCase = (Integer)variant.getProperty("GTYSUM@HetGtyNum_CASE");
                        int aaCase = (Integer)variant.getProperty("GTYSUM@AltHomGtyNum_CASE");
                        int AAControl = (Integer)variant.getProperty("GTYSUM@RefHomGtyNum_CONTROL");
                        int AaControl = (Integer)variant.getProperty("GTYSUM@HetGtyNum_CONTROL");
                        int aaControl = (Integer)variant.getProperty("GTYSUM@AltHomGtyNum_CONTROL");
                        int maxSize = geno.length * 2 + 10;
                        AssociationModel associationModel = (AssociationModel)ASSOCIATION_MODEL_POOL.get();
                        if (finalHasAllelic) {
                            long[][] counts = new long[2][2];
                            counts[0][0] = (long)AACase + (long)AACase + (long)AaCase;
                            counts[0][1] = (long)AaCase + (long)aaCase + (long)aaCase;
                            counts[1][0] = (long)AAControl + (long)AAControl + (long)AaControl;
                            counts[1][1] = (long)AaControl + (long)aaControl + (long)aaControl;
                            double p = ContingencyTable.chiSquareTest(counts);
                            variant.setProperty(VariantAssocTask1.this.Allelic_Assoc_P.fullName(), p);
                            pValuesCCT.add(p);
                        }
                        if (finalHasModelTrend) {
                            associationModel.setMethodStrategy(new ModelTrend());
                            associationModel.execute(AACase, AaCase, aaCase, AAControl, AaControl, aaControl, maxSize, this.cell);
                            variant.setProperty(VariantAssocTask1.this.Model_Trend_P.fullName(), associationModel.pVal);
                            pValuesCCT.add(associationModel.pVal);
                        }
                        if (finalHasModelDom) {
                            associationModel.setMethodStrategy(new ModelDominant());
                            associationModel.execute(AACase, AaCase, aaCase, AAControl, AaControl, aaControl, maxSize, this.cell);
                            variant.setProperty(VariantAssocTask1.this.Model_Dominant_P.fullName(), associationModel.pVal);
                            pValuesCCT.add(associationModel.pVal);
                        }
                        if (finalHasModelRec) {
                            associationModel.setMethodStrategy(new ModelRecessive());
                            associationModel.execute(AACase, AaCase, aaCase, AAControl, AaControl, aaControl, maxSize, this.cell);
                            variant.setProperty(VariantAssocTask1.this.Model_Recessive_P.fullName(), associationModel.pVal);
                            pValuesCCT.add(associationModel.pVal);
                        }
                        if (finalHasModelAll) {
                            associationModel.setMethodStrategy(new ModelAllelic());
                            associationModel.execute(AACase, AaCase, aaCase, AAControl, AaControl, aaControl, maxSize, this.cell);
                            variant.setProperty(VariantAssocTask1.this.Model_Allelic_P.fullName(), associationModel.pVal);
                            pValuesCCT.add(associationModel.pVal);
                        }
                    }
                    if (finalHasAnova && this.isContinuous) {
                        if (!muchZero) {
                            ANOVA anova = new ANOVA(this.cell);
                            anova.setConfig(geno, phenotypes);
                            anova.calculate();
                            variant.setProperty(VariantAssocTask1.this.ANOVA_P.fullName(), anova.getPVal());
                            variant.setProperty(VariantAssocTask1.this.ANOVA_F.fullName(), anova.getFStatistic());
                            variant.setProperty(VariantAssocTask1.this.ANOVA_DFB.fullName(), anova.getDfb());
                            variant.setProperty(VariantAssocTask1.this.ANOVA_DFW.fullName(), anova.getDfw());
                            pValuesCCT.add(anova.getPVal());
                        } else {
                            this.setAnovaNaNs(variant);
                        }
                    }
                    if (Double.isNaN(cctP = CCT.calculate(pValuesCCT, null))) {
                        return false;
                    }
                    variant.setProperty(VariantAssocTask1.this.CCT_P.fullName(), cctP);
                    return !(cctP > VariantAssocTask1.this.pCut);
                }

                private void runLogistic(Variant variant, double[] originalGeno, double[][] cov, double[] phenotypes, int mode, int minNonZero, boolean isMuchZero, DoubleList pValuesCCT) {
                    FieldMeta upperField;
                    FieldMeta lowerField;
                    FieldMeta orField;
                    FieldMeta seField;
                    FieldMeta betaField;
                    FieldMeta pField;
                    if (phenotypes.length < 2) {
                        return;
                    }
                    double[] genoToUse = originalGeno;
                    if (mode == 0) {
                        if (isMuchZero) {
                            this.setLogisticNaNs(variant, VariantAssocTask1.this.Logistic_Add_P, VariantAssocTask1.this.Logistic_Add_Beta, VariantAssocTask1.this.Logistic_Add_Beta_SE, VariantAssocTask1.this.Logistic_Add_OR, VariantAssocTask1.this.Logistic_Add_Lower, VariantAssocTask1.this.Logistic_Add_Upper);
                            return;
                        }
                        pField = VariantAssocTask1.this.Logistic_Add_P;
                        betaField = VariantAssocTask1.this.Logistic_Add_Beta;
                        seField = VariantAssocTask1.this.Logistic_Add_Beta_SE;
                        orField = VariantAssocTask1.this.Logistic_Add_OR;
                        lowerField = VariantAssocTask1.this.Logistic_Add_Lower;
                        upperField = VariantAssocTask1.this.Logistic_Add_Upper;
                    } else {
                        double[] processedGeno = new double[originalGeno.length];
                        int nonZeroCount = this.processGenotypeData(originalGeno, processedGeno, mode);
                        if (nonZeroCount <= minNonZero) {
                            if (mode == 1) {
                                this.setLogisticNaNs(variant, VariantAssocTask1.this.Logistic_Dom_P, VariantAssocTask1.this.Logistic_Dom_Beta, VariantAssocTask1.this.Logistic_Dom_Beta_SE, VariantAssocTask1.this.Logistic_Dom_OR, VariantAssocTask1.this.Logistic_Dom_Lower, VariantAssocTask1.this.Logistic_Dom_Upper);
                            } else {
                                this.setLogisticNaNs(variant, VariantAssocTask1.this.Logistic_Rec_P, VariantAssocTask1.this.Logistic_Rec_Beta, VariantAssocTask1.this.Logistic_Rec_Beta_SE, VariantAssocTask1.this.Logistic_Rec_OR, VariantAssocTask1.this.Logistic_Rec_Lower, VariantAssocTask1.this.Logistic_Rec_Upper);
                            }
                            return;
                        }
                        genoToUse = processedGeno;
                        if (mode == 1) {
                            pField = VariantAssocTask1.this.Logistic_Dom_P;
                            betaField = VariantAssocTask1.this.Logistic_Dom_Beta;
                            seField = VariantAssocTask1.this.Logistic_Dom_Beta_SE;
                            orField = VariantAssocTask1.this.Logistic_Dom_OR;
                            lowerField = VariantAssocTask1.this.Logistic_Dom_Lower;
                            upperField = VariantAssocTask1.this.Logistic_Dom_Upper;
                        } else {
                            pField = VariantAssocTask1.this.Logistic_Rec_P;
                            betaField = VariantAssocTask1.this.Logistic_Rec_Beta;
                            seField = VariantAssocTask1.this.Logistic_Rec_Beta_SE;
                            orField = VariantAssocTask1.this.Logistic_Rec_OR;
                            lowerField = VariantAssocTask1.this.Logistic_Rec_Lower;
                            upperField = VariantAssocTask1.this.Logistic_Rec_Upper;
                        }
                    }
                    double[][] X2 = this.processData(genoToUse, cov, this.interaction, this.useInteraction, true);
                    LogisticRegressionGty logisticRegression = (LogisticRegressionGty)LOGISTIC_REGRESSION_POOL.get();
                    logisticRegression.reset(X2, phenotypes, false);
                    double p = Double.NaN;
                    try {
                        logisticRegression.fitLM5();
                        double[] coef = logisticRegression.getCoefs();
                        double[] se = logisticRegression.getSE();
                        double[] OR = logisticRegression.getOR();
                        double[][] confidenceInterval = logisticRegression.getORConfidenceInterval();
                        p = logisticRegression.getCoefPValueWithTTest(1);
                        variant.setProperty(pField.fullName(), p);
                        variant.setProperty(betaField.fullName(), coef[1]);
                        variant.setProperty(seField.fullName(), se[1]);
                        variant.setProperty(orField.fullName(), OR[1]);
                        variant.setProperty(lowerField.fullName(), confidenceInterval[1][0]);
                        variant.setProperty(upperField.fullName(), confidenceInterval[1][1]);
                    }
                    catch (Exception e) {
                        this.setLogisticNaNs(variant, pField, betaField, seField, orField, lowerField, upperField);
                    }
                    pValuesCCT.add(p);
                }

                private void runLinear(Variant variant, double[] originalGeno, double[][] cov, double[] phenotypes, int mode, int minNonZero, boolean isMuchZero, DoubleList pValuesCCT) {
                    FieldMeta tField;
                    FieldMeta seField;
                    FieldMeta betaField;
                    FieldMeta pField;
                    if (phenotypes.length < 2) {
                        return;
                    }
                    double[] genoToUse = originalGeno;
                    if (mode == 0) {
                        if (isMuchZero) {
                            this.setLinearNaNs(variant, VariantAssocTask1.this.Linear_Add_P, VariantAssocTask1.this.Linear_Add_Beta, VariantAssocTask1.this.Linear_Add_Beta_SE, VariantAssocTask1.this.Linear_Add_T);
                            return;
                        }
                        pField = VariantAssocTask1.this.Linear_Add_P;
                        betaField = VariantAssocTask1.this.Linear_Add_Beta;
                        seField = VariantAssocTask1.this.Linear_Add_Beta_SE;
                        tField = VariantAssocTask1.this.Linear_Add_T;
                    } else {
                        double[] processedGeno = new double[originalGeno.length];
                        int nonZeroCount = this.processGenotypeData(originalGeno, processedGeno, mode);
                        if (nonZeroCount <= minNonZero) {
                            if (mode == 1) {
                                this.setLinearNaNs(variant, VariantAssocTask1.this.Linear_Dom_P, VariantAssocTask1.this.Linear_Dom_Beta, VariantAssocTask1.this.Linear_Dom_Beta_SE, VariantAssocTask1.this.Linear_Dom_T);
                            } else {
                                this.setLinearNaNs(variant, VariantAssocTask1.this.Linear_Rec_P, VariantAssocTask1.this.Linear_Rec_Beta, VariantAssocTask1.this.Linear_Rec_Beta_SE, VariantAssocTask1.this.Linear_Rec_T);
                            }
                            return;
                        }
                        genoToUse = processedGeno;
                        if (mode == 1) {
                            pField = VariantAssocTask1.this.Linear_Dom_P;
                            betaField = VariantAssocTask1.this.Linear_Dom_Beta;
                            seField = VariantAssocTask1.this.Linear_Dom_Beta_SE;
                            tField = VariantAssocTask1.this.Linear_Dom_T;
                        } else {
                            pField = VariantAssocTask1.this.Linear_Rec_P;
                            betaField = VariantAssocTask1.this.Linear_Rec_Beta;
                            seField = VariantAssocTask1.this.Linear_Rec_Beta_SE;
                            tField = VariantAssocTask1.this.Linear_Rec_T;
                        }
                    }
                    double[][] X2 = this.processData(genoToUse, cov, this.interaction, this.useInteraction, true);
                    LinearRegressionGty linearRegression = (LinearRegressionGty)LINEAR_REGRESSION_POOL.get();
                    double p = Double.NaN;
                    try {
                        linearRegression.reset(X2, phenotypes, false);
                        linearRegression.fit();
                        p = linearRegression.calculatePValues()[1];
                        variant.setProperty(pField.fullName(), p);
                        variant.setProperty(betaField.fullName(), linearRegression.beta(1));
                        variant.setProperty(seField.fullName(), linearRegression.getSE()[1]);
                        variant.setProperty(tField.fullName(), linearRegression.getTValues()[1]);
                    }
                    catch (Exception e) {
                        this.setLinearNaNs(variant, pField, betaField, seField, tField);
                    }
                    pValuesCCT.add(p);
                }

                private void setLogisticNaNs(Variant v, FieldMeta p, FieldMeta beta, FieldMeta se, FieldMeta or, FieldMeta lower, FieldMeta upper) {
                    v.setProperty(p.fullName(), Double.NaN);
                    v.setProperty(beta.fullName(), Double.NaN);
                    v.setProperty(se.fullName(), Double.NaN);
                    v.setProperty(or.fullName(), Double.NaN);
                    v.setProperty(lower.fullName(), Double.NaN);
                    v.setProperty(upper.fullName(), Double.NaN);
                }

                private void setLinearNaNs(Variant v, FieldMeta p, FieldMeta beta, FieldMeta se, FieldMeta t) {
                    v.setProperty(p.fullName(), Double.NaN);
                    v.setProperty(beta.fullName(), Double.NaN);
                    v.setProperty(se.fullName(), Double.NaN);
                    v.setProperty(t.fullName(), Double.NaN);
                }

                private void setAnovaNaNs(Variant v) {
                    v.setProperty(VariantAssocTask1.this.ANOVA_P.fullName(), Double.NaN);
                    v.setProperty(VariantAssocTask1.this.ANOVA_F.fullName(), Double.NaN);
                    v.setProperty(VariantAssocTask1.this.ANOVA_DFB.fullName(), Double.NaN);
                    v.setProperty(VariantAssocTask1.this.ANOVA_DFW.fullName(), Double.NaN);
                }

                private double[][] processData(double[] geno, double[][] covData, int[] paraList, boolean hasInteraction, boolean addIntercept) {
                    List resultList = (List)COV_TMP_POOL.get();
                    resultList.clear();
                    List newRow = (List)NEW_ROW_POOL.get();
                    double[] temp = (double[])TEMP_ARRAY_POOL.get();
                    for (int i = 0; i < geno.length; ++i) {
                        double[] row;
                        newRow.clear();
                        double SNP = geno[i];
                        double[] COV = covData[i];
                        if (COV == null || COV.length == 0) {
                            if (addIntercept) {
                                resultList.add(new double[]{1.0, SNP});
                                continue;
                            }
                            resultList.add(new double[]{SNP});
                            continue;
                        }
                        newRow.add(SNP);
                        for (double covValue : COV) {
                            newRow.add(covValue);
                        }
                        if (hasInteraction) {
                            this.addInteractionTerms(SNP, COV, paraList, newRow);
                        }
                        if (temp.length < newRow.size()) {
                            temp = new double[newRow.size()];
                            TEMP_ARRAY_POOL.set(temp);
                        }
                        for (int j = 0; j < newRow.size(); ++j) {
                            temp[j] = (Double)newRow.get(j);
                        }
                        if (addIntercept) {
                            row = new double[newRow.size() + 1];
                            row[0] = 1.0;
                            System.arraycopy(temp, 0, row, 1, newRow.size());
                        } else {
                            row = new double[newRow.size()];
                            System.arraycopy(temp, 0, row, 0, row.length);
                        }
                        resultList.add(row);
                    }
                    return (double[][])resultList.toArray((T1[])new double[resultList.size()][]);
                }

                private void addInteractionTerms(double SNP, double[] COV, int[] paraList, List<Double> newRow) {
                    if (paraList == null || paraList.length == 0) {
                        for (double covValue : COV) {
                            newRow.add(SNP * covValue);
                        }
                    } else {
                        for (int param : paraList) {
                            int index = param - 1;
                            if (index < 0 || index >= COV.length) continue;
                            newRow.add(SNP * COV[index]);
                        }
                    }
                }
            }).submit(this.generalIOOptions.threads);
            completeTaskResult.setOutputPath(this.outputFile);
            SetupApplication.GlobalTaskTracker.recordTaskCompletion(completeTaskResult);
            GTBManager outputManager = new GTBManager(this.outputFile);
            SetupApplication.GlobalLogger.info("{} out of {} variants are retained after pruning by association p value cutoff {}.", outputManager.numOfVariants(), inputManager.numOfVariants(), this.pCut);
            context.put("UpdatedBaseVariantSet", true);
        } else {
            context.put("UpdatedBaseVariantSet", false);
        }
        context.put("AnnotationBaseVariantSet", this.outputFile);
    }

    private String digest() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.ldPruneOptions.associationOptionSet.hashCode());
        sb.append(",");
        sb.append(this.pCut);
        return ITrack.digest(sb.toString());
    }
}

