/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.kgga.io;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

public enum ArgumentProcessor {
    INSTANCE;


    public static String[] reconstructWildcardArgs(String[] args) {
        if (args == null || args.length == 0) {
            return new String[0];
        }
        ArrayList<String> resultArgs = new ArrayList<String>();
        int i = 0;
        while (i < args.length) {
            int j;
            if (!ArgumentProcessor.isExistingFile(args[i])) {
                resultArgs.add(args[i]);
                ++i;
                continue;
            }
            ArrayList<String> potentialGroup = new ArrayList<String>();
            for (j = i; j < args.length && ArgumentProcessor.isExistingFile(args[j]); ++j) {
                potentialGroup.add(args[j]);
            }
            if (potentialGroup.size() > 1) {
                String pattern = ArgumentProcessor.findCommonPattern(potentialGroup);
                resultArgs.add(pattern);
                i = j;
                continue;
            }
            resultArgs.add(args[i]);
            ++i;
        }
        return resultArgs.toArray(new String[0]);
    }

    private static boolean isExistingFile(String path) {
        if ("-".equals(path)) {
            return false;
        }
        if (path.startsWith("-")) {
            return false;
        }
        try {
            return new File(path).exists();
        }
        catch (Exception e) {
            return false;
        }
    }

    private static String findCommonPattern(List<String> strings) {
        if (strings == null || strings.isEmpty()) {
            return "";
        }
        if (strings.size() == 1) {
            return strings.get(0);
        }
        String prefix = ArgumentProcessor.findLongestCommonPrefix(strings);
        String suffix = ArgumentProcessor.findLongestCommonSuffix(strings);
        int shortestLength = strings.stream().mapToInt(String::length).min().orElse(0);
        if (prefix.length() + suffix.length() >= shortestLength && prefix.equals(suffix) && prefix.equals(strings.get(0))) {
            return strings.get(0);
        }
        return prefix + "*" + suffix;
    }

    private static String findLongestCommonPrefix(List<String> strings) {
        String first = strings.get(0);
        for (int i = 0; i < first.length(); ++i) {
            char c = first.charAt(i);
            for (int j = 1; j < strings.size(); ++j) {
                if (i != strings.get(j).length() && strings.get(j).charAt(i) == c) continue;
                return first.substring(0, i);
            }
        }
        return first;
    }

    private static String findLongestCommonSuffix(List<String> strings) {
        ArrayList<String> reversedStrings = new ArrayList<String>();
        for (String s : strings) {
            reversedStrings.add(new StringBuilder(s).reverse().toString());
        }
        String reversedLcp = ArgumentProcessor.findLongestCommonPrefix(reversedStrings);
        return new StringBuilder(reversedLcp).reverse().toString();
    }
}

