/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.kgga.io;

import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.io.text.reader.ISeparator;
import java.util.Arrays;

public class ConsecutiveSeparator
implements ISeparator {
    byte[] sepBytes;

    public ConsecutiveSeparator(String sepString) {
        if (sepString == null || sepString.isEmpty()) {
            this.sepBytes = new byte[]{32, 9};
        } else if (sepString.equalsIgnoreCase("UNIVERSAL")) {
            this.sepBytes = new byte[]{9, 32, 44};
        } else if (sepString.equalsIgnoreCase("TAB")) {
            this.sepBytes = new byte[]{9};
        } else if (sepString.equalsIgnoreCase("BLANK")) {
            this.sepBytes = new byte[]{32};
        } else if (sepString.equalsIgnoreCase("COMMA")) {
            this.sepBytes = new byte[]{44};
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.sepBytes != null) {
            Arrays.sort(this.sepBytes);
            for (byte sepByte : this.sepBytes) {
                sb.append(sepByte);
                sb.append(",");
            }
        }
        return sb.toString();
    }

    @Override
    public void accept(Bytes bytes, List<Bytes> values2) {
        int mark = 0;
        bytes = bytes.trim();
        int length = bytes.length();
        boolean isHit = false;
        for (int start = 0; start < length; ++start) {
            isHit = false;
            for (byte sepByte : this.sepBytes) {
                if (bytes.byteAt(start) != sepByte) continue;
                isHit = true;
                break;
            }
            if (!isHit) continue;
            if (mark != start) {
                values2.add(bytes.subBytes(mark, start));
            }
            mark = start + 1;
        }
        values2.add(bytes.subBytes(mark));
    }
}

