/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.kgga.io;

import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.ccf.record.IRecord;
import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.container.Individuals;
import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.indexable.LinkedSet;
import edu.sysu.pmglab.container.list.IntList;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.io.file.LiveFile;
import edu.sysu.pmglab.io.text.TextRecord;
import edu.sysu.pmglab.io.text.reader.CustomSeparator;
import edu.sysu.pmglab.io.text.reader.IHeaderParser;
import edu.sysu.pmglab.io.text.reader.TextReader;
import edu.sysu.pmglab.kgga.command.SetupApplication;
import edu.sysu.pmglab.kgga.command.setting.OrderSeparator;
import edu.sysu.pmglab.kgga.io.InputPhenotypeFileSet;
import gnu.trove.map.hash.THashMap;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public enum GlobalPedIndividuals implements Iterable<IRecord>
{
    INSTANCE;

    private static final Individuals individuals;
    private static final Map<String, Map<String, Object>> otherInfos;
    private static final Set<String> subjectWithNas;
    private static boolean[] isBinaryPhenotypes;
    private static String[] phenotypeNames;
    private static String[] covariableNames;

    public static Set<String> getSubjectWithNas() {
        return subjectWithNas;
    }

    public static boolean isBinaryPhenotypes(int index) {
        if (isBinaryPhenotypes == null) {
            return false;
        }
        return isBinaryPhenotypes[index];
    }

    public static String getPhenotypeName(int i) {
        return phenotypeNames[i];
    }

    public static String[] getPhenotypeNames() {
        return phenotypeNames;
    }

    public static String[] getCovariableNames() {
        return covariableNames;
    }

    public static boolean[] getIsBinaryPhenotypes() {
        return isBinaryPhenotypes;
    }

    public void setBinaryPhenotypes(boolean[] binaryPhenotypes) {
        isBinaryPhenotypes = binaryPhenotypes;
    }

    public static GlobalPedIndividuals append(InputPhenotypeFileSet pedPhenoFileSet) throws IOException {
        GlobalPedIndividuals.load(pedPhenoFileSet.file, pedPhenoFileSet.phenotypeNameIndex, pedPhenoFileSet.covariableNameIndexes, pedPhenoFileSet.compositeSubjectID, pedPhenoFileSet.missingLabel);
        return INSTANCE;
    }

    public static GlobalPedIndividuals load(LiveFile pedFile, int[] majorPheItemIndex, int[] covPhenotypeColIDs, boolean compositeID, String missingLabel) throws IOException {
        individuals.clear();
        otherInfos.clear();
        GlobalPedIndividuals.append(pedFile, majorPheItemIndex, covPhenotypeColIDs, compositeID, missingLabel);
        return INSTANCE;
    }

    public static boolean append(LiveFile pedFile, int[] majorPheItemIndex, int[] covPhenotypeColIDs, boolean compositeID, String missingLabel) throws IOException {
        int i;
        TextReader reader = TextReader.setInput(pedFile).setHeaderParser((values2, separator, header) -> {
            boolean containsHeaderLine;
            List<Bytes> firstLine = separator.accept(values2);
            if (firstLine.size() <= 5) {
                throw new RuntimeException("Missing mandatory fields: FID IID PID MID SEX");
            }
            Bytes fid = firstLine.fastGet(0).trim();
            if (fid.toString().equalsIgnoreCase("FID")) {
                containsHeaderLine = true;
                if (!firstLine.fastGet(1).toString().equalsIgnoreCase("IID") || !firstLine.fastGet(2).toString().equalsIgnoreCase("PID") && !firstLine.fastGet(2).toString().equalsIgnoreCase("FATID") || !firstLine.fastGet(3).toString().equalsIgnoreCase("MID") && !firstLine.fastGet(3).toString().equalsIgnoreCase("MOTID") || !firstLine.fastGet(4).toString().equalsIgnoreCase("SEX")) {
                    throw new RuntimeException("Missing mandatory fields: FID IID PID MID SEX");
                }
            } else {
                containsHeaderLine = false;
            }
            if (containsHeaderLine) {
                IHeaderParser.FIRST_LINE.parse(values2, separator, header);
                return true;
            }
            header.add("FID");
            header.add("IID");
            header.add("PID");
            header.add("MID");
            header.add("SEX");
            for (int i = 5; i < firstLine.size(); ++i) {
                header.add("Pheno_" + (i - 4));
            }
            return false;
        }).setSeparator(new CustomSeparator(new OrderSeparator())).instance();
        TextRecord input = null;
        boolean hasDefinedTraits = false;
        IndexableSet<String> header2 = reader.getHeader();
        if (covPhenotypeColIDs != null) {
            hasDefinedTraits = true;
            covariableNames = new String[covPhenotypeColIDs.length];
            for (i = 0; i < covPhenotypeColIDs.length; ++i) {
                GlobalPedIndividuals.covariableNames[i] = header2.valueOf(covPhenotypeColIDs[i]);
            }
        } else {
            covariableNames = new String[header2.size() - 6];
            for (i = 0; i < covariableNames.length; ++i) {
                GlobalPedIndividuals.covariableNames[i] = header2.valueOf(6 + i);
            }
        }
        if (majorPheItemIndex != null) {
            hasDefinedTraits = true;
            phenotypeNames = new String[majorPheItemIndex.length];
            for (i = 0; i < majorPheItemIndex.length; ++i) {
                GlobalPedIndividuals.phenotypeNames[i] = header2.valueOf(majorPheItemIndex[i]);
            }
        } else {
            phenotypeNames = new String[1];
            GlobalPedIndividuals.phenotypeNames[0] = header2.valueOf(5);
        }
        int effectiveNum = 0;
        Individuals.addField("hasGenotypes", FieldType.bool);
        Individuals.addField("phenotype", FieldType.float64Array);
        Individuals.addField("covarTraits", FieldType.float64Array);
        boolean checkMissingLabel = missingLabel != null;
        IndexableSet[] phenotypeValueSet = null;
        int missingNum = 0;
        try {
            subjectWithNas.clear();
            while ((input = reader.read()) != null) {
                int covTraitCol;
                boolean hasNa = false;
                String FID = input.get(0).toString().trim();
                if (FID.isEmpty()) continue;
                String IID = input.get(1).toString().trim();
                String UID = compositeID ? FID + "_" + IID : IID;
                String PID = input.get(2).toString().trim();
                String MID = input.get(3).toString().trim();
                int GENDER = input.get(4).toInt();
                double[] phenotype = null;
                boolean hasGenotypes = false;
                double[] covarTraits = null;
                int inputSize = input.size();
                if (hasDefinedTraits) {
                    Bytes byteCode;
                    if (majorPheItemIndex != null) {
                        phenotype = new double[majorPheItemIndex.length];
                        covTraitCol = 0;
                        boolean anyNA = false;
                        for (int id : majorPheItemIndex) {
                            byteCode = input.get(id).trim();
                            if (checkMissingLabel && byteCode.toString().equals(missingLabel)) {
                                phenotype[covTraitCol] = Double.NaN;
                                anyNA = true;
                            } else {
                                phenotype[covTraitCol] = byteCode.toDouble();
                            }
                            ++covTraitCol;
                        }
                        if (anyNA) {
                            subjectWithNas.add(UID);
                            hasNa = true;
                        }
                    }
                    if (covPhenotypeColIDs != null) {
                        covarTraits = new double[covPhenotypeColIDs.length];
                        covTraitCol = 0;
                        for (int id : covPhenotypeColIDs) {
                            byteCode = input.get(id).trim();
                            if (checkMissingLabel && byteCode.toString().equals(missingLabel)) {
                                covarTraits[covTraitCol] = Double.NaN;
                                hasNa = true;
                                subjectWithNas.add(UID);
                            } else {
                                covarTraits[covTraitCol] = byteCode.toDouble();
                            }
                            ++covTraitCol;
                        }
                    }
                } else {
                    majorPheItemIndex = new int[]{5};
                    if (inputSize > 5) {
                        Bytes phenoStr = input.get(majorPheItemIndex[0]).trim();
                        if (!checkMissingLabel || !phenoStr.toString().equals(missingLabel)) {
                            phenotype = new double[]{phenoStr.toDouble()};
                        } else {
                            hasNa = true;
                            subjectWithNas.add(UID);
                        }
                    }
                    covTraitCol = 0;
                    covarTraits = new double[inputSize - 6];
                    for (int i2 = 6; i2 < inputSize; ++i2) {
                        Bytes byteCode = input.get(i2).trim();
                        if (checkMissingLabel && byteCode.toString().equals(missingLabel)) {
                            covarTraits[covTraitCol] = Double.NaN;
                            hasNa = true;
                            subjectWithNas.add(UID);
                        } else {
                            covarTraits[covTraitCol] = byteCode.toDouble();
                        }
                        ++covTraitCol;
                    }
                }
                if (!hasNa) {
                    individuals.add(UID, new Object[0]).set("FID", (Object)FID).set("IID", (Object)IID).set("PID", (Object)PID).set("MID", (Object)MID).set("SEX", (Object)GENDER).set("phenotype", (Object)phenotype).set("covarTraits", (Object)covarTraits).set("hasGenotypes", (Object)hasGenotypes);
                    ++effectiveNum;
                    if (phenotypeValueSet == null) {
                        phenotypeValueSet = new IndexableSet[phenotype.length];
                        for (int i3 = 0; i3 < phenotypeValueSet.length; ++i3) {
                            phenotypeValueSet[i3] = new LinkedSet();
                        }
                    }
                    for (int i4 = 0; i4 < phenotypeValueSet.length; ++i4) {
                        phenotypeValueSet[i4].add(phenotype[i4]);
                    }
                    continue;
                }
                ++missingNum;
            }
            reader.close();
            if (phenotypeValueSet != null) {
                isBinaryPhenotypes = new boolean[phenotypeValueSet.length];
                for (int i5 = 0; i5 < isBinaryPhenotypes.length; ++i5) {
                    boolean bl = GlobalPedIndividuals.isBinaryPhenotypes[i5] = phenotypeValueSet[i5].size() <= 2;
                    if (!isBinaryPhenotypes[i5]) continue;
                    for (int j = 0; j < effectiveNum; ++j) {
                        double[] phenotypes = (double[])individuals.get(j, "phenotype");
                        phenotypes[i5] = phenotypeValueSet[i5].indexOf(phenotypes[i5]);
                        individuals.set(j, "phenotype", (Object)phenotypes);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            String info = e.getMessage() + " when parsing at line " + effectiveNum + ": " + input.toString();
            System.err.printf("INFO    %s%n", info);
        }
        SetupApplication.GlobalLogger.info("{} effective individuals are loaded and {} with missing values are excluded from {}", effectiveNum, missingNum, pedFile.getName());
        return true;
    }

    public static IntList alignIndexTo(Individuals other) {
        return other.getUIDs().findIndicesIn(individuals.getUIDs());
    }

    public static <V> V get(int index, String fieldName) {
        return (V)individuals.get(index, fieldName);
    }

    public static int indexOfIndividual(String uniqueID) {
        return individuals.indexOf(uniqueID);
    }

    public static int size() {
        return individuals.getUIDs().size();
    }

    public static void appendUniqueIDs(IndexableSet<String> ids) {
        for (String id : ids) {
            individuals.add(id, new Object[0]);
        }
    }

    public static IndexableSet<String> uniqueIDs() {
        return individuals.getUIDs();
    }

    public static Individuals getIndividuals() {
        return individuals;
    }

    @Override
    public Iterator<IRecord> iterator() {
        return null;
    }

    static {
        individuals = new Individuals();
        otherInfos = new THashMap<String, Map<String, Object>>();
        subjectWithNas = new HashSet<String>();
    }
}

