/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.kgga.io;

import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.ccf.CCFTable;
import edu.sysu.pmglab.ccf.field.FieldMeta;
import edu.sysu.pmglab.ccf.field.IFieldCollection;
import edu.sysu.pmglab.ccf.loader.CCFChunk;
import edu.sysu.pmglab.ccf.loader.CCFLoader;
import edu.sysu.pmglab.commandParser.exception.ParameterException;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.gtb.GTBManager;
import edu.sysu.pmglab.io.file.LiveFile;
import edu.sysu.pmglab.io.reader.ReaderStream;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class InputOutputFileSet
extends Enum<InputOutputFileSet> {
    public static final /* enum */ InputOutputFileSet INSTANCE = new InputOutputFileSet();
    public static final Set<String> availableFileNameSet;
    private static final String annotationFileName = "variants.annot.hg38.gtb";
    private static final String annotationGtyFileName = "variants.annot.gty.hg38.gtb";
    private static final String annotationFileNameNoExtension = "variants.annot.hg38";
    private static final String outputFileName = "variants.hg38.tsv.gz";
    private static final /* synthetic */ InputOutputFileSet[] $VALUES;

    public static InputOutputFileSet[] values() {
        return (InputOutputFileSet[])$VALUES.clone();
    }

    public static InputOutputFileSet valueOf(String name) {
        return Enum.valueOf(InputOutputFileSet.class, name);
    }

    public static Bytes collectFiles(String filePath, List<LiveFile> inputFiles) {
        LiveFile file = null;
        ReaderStream fs = null;
        Bytes line = null;
        try {
            filePath = filePath.replaceAll("^['\"]|['\"]$", "");
            String wildcardRegex = ".*[*?\\[{(].*";
            if (filePath.matches(wildcardRegex)) {
                ArrayList matchingFiles = new ArrayList();
                Path path = Paths.get(filePath, new String[0]).getParent();
                String globPattern = filePath.substring(path.toString().length() + 1);
                PathMatcher matcher = FileSystems.getDefault().getPathMatcher("glob:" + globPattern);
                try {
                    Stream<Path> walk = Files.list(path);
                    Object object = null;
                    try {
                        walk.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> matcher.matches(p.getFileName())).map(Path::toString).collect(Collectors.toCollection(() -> matchingFiles));
                        if (matchingFiles.isEmpty()) {
                            String info = "No matching files found in " + filePath;
                            throw new ParameterException(info);
                        }
                        for (String matchingFile : matchingFiles) {
                            file = LiveFile.of(matchingFile);
                            if (availableFileNameSet.contains(file.getName())) {
                                String info = "Duplicate file name " + file;
                                throw new ParameterException(info);
                            }
                            availableFileNameSet.add(file.getName());
                            inputFiles.add(file);
                        }
                    }
                    catch (Throwable info) {
                        object = info;
                        throw info;
                    }
                    finally {
                        if (walk != null) {
                            if (object != null) {
                                try {
                                    walk.close();
                                }
                                catch (Throwable info) {
                                    ((Throwable)object).addSuppressed(info);
                                }
                            } else {
                                walk.close();
                            }
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                file = inputFiles.get(0);
            } else {
                file = LiveFile.of(filePath);
                inputFiles.add(file);
            }
            if (filePath.endsWith(".gtb")) {
                CCFLoader loader = new CCFLoader(List.singleton(CCFChunk.Type.FIELD_GROUP_META));
                CCFTable table = loader.parse(file);
                GTBManager gtb = new GTBManager(table);
                IFieldCollection fields = gtb.getAllFields();
                StringBuilder sb = new StringBuilder();
                for (FieldMeta field : fields) {
                    sb.append(field.simpleName());
                    sb.append("\t");
                }
                int len = sb.length();
                line = new Bytes(sb.delete(len - 1, len).toString());
            } else {
                fs = file.openAsText();
                while ((line = fs.readline()) != null && line.startsWith("##".getBytes())) {
                }
                assert (line != null);
                if (line.startsWith((byte)35)) {
                    line = line.subBytes(1);
                }
                fs.close();
            }
            return line;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getAnnotationFileName() {
        return annotationFileName;
    }

    public static String getAnnotationFileNameNoExtension() {
        return annotationFileNameNoExtension;
    }

    public static String getAnnotationGtyFileName() {
        return annotationGtyFileName;
    }

    public static String getOutputFileName() {
        return outputFileName;
    }

    static {
        $VALUES = new InputOutputFileSet[]{INSTANCE};
        availableFileNameSet = new HashSet<String>();
    }
}

