/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.kgga.io;

import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.commandParser.converter.IDynamicConverter;
import edu.sysu.pmglab.commandParser.exception.ParameterException;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.io.file.LiveFile;
import edu.sysu.pmglab.io.reader.ReaderStream;
import edu.sysu.pmglab.io.text.reader.CustomSeparator;
import edu.sysu.pmglab.kgga.command.setting.OrderSeparator;
import edu.sysu.pmglab.kgga.io.GlobalPedIndividuals;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;

public class InputPhenotypeFileSet {
    LiveFile file;
    public String[] phenotypeNames = null;
    int[] phenotypeNameIndex = null;
    public String[] covariableNames = null;
    int[] covariableNameIndexes;
    boolean compositeSubjectID;
    String missingLabel;

    public InputPhenotypeFileSet(LiveFile file, String[] phenotypeName, String[] covariableNames, boolean compositeSubjectID, String missingLabel) {
        this.file = file;
        this.phenotypeNames = phenotypeName;
        this.covariableNames = covariableNames;
        this.compositeSubjectID = compositeSubjectID;
        this.missingLabel = missingLabel;
    }

    public InputPhenotypeFileSet(String filePath) throws IOException {
        this.file = LiveFile.of(filePath);
        this.compositeSubjectID = false;
    }

    public LiveFile getFile() {
        return this.file;
    }

    public int hashCode() {
        return Objects.hash(this.file.hashCode(), this.compositeSubjectID);
    }

    public int hashCodeBinaryPhenotype() {
        StringBuilder sb = new StringBuilder(256);
        if (this.phenotypeNames != null && this.phenotypeNames.length > 0) {
            for (int i = 0; i < this.phenotypeNames.length; ++i) {
                if (!GlobalPedIndividuals.isBinaryPhenotypes(i)) continue;
                sb.append(this.phenotypeNames[i]);
            }
        }
        return Objects.hash(sb);
    }

    public static class Converter
    implements IDynamicConverter<InputPhenotypeFileSet> {
        @Override
        public InputPhenotypeFileSet convert(String name, Map<String, String> options) {
            try {
                String[] phenotypeNames = null;
                String[] covariableNames = null;
                boolean composite = false;
                String fileName = options.get("file");
                String phenotypeNameOption = options.get("pheno");
                String covariableNamesOption = options.get("covar");
                String compositeOption = options.get("composite").toUpperCase();
                String missingLabel = options.get("missing");
                if (phenotypeNameOption != null && !phenotypeNameOption.trim().isEmpty()) {
                    phenotypeNames = phenotypeNameOption.split(",");
                }
                if (covariableNamesOption != null && !covariableNamesOption.trim().isEmpty()) {
                    covariableNames = covariableNamesOption.split(",");
                }
                if (compositeOption.toUpperCase().startsWith("Y")) {
                    composite = true;
                }
                LiveFile file = LiveFile.of(fileName);
                InputPhenotypeFileSet fileSet = new InputPhenotypeFileSet(file, phenotypeNames, covariableNames, composite, missingLabel);
                this.processHeader(file, fileSet);
                return fileSet;
            }
            catch (IOException e) {
                throw new ParameterException("Invalid parameter \"" + name + "\": cannot get file object from " + options.get("file"), e);
            }
        }

        private void processHeader(LiveFile file, InputPhenotypeFileSet fileSet) throws IOException {
            try (ReaderStream fs = file.openAsText();){
                int i;
                Bytes line = fs.readline();
                CustomSeparator separator = new CustomSeparator(new OrderSeparator());
                List<Bytes> cells = separator.accept(line);
                if (fileSet.phenotypeNames != null) {
                    fileSet.phenotypeNameIndex = new int[fileSet.phenotypeNames.length];
                    for (i = 0; i < fileSet.phenotypeNameIndex.length; ++i) {
                        String phenotypeName = fileSet.phenotypeNames[i];
                        fileSet.phenotypeNameIndex[i] = this.findColumnIndex(cells, phenotypeName.trim(), file);
                    }
                }
                if (fileSet.covariableNames != null) {
                    fileSet.covariableNameIndexes = new int[fileSet.covariableNames.length];
                    for (i = 0; i < fileSet.covariableNames.length; ++i) {
                        fileSet.covariableNameIndexes[i] = this.findColumnIndex(cells, fileSet.covariableNames[i], file);
                    }
                }
            }
        }

        private int findColumnIndex(List<Bytes> cells, String columnName, LiveFile file) {
            for (int i = 0; i < cells.size(); ++i) {
                if (!cells.fastGet(i).toString().equals(columnName)) continue;
                return i;
            }
            throw new ParameterException("Column \"" + columnName + "\" does not exist in " + file + "!");
        }
    }
}

