/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.kgga.io;

import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.io.text.TextRecord;
import edu.sysu.pmglab.io.text.reader.IHeaderParser;
import edu.sysu.pmglab.io.text.reader.IMetadataParser;
import edu.sysu.pmglab.io.text.reader.Separator;
import edu.sysu.pmglab.io.text.reader.TextReader;
import java.io.File;
import java.io.IOException;
import jxl.Workbook;
import jxl.format.Alignment;
import jxl.format.Border;
import jxl.format.BorderLineStyle;
import jxl.format.CellFormat;
import jxl.format.Colour;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;

public class ZebraExcelExporter {
    private WritableCellFormat headerStyle;
    private WritableCellFormat evenRowStyle;
    private WritableCellFormat oddRowStyle;
    WritableWorkbook workbookGlobal;
    WritableSheet sheetGlobal;
    int startRowGlobal = 0;

    public ZebraExcelExporter(File outputPath, String[] head) throws IOException, WriteException {
        this.workbookGlobal = Workbook.createWorkbook(outputPath);
        this.sheetGlobal = this.workbookGlobal.createSheet("Sheet1", 0);
        this.initStyles();
        this.addHeaderRow(this.sheetGlobal, head);
    }

    public ZebraExcelExporter() {
    }

    public void addRow(String[] rowData) throws WriteException {
        WritableCellFormat rowStyle = this.getRowStyle(this.startRowGlobal, 0);
        for (int colIdx = 0; colIdx < rowData.length; ++colIdx) {
            ZebraExcelExporter.addCell(this.sheetGlobal, colIdx, this.startRowGlobal, rowData[colIdx], rowStyle);
        }
        ++this.startRowGlobal;
    }

    public void close() throws IOException {
        this.workbookGlobal.write();
        ZebraExcelExporter.closeWorkbook(this.workbookGlobal);
        this.clearStyles();
    }

    private void clearStyles() {
        this.headerStyle = null;
        this.evenRowStyle = null;
        this.oddRowStyle = null;
    }

    private void initStyles() {
        try {
            WritableFont headerFont = new WritableFont(WritableFont.ARIAL, 10, WritableFont.BOLD);
            this.headerStyle = new WritableCellFormat(headerFont);
            this.headerStyle.setBackground(Colour.GREY_25_PERCENT);
            this.headerStyle.setBorder(Border.ALL, BorderLineStyle.THIN);
            this.headerStyle.setAlignment(Alignment.CENTRE);
            WritableFont rowFont = new WritableFont(WritableFont.ARIAL, 10, WritableFont.NO_BOLD);
            this.evenRowStyle = new WritableCellFormat(rowFont);
            this.evenRowStyle.setBackground(Colour.LIGHT_GREEN);
            this.evenRowStyle.setBorder(Border.ALL, BorderLineStyle.THIN);
            this.oddRowStyle = new WritableCellFormat(rowFont);
            this.oddRowStyle.setBackground(Colour.WHITE);
            this.oddRowStyle.setBorder(Border.ALL, BorderLineStyle.THIN);
        }
        catch (WriteException e) {
            throw new RuntimeException("\u6837\u5f0f\u521d\u59cb\u5316\u5931\u8d25", e);
        }
    }

    public void exportToExcel(List<String[]> data, File outputPath, boolean hasHeader) {
        if (data == null || data.isEmpty()) {
            throw new IllegalArgumentException("\u8f93\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        WritableWorkbook workbook = null;
        try {
            workbook = Workbook.createWorkbook(outputPath);
            WritableSheet sheet = workbook.createSheet("Sheet1", 0);
            this.initStyles();
            int startRow = 0;
            if (hasHeader && !data.isEmpty()) {
                this.addHeaderRow(sheet, data.get(0));
                startRow = 1;
            }
            boolean aborted = false;
            for (int rowIdx = startRow; rowIdx < data.size(); ++rowIdx) {
                String[] rowData = data.get(rowIdx);
                WritableCellFormat rowStyle = this.getRowStyle(rowIdx, startRow);
                if (rowIdx >= 65535) {
                    aborted = true;
                    break;
                }
                for (int colIdx = 0; colIdx < rowData.length; ++colIdx) {
                    ZebraExcelExporter.addCell(sheet, colIdx, rowIdx - startRow, rowData[colIdx], rowStyle);
                }
            }
            if (aborted) {
                System.out.println("Warning: Data rows exceeded the 65,535 limit. Subsequent rows have been truncated.");
            }
            workbook.write();
        }
        catch (Exception e) {
            throw new RuntimeException("\u5bfc\u51faExcel\u5931\u8d25", e);
        }
        finally {
            ZebraExcelExporter.closeWorkbook(workbook);
            this.clearStyles();
        }
    }

    public void exportToExcel(File inputPath, File outputPath) throws IOException {
        if (!inputPath.exists()) {
            throw new IllegalArgumentException("\u8f93\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        TextReader reader = TextReader.setInput(inputPath).setHeaderParser(IHeaderParser.FIRST_LINE).setMetadataParser(IMetadataParser.NO_METADATA).setSeparator(Separator.TAB).instance();
        WritableWorkbook workbook = null;
        try {
            TextRecord input;
            IndexableSet<String> head = reader.getHeader();
            int size = head.size();
            workbook = Workbook.createWorkbook(outputPath);
            WritableSheet sheet = workbook.createSheet("Sheet1", 0);
            this.initStyles();
            int startRow = 0;
            this.addHeaderRow(sheet, head.toArray(new String[0]));
            int rowIdx = 0;
            boolean aborted = false;
            while ((input = reader.read()) != null) {
                WritableCellFormat rowStyle = this.getRowStyle(rowIdx, startRow);
                for (int colIdx = 0; colIdx < size; ++colIdx) {
                    ZebraExcelExporter.addCell(sheet, colIdx, rowIdx - startRow, input.get(colIdx).toString(), rowStyle);
                }
                if (++rowIdx <= 65535) continue;
                aborted = true;
                break;
            }
            if (aborted) {
                System.out.println("Warning: Data rows exceeded the 65,535 limit. Subsequent rows have been truncated.");
            }
            reader.close();
            workbook.write();
        }
        catch (Exception e) {
            try {
                throw new RuntimeException("\u5bfc\u51faExcel\u5931\u8d25", e);
            }
            catch (Throwable throwable) {
                ZebraExcelExporter.closeWorkbook(workbook);
                this.clearStyles();
                throw throwable;
            }
        }
        ZebraExcelExporter.closeWorkbook(workbook);
        this.clearStyles();
    }

    private void addHeaderRow(WritableSheet sheet, String[] headers) throws WriteException {
        for (int col = 0; col < headers.length; ++col) {
            sheet.addCell(new Label(col, 0, headers[col], (CellFormat)this.headerStyle));
        }
        sheet.setRowView(0, 350);
    }

    private static void addCell(WritableSheet sheet, int col, int row, String value, WritableCellFormat style) throws WriteException {
        try {
            double numberValue = Double.parseDouble(value);
            sheet.addCell(new Number(col, row + 1, numberValue, (CellFormat)style));
        }
        catch (NumberFormatException e) {
            sheet.addCell(new Label(col, row + 1, value, (CellFormat)style));
        }
    }

    private WritableCellFormat getRowStyle(int absoluteRow, int startRow) {
        int relativeRow = absoluteRow - startRow;
        return relativeRow % 2 == 0 ? this.evenRowStyle : this.oddRowStyle;
    }

    private void adjustColumnWidth(WritableSheet sheet, int columnCount) throws WriteException {
        for (int i = 0; i < columnCount; ++i) {
            sheet.setColumnView(i, 20);
        }
    }

    private static void closeWorkbook(WritableWorkbook workbook) {
        try {
            if (workbook != null) {
                workbook.close();
            }
        }
        catch (Exception e) {
            System.err.println("\u5173\u95ed\u5de5\u4f5c\u7c3f\u65f6\u51fa\u9519: " + e.getMessage());
        }
    }

    public static void main(String[] args) {
        List<String[]> data = new List<String[]>();
        data.add(new String[]{"\u59d3\u540d", "\u5e74\u9f84", "\u6210\u7ee9"});
        data.add(new String[]{"\u5f20\u4e09", "22", "89.5"});
        data.add(new String[]{"\u674e\u56db", "25", "92.0"});
        data.add(new String[]{"\u738b\u4e94", "24", "78.5"});
        try {
            ZebraExcelExporter excelExporter = new ZebraExcelExporter();
            String path = "/home/lmx/MyJava/idea/kggsum2/test/smk_cad_gbmr/commonmind.gene.eqtl.hg19.tsv.gz/GeneBasedCausationTask/";
            excelExporter.exportToExcel(new File(path + "genes.hg38.emic.tsv"), new File(path + "genes.hg38.emic.xls"));
            System.out.println("\u5bfc\u51fa\u6210\u529f\uff01");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

