/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.objectpool;

import edu.sysu.pmglab.objectpool.ObjectFactory;
import edu.sysu.pmglab.objectpool.ObjectPool;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class GenericObjectPool<T>
implements ObjectPool<T> {
    private final Queue<T> pool;
    private final ObjectFactory<T> factory;
    private final int maxSize;

    public GenericObjectPool(ObjectFactory<T> factory2) {
        this.factory = factory2;
        this.pool = new ConcurrentLinkedQueue<T>();
        this.maxSize = Integer.MAX_VALUE;
    }

    public GenericObjectPool(ObjectFactory<T> factory2, int maxSize) {
        this.factory = factory2;
        this.pool = new ConcurrentLinkedQueue<T>();
        this.maxSize = maxSize;
    }

    @Override
    public T borrowObject() {
        T obj = this.pool.poll();
        if (obj == null && (obj = this.factory.create()) == null) {
            throw new IllegalArgumentException("Object cannot be null");
        }
        return obj;
    }

    @Override
    public void returnObject(T obj) {
        if (obj == null) {
            throw new IllegalArgumentException("Object cannot be null");
        }
        if (this.pool.size() >= this.maxSize || !this.pool.offer(obj)) {
            this.factory.destroy(obj);
        }
    }

    @Override
    public ObjectFactory<T> getFactory() {
        return this.factory;
    }

    @Override
    public void clear() {
        for (Object obj : this.pool) {
            this.factory.destroy(obj);
        }
        this.pool.clear();
    }

    public int size() {
        return this.pool.size();
    }
}

