/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.objectpool;

import edu.sysu.pmglab.container.array.EmptyArray;
import edu.sysu.pmglab.objectpool.Producer;
import edu.sysu.pmglab.utils.ValueUtils;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;

public final class LinkedObjectPool<T>
implements Iterable<T> {
    final Producer<T> factory;
    Object[] cache;
    int start = 0;
    int end = 0;

    public LinkedObjectPool(Producer<T> factory2) {
        if (factory2 == null) {
            throw new NullPointerException();
        }
        this.factory = factory2;
        this.cache = EmptyArray.OBJECT;
    }

    public T popFirst() {
        if (this.isEmpty()) {
            throw new IndexOutOfBoundsException("Empty queue");
        }
        try {
            T t = this.fastGet(0);
            return t;
        }
        finally {
            ++this.start;
        }
    }

    public T popLast() {
        if (this.isEmpty()) {
            throw new IndexOutOfBoundsException("Empty queue");
        }
        try {
            T t = this.fastLastGet(0);
            return t;
        }
        finally {
            --this.end;
        }
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            final int length;
            int seek;
            {
                this.length = LinkedObjectPool.this.size();
                this.seek = 0;
            }

            @Override
            public boolean hasNext() {
                return this.seek < this.length;
            }

            @Override
            public T next() {
                try {
                    Object t = LinkedObjectPool.this.fastGet(this.seek);
                    return t;
                }
                finally {
                    ++this.seek;
                }
            }
        };
    }

    public int size() {
        return this.end - this.start;
    }

    public boolean isEmpty() {
        return this.start == this.end;
    }

    public T fastGet(int index) {
        Object object = this.cache[this.start + index];
        if (object == null) {
            this.cache[this.start + index] = object = this.factory.offer();
        }
        return (T)object;
    }

    public T fastLastGet(int index) {
        return this.fastGet(this.size() - index - 1);
    }

    public T get(int index) {
        if (index < 0 || this.start + index >= this.end) {
            throw new IndexOutOfBoundsException("Index out of bounds");
        }
        return this.fastGet(index);
    }

    public boolean isInit(int index) {
        if (index < 0 || this.start + index >= this.end) {
            throw new IndexOutOfBoundsException("Index out of bounds");
        }
        return this.cache[this.start + index] != null;
    }

    public T lastGet(int index) {
        if (index < 0 || this.start + index >= this.end) {
            throw new IndexOutOfBoundsException("Index out of bounds");
        }
        return this.fastLastGet(index);
    }

    public LinkedObjectPool<T> require(int n) {
        if (n == 0) {
            return this;
        }
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        int currentSize = this.size();
        if (n <= this.cache.length - this.end) {
            this.end += n;
        } else if (currentSize + n <= this.cache.length) {
            for (int i = 0; i < currentSize; ++i) {
                Object temp = this.cache[i];
                this.cache[i] = this.cache[this.start + i];
                this.cache[this.start + i] = temp;
            }
            this.start = 0;
            this.end = currentSize + n;
        } else {
            if (this.start > 0) {
                for (int i = 0; i < currentSize; ++i) {
                    Object temp = this.cache[i];
                    this.cache[i] = this.cache[this.start + i];
                    this.cache[this.start + i] = temp;
                }
                this.start = 0;
                this.end = currentSize;
            }
            Object[] newCache = new Object[(int)ValueUtils.valueOf((long)(currentSize + n) * 2L, 16L, 0x7FFFFFFDL)];
            System.arraycopy(this.cache, 0, newCache, 0, this.cache.length);
            this.cache = newCache;
            this.start = 0;
            this.end = currentSize + n;
        }
        return this;
    }

    public Producer<T> getFactory() {
        return this.factory;
    }

    public void clear() {
        this.start = 0;
        this.end = 0;
    }

    public void close() {
        this.start = 0;
        this.end = 0;
        this.cache = EmptyArray.OBJECT;
    }

    public void sort(Comparator<? super T> comparator) {
        Arrays.sort(this.cache, this.start, this.end, (o1, o2) -> {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return comparator.compare(o1, o2);
        });
    }
}

