/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.pconsumer;

import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.io.bgzip.BGZIPBlockEncoder;
import edu.sysu.pmglab.io.bgzip.BGZIPConstants;
import edu.sysu.pmglab.pconsumer.TaskConsumer;
import java.io.IOException;
import java.io.OutputStream;

public class BGZIPProcessor
implements TaskConsumer<Bytes, OutputStream> {
    final BGZIPBlockEncoder encoder;

    public BGZIPProcessor(int compressionLevel) {
        this.encoder = new BGZIPBlockEncoder(compressionLevel, true);
    }

    @Override
    public void process(Bytes input) throws IOException {
        this.encoder.write(input);
    }

    @Override
    public void write(OutputStream output) throws IOException {
        Bytes data = this.encoder.finish();
        if (data.length() > 0) {
            output.write(data.bytes(), data.offset(), data.length());
        }
    }

    @Override
    public void close(OutputStream output) throws IOException {
        output.write(BGZIPConstants.EMPTY_BGZIP_BLOCK);
        output.close();
    }

    @Override
    public void stop() {
        this.encoder.close();
    }
}

