/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.pconsumer;

public abstract class Node<I, O> {
    private int taskId = -1;
    private O output;
    private Operator operator = Operator.INIT;

    public final Node<I, O> update(I input, O output, int taskId) {
        this.taskId = taskId;
        this.output = output;
        this.operator = Operator.TASK;
        return this.update(input);
    }

    public abstract Node<I, O> update(I var1);

    public int getTaskId() {
        return this.taskId;
    }

    public abstract I getInput();

    public O getOutput() {
        return this.output;
    }

    public final void close(O output, int taskId) {
        this.taskId = taskId;
        this.output = output;
        this.operator = Operator.CLOSED;
    }

    public final void stop() {
        this.taskId = -1;
        this.output = null;
        this.operator = Operator.STOP;
    }

    public final boolean isInit() {
        return this.operator == Operator.INIT;
    }

    public final boolean isTask() {
        return this.operator == Operator.TASK;
    }

    public final boolean isClose() {
        return this.operator == Operator.CLOSED;
    }

    public final boolean isStop() {
        return this.operator == Operator.STOP;
    }

    private static enum Operator {
        INIT,
        TASK,
        CLOSED,
        STOP;

    }
}

