/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.plot;

import cern.colt.list.DoubleArrayList;
import cern.jet.stat.Descriptive;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;

public class BasicPainter {
    protected int canvasWidth = 650;
    protected int canvasHeight = 400;
    protected int dataPlottingOffsetLeft = 40;
    protected int dataPlottingOffsetTop = 10;
    protected int dataPlottingOffsetBottom = 30;
    protected int dataPlottingOffsetRight = 20;
    protected Rectangle dataPlottingArea;
    protected Color canvasBackgroundColor = Color.WHITE;
    protected Color axesColor = Color.DARK_GRAY;
    protected Color nonplotBackgroundColor = Color.LIGHT_GRAY;
    protected Font titleFont = new Font("SansSerif", 1, 16);
    protected Font numFont = new Font("SansSerif", 1, 11);
    protected int titleLineHeight = 30;
    protected int yScalDecimal = 2;

    public int getDataPlottingOffsetBottom() {
        return this.dataPlottingOffsetBottom;
    }

    public void setDataPlottingOffsetBottom(int dataPlottingOffsetBottom) {
        this.dataPlottingOffsetBottom = dataPlottingOffsetBottom;
    }

    public int getDataPlottingOffsetLeft() {
        return this.dataPlottingOffsetLeft;
    }

    public void setDataPlottingOffsetLeft(int dataPlottingOffsetLeft) {
        this.dataPlottingOffsetLeft = dataPlottingOffsetLeft;
    }

    public int getDataPlottingOffsetRight() {
        return this.dataPlottingOffsetRight;
    }

    public void setDataPlottingOffsetRight(int dataPlottingOffsetRight) {
        this.dataPlottingOffsetRight = dataPlottingOffsetRight;
    }

    public int getDataPlottingOffsetTop() {
        return this.dataPlottingOffsetTop;
    }

    public void setDataPlottingOffsetTop(int dataPlottingOffsetTop) {
        this.dataPlottingOffsetTop = dataPlottingOffsetTop;
    }

    public BasicPainter(int width, int height) {
        this.canvasWidth = width;
        this.canvasHeight = height;
    }

    protected void plotTriangle(Graphics2D g, int positionX, int postionY, int triangleLen) {
        Point p1 = new Point(positionX, postionY);
        Point p2 = new Point(positionX - triangleLen / 2, postionY + triangleLen);
        Point p3 = new Point(positionX + triangleLen / 2, postionY + triangleLen);
        Polygon filledPolygon = new Polygon();
        filledPolygon.addPoint(p1.x, p1.y);
        filledPolygon.addPoint(p2.x, p2.y);
        filledPolygon.addPoint(p3.x, p3.y);
        g.fillPolygon(filledPolygon);
    }

    protected void calculateDataPlottingArea(boolean drawTitle, int legendBoxWidth) throws Exception {
        this.dataPlottingArea = drawTitle ? new Rectangle(this.dataPlottingOffsetLeft, this.dataPlottingOffsetTop, this.canvasWidth - this.dataPlottingOffsetRight - this.dataPlottingOffsetLeft - legendBoxWidth, this.canvasHeight - this.dataPlottingOffsetBottom - this.dataPlottingOffsetTop - this.titleLineHeight) : new Rectangle(this.dataPlottingOffsetLeft, this.dataPlottingOffsetTop, this.canvasWidth - this.dataPlottingOffsetRight - this.dataPlottingOffsetLeft - legendBoxWidth, this.canvasHeight - this.dataPlottingOffsetBottom - this.dataPlottingOffsetTop);
    }

    protected void calculateDataPlottingArea(boolean drawTitle) throws Exception {
        this.dataPlottingArea = drawTitle ? new Rectangle(this.dataPlottingOffsetLeft, this.dataPlottingOffsetTop, this.canvasWidth - this.dataPlottingOffsetRight - this.dataPlottingOffsetLeft, this.canvasHeight - this.dataPlottingOffsetBottom - this.dataPlottingOffsetTop - this.titleLineHeight) : new Rectangle(this.dataPlottingOffsetLeft, this.dataPlottingOffsetTop, this.canvasWidth - this.dataPlottingOffsetRight - this.dataPlottingOffsetLeft, this.canvasHeight - this.dataPlottingOffsetBottom - this.dataPlottingOffsetTop);
    }

    public static void outputJPEGFile(BufferedImage image, String outputPath) throws Exception {
        ImageWriter writer = null;
        ImageTypeSpecifier type = ImageTypeSpecifier.createFromRenderedImage(image);
        Iterator<ImageWriter> iter = ImageIO.getImageWriters(type, "jpg");
        if (iter.hasNext()) {
            writer = iter.next();
        }
        if (writer == null) {
            return;
        }
        IIOImage iioImage = new IIOImage(image, null, null);
        ImageWriteParam param = writer.getDefaultWriteParam();
        param.setCompressionMode(2);
        param.setCompressionQuality(1.0f);
        ImageOutputStream outputStream2 = ImageIO.createImageOutputStream(new File(outputPath));
        writer.setOutput(outputStream2);
        writer.write(null, iioImage, param);
        outputStream2.flush();
        outputStream2.close();
        writer.dispose();
    }

    public static void outputPNGFile(BufferedImage image, String outputPath) throws Exception {
        ImageWriter writer = null;
        ImageTypeSpecifier type = ImageTypeSpecifier.createFromRenderedImage(image);
        Iterator<ImageWriter> iter = ImageIO.getImageWriters(type, "png");
        if (iter.hasNext()) {
            writer = iter.next();
        }
        if (writer == null) {
            return;
        }
        IIOImage iioImage = new IIOImage(image, null, null);
        ImageWriteParam param = writer.getDefaultWriteParam();
        ImageOutputStream outputStream2 = ImageIO.createImageOutputStream(new File(outputPath));
        writer.setOutput(outputStream2);
        writer.write(null, iioImage, param);
        outputStream2.flush();
        outputStream2.close();
        writer.dispose();
    }

    public void paintCanvas(Graphics2D g2d) {
        g2d.clipRect(0, 0, this.canvasWidth, this.canvasHeight);
        g2d.setColor(this.canvasBackgroundColor);
        Rectangle2D.Double rc = new Rectangle2D.Double(0.0, 0.0, this.canvasWidth, this.canvasHeight);
        g2d.fill(rc);
        GradientPaint pat = new GradientPaint(0.0f, 0.0f, Color.WHITE, 100.0f, 45.0f, Color.GREEN);
        g2d.setPaint(pat);
    }

    protected void drawAxes(Graphics2D g2, String title, String XLabel, String yLabel, int maxYScalLen) {
        g2.setColor(this.axesColor.darker());
        Line2D.Double zz = new Line2D.Double(this.dataPlottingArea.getX(), this.dataPlottingArea.getY(), this.dataPlottingArea.getX(), this.dataPlottingArea.getY() + this.dataPlottingArea.getHeight());
        g2.draw(zz);
        Font oldFront = g2.getFont();
        g2.setFont(this.numFont);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < maxYScalLen; ++i) {
            sb.append('0');
        }
        int strYScalLen = g2.getFontMetrics().stringWidth(sb.toString());
        int strLen = g2.getFontMetrics().stringWidth(yLabel);
        int strHei = g2.getFontMetrics().getAscent();
        if (strLen > this.dataPlottingOffsetLeft) {
            strLen = this.dataPlottingOffsetLeft;
        }
        g2.rotate(-1.5707963267948966);
        g2.drawString(yLabel, -(this.dataPlottingArea.height + strLen) * 3 / 5 - this.dataPlottingArea.y, this.dataPlottingArea.x - strYScalLen * 24 / 21);
        g2.rotate(1.5707963267948966);
        zz = new Line2D.Double(this.dataPlottingArea.getX(), this.dataPlottingArea.getY() + this.dataPlottingArea.getHeight(), this.dataPlottingArea.getX() + this.dataPlottingArea.getWidth(), this.dataPlottingArea.getY() + this.dataPlottingArea.getHeight());
        g2.draw(zz);
        strLen = g2.getFontMetrics().stringWidth(XLabel);
        g2.drawString(XLabel, (float)this.dataPlottingArea.x + (float)this.dataPlottingArea.width / 2.0f - (float)strLen / 2.0f, (float)(this.dataPlottingArea.getY() + this.dataPlottingArea.getHeight() + (double)(this.dataPlottingOffsetBottom * 5) / 6.0));
        if (title != null && !title.isEmpty()) {
            this.drawTitle(g2, title);
        }
        g2.setFont(oldFront);
    }

    protected void drawTitle(Graphics2D g2d, String title) {
        g2d.setColor(this.axesColor.darker());
        Font oldFront = g2d.getFont();
        if (title != null && !title.isEmpty()) {
            g2d.setFont(this.titleFont);
            int strLen = g2d.getFontMetrics().stringWidth(title);
            g2d.drawString(title, (float)this.dataPlottingArea.x + (float)this.dataPlottingArea.width / 2.0f - (float)strLen / 2.0f, (float)(this.dataPlottingArea.getY() + this.dataPlottingArea.getHeight() + (double)this.dataPlottingOffsetBottom + (double)this.titleLineHeight / 2.0));
        }
        g2d.setFont(oldFront);
    }

    protected int drawAxesSciScale(Graphics2D g2, CoordinateTransformer transformer, boolean xSci, boolean ySci) {
        String str;
        g2.setColor(this.axesColor.darker());
        int scaleLen = 3;
        int verticalScale = 10;
        double vMin = transformer.getDataVerticalMin();
        double vMax = transformer.getDataVerticalMax();
        double hMin = transformer.getDataHorizontalMin();
        double hMax = transformer.getDataHorizontalMax();
        double gridLen = (vMax - vMin) / (double)verticalScale;
        Font oldFront = g2.getFont();
        g2.setFont(this.numFont);
        int maxYScaleLen = 0;
        int str_hei = g2.getFontMetrics().getAscent();
        for (int i = 1; i <= verticalScale; ++i) {
            Point point1 = transformer.data2ScreenPoint(hMin, vMin + (double)i * gridLen);
            Point2D.Double point2 = new Point2D.Double(((Point2D)point1).getX() + (double)scaleLen, ((Point2D)point1).getY());
            Line2D.Double zz = new Line2D.Double(point1, point2);
            g2.draw(zz);
            str = ySci ? String.format("%.2e", vMin + (double)i * gridLen) : String.format("%.2f", vMin + (double)i * gridLen);
            if (maxYScaleLen < str.length()) {
                maxYScaleLen = str.length();
            }
            int str_len = g2.getFontMetrics().stringWidth(str);
            g2.drawString(str, (float)((Point2D)point1).getX() - (float)str_len, (float)(((Point2D)point1).getY() + (double)str_hei / 2.0));
        }
        int horizontalScale = 10;
        gridLen = (hMax - hMin) / (double)horizontalScale;
        for (int i = 1; i <= horizontalScale; ++i) {
            Point point1 = transformer.data2ScreenPoint(hMin + (double)i * gridLen, vMin);
            Point2D.Double point2 = new Point2D.Double(((Point2D)point1).getX(), ((Point2D)point1).getY() - (double)scaleLen);
            Line2D.Double zz = new Line2D.Double(point1, point2);
            g2.draw(zz);
            str = ySci ? String.format("%.2e", hMin + (double)i * gridLen) : String.format("%.2f", hMin + (double)i * gridLen);
            int str_len = g2.getFontMetrics().stringWidth(str);
            g2.drawString(str, (float)((Point2D)point1).getX() - (float)str_len / 2.0f, (float)(((Point2D)point1).getY() + (double)str_hei));
        }
        g2.setFont(oldFront);
        return maxYScaleLen;
    }

    protected int drawAxesScale(Graphics2D g2, CoordinateTransformer transformer) {
        String str;
        g2.setColor(this.axesColor.darker());
        int scaleLen = 3;
        int verticalScale = 10;
        double vMin = transformer.getDataVerticalMin();
        double vMax = transformer.getDataVerticalMax();
        double hMin = transformer.getDataHorizontalMin();
        double hMax = transformer.getDataHorizontalMax();
        double gridLen = 0.5;
        if (vMax - vMin > 8.0) {
            gridLen = 1.0;
        }
        verticalScale = (int)((vMax - vMin) / gridLen);
        Font oldFront = g2.getFont();
        g2.setFont(this.numFont);
        int maxYScaleLen = 0;
        int str_hei = g2.getFontMetrics().getAscent();
        DoubleArrayList allLens = new DoubleArrayList();
        for (int i = 1; i <= verticalScale; ++i) {
            Point point1 = transformer.data2ScreenPoint(hMin, vMin + (double)i * gridLen);
            Point2D.Double point2 = new Point2D.Double(((Point2D)point1).getX() + (double)scaleLen, ((Point2D)point1).getY());
            Line2D.Double zz = new Line2D.Double(point1, point2);
            g2.draw(zz);
            str = String.format("%.1f", vMin + (double)i * gridLen);
            if (maxYScaleLen < str.length()) {
                maxYScaleLen = str.length();
            }
            allLens.add(str.length());
            int str_len = g2.getFontMetrics().stringWidth(str);
            g2.drawString(str, (float)((Point2D)point1).getX() - (float)(str_len * 6) / 5.0f, (float)(((Point2D)point1).getY() + (double)str_hei / 2.0));
        }
        int horizontalScale = 10;
        gridLen = 0.5;
        if (hMax - hMin > 8.0) {
            gridLen = 1.0;
        }
        horizontalScale = (int)((hMax - hMin) / gridLen);
        for (int i = 1; i <= horizontalScale; ++i) {
            Point point1 = transformer.data2ScreenPoint(hMin + (double)i * gridLen, vMin);
            Point2D.Double point2 = new Point2D.Double(((Point2D)point1).getX(), ((Point2D)point1).getY() - (double)scaleLen);
            Line2D.Double zz = new Line2D.Double(point1, point2);
            g2.draw(zz);
            str = String.format("%.1f", vMin + (double)i * gridLen);
            int str_len = g2.getFontMetrics().stringWidth(str);
            g2.drawString(str, (float)((Point2D)point1).getX() - (float)(str_len * 1) / 2.0f, (float)(((Point2D)point1).getY() + (double)str_hei));
        }
        g2.setFont(oldFront);
        allLens.quickSort();
        return (int)Descriptive.median(allLens);
    }

    public static class CoordinateTransformer {
        protected int screenHorizontalMin;
        protected int screenVerticalMin;
        protected int screenHorizontalMax;
        protected int screenVerticalMax;
        protected double dataHorizontalMin;
        protected double dataVerticalMin;
        protected double dataHorizontalMax;
        protected double dataVerticalMax;
        double horizontalResolution;
        double verticalResolution;

        public double getDataHorizontalMax() {
            return this.dataHorizontalMax;
        }

        public void setDataHorizontalMax(double dataHorizontalMax) {
            this.dataHorizontalMax = dataHorizontalMax;
        }

        public double getDataHorizontalMin() {
            return this.dataHorizontalMin;
        }

        public void setDataHorizontalMin(double dataHorizontalMin) {
            this.dataHorizontalMin = dataHorizontalMin;
        }

        public double getDataVerticalMax() {
            return this.dataVerticalMax;
        }

        public void setDataVerticalMax(double dataVerticalMax) {
            this.dataVerticalMax = dataVerticalMax;
        }

        public double getDataVerticalMin() {
            return this.dataVerticalMin;
        }

        public void setDataVerticalMin(double dataVerticalMin) {
            this.dataVerticalMin = dataVerticalMin;
        }

        public double getHorizontalResolution() {
            return this.horizontalResolution;
        }

        public void setHorizontalResolution(double horizontalResolution) {
            this.horizontalResolution = horizontalResolution;
        }

        public int getScreenHorizontalMax() {
            return this.screenHorizontalMax;
        }

        public void setScreenHorizontalMax(int screenHorizontalMax) {
            this.screenHorizontalMax = screenHorizontalMax;
        }

        public int getScreenHorizontalMin() {
            return this.screenHorizontalMin;
        }

        public void setScreenHorizontalMin(int screenHorizontalMin) {
            this.screenHorizontalMin = screenHorizontalMin;
        }

        public int getScreenVerticalMax() {
            return this.screenVerticalMax;
        }

        public void setScreenVerticalMax(int screenVerticalMax) {
            this.screenVerticalMax = screenVerticalMax;
        }

        public int getScreenVerticalMin() {
            return this.screenVerticalMin;
        }

        public void setScreenVerticalMin(int screenVerticalMin) {
            this.screenVerticalMin = screenVerticalMin;
        }

        public double getVerticalResolution() {
            return this.verticalResolution;
        }

        public void setVerticalResolution(double verticalResolution) {
            this.verticalResolution = verticalResolution;
        }

        public void setupBasicScope(int screenHorizontalMin, int screenHorizontalMax, int screenVerticalMin, int screenVerticalMax, double dataHorizontalMin, double dataHorizontalMax, double dataVerticalMin, double dataVerticalMax) {
            this.screenHorizontalMin = screenHorizontalMin;
            this.screenHorizontalMax = screenHorizontalMax;
            this.screenVerticalMin = screenVerticalMin;
            this.screenVerticalMax = screenVerticalMax;
            this.dataHorizontalMin = dataHorizontalMin;
            this.dataHorizontalMax = dataHorizontalMax;
            this.dataVerticalMin = dataVerticalMin;
            this.dataVerticalMax = dataVerticalMax;
            this.horizontalResolution = (dataHorizontalMax - dataHorizontalMin) / (double)(screenHorizontalMax - screenHorizontalMin);
            this.verticalResolution = (dataVerticalMax - dataVerticalMin) / (double)(screenVerticalMax - screenVerticalMin);
        }

        public double[] data2Screen(double Xa, double Ya) {
            double[] myout = new double[]{(Xa - this.dataHorizontalMin) / this.horizontalResolution + (double)this.screenHorizontalMin, (double)this.screenVerticalMax - (Ya - this.dataVerticalMin) / this.verticalResolution};
            return myout;
        }

        public Point data2ScreenPoint(double Xa, double Ya) {
            Point myout = new Point();
            myout.setLocation((Xa - this.dataHorizontalMin) / this.horizontalResolution + (double)this.screenHorizontalMin, (double)this.screenVerticalMax - (Ya - this.dataVerticalMin) / this.verticalResolution);
            return myout;
        }

        public void data2ScreenPoint(Point myout, double Xa, double Ya) {
            myout.setLocation((Xa - this.dataHorizontalMin) / this.horizontalResolution + (double)this.screenHorizontalMin, (double)this.screenVerticalMax - (Ya - this.dataVerticalMin) / this.verticalResolution);
        }

        public double[] screen2Data(int X6, int Y6) {
            double[] myout = new double[]{(double)(X6 - this.screenHorizontalMin) * this.horizontalResolution + this.dataHorizontalMin, (double)(this.screenVerticalMax - Y6) * this.verticalResolution + this.dataVerticalMin};
            return myout;
        }

        public double horizontalSegmentData2Screen(double len) {
            return len / this.horizontalResolution;
        }

        public double verticalSegmentData2Screen(double len) {
            return len / this.verticalResolution;
        }
    }
}

