/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.plot;

import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import edu.sysu.pmglab.analysis.GenotypeLDUtils;
import edu.sysu.pmglab.container.list.IntList;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.gtb.genome.Variant;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class LDPainter {
    private static final float VIOLATOR_GENOTYPE_MIN_PERCENT = 0.5f;
    private final IntList boundaries;
    private final List<Variant> subVariants;
    private final int startIndex;
    private final DenseDoubleMatrix2D ldMatrix;
    private final int size;
    private final String savePath;

    public static Builder builder() {
        return new Builder();
    }

    public DenseDoubleMatrix2D getLdMatrix() {
        return this.ldMatrix;
    }

    private LDPainter(int startIndex, List<Variant> subVariants, IntList boundaries, String savePath) {
        this.startIndex = startIndex;
        this.subVariants = subVariants;
        this.boundaries = boundaries;
        this.size = subVariants.size();
        this.ldMatrix = this.generateMatrix();
        this.savePath = savePath;
        this.generatePng();
    }

    private DenseDoubleMatrix2D generateMatrix() {
        DenseDoubleMatrix2D matrix = new DenseDoubleMatrix2D(this.size, this.size);
        matrix.assign(0.0);
        int minN = Math.round((float)this.subVariants.get(0).getGenotypes().size() * 0.5f);
        for (int i = 0; i < this.size; ++i) {
            matrix.set(i, i, 1.0);
            for (int i1 = i + 1; i1 < this.size; ++i1) {
                float r2 = ((Float)GenotypeLDUtils.INSTANCE.apply(this.subVariants.fastGet(i), this.subVariants.fastGet(i1), minN).get("R^2")).floatValue();
                if (Double.isNaN(r2)) continue;
                matrix.set(i, i1, r2);
                matrix.set(i1, i, r2);
            }
        }
        return matrix;
    }

    private void generatePng() {
        try {
            Color[] colorLUT = this.createRedGradientLUT();
            int cellSize = 10;
            int heatmapSize = this.size * cellSize;
            int legendWidth = 100;
            int padding = 20;
            int totalWidth = heatmapSize + legendWidth + padding;
            BufferedImage image = new BufferedImage(totalWidth, heatmapSize, 1);
            Graphics2D g2d = image.createGraphics();
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g2d.setColor(Color.WHITE);
            g2d.fillRect(0, 0, totalWidth, heatmapSize);
            for (int row = 0; row < this.size; ++row) {
                for (int col = row; col < this.size; ++col) {
                    float value = (float)this.ldMatrix.getQuick(row, col);
                    Color color = value < 1.0E-4f ? Color.WHITE : this.getColorFromLUT(value, colorLUT);
                    g2d.setColor(color);
                    g2d.fillRect(col * cellSize, row * cellSize, cellSize, cellSize);
                }
            }
            for (int i = 0; i < this.boundaries.size(); ++i) {
                int split = this.boundaries.fastGet(i);
                if (split < this.startIndex || split > this.startIndex + this.size) continue;
                int linePos = (split - this.startIndex) * cellSize + cellSize / 2;
                g2d.setColor(Color.GREEN);
                g2d.setStroke(new BasicStroke(6.0f));
                g2d.drawLine(linePos, 0, linePos, linePos);
                g2d.drawLine(linePos, linePos, heatmapSize, linePos);
            }
            this.drawColorLegend(g2d, heatmapSize + padding, padding, legendWidth, heatmapSize - 2 * padding, colorLUT);
            g2d.dispose();
            ImageIO.write((RenderedImage)image, "png", new File(this.savePath));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Color[] createRedGradientLUT() {
        Color[] colors = new Color[256];
        Color lightRed = new Color(255, 240, 240);
        Color darkRed = new Color(178, 34, 34);
        for (int i = 0; i < 256; ++i) {
            float ratio = (float)i / 255.0f;
            int red = (int)((float)lightRed.getRed() * (1.0f - ratio) + (float)darkRed.getRed() * ratio);
            int green = (int)((float)lightRed.getGreen() * (1.0f - ratio) + (float)darkRed.getGreen() * ratio);
            int blue = (int)((float)lightRed.getBlue() * (1.0f - ratio) + (float)darkRed.getBlue() * ratio);
            colors[i] = new Color(red, green, blue);
        }
        return colors;
    }

    private Color getColorFromLUT(float value, Color[] lut) {
        float normalizedValue = (value - 1.0E-4f) / 0.9999f;
        int index = Math.min(lut.length - 1, (int)(normalizedValue * (float)lut.length));
        return lut[Math.max(0, index)];
    }

    private void drawColorLegend(Graphics2D g2d, int x, int y, int width, int height, Color[] lut) {
        int gradientHeight = height - 60;
        for (int i = 0; i < gradientHeight; ++i) {
            float ratio = 1.0f - (float)i / (float)gradientHeight;
            Color color = lut[(int)(ratio * (float)(lut.length - 1))];
            g2d.setColor(color);
            g2d.drawLine(x, y + i, x + width, y + i);
        }
        g2d.setColor(Color.BLACK);
        g2d.drawRect(x, y, width, gradientHeight);
        g2d.setColor(Color.GRAY);
        g2d.fillRect(x, y + gradientHeight + 10, width, 20);
        g2d.setColor(Color.BLACK);
        g2d.drawRect(x, y + gradientHeight + 10, width, 20);
        Font font = new Font("SansSerif", 0, 12);
        g2d.setFont(font);
        FontMetrics metrics = g2d.getFontMetrics();
        String[] labels = new String[]{"1.0", "0.5", "0.0"};
        int[] labelPositions = new int[]{y, y + gradientHeight / 2, y + gradientHeight, y + gradientHeight + 25};
        for (int i = 0; i < labels.length; ++i) {
            int labelY = labelPositions[i];
            String text = labels[i];
            if (i < 2) {
                g2d.drawLine(x - 5, labelY, x, labelY);
            }
            g2d.drawString(text, x + width + 5, labelY + metrics.getAscent() / 2);
        }
        String title = "R\u00b2 Value";
        int titleWidth = metrics.stringWidth(title);
        g2d.drawString(title, x + (width - titleWidth) / 2, y - 5);
    }

    public static class Builder {
        private int startIndex;
        private List<Variant> subVariants;
        private IntList boundaries;
        private String savePath;

        public Builder setStartIndex(int startIndex) {
            this.startIndex = startIndex;
            return this;
        }

        public Builder setSubVariants(List<Variant> subVariants) {
            this.subVariants = subVariants;
            return this;
        }

        public Builder setBoundaries(IntList boundaries) {
            this.boundaries = boundaries;
            return this;
        }

        public Builder setSavePath(String savePath) {
            this.savePath = savePath;
            return this;
        }

        public DenseDoubleMatrix2D execute() {
            return new LDPainter(this.startIndex, this.subVariants, this.boundaries, this.savePath).getLdMatrix();
        }
    }
}

