/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.plot;

import cern.colt.list.DoubleArrayList;
import cern.jet.random.Uniform;
import cern.jet.random.engine.MersenneTwister;
import com.itextpdf.awt.PdfGraphics2D;
import com.itextpdf.text.Document;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.PdfWriter;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.plot.BasicPainter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Date;
import umontreal.iro.lecuyer.probdist.BetaDist;

public class PValuePainter
extends BasicPainter {
    public PValuePainter(int width, int height) {
        super(width, height);
    }

    public void drawMultipleQQPlot(List<DoubleArrayList> valueLists, List<String> legends, String title, String outputPath, double pValueTolerationLevel) throws Exception {
        double vMax;
        if (valueLists == null || valueLists.isEmpty()) {
            System.err.println("Null p-value list");
            return;
        }
        int listNum = valueLists.size();
        for (int i = listNum - 1; i >= 0; --i) {
            if (valueLists.get(i) != null && !valueLists.get(i).isEmpty()) continue;
            System.err.println("Null p-value list");
            valueLists.removeByIndex(i);
        }
        if (valueLists.isEmpty()) {
            System.err.println("Null p-value list");
            return;
        }
        int dataSize = valueLists.get(0).size();
        this.calculateDataPlottingArea(title != null && !title.isEmpty());
        double vMin = vMax = valueLists.get(0).getQuick(0);
        double hMin = 0.0;
        double hMax = 1.0 / (double)dataSize;
        int maxDataPointSize = dataSize;
        for (int i = 0; i < listNum; ++i) {
            DoubleArrayList tmpValueList = valueLists.get(i);
            tmpValueList.quickSort();
            dataSize = tmpValueList.size();
            for (int j = 0; j < dataSize; ++j) {
                if (vMax > tmpValueList.getQuick(j)) {
                    vMax = tmpValueList.getQuick(j);
                    continue;
                }
                if (!(vMin < tmpValueList.getQuick(j))) continue;
            }
            if (hMax > 1.0 / (double)(dataSize + 1)) {
                hMax = 1.0 / (double)(dataSize + 1);
            }
            if (maxDataPointSize >= dataSize) continue;
            maxDataPointSize = dataSize;
        }
        vMin = 1.0;
        vMin = -Math.log10(vMin);
        vMax = -Math.log10(vMax);
        hMax = -Math.log10(hMax);
        if (vMax > -Math.log10(pValueTolerationLevel)) {
            vMax = -Math.log10(pValueTolerationLevel);
        }
        hMax = Math.ceil(hMax);
        vMax = Math.ceil(vMax);
        BufferedImage image = new BufferedImage(this.canvasWidth, this.canvasHeight, 1);
        Graphics2D g2d = image.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.paintCanvas(g2d);
        BasicPainter.CoordinateTransformer transformer = new BasicPainter.CoordinateTransformer();
        transformer.setupBasicScope(this.dataPlottingArea.x, this.dataPlottingArea.x + this.dataPlottingArea.width, this.dataPlottingArea.y, this.dataPlottingArea.y + this.dataPlottingArea.height, hMin, hMax, vMin, vMax);
        int maxYScalLen = this.drawAxesScale(g2d, transformer);
        this.drawAxes(g2d, title, "Expected [-log10(P)]", "Observed [-log10(P)]", maxYScalLen);
        Point point1 = transformer.data2ScreenPoint(0.0, 0.0);
        Point point2 = transformer.data2ScreenPoint(Math.min(hMax, vMax), Math.min(hMax, vMax));
        Line2D.Double zz = new Line2D.Double(point1, point2);
        Stroke oldStroke = g2d.getStroke();
        Color oldColor = g2d.getColor();
        g2d.setColor(Color.GREEN);
        g2d.setStroke(new BasicStroke(2.0f, 1, 1));
        g2d.draw(zz);
        int rectangleSize = 2;
        int harlfRectangleSize = rectangleSize / 2;
        int triangleLen = 4;
        double maxDiff = 0.05;
        Color[] colors = new Color[]{Color.BLUE, Color.RED, Color.ORANGE, Color.MAGENTA, Color.BLACK, Color.PINK, Color.CYAN};
        int strHei = g2d.getFontMetrics().getHeight();
        double vRectangleSize = 6.0;
        double hRectangleSize = 6.0;
        g2d.setStroke(oldStroke);
        Font oldFront = g2d.getFont();
        g2d.setFont(this.numFont);
        int maxLegentWidth = g2d.getFontMetrics().stringWidth(legends.get(listNum - 1));
        for (int i = listNum - 2; i >= 0; --i) {
            int strLen = g2d.getFontMetrics().stringWidth(legends.get(i));
            if (maxLegentWidth >= strLen) continue;
            maxLegentWidth = strLen;
        }
        Point minP1 = new Point();
        Point minP2 = new Point();
        Point maxP1 = new Point();
        Point maxP2 = new Point();
        BetaDist betaDist = new BetaDist(1.0, maxDataPointSize);
        double x = betaDist.inverseF(0.5);
        x = -Math.log10(x);
        double fmin = betaDist.inverseF(0.025);
        fmin = -Math.log10(fmin);
        transformer.data2ScreenPoint(minP1, x, fmin);
        double fmax = betaDist.inverseF(0.975);
        fmax = -Math.log10(fmax);
        transformer.data2ScreenPoint(maxP1, x, fmax);
        g2d.setColor(Color.BLACK);
        float[] dashes = new float[]{3.0f};
        g2d.setStroke(new BasicStroke(0.5f, 1, 1, 10.0f, dashes, 0.0f));
        int k = 2;
        while (k <= maxDataPointSize) {
            betaDist = new BetaDist(k, maxDataPointSize + 1 - k);
            x = betaDist.inverseF(0.5);
            x = -Math.log10(x);
            fmin = betaDist.inverseF(0.025);
            fmin = -Math.log10(fmin);
            transformer.data2ScreenPoint(minP2, x, fmin);
            g2d.drawLine(minP1.x, minP1.y, minP2.x, minP2.y);
            minP1.x = minP2.x;
            minP1.y = minP2.y;
            fmax = betaDist.inverseF(0.975);
            fmax = -Math.log10(fmax);
            transformer.data2ScreenPoint(maxP2, x, fmax);
            g2d.drawLine(maxP1.x, maxP1.y, maxP2.x, maxP2.y);
            maxP1.x = maxP2.x;
            maxP1.y = maxP2.y;
            if (k <= 2000) {
                ++k;
                continue;
            }
            k += k;
        }
        g2d.setStroke(oldStroke);
        for (int i = listNum - 1; i >= 0; --i) {
            DoubleArrayList tmpValueList = valueLists.get(i);
            dataSize = tmpValueList.size();
            g2d.setColor(colors[i % colors.length]);
            int dataSizeMore = dataSize + 1;
            for (int j = 0; j < dataSize; ++j) {
                double tmpDouble1 = -Math.log10((double)(j + 1) / (double)dataSizeMore);
                double tmpDouble2 = -Math.log10(tmpValueList.getQuick(j));
                if (Double.isNaN(tmpDouble2)) {
                    tmpDouble2 = 0.0;
                }
                if (tmpDouble2 <= vMax) {
                    transformer.data2ScreenPoint(point1, tmpDouble1, tmpDouble2);
                    g2d.drawRect(point1.x - harlfRectangleSize, point1.y - harlfRectangleSize, rectangleSize, rectangleSize);
                    continue;
                }
                tmpDouble2 = vMax;
                transformer.data2ScreenPoint(point1, tmpDouble1, tmpDouble2);
                x = point1.getX();
                double y = point1.getY();
                this.plotTriangle(g2d, (int)x, (int)y, triangleLen);
            }
            if (legends.get(i) == null || legends.get(i).trim().isEmpty()) continue;
            g2d.setStroke(new BasicStroke(1.5f));
            double xOffset = this.dataPlottingArea.getWidth() * 1.0 / 20.0;
            double yOffset = this.dataPlottingArea.getHeight() * 1.0 / 20.0;
            g2d.drawString(legends.get(i), (float)((double)this.dataPlottingArea.x + xOffset), (float)(this.dataPlottingArea.getY() + yOffset) + (float)(strHei * i));
            Rectangle2D.Double f = new Rectangle2D.Double((double)this.dataPlottingArea.x + xOffset + (double)maxLegentWidth + hRectangleSize, this.dataPlottingArea.getY() + yOffset + (double)(strHei * i) - vRectangleSize, hRectangleSize, vRectangleSize);
            g2d.fill(f);
            g2d.draw(f);
            g2d.setStroke(oldStroke);
        }
        g2d.setFont(oldFront);
        g2d.setColor(oldColor);
        g2d.dispose();
        PValuePainter.outputPNGFile(image, outputPath);
    }

    public void drawMultipleQQPlotPDF(List<DoubleArrayList> valueLists, List<String> legends, String title, String outputPath, double pValueTolerationLevel) throws Exception {
        double vMax;
        if (valueLists == null || valueLists.isEmpty()) {
            System.err.println("Null p-value list");
            return;
        }
        int listNum = valueLists.size();
        for (int i = listNum - 1; i >= 0; --i) {
            if (valueLists.get(i) != null && !valueLists.get(i).isEmpty()) continue;
            System.err.println("Null p-value list");
            valueLists.removeByIndex(i);
        }
        if (valueLists.isEmpty()) {
            System.err.println("Null p-value list");
            return;
        }
        int dataSize = valueLists.get(0).size();
        this.calculateDataPlottingArea(title != null && !title.isEmpty());
        double vMin = vMax = valueLists.get(0).getQuick(0);
        double hMin = 0.0;
        double hMax = 1.0 / (double)dataSize;
        int maxDataPointSize = dataSize;
        for (int i = 0; i < listNum; ++i) {
            DoubleArrayList tmpValueList = valueLists.get(i);
            tmpValueList.quickSort();
            dataSize = tmpValueList.size();
            for (int j = 0; j < dataSize; ++j) {
                if (vMax > tmpValueList.getQuick(j)) {
                    vMax = tmpValueList.getQuick(j);
                    continue;
                }
                if (!(vMin < tmpValueList.getQuick(j))) continue;
            }
            if (hMax > 1.0 / (double)(dataSize + 1)) {
                hMax = 1.0 / (double)(dataSize + 1);
            }
            if (maxDataPointSize >= dataSize) continue;
            maxDataPointSize = dataSize;
        }
        vMin = 1.0;
        vMin = -Math.log10(vMin);
        vMax = -Math.log10(vMax);
        hMax = -Math.log10(hMax);
        if (vMax > -Math.log10(pValueTolerationLevel)) {
            vMax = -Math.log10(pValueTolerationLevel);
        }
        hMax = Math.ceil(hMax);
        vMax = Math.ceil(vMax);
        Document document = new Document(new Rectangle(this.canvasWidth, this.canvasHeight));
        PdfWriter writer = PdfWriter.getInstance(document, Files.newOutputStream(Paths.get(outputPath, new String[0]), new OpenOption[0]));
        document.open();
        PdfContentByte canvas = writer.getDirectContent();
        PdfTemplate template = canvas.createTemplate(this.canvasWidth, this.canvasHeight);
        PdfGraphics2D g2d = new PdfGraphics2D(template, this.canvasWidth, this.canvasHeight);
        ((Graphics2D)g2d).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.paintCanvas(g2d);
        BasicPainter.CoordinateTransformer transformer = new BasicPainter.CoordinateTransformer();
        transformer.setupBasicScope(this.dataPlottingArea.x, this.dataPlottingArea.x + this.dataPlottingArea.width, this.dataPlottingArea.y, this.dataPlottingArea.y + this.dataPlottingArea.height, hMin, hMax, vMin, vMax);
        int maxYScalLen = this.drawAxesScale(g2d, transformer);
        this.drawAxes(g2d, title, "Expected [-log10(P)]", "Observed [-log10(P)]", maxYScalLen);
        Point point1 = transformer.data2ScreenPoint(0.0, 0.0);
        Point point2 = transformer.data2ScreenPoint(Math.min(hMax, vMax), Math.min(hMax, vMax));
        Line2D.Double zz = new Line2D.Double(point1, point2);
        Stroke oldStroke = ((Graphics2D)g2d).getStroke();
        Color oldColor = ((Graphics)g2d).getColor();
        ((Graphics)g2d).setColor(Color.GREEN);
        ((Graphics2D)g2d).setStroke(new BasicStroke(2.0f, 1, 1));
        ((Graphics2D)g2d).draw(zz);
        int rectangleSize = 6;
        if (valueLists.size() > 2) {
            rectangleSize = 4;
        }
        int harlfRectangleSize = rectangleSize / 2;
        int triangleLen = 6;
        double maxDiff = 0.05;
        Color[] colors = new Color[]{Color.BLUE, Color.RED, Color.ORANGE, Color.MAGENTA, Color.BLACK, Color.PINK, Color.CYAN};
        int strHei = g2d.getFontMetrics().getHeight();
        double vRectangleSize = 6.0;
        double hRectangleSize = 6.0;
        ((Graphics2D)g2d).setStroke(oldStroke);
        Font oldFront = ((Graphics)g2d).getFont();
        ((Graphics)g2d).setFont(this.numFont);
        int maxLegentWidth = g2d.getFontMetrics().stringWidth(legends.get(listNum - 1));
        for (int i = listNum - 2; i >= 0; --i) {
            int strLen = g2d.getFontMetrics().stringWidth(legends.get(i));
            if (maxLegentWidth >= strLen) continue;
            maxLegentWidth = strLen;
        }
        BetaDist betaDist = new BetaDist(1.0, maxDataPointSize);
        Point minP1 = new Point();
        Point minP2 = new Point();
        Point maxP1 = new Point();
        Point maxP2 = new Point();
        double x = betaDist.inverseF(0.5);
        x = -Math.log10(x);
        double fmin = betaDist.inverseF(0.025);
        fmin = -Math.log10(fmin);
        transformer.data2ScreenPoint(minP1, x, fmin);
        double fmax = betaDist.inverseF(0.975);
        fmax = -Math.log10(fmax);
        transformer.data2ScreenPoint(maxP1, x, fmax);
        ((Graphics)g2d).setColor(Color.BLACK);
        float[] dashes = new float[]{3.0f};
        ((Graphics2D)g2d).setStroke(new BasicStroke(0.5f, 1, 1, 10.0f, dashes, 0.0f));
        int[] xPoints = new int[4];
        int[] yPoints = new int[4];
        int k = 2;
        while (k <= maxDataPointSize) {
            betaDist = new BetaDist(k, maxDataPointSize + 1 - k);
            x = betaDist.inverseF(0.5);
            x = -Math.log10(x);
            fmin = betaDist.inverseF(0.025);
            fmin = -Math.log10(fmin);
            transformer.data2ScreenPoint(minP2, x, fmin);
            ((Graphics)g2d).drawLine(minP1.x, minP1.y, minP2.x, minP2.y);
            xPoints[0] = maxP1.x;
            yPoints[0] = maxP1.y;
            xPoints[1] = maxP2.x;
            yPoints[1] = maxP2.y;
            minP1.x = minP2.x;
            minP1.y = minP2.y;
            fmax = betaDist.inverseF(0.975);
            fmax = -Math.log10(fmax);
            transformer.data2ScreenPoint(maxP2, x, fmax);
            ((Graphics)g2d).drawLine(maxP1.x, maxP1.y, maxP2.x, maxP2.y);
            xPoints[2] = maxP1.x;
            yPoints[2] = maxP1.y;
            xPoints[3] = maxP2.x;
            yPoints[3] = maxP2.y;
            maxP1.x = maxP2.x;
            maxP1.y = maxP2.y;
            if (k <= 2000) {
                ++k;
                continue;
            }
            k += k;
        }
        ((Graphics2D)g2d).setStroke(oldStroke);
        for (int i = listNum - 1; i >= 0; --i) {
            DoubleArrayList tmpValueList = valueLists.get(i);
            dataSize = tmpValueList.size();
            ((Graphics)g2d).setColor(colors[i % colors.length]);
            int dataSizeMore = dataSize + 1;
            for (int j = 0; j < dataSize; ++j) {
                double tmpDouble1 = -Math.log10((double)(j + 1) / (double)dataSizeMore);
                double tmpDouble2 = -Math.log10(tmpValueList.getQuick(j));
                if (Double.isNaN(tmpDouble2)) {
                    tmpDouble2 = 0.0;
                }
                if (tmpDouble2 <= vMax) {
                    transformer.data2ScreenPoint(point1, tmpDouble1, tmpDouble2);
                    Ellipse2D.Double circle = new Ellipse2D.Double(point1.x - harlfRectangleSize, point1.y - harlfRectangleSize, rectangleSize, rectangleSize);
                    ((Graphics2D)g2d).fill(circle);
                    continue;
                }
                tmpDouble2 = vMax;
                transformer.data2ScreenPoint(point1, tmpDouble1, tmpDouble2);
                x = point1.getX();
                double y = point1.getY();
                this.plotTriangle(g2d, (int)x, (int)y, triangleLen);
            }
            oldStroke = ((Graphics2D)g2d).getStroke();
            if (legends.get(i) == null || legends.get(i).trim().isEmpty()) continue;
            ((Graphics2D)g2d).setStroke(new BasicStroke(1.5f));
            double xOffset = this.dataPlottingArea.getWidth() * 1.0 / 20.0;
            double yOffset = this.dataPlottingArea.getHeight() * 1.0 / 20.0;
            ((Graphics2D)g2d).drawString(legends.get(i), (float)((double)this.dataPlottingArea.x + xOffset), (float)(this.dataPlottingArea.getY() + yOffset) + (float)(strHei * i));
            Ellipse2D.Double circle = new Ellipse2D.Double((double)this.dataPlottingArea.x + xOffset + (double)maxLegentWidth + hRectangleSize, this.dataPlottingArea.getY() + yOffset + (double)(strHei * i) - vRectangleSize, hRectangleSize, vRectangleSize);
            ((Graphics2D)g2d).fill(circle);
            ((Graphics2D)g2d).setStroke(oldStroke);
        }
        ((Graphics)g2d).setFont(oldFront);
        ((Graphics)g2d).setColor(oldColor);
        ((Graphics)g2d).dispose();
        canvas.addTemplate(template, 0.0f, 0.0f);
        document.newPage();
        document.close();
    }

    public static void main(String[] args) {
        try {
            List<DoubleArrayList> pList = new List<DoubleArrayList>();
            DoubleArrayList dlist = new DoubleArrayList();
            Uniform twister = new Uniform(new MersenneTwister(new Date()));
            for (int i = 0; i < 1000000; ++i) {
                dlist.add(twister.nextDouble());
            }
            PValuePainter painter = new PValuePainter(450, 350);
            double pValueTolerationLevle = 1.0E-20;
            List<String> legs = new List<String>();
            legs.add("Test");
            pList.add(dlist);
            painter.drawMultipleQQPlotPDF(pList, legs, null, "qq.pdf", pValueTolerationLevle);
            painter.drawMultipleQQPlot(pList, legs, null, "qq.png", pValueTolerationLevle);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

