/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.progressbar;

import edu.sysu.pmglab.container.iterator.LoopIterator;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.progressbar.ProgressRenderer;
import edu.sysu.pmglab.progressbar.ProgressState;
import edu.sysu.pmglab.progressbar.unit.IUnit;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Iterator;
import java.util.Locale;

public class BarProgressRenderer
implements ProgressRenderer {
    private static final DecimalFormat rateFormat = new DecimalFormat("#.## %", new DecimalFormatSymbols(Locale.US));
    private static final DecimalFormat valueFormat = new DecimalFormat("###,###.#", new DecimalFormatSymbols(Locale.US));
    private static final DecimalFormat timeFormat = new DecimalFormat("#.#", new DecimalFormatSymbols(Locale.US));
    final String name;
    final IUnit unit;
    final Iterator<String> beginLabels = new LoopIterator<String>(List.wrap(" \\", " |", " /", " |"));
    final StringBuilder builder = new StringBuilder();

    public BarProgressRenderer(String name, IUnit unit) {
        this.name = name;
        this.unit = unit;
    }

    private static String repeat(char c, int n) {
        if (n <= 0) {
            return "";
        }
        char[] s = new char[n];
        for (int i = 0; i < n; ++i) {
            s[i] = c;
        }
        return new String(s);
    }

    private String percentage(ProgressState progress) {
        String res = progress.getMaxStep() <= 0L ? "? %" : (int)Math.floor(100.0 * (double)progress.getCurrentStep() / (double)progress.getMaxStep()) + "%";
        return BarProgressRenderer.repeat(' ', 4 - res.length()) + res;
    }

    private String fillTime(long seconds) {
        long hours = seconds / 3600L;
        long minutes = seconds % 3600L / 60L;
        return String.format("%02d:%02d:%02d", hours, minutes, seconds %= 60L);
    }

    @Override
    public String render(ProgressState state) {
        long currentTime = System.currentTimeMillis();
        double current = state.getCurrentStep();
        double last = state.getLastStep();
        double lastTime = state.getLastUpdateTime();
        double max = state.getMaxStep();
        this.builder.setLength(0);
        if (max >= 0.0) {
            int step = (int)(current / max * 25.0);
            if (current == max) {
                this.builder.append(this.name).append(" ").append(this.percentage(state)).append(" ").append("\u2502").append(BarProgressRenderer.repeat('\u2588', 25)).append('\u2502');
            } else {
                this.builder.append(this.name).append(" ").append(this.percentage(state)).append(" ").append("\u2502").append(BarProgressRenderer.repeat('\u2588', step)).append(BarProgressRenderer.repeat(' ', 25 - step)).append('\u2502');
            }
            double timePassed = (double)currentTime - lastTime;
            double remainingTime = (max - current) / (current - last) * timePassed;
            this.builder.append(" ").append(this.unit.convert(current, valueFormat)).append("/").append(this.unit.convert(max, valueFormat)).append(" (").append(this.fillTime((currentTime - state.getStartTime()) / 1000L)).append("/").append(Double.isNaN(remainingTime) || Double.isInfinite(remainingTime) ? "-" : this.fillTime((long)remainingTime / 1000L)).append(")");
        } else {
            this.builder.append(this.name).append(" ").append(this.percentage(state)).append(" ").append("\u2502").append(BarProgressRenderer.repeat('\u2588', 1)).append(BarProgressRenderer.repeat(' ', 24)).append('\u2502');
            this.builder.append(" ").append(this.unit.convert(current, valueFormat)).append(" (").append(this.fillTime((currentTime - state.getStartTime()) / 1000L)).append(")");
        }
        return this.builder.toString();
    }

    @Override
    public String finish(ProgressState state) {
        long currentTime = System.currentTimeMillis();
        double current = state.getCurrentStep();
        double last = state.getLastStep();
        double lastTime = state.getLastUpdateTime();
        double max = state.getMaxStep();
        this.builder.setLength(0);
        if (max >= 0.0) {
            int step = (int)(current / max * 25.0);
            if (current == max) {
                this.builder.append(this.name).append(" ").append(this.percentage(state)).append(" ").append("\u2502").append(BarProgressRenderer.repeat('\u2588', 25)).append('\u2502');
            } else {
                this.builder.append(this.name).append(" ").append(this.percentage(state)).append(" ").append("\u2502").append(BarProgressRenderer.repeat('\u2588', step)).append(BarProgressRenderer.repeat(' ', 25 - step)).append('\u2502');
            }
            double timePassed = (double)currentTime - lastTime;
            double remainingTime = (max - current) / (current - last) * timePassed;
            this.builder.append(" ").append(this.unit.convert(current, valueFormat)).append("/").append(this.unit.convert(max, valueFormat)).append(" (").append(this.fillTime((currentTime - state.getStartTime()) / 1000L)).append(")\n");
        } else {
            max = current;
            int step = (int)(current / max * 25.0);
            this.builder.append(this.name).append(" ").append("100%").append(" ").append("\u2502").append(BarProgressRenderer.repeat('\u2588', 25)).append('\u2502');
            double timePassed = (double)currentTime - lastTime;
            double remainingTime = (max - current) / (current - last) * timePassed;
            this.builder.append(" ").append(this.unit.convert(current, valueFormat)).append(" (").append(this.fillTime((currentTime - state.getStartTime()) / 1000L)).append(")\n");
        }
        return this.builder.toString();
    }
}

