/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.progressbar;

import edu.sysu.pmglab.progressbar.ProgressBar;
import edu.sysu.pmglab.progressbar.ProgressConsumer;
import edu.sysu.pmglab.progressbar.ProgressRenderers;
import edu.sysu.pmglab.progressbar.ProgressUpdateActions;
import edu.sysu.pmglab.progressbar.TextProgressRenderers;
import edu.sysu.pmglab.progressbar.console.ConsoleConsumer;
import java.io.Closeable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class MultiProgressBar
implements Closeable,
AutoCloseable {
    final ProgressUpdateActions action;
    final ScheduledFuture<?> scheduledTask;

    private MultiProgressBar(ProgressUpdateActions action) {
        this.action = action;
        this.scheduledTask = ProgressBar.EXECUTOR.scheduleAtFixedRate(this.action, 0L, 500L, TimeUnit.MILLISECONDS);
    }

    public MultiProgressBar step(long ... ns) {
        this.action.step(ns);
        return this;
    }

    public long[] get() {
        return this.action.get();
    }

    public MultiProgressBar print(String info) {
        this.action.consumer.accept(info);
        return this;
    }

    public MultiProgressBar pause() {
        this.action.pause();
        return this;
    }

    public MultiProgressBar resume() {
        this.action.resume();
        return this;
    }

    @Override
    public void close() {
        this.scheduledTask.cancel(false);
        this.action.stop();
        try {
            ProgressBar.EXECUTOR.schedule(this.action, 0L, TimeUnit.NANOSECONDS).get();
        }
        catch (InterruptedException | ExecutionException exception) {
            // empty catch block
        }
    }

    public static class Builder {
        ProgressConsumer consumer = null;
        ProgressRenderers renderers = null;

        public Builder setConsumer(ProgressConsumer consumer) {
            this.consumer = consumer;
            return this;
        }

        public Builder setRenderers(ProgressRenderers renderer) {
            this.renderers = renderer;
            return this;
        }

        public MultiProgressBar build() {
            ProgressUpdateActions state = this.consumer == ProgressConsumer.SILENT || this.renderers == ProgressRenderers.SILENT ? new ProgressUpdateActions(ProgressRenderers.SILENT, ProgressConsumer.SILENT) : new ProgressUpdateActions(this.renderers == null ? new TextProgressRenderers() : this.renderers, this.consumer == null ? new ConsoleConsumer() : this.consumer);
            return new MultiProgressBar(state);
        }
    }
}

