/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.progressbar;

import edu.sysu.pmglab.progressbar.BarProgressRenderer;
import edu.sysu.pmglab.progressbar.ProgressConsumer;
import edu.sysu.pmglab.progressbar.ProgressRenderer;
import edu.sysu.pmglab.progressbar.ProgressState;
import edu.sysu.pmglab.progressbar.ProgressUpdateAction;
import edu.sysu.pmglab.progressbar.TextProgressRenderer;
import edu.sysu.pmglab.progressbar.console.ConsoleConsumer;
import edu.sysu.pmglab.progressbar.unit.IUnit;
import edu.sysu.pmglab.utils.ValueUtils;
import java.io.Closeable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ProgressBar
implements Closeable,
AutoCloseable {
    static final ScheduledThreadPoolExecutor EXECUTOR = new ScheduledThreadPoolExecutor(1, runnable2 -> {
        Thread thread2 = Executors.defaultThreadFactory().newThread(runnable2);
        thread2.setName("ProgressBar");
        thread2.setDaemon(true);
        return thread2;
    });
    final ProgressUpdateAction action;
    final ScheduledFuture<?> scheduledTask;

    private ProgressBar(ProgressUpdateAction action) {
        this.action = action;
        this.scheduledTask = EXECUTOR.scheduleAtFixedRate(this.action, 0L, 500L, TimeUnit.MILLISECONDS);
    }

    public ProgressBar step(long n) {
        this.action.step(n);
        return this;
    }

    public long get() {
        return this.action.get();
    }

    public ProgressBar print(String info) {
        this.action.consumer.accept(info);
        return this;
    }

    public ProgressBar pause() {
        this.action.pause();
        return this;
    }

    public ProgressBar resume() {
        this.action.resume();
        return this;
    }

    @Override
    public void close() {
        this.scheduledTask.cancel(false);
        this.action.stop();
        try {
            EXECUTOR.schedule(this.action, 0L, TimeUnit.NANOSECONDS).get();
        }
        catch (InterruptedException | ExecutionException exception) {
            // empty catch block
        }
    }

    public static class Builder {
        long initialMax = -1L;
        long processed = 0L;
        ProgressConsumer consumer = null;
        ProgressRenderer renderer = null;

        public Builder setInitialMax(long initialMax) {
            this.initialMax = ValueUtils.valueOf(initialMax, -1L, Long.MAX_VALUE);
            return this;
        }

        public Builder startsFrom(long processed) {
            this.processed = ValueUtils.valueOf(processed, 0L, Long.MAX_VALUE);
            return this;
        }

        public Builder setConsumer(ProgressConsumer consumer) {
            this.consumer = consumer;
            return this;
        }

        public Builder setRenderer(ProgressRenderer renderer) {
            this.renderer = renderer;
            return this;
        }

        public Builder setTextRenderer(String name) {
            return this.setTextRenderer(name, "");
        }

        public Builder setTextRenderer(String name, String unit) {
            return this.setTextRenderer(name, () -> unit);
        }

        public Builder setTextRenderer(String name, IUnit unit) {
            this.renderer = new TextProgressRenderer(name == null ? "" : name, unit == null ? () -> "" : unit);
            return this;
        }

        public Builder setBarRenderer(String name) {
            return this.setBarRenderer(name, "");
        }

        public Builder setBarRenderer(String name, String unit) {
            return this.setBarRenderer(name, () -> unit);
        }

        public Builder setBarRenderer(String name, IUnit unit) {
            this.renderer = new BarProgressRenderer(name == null ? "" : name, unit == null ? () -> "" : unit);
            return this;
        }

        public ProgressBar build() {
            ProgressUpdateAction state = this.consumer == ProgressConsumer.SILENT || this.renderer == ProgressRenderer.SILENT ? new ProgressUpdateAction(new ProgressState(this.processed, this.initialMax), ProgressRenderer.SILENT, ProgressConsumer.SILENT) : new ProgressUpdateAction(new ProgressState(this.processed, this.initialMax), this.renderer == null ? new TextProgressRenderer("Processed", () -> "") : this.renderer, this.consumer == null ? new ConsoleConsumer() : this.consumer);
            return new ProgressBar(state);
        }
    }
}

