/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.progressbar;

import edu.sysu.pmglab.utils.ValueUtils;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

class ProgressState {
    final AtomicLong startStep = new AtomicLong();
    final AtomicLong lastStep = new AtomicLong();
    final AtomicLong currentStep = new AtomicLong();
    final AtomicLong maxStep = new AtomicLong();
    final AtomicLong startTime = new AtomicLong();
    final AtomicReference<Long> lastUpdateTime = new AtomicReference();

    public ProgressState(long processed, long initialMax) {
        processed = ValueUtils.valueOf(processed, 0L, Long.MAX_VALUE);
        initialMax = ValueUtils.valueOf(initialMax, -1L, Long.MAX_VALUE);
        this.maxStep.set(initialMax);
        this.startStep.set(processed);
        this.lastStep.set(processed);
        this.currentStep.set(processed);
        this.startTime.set(System.currentTimeMillis());
        this.lastUpdateTime.set(this.startTime.get());
    }

    void step(long n) {
        if (n < 0L) {
            throw new IllegalStateException("step < 0");
        }
        this.currentStep.addAndGet(n);
        if (this.maxStep.get() != -1L && this.maxStep.get() < this.currentStep.get()) {
            this.maxStep.set(this.currentStep.get());
        }
    }

    void mark() {
        long current = this.getCurrentStep();
        long currentTime = System.currentTimeMillis();
        this.lastStep.set(current);
        this.lastUpdateTime.set(currentTime);
    }

    public long getMaxStep() {
        return this.maxStep.get();
    }

    public long getStarStep() {
        return this.startStep.get();
    }

    public long getCurrentStep() {
        return this.currentStep.get();
    }

    public long getLastStep() {
        return this.lastStep.get();
    }

    public long getStartTime() {
        return this.startTime.get();
    }

    public long getLastUpdateTime() {
        return this.lastUpdateTime.get();
    }
}

