/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.progressbar;

import edu.sysu.pmglab.progressbar.ProgressConsumer;
import edu.sysu.pmglab.progressbar.ProgressRenderer;
import edu.sysu.pmglab.progressbar.ProgressState;
import edu.sysu.pmglab.progressbar.console.ConsoleConsumer;
import java.util.concurrent.atomic.AtomicBoolean;

class ProgressUpdateAction
implements Runnable {
    final ProgressState state;
    final ProgressRenderer renderer;
    final ProgressConsumer consumer;
    final AtomicBoolean alive = new AtomicBoolean(true);
    final AtomicBoolean pause = new AtomicBoolean(false);

    ProgressUpdateAction(ProgressState state, ProgressRenderer renderer, ProgressConsumer consumer) {
        this.state = state;
        this.renderer = renderer;
        this.consumer = consumer == null ? new ConsoleConsumer() : consumer;
        this.refresh();
    }

    void step(long n) {
        if (!this.pause.get() && this.alive.get()) {
            this.state.step(n);
        }
    }

    void pause() {
        if (this.alive.get()) {
            this.pause.set(true);
        }
    }

    void resume() {
        if (this.alive.get() && this.pause.get()) {
            this.pause.set(false);
            this.state.mark();
        }
    }

    void refresh() {
        String rendered = this.renderer.render(this.state);
        this.state.mark();
        this.consumer.clear();
        this.consumer.accept(rendered);
    }

    @Override
    public void run() {
        if (!this.pause.get()) {
            this.refresh();
        }
        if (!this.alive.get()) {
            String renderer = this.renderer.finish(this.state);
            this.state.mark();
            this.consumer.clear();
            this.consumer.accept(renderer);
            this.consumer.close();
        }
    }

    public void stop() {
        this.alive.set(false);
    }

    public long get() {
        return this.state.getCurrentStep();
    }
}

