/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.progressbar;

import edu.sysu.pmglab.progressbar.ProgressConsumer;
import edu.sysu.pmglab.progressbar.ProgressRenderers;
import edu.sysu.pmglab.progressbar.ProgressState;
import edu.sysu.pmglab.progressbar.console.ConsoleConsumer;
import java.util.concurrent.atomic.AtomicBoolean;

class ProgressUpdateActions
implements Runnable {
    final ProgressState[] states;
    final ProgressRenderers renderer;
    final ProgressConsumer consumer;
    final AtomicBoolean alive = new AtomicBoolean(true);
    final AtomicBoolean pause = new AtomicBoolean(false);

    ProgressUpdateActions(ProgressRenderers renderer, ProgressConsumer consumer) {
        this.states = new ProgressState[renderer.numOfRenders()];
        for (int i = 0; i < this.states.length; ++i) {
            this.states[i] = new ProgressState(-1L, -1L);
        }
        this.renderer = renderer;
        this.consumer = consumer == null ? new ConsoleConsumer() : consumer;
        this.refresh();
    }

    void step(long ... ns) {
        if (!this.pause.get() && this.alive.get()) {
            for (int i = 0; i < this.states.length; ++i) {
                this.states[i].step(ns[i]);
            }
        }
    }

    void pause() {
        if (this.alive.get()) {
            this.pause.set(true);
        }
    }

    void resume() {
        if (this.alive.get() && this.pause.get()) {
            this.pause.set(false);
            for (ProgressState state : this.states) {
                state.mark();
            }
        }
    }

    void refresh() {
        String rendered = this.renderer.render(this.states);
        for (ProgressState state : this.states) {
            state.mark();
        }
        this.consumer.clear();
        this.consumer.accept(rendered);
    }

    @Override
    public void run() {
        if (!this.pause.get()) {
            this.refresh();
        }
        if (!this.alive.get()) {
            String renderer = this.renderer.finish(this.states);
            for (ProgressState state : this.states) {
                state.mark();
            }
            this.consumer.clear();
            this.consumer.accept(renderer);
            this.consumer.close();
        }
    }

    public void stop() {
        this.alive.set(false);
    }

    public long[] get() {
        long[] returns = new long[this.states.length];
        for (int i = 0; i < this.states.length; ++i) {
            returns[i] = this.states[i].getCurrentStep();
        }
        return returns;
    }
}

