/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.progressbar;

import edu.sysu.pmglab.container.iterator.LoopIterator;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.progressbar.ProgressRenderer;
import edu.sysu.pmglab.progressbar.ProgressState;
import edu.sysu.pmglab.progressbar.unit.IUnit;
import edu.sysu.pmglab.progressbar.unit.TimeUnit;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Iterator;
import java.util.Locale;

public class TextProgressRenderer
implements ProgressRenderer {
    private static final DecimalFormat rateFormat = new DecimalFormat("#.## %", new DecimalFormatSymbols(Locale.US));
    private static final DecimalFormat valueFormat = new DecimalFormat("###,###.#", new DecimalFormatSymbols(Locale.US));
    private static final DecimalFormat timeFormat = new DecimalFormat("#.##", new DecimalFormatSymbols(Locale.US));
    final String name;
    final IUnit unit;
    final Iterator<String> beginLabels = new LoopIterator<String>(List.wrap(" \\", " |", " /", " |"));
    final StringBuilder builder = new StringBuilder();

    public TextProgressRenderer(String name, IUnit unit) {
        this.name = name == null ? "" : name;
        this.unit = unit == null ? () -> "" : unit;
    }

    @Override
    public String render(ProgressState state) {
        double current = state.getCurrentStep();
        double last = state.getLastStep();
        double currentTime = System.currentTimeMillis();
        double lastTime = state.getLastUpdateTime();
        double max = state.getMaxStep();
        this.builder.setLength(0);
        double timePassed = currentTime - lastTime;
        this.builder.append(this.beginLabels.next());
        this.builder.append(" ");
        if (max == -1.0) {
            this.builder.append(this.name).append(": ").append(this.unit.convert(current, valueFormat)).append("; Speed: ");
            if (timePassed == 0.0) {
                this.builder.append("-");
            } else {
                this.builder.append(this.unit.convert((current - last) / timePassed * 1000.0, valueFormat)).append("/s");
            }
        } else {
            this.builder.append(this.name).append(": ").append(this.unit.convert(current, valueFormat)).append(" / ").append(this.unit.convert(max, valueFormat)).append(" ");
            if (max > 0.0) {
                this.builder.append("(").append(rateFormat.format(current / max)).append("); Speed: ");
            } else {
                this.builder.append("(100%); Speed: ");
            }
            if (timePassed == 0.0) {
                this.builder.append("-");
            } else {
                this.builder.append(this.unit.convert((current - last) / timePassed * 1000.0, valueFormat)).append("/s");
            }
            double remainingTime = (max - current) / (current - last) * timePassed;
            this.builder.append("; Remaining time: ");
            if (Double.isNaN(remainingTime) || Double.isInfinite(remainingTime)) {
                this.builder.append("-");
            } else {
                this.builder.append(TimeUnit.MILLIS.convert(remainingTime, timeFormat));
            }
        }
        return this.builder.toString();
    }

    @Override
    public String finish(ProgressState state) {
        double startTime = state.getStartTime();
        double start = state.getStarStep();
        double current = state.getCurrentStep();
        double last = state.getLastStep();
        double currentTime = System.currentTimeMillis();
        double lastTime = state.getLastUpdateTime();
        double max = state.getMaxStep();
        this.builder.setLength(0);
        double timePassed = currentTime - startTime;
        this.builder.append(" > ");
        if (max == -1.0) {
            this.builder.append(this.name).append(": ").append(this.unit.convert(current, valueFormat));
        } else {
            this.builder.append(this.name).append(": ").append(this.unit.convert(current, valueFormat)).append(" / ").append(this.unit.convert(max, valueFormat)).append(" ");
            if (max > 0.0) {
                this.builder.append("(").append(rateFormat.format(current / max)).append(")");
            } else {
                this.builder.append("(100%)");
            }
        }
        this.builder.append("; Average Speed: ");
        if (timePassed == 0.0) {
            this.builder.append("-");
        } else {
            this.builder.append(this.unit.convert((current - start) / timePassed * 1000.0, valueFormat)).append("/s");
        }
        this.builder.append("; Elapsed time: ").append(TimeUnit.MILLIS.convert(timePassed, timeFormat));
        this.builder.append("\n");
        return this.builder.toString();
    }
}

