/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.progressbar;

import edu.sysu.pmglab.container.iterator.LoopIterator;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.progressbar.ProgressRenderers;
import edu.sysu.pmglab.progressbar.ProgressState;
import edu.sysu.pmglab.progressbar.unit.IUnit;
import edu.sysu.pmglab.progressbar.unit.TimeUnit;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Iterator;
import java.util.Locale;

public class TextProgressRenderers
implements ProgressRenderers {
    private static final DecimalFormat rateFormat = new DecimalFormat("#.## %", new DecimalFormatSymbols(Locale.US));
    private static final DecimalFormat valueFormat = new DecimalFormat("###,###.#", new DecimalFormatSymbols(Locale.US));
    private static final DecimalFormat timeFormat = new DecimalFormat("#.##", new DecimalFormatSymbols(Locale.US));
    final List<String> names = new List();
    final List<IUnit> units = new List();
    final List<Boolean> speeds = new List();
    final Iterator<String> beginLabels = new LoopIterator<String>(List.wrap(" \\", " |", " /", " |"));
    final StringBuilder builder = new StringBuilder();

    public TextProgressRenderers add(String name) {
        return this.add(name, "");
    }

    public TextProgressRenderers add(String name, String unit) {
        return this.add(name, unit == null ? () -> "" : () -> unit, true);
    }

    public TextProgressRenderers add(String name, String unit, boolean displaySpeed) {
        if (name == null) {
            this.names.add("");
        } else {
            this.names.add(name);
        }
        if (unit == null) {
            this.units.add(() -> "");
        } else {
            this.units.add(() -> unit);
        }
        this.speeds.add(displaySpeed);
        return this;
    }

    public TextProgressRenderers add(String name, IUnit unit, boolean displaySpeed) {
        if (name == null) {
            this.names.add("");
        } else {
            this.names.add(name);
        }
        if (unit == null) {
            this.units.add(() -> "");
        } else {
            this.units.add(unit);
        }
        this.speeds.add(displaySpeed);
        return this;
    }

    @Override
    public String render(ProgressState[] states) {
        this.builder.setLength(0);
        this.builder.append(this.beginLabels.next());
        this.builder.append(" ");
        for (int i = 0; i < this.names.size(); ++i) {
            if (i != 0) {
                this.builder.append(" | ");
            }
            ProgressState state = states[i];
            double current = state.getCurrentStep();
            double last = state.getLastStep();
            double currentTime = System.currentTimeMillis();
            double lastTime = state.getLastUpdateTime();
            double max = state.getMaxStep();
            double timePassed = currentTime - lastTime;
            if (max == -1.0) {
                this.builder.append(this.names.get(i)).append(": ").append(this.units.get(i).convert(current, valueFormat));
            } else {
                this.builder.append(this.names.get(i)).append(": ").append(this.units.get(i).convert(current, valueFormat)).append(" / ").append(this.units.get(i).convert(max, valueFormat)).append(" ");
                if (max > 0.0) {
                    this.builder.append("(").append(rateFormat.format(current / max)).append(")");
                } else {
                    this.builder.append("(100%)");
                }
            }
            if (!this.speeds.get(i).booleanValue()) continue;
            this.builder.append("; Speed: ");
            if (timePassed == 0.0) {
                this.builder.append("-");
                continue;
            }
            this.builder.append(this.units.get(i).convert((current - last) / timePassed * 1000.0, valueFormat)).append("/s");
        }
        return this.builder.toString();
    }

    @Override
    public String finish(ProgressState[] states) {
        this.builder.setLength(0);
        this.builder.append(" >");
        double maxTime = 0.0;
        for (int i = 0; i < this.names.size(); ++i) {
            if (i != 0) {
                this.builder.append(" | ");
            } else {
                this.builder.append(" ");
            }
            ProgressState state = states[i];
            double startTime = state.getStartTime();
            double start = state.getStarStep();
            double current = state.getCurrentStep();
            double last = state.getLastStep();
            double currentTime = System.currentTimeMillis();
            double lastTime = state.getLastUpdateTime();
            double max = state.getMaxStep();
            double timePassed = currentTime - startTime;
            if (timePassed > maxTime) {
                maxTime = timePassed;
            }
            if (max == -1.0) {
                this.builder.append(this.names.get(i)).append(": ").append(this.units.get(i).convert(current, valueFormat));
            } else {
                this.builder.append(this.names.get(i)).append(": ").append(this.units.get(i).convert(current, valueFormat)).append(" / ").append(this.units.get(i).convert(max, valueFormat)).append(" ");
                if (max > 0.0) {
                    this.builder.append("(").append(rateFormat.format(current / max)).append(")");
                } else {
                    this.builder.append("(100%)");
                }
            }
            this.builder.append("; Average Speed: ");
            if (timePassed == 0.0) {
                this.builder.append("-");
                continue;
            }
            this.builder.append(this.units.get(i).convert((current - start) / timePassed * 1000.0, valueFormat)).append("/s");
        }
        if (this.names.size() == 0) {
            this.builder.append(" Elapsed time: ").append(TimeUnit.MILLIS.convert(maxTime, timeFormat));
        } else {
            this.builder.append(" | Elapsed time: ").append(TimeUnit.MILLIS.convert(maxTime, timeFormat));
        }
        this.builder.append("\n");
        return this.builder.toString();
    }

    @Override
    public int numOfRenders() {
        return this.names.size();
    }
}

