/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.progressbar.console;

import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.progressbar.ProgressConsumer;
import edu.sysu.pmglab.progressbar.console.ConsoleTextColor;
import java.io.PrintStream;

public class ConsoleConsumer
implements ProgressConsumer {
    private static final PrintStream out = System.out;
    final ByteStream clearUp = new ByteStream();
    final ConsoleTextColor color;

    public ConsoleConsumer() {
        this(null);
    }

    public ConsoleConsumer(ConsoleTextColor color) {
        this.clearUp.write(13);
        for (int i = 0; i < 80; ++i) {
            this.clearUp.write(32);
        }
        this.color = color == null ? ConsoleTextColor.YELLOW : color;
    }

    @Override
    public synchronized void accept(String str) {
        out.write(13);
        out.print(this.color.getCode());
        out.print(str);
        int offset = str.length() - this.clearUp.length();
        if (offset > -5) {
            for (int i = 0; i < offset + 15; ++i) {
                this.clearUp.write(32);
            }
        }
        out.print("\u001b[0m");
    }

    @Override
    public synchronized void clear() {
        out.write(this.clearUp.bytes(), 0, this.clearUp.length());
    }

    @Override
    public synchronized void close() {
        out.flush();
    }
}

