/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.pyserve;

import edu.sysu.pmglab.container.array.EmptyArray;
import edu.sysu.pmglab.container.entry.TEntry;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.pyserve.InstanceInterpreter;
import gnu.trove.set.hash.THashSet;
import java.io.Closeable;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import jep.JepException;

public class GlobalPythonInterpreter
implements AutoCloseable,
Closeable {
    private static final AtomicLong counter = new AtomicLong();
    private static final Set<GlobalPythonInterpreter> instances = new THashSet<GlobalPythonInterpreter>();
    private static final AtomicReference<InstanceInterpreter> interpreter = new AtomicReference();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GlobalPythonInterpreter() {
        Class<GlobalPythonInterpreter> clazz = GlobalPythonInterpreter.class;
        synchronized (GlobalPythonInterpreter.class) {
            instances.add(this);
            if (interpreter.get() == null) {
                interpreter.set(new InstanceInterpreter());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static long next() {
        return counter.getAndAdd(1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exec(String script) {
        if (script == null || script.length() == 0) {
            return;
        }
        FutureTask<Void> task = new FutureTask<Void>(() -> {
            InstanceInterpreter.interpreter.exec(script);
            return null;
        });
        Class<GlobalPythonInterpreter> clazz = GlobalPythonInterpreter.class;
        synchronized (GlobalPythonInterpreter.class) {
            if (!instances.contains(this)) {
                throw new JepException("Jep reference instance has been closed.");
            }
            try {
                interpreter.get().submit(task);
                task.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new JepException(e);
            }
            return;
        }
    }

    public <T> T execAndGet(String script, String variable, Class<T> ndArrayClass) {
        FutureTask<Object> task = new FutureTask<Object>(() -> {
            if (script != null && script.length() > 0) {
                InstanceInterpreter.interpreter.exec(script);
            }
            return InstanceInterpreter.interpreter.getValue(variable, ndArrayClass);
        });
        Class<GlobalPythonInterpreter> clazz = GlobalPythonInterpreter.class;
        synchronized (GlobalPythonInterpreter.class) {
            if (!instances.contains(this)) {
                throw new JepException("Jep reference instance has been closed.");
            }
            try {
                interpreter.get().submit(task);
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return (T)task.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new JepException(e);
            }
        }
    }

    public Object[] execAndGets(String script, List<TEntry<String, Class<?>>> values2) {
        FutureTask<Object[]> task = new FutureTask<Object[]>(() -> {
            Object[] returns;
            if (script != null && script.length() > 0) {
                InstanceInterpreter.interpreter.exec(script);
            }
            Object[] objectArray = returns = values2 == null || values2.size() == 0 ? EmptyArray.OBJECT : new Object[values2.size()];
            if (values2 != null && returns.length > 0) {
                int index = 0;
                for (TEntry value : values2) {
                    returns[index++] = InstanceInterpreter.interpreter.getValue((String)value.getKey(), (Class)value.getValue());
                }
            }
            return returns;
        });
        Class<GlobalPythonInterpreter> clazz = GlobalPythonInterpreter.class;
        synchronized (GlobalPythonInterpreter.class) {
            if (!instances.contains(this)) {
                throw new JepException("Jep reference instance has been closed.");
            }
            try {
                interpreter.get().submit(task);
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return task.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new JepException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eval(String script) {
        if (script == null || script.length() == 0) {
            return;
        }
        FutureTask<Boolean> task = new FutureTask<Boolean>(() -> InstanceInterpreter.interpreter.eval(script));
        Class<GlobalPythonInterpreter> clazz = GlobalPythonInterpreter.class;
        synchronized (GlobalPythonInterpreter.class) {
            if (!instances.contains(this)) {
                throw new JepException("Jep reference instance has been closed.");
            }
            try {
                interpreter.get().submit(task);
                task.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new JepException(e);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(String variable, Object value) {
        FutureTask<Boolean> task = new FutureTask<Boolean>(() -> {
            InstanceInterpreter.interpreter.set(variable, value);
            return null;
        });
        Class<GlobalPythonInterpreter> clazz = GlobalPythonInterpreter.class;
        synchronized (GlobalPythonInterpreter.class) {
            if (!instances.contains(this)) {
                throw new JepException("Jep reference instance has been closed.");
            }
            try {
                interpreter.get().submit(task);
                task.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new JepException(e);
            }
            return;
        }
    }

    public <T> T getValue(String variable, Class<T> ndArrayClass) {
        FutureTask<Object> task = new FutureTask<Object>(() -> InstanceInterpreter.interpreter.getValue(variable, ndArrayClass));
        Class<GlobalPythonInterpreter> clazz = GlobalPythonInterpreter.class;
        synchronized (GlobalPythonInterpreter.class) {
            if (!instances.contains(this)) {
                throw new JepException("Jep reference instance has been closed.");
            }
            try {
                interpreter.get().submit(task);
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return (T)task.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new JepException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Class<GlobalPythonInterpreter> clazz = GlobalPythonInterpreter.class;
        synchronized (GlobalPythonInterpreter.class) {
            if (instances.contains(this)) {
                instances.remove(this);
                if (instances.size() == 0) {
                    try {
                        interpreter.get().close();
                        interpreter.set(null);
                    }
                    catch (InterruptedException | ExecutionException e) {
                        Thread.currentThread().interrupt();
                        throw new JepException(e);
                    }
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

