/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.pyserve;

import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.pyserve.PyResult;
import edu.sysu.pmglab.pyserve.PyServeException;
import edu.sysu.pmglab.utils.Assert;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;

public class PyConnection
implements AutoCloseable,
Closeable {
    private static final int MAX_SCRIPT_SIZE = 0x800000;
    private static final String LINE_BREAK = "\r\n";
    private static final String MARK_BEGIN = "#!{";
    private static final String MARK_END = "#!}";
    private static final String MARK_EXIT = "#!exit";
    private final Socket socket;
    private final BufferedWriter writer;
    private final BufferedReader reader;
    private boolean isClosed;

    public PyConnection(int port) throws PyServeException {
        this("0.0.0.0", port);
    }

    public PyConnection(String host, int port) throws PyServeException {
        try {
            this.socket = new Socket(host, port);
            this.writer = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream()));
            this.reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
        }
        catch (Exception e) {
            throw new PyServeException(e);
        }
        this.isClosed = false;
    }

    private PyResult executeScript(String script) throws PyServeException {
        if (this.isClosed) {
            return new PyResult(null, false);
        }
        StringBuilder request = new StringBuilder();
        request.append(MARK_BEGIN).append(LINE_BREAK).append(script).append(LINE_BREAK).append(MARK_END).append(LINE_BREAK);
        try {
            byte[] returns;
            this.writer.write(request.toString());
            this.writer.flush();
            while (!MARK_BEGIN.equals(this.reader.readLine())) {
            }
            int value = this.reader.read();
            int length = new Bytes(new byte[]{(byte)this.reader.read(), (byte)this.reader.read(), (byte)this.reader.read(), (byte)this.reader.read()}).decodeInt() - 1;
            if (length == -1) {
                returns = null;
            } else {
                returns = new byte[length];
                for (int i = 0; i < length; ++i) {
                    returns[i] = (byte)this.reader.read();
                }
            }
            Assert.that(this.reader.readLine().equals(MARK_END));
            if (value == 1) {
                return new PyResult(returns == null ? null : new Bytes(returns), true);
            }
            throw new PyServeException(returns == null ? "" : new String(returns));
        }
        catch (Error | Exception e) {
            throw new PyServeException(e);
        }
    }

    @Override
    public void close() throws IOException {
        this.isClosed = true;
        try {
            this.writer.write("#!exit\r\n");
            this.writer.flush();
            this.writer.close();
            this.reader.close();
        }
        catch (Exception exception) {
        }
        finally {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {}
        }
    }

    public PyResult exec(String script) throws PyServeException {
        if (script.length() > 0x800000) {
            throw new PyServeException("Exceeds the max script size limit (8M)");
        }
        return this.executeScript(script);
    }

    public PyResult exec(File scriptFile) throws PyServeException {
        try {
            return this.exec(new FileInputStream(scriptFile));
        }
        catch (FileNotFoundException e) {
            throw new PyServeException(e);
        }
    }

    public PyResult exec(InputStream scriptStream) throws PyServeException {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            OutputStreamWriter osw = new OutputStreamWriter(bos);
            InputStreamReader input = new InputStreamReader(scriptStream);
            char[] buffer = new char[8192];
            long count = 0L;
            int n = 0;
            while (-1 != (n = input.read(buffer))) {
                osw.write(buffer, 0, n);
                count += (long)n;
            }
            if (count > 0x800000L) {
                throw new PyServeException("Exceed the max script size limit (8M)");
            }
            osw.flush();
            return this.exec(bos.toString());
        }
        catch (Error | Exception e) {
            throw new PyServeException(e);
        }
    }

    public Bytes getValue(String key) throws PyServeException {
        return this.exec("_result_ = " + key).getResult();
    }
}

