/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.runtimecompiler;

import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.ccf.record.BoxRecord;
import edu.sysu.pmglab.ccf.record.IRecord;
import edu.sysu.pmglab.commandParser.annotation.option.CustomOption;
import edu.sysu.pmglab.commandParser.annotation.usage.OptionUsage;
import edu.sysu.pmglab.commandParser.converter.IConverter;
import edu.sysu.pmglab.commandParser.exception.ParameterException;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.genome.coordinate.Chromosome;
import edu.sysu.pmglab.gtb.genome.genotype.Genotype;
import edu.sysu.pmglab.gtb.genome.genotype.IGenotypes;
import edu.sysu.pmglab.io.file.LiveFile;
import edu.sysu.pmglab.io.text.TextRecord;
import edu.sysu.pmglab.runtimecompiler.JavaStringCompiler;
import edu.sysu.pmglab.utils.Assert;
import gnu.trove.procedure.TObjectObjectProcedure;
import gnu.trove.procedure.TObjectProcedure;
import java.io.File;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;

public enum JavaCompiler {
    INSTANCE;

    private static final String packagePath;
    @CustomOption(names={"--jc-import"}, arity={-1}, converter=ImportPackageConverter.class, repeated=true, bind=false)
    @OptionUsage(description={"Import packages for the dynamic JavaCompiler."}, format="--jc-import <class> <class> ...", group="Runtime Support Options")
    private static final List<Class<?>> imports;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void importClass(Class<?> ... tClasses) {
        JavaCompiler javaCompiler = INSTANCE;
        synchronized (javaCompiler) {
            for (Class<?> tClass : tClasses) {
                if (tClass.isArray()) {
                    JavaCompiler.importClass(tClass.getComponentType());
                    continue;
                }
                imports.add(tClass);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void importClass(String ... tClasses) throws ClassNotFoundException {
        JavaCompiler javaCompiler = INSTANCE;
        synchronized (javaCompiler) {
            for (String tClass : tClasses) {
                JavaCompiler.importClass(Class.forName(tClass));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearImports() {
        JavaCompiler javaCompiler = INSTANCE;
        synchronized (javaCompiler) {
            imports.clear();
        }
    }

    public static List<Class<?>> getImports() {
        return imports.asUnmodifiable();
    }

    private static String generateImportInfo() {
        StringBuilder builder = new StringBuilder();
        for (Class<?> tClass : imports) {
            builder.append("import " + tClass.getName() + ";");
            builder.append("\n");
        }
        return builder.toString();
    }

    public static Runnable exec(String script) {
        String className = "JavaCompilerCache_" + INSTANCE.hashCode();
        String javaSource = "package " + packagePath + ";\n\nimport java.lang.Runnable;\n" + JavaCompiler.generateImportInfo() + "\npublic class " + className + " implements Runnable {\n    @Override\n    public void run() {\n        " + script + ";\n    }\n}\n";
        try {
            Map<String, byte[]> encoded = JavaStringCompiler.compile(className + ".java", javaSource);
            Class<?> clazz = JavaStringCompiler.loadClass(packagePath + "." + className, encoded);
            return (Runnable)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Error | Exception e) {
            throw new RuntimeException("An exception occurred while compiling the following Java source code:\n>>>>>>>>>>>>>>>>>>>>>>>>> BEGIN >>>>>>>>>>>>>>>>>>>>>>>>>\n" + javaSource + "\n<<<<<<<<<<<<<<<<<<<<<<<<< END <<<<<<<<<<<<<<<<<<<<<<<<<");
        }
    }

    public static <T> Consumer<T> exec(String script, Param input) {
        String className = "JavaCompilerCache_" + INSTANCE.hashCode();
        String javaSource = "package " + packagePath + ";\n\nimport java.util.function.Consumer;\n" + JavaCompiler.generateImportInfo() + "\npublic class " + className + " implements Consumer<" + input.tClass + "> {\n    @Override\n    public void accept(" + input.tClass + " " + input.key + ") {\n        " + script + ";\n    }\n}\n";
        try {
            Map<String, byte[]> encoded = JavaStringCompiler.compile(className + ".java", javaSource);
            Class<?> clazz = JavaStringCompiler.loadClass(packagePath + "." + className, encoded);
            return (Consumer)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Error | Exception e) {
            throw new RuntimeException("An exception occurred while compiling the following Java source code:\n>>>>>>>>>>>>>>>>>>>>>>>>> BEGIN >>>>>>>>>>>>>>>>>>>>>>>>>\n" + javaSource + "\n<<<<<<<<<<<<<<<<<<<<<<<<< END <<<<<<<<<<<<<<<<<<<<<<<<<");
        }
    }

    public static <I1, I2> BiConsumer<I1, I2> exec(String script, Param input1, Param input2) {
        String className = "JavaCompilerCache_" + INSTANCE.hashCode();
        String javaSource = "package " + packagePath + ";\n\nimport java.util.function.BiConsumer;\n" + JavaCompiler.generateImportInfo() + "\npublic class " + className + " implements BiConsumer<" + input1.tClass + ", " + input2.tClass + "> {\n    @Override\n    public void accept(" + input1.tClass + " " + input1.key + ", " + input2.tClass + " " + input2.key + ") {\n        " + script + ";\n    }\n}\n";
        try {
            Map<String, byte[]> encoded = JavaStringCompiler.compile(className + ".java", javaSource);
            Class<?> clazz = JavaStringCompiler.loadClass(packagePath + "." + className, encoded);
            return (BiConsumer)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Error | Exception e) {
            throw new RuntimeException("An exception occurred while compiling the following Java source code:\n>>>>>>>>>>>>>>>>>>>>>>>>> BEGIN >>>>>>>>>>>>>>>>>>>>>>>>>\n" + javaSource + "\n<<<<<<<<<<<<<<<<<<<<<<<<< END <<<<<<<<<<<<<<<<<<<<<<<<<");
        }
    }

    public static <I1, I2, O> BiFunction<I1, I2, O> eval(String script, Param input1, Param input2, Class<O> outputParamType) {
        return JavaCompiler.eval(script, input1, input2, Param.of(null, outputParamType));
    }

    public static <I, O> Function<I, O> eval(String script, Param inputParam, Class<O> outputParamType) {
        return JavaCompiler.eval(script, inputParam, Param.of(null, outputParamType));
    }

    public static <I, O> Function<I, O> eval(String script, Param inputParam, Param outputParam) {
        Assert.that(inputParam.key != null);
        String className = "JavaCompilerCache_" + INSTANCE.hashCode();
        String javaSource = "package " + packagePath + ";\n\nimport java.util.function.Function;\n" + JavaCompiler.generateImportInfo() + "\npublic class " + className + " implements Function<" + inputParam.tClass + ", " + outputParam.tClass + "> {\n    @Override\n    public " + outputParam.tClass + " apply(" + inputParam.tClass + " " + inputParam.key + ") {\n";
        javaSource = outputParam.equals(inputParam) ? javaSource + "        " + script + ";\n        return " + outputParam.key + ";\n    }\n}\n" : (outputParam.key == null ? javaSource + "        return " + script + ";\n    }\n}\n" : javaSource + "        " + outputParam.tClass + " " + outputParam.key + ";\n        " + script + ";\n        return " + outputParam.key + ";\n    }\n}\n");
        try {
            Map<String, byte[]> encoded = JavaStringCompiler.compile(className + ".java", javaSource);
            Class<?> clazz = JavaStringCompiler.loadClass(packagePath + "." + className, encoded);
            return (Function)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Error | Exception e) {
            throw new RuntimeException("An exception occurred while compiling the following Java source code:\n>>>>>>>>>>>>>>>>>>>>>>>>> BEGIN >>>>>>>>>>>>>>>>>>>>>>>>>\n" + javaSource + "\n<<<<<<<<<<<<<<<<<<<<<<<<< END <<<<<<<<<<<<<<<<<<<<<<<<<");
        }
    }

    public static <I1, I2, O> BiFunction<I1, I2, O> eval(String script, Param input1, Param input2, Param outputParam) {
        Assert.that(input1.key != null);
        String className = "JavaCompilerCache_" + INSTANCE.hashCode();
        String javaSource = "package " + packagePath + ";\n\nimport java.util.function.BiFunction;\n" + JavaCompiler.generateImportInfo() + "\npublic class " + className + " implements BiFunction<" + input1.tClass + ", " + input2.tClass + ", " + outputParam.tClass + "> {\n    @Override\n    public " + outputParam.tClass + " apply(" + input1.tClass + " " + input1.key + ", " + input2.tClass + " " + input2.key + ") {\n";
        javaSource = outputParam.equals(input1) ? javaSource + "        " + script + ";\n        return " + outputParam.key + ";\n    }\n}\n" : (outputParam.key == null ? javaSource + "        return " + script + ";\n    }\n}\n" : javaSource + "        " + outputParam.tClass + " " + outputParam.key + ";\n        " + script + ";\n        return " + outputParam.key + ";\n    }\n}\n");
        try {
            Map<String, byte[]> encoded = JavaStringCompiler.compile(className + ".java", javaSource);
            Class<?> clazz = JavaStringCompiler.loadClass(packagePath + "." + className, encoded);
            return (BiFunction)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Error | Exception e) {
            throw new RuntimeException("An exception occurred while compiling the following Java source code:\n>>>>>>>>>>>>>>>>>>>>>>>>> BEGIN >>>>>>>>>>>>>>>>>>>>>>>>>\n" + javaSource + "\n<<<<<<<<<<<<<<<<<<<<<<<<< END <<<<<<<<<<<<<<<<<<<<<<<<<");
        }
    }

    public static <I> TObjectProcedure<I> procedure(String script, Param inputParam) {
        Assert.that(inputParam.key != null);
        String className = "JavaCompilerCache_" + INSTANCE.hashCode();
        String javaSource = "package " + packagePath + ";\n\nimport gnu.trove.procedure.TObjectProcedure;\n" + JavaCompiler.generateImportInfo() + "\npublic class " + className + " implements TObjectProcedure<" + inputParam.tClass + "> {\n    @Override\n    public boolean execute(" + inputParam.tClass + " " + inputParam.key + ") {\n        return " + script + ";\n    }\n}\n";
        try {
            Map<String, byte[]> encoded = JavaStringCompiler.compile(className + ".java", javaSource);
            Class<?> clazz = JavaStringCompiler.loadClass(packagePath + "." + className, encoded);
            return (TObjectProcedure)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Error | Exception e) {
            throw new RuntimeException("An exception occurred while compiling the following Java source code:\n>>>>>>>>>>>>>>>>>>>>>>>>> BEGIN >>>>>>>>>>>>>>>>>>>>>>>>>\n" + javaSource + "\n<<<<<<<<<<<<<<<<<<<<<<<<< END <<<<<<<<<<<<<<<<<<<<<<<<<");
        }
    }

    public static <I1, I2> TObjectObjectProcedure<I1, I2> procedure(String script, Param input1, Param input2) {
        Assert.that(input1.key != null);
        String className = "JavaCompilerCache_" + INSTANCE.hashCode();
        String javaSource = "package " + packagePath + ";\n\nimport gnu.trove.procedure.TObjectObjectProcedure;\n" + JavaCompiler.generateImportInfo() + "\npublic class " + className + " implements TObjectObjectProcedure<" + input1.tClass + ", " + input2.tClass + "> {\n    @Override\n    public boolean execute(" + input1.tClass + " " + input1.key + ", " + input2.tClass + " " + input2.key + ") {\n        return " + script + ";\n    }\n}\n";
        try {
            Map<String, byte[]> encoded = JavaStringCompiler.compile(className + ".java", javaSource);
            Class<?> clazz = JavaStringCompiler.loadClass(packagePath + "." + className, encoded);
            return (TObjectObjectProcedure)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Error | Exception e) {
            throw new RuntimeException("An exception occurred while compiling the following Java source code:\n>>>>>>>>>>>>>>>>>>>>>>>>> BEGIN >>>>>>>>>>>>>>>>>>>>>>>>>\n" + javaSource + "\n<<<<<<<<<<<<<<<<<<<<<<<<< END <<<<<<<<<<<<<<<<<<<<<<<<<");
        }
    }

    static {
        packagePath = JavaCompiler.class.getPackage().getName();
        imports = new List();
        imports.add(IRecord.class);
        imports.add(BoxRecord.class);
        imports.add(Variant.class);
        imports.add(Genotype.class);
        imports.add(List.class);
        imports.add(IGenotypes.class);
        imports.add(TextRecord.class);
        imports.add(Chromosome.class);
        imports.add(Bytes.class);
        imports.add(Byte.class);
        imports.add(Integer.class);
        imports.add(Long.class);
        imports.add(Float.class);
        imports.add(Double.class);
        imports.add(File.class);
        imports.add(LiveFile.class);
    }

    public static class Param {
        final String key;
        final String tClass;

        public Param(String key, String tClass) {
            Assert.that(tClass != null);
            this.key = key;
            this.tClass = tClass;
        }

        public static Param of(Class<?> tClass) {
            return new Param(null, tClass.getTypeName());
        }

        public static Param of(Class<?> tClass, String genericsType) {
            return Param.of(null, tClass, genericsType);
        }

        public static Param of(String key, Class<?> tClass) {
            return new Param(key, tClass.getTypeName());
        }

        public static Param of(String key, Class<?> tClass, String genericsType) {
            if (genericsType == null || genericsType.length() == 0) {
                return new Param(key, tClass.getTypeName());
            }
            if (!genericsType.startsWith("<") && !genericsType.endsWith(">")) {
                return new Param(key, tClass.getTypeName() + "<" + genericsType + ">");
            }
            return new Param(key, tClass.getTypeName() + genericsType);
        }

        public int hashCode() {
            return Objects.hash(this.key);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Param param = (Param)o;
            return Objects.equals(this.key, param.key);
        }
    }

    private static enum ImportPackageConverter implements IConverter<Void>
    {
        INSTANCE;


        @Override
        public Void convert(String name, String ... values2) {
            try {
                JavaCompiler.importClass(values2);
            }
            catch (ClassNotFoundException e) {
                throw new ParameterException(e);
            }
            return null;
        }
    }
}

