/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.runtimecompiler;

import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.runtimecompiler.MemoryClassLoader;
import edu.sysu.pmglab.runtimecompiler.MemoryJavaFileManager;
import java.io.IOException;
import java.util.Map;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;

enum JavaStringCompiler {
    INSTANCE;

    private final JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
    private final StandardJavaFileManager stdManager = this.compiler.getStandardFileManager(null, null, null);

    public static Map<String, byte[]> compile(String fileName, String source2) {
        try (MemoryJavaFileManager manager = new MemoryJavaFileManager(JavaStringCompiler.INSTANCE.stdManager);){
            JavaFileObject javaFileObject = manager.makeStringSource(fileName, source2);
            JavaCompiler.CompilationTask task = JavaStringCompiler.INSTANCE.compiler.getTask(null, manager, null, null, null, List.singleton(javaFileObject));
            Boolean result = task.call();
            if (result == null || !result.booleanValue()) {
                throw new RuntimeException("Compilation failed");
            }
            Map<String, byte[]> map = manager.getClassBytes();
            return map;
        }
    }

    public static Class<?> loadClass(String classPath, Map<String, byte[]> classBytes) throws ClassNotFoundException, IOException {
        try (MemoryClassLoader classLoader = new MemoryClassLoader(classBytes);){
            Class<?> clazz = classLoader.loadClass(classPath);
            return clazz;
        }
    }
}

