/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.simulation;

import cern.colt.list.DoubleArrayList;
import cern.jet.stat.Descriptive;
import edu.sysu.pmglab.container.list.DoubleList;
import edu.sysu.pmglab.kgga.command.setting.TimingGeneModelSetting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class GeneExpressionLiabilitySimulator {
    private double C_COMMON = 20.0;
    private double D_COMMON = 20.0;
    private double A_COMMON = 1.0;
    private double EQTL_SCALE = 0.1;
    private double H_E_SQ_COMMON = 0.1;
    private double H_G_SQ_LIABILITY = 0.3;
    private double W_T_LIABILITY = 1.0;
    private final Random random;

    public GeneExpressionLiabilitySimulator(double eQTL_Scale_VAR, double h_E_SQ_COMMON, double h_G_SQ_LIABILITY, double w_T_LIABILITY, Random random) {
        this.EQTL_SCALE = eQTL_Scale_VAR;
        this.H_E_SQ_COMMON = h_E_SQ_COMMON;
        this.H_G_SQ_LIABILITY = h_G_SQ_LIABILITY;
        this.W_T_LIABILITY = w_T_LIABILITY;
        this.random = random;
    }

    public void setTimingGeneModel(TimingGeneModelSetting timingGeneModel) {
        this.A_COMMON = timingGeneModel.getScaleWidth();
        this.C_COMMON = timingGeneModel.getPeakTime();
        this.D_COMMON = timingGeneModel.getAmplitude();
    }

    private double calculateMeanExpressionProfile(double age) {
        if (this.D_COMMON == 0.0) {
            return this.A_COMMON;
        }
        return this.A_COMMON * Math.exp(-Math.pow(age - this.C_COMMON, 2.0) / this.D_COMMON);
    }

    private double calculatePopulationVariance(double[] data) {
        if (data == null || data.length < 2) {
            return 0.0;
        }
        double sum = 0.0;
        double sumSq = 0.0;
        int count = 0;
        for (double val : data) {
            if (Double.isNaN(val) || Double.isInfinite(val)) continue;
            sum += val;
            sumSq += val * val;
            ++count;
        }
        if (count < 2) {
            return 0.0;
        }
        double mean = sum / (double)count;
        double meanSq = sumSq / (double)count;
        return meanSq - mean * mean;
    }

    private double calculatePopulationVariance(float[] data) {
        if (data == null || data.length == 0) {
            return 0.0;
        }
        int n = data.length;
        double sum = 0.0;
        float[] fArray = data;
        int n2 = fArray.length;
        for (int i = 0; i < n2; ++i) {
            double val = fArray[i];
            sum += val;
        }
        double mean = sum / (double)n;
        double sumSqDiff = 0.0;
        float[] fArray2 = data;
        int n3 = fArray2.length;
        for (int i = 0; i < n3; ++i) {
            double val = fArray2[i];
            sumSqDiff += Math.pow(val - mean, 2.0);
        }
        return sumSqDiff / (double)n;
    }

    public float[][] simuGeneExpression(List<byte[][]> genotypeCodes, double age) {
        if (genotypeCodes == null || genotypeCodes.isEmpty()) {
            return new float[0][0];
        }
        int numGenes = genotypeCodes.size();
        int numIndividuals = 0;
        for (byte[][] geneGenoArray : genotypeCodes) {
            if (geneGenoArray == null || geneGenoArray.length <= 0 || geneGenoArray[0] == null || geneGenoArray[0].length <= 0) continue;
            numIndividuals = geneGenoArray[0].length;
            break;
        }
        float[][] geneExpressionValues = new float[numGenes][numIndividuals];
        double fx = this.calculateMeanExpressionProfile(age);
        int numEqtls = 0;
        for (int t = 0; t < numGenes; ++t) {
            byte[][] geneGenoData = genotypeCodes.get(t);
            numEqtls = geneGenoData.length;
            if (numIndividuals <= 0 || numEqtls <= 0 || geneGenoData[0] == null || geneGenoData[0].length != numIndividuals) {
                // empty if block
            }
            double[] r_ti_effects = new double[numEqtls];
            for (int i = 0; i < numEqtls; ++i) {
                r_ti_effects[i] = this.EQTL_SCALE;
            }
            double[] currentGeneIndividualGeneticValues = new double[numIndividuals];
            for (int indiv = 0; indiv < numIndividuals; ++indiv) {
                double sumGeneticEffect = 0.0;
                for (int i = 0; i < numEqtls; ++i) {
                    byte genotype;
                    if (geneGenoData[i] == null || geneGenoData[i].length <= indiv || (genotype = geneGenoData[i][indiv]) < 0) continue;
                    sumGeneticEffect += (double)genotype * fx * r_ti_effects[i];
                }
                geneExpressionValues[t][indiv] = (float)sumGeneticEffect;
                currentGeneIndividualGeneticValues[indiv] = sumGeneticEffect;
            }
            double varGeneticComponent_t = this.calculatePopulationVariance(currentGeneIndividualGeneticValues);
            double sigma_1t_sq = varGeneticComponent_t / this.H_E_SQ_COMMON - varGeneticComponent_t;
            if (sigma_1t_sq <= 0.0) {
                System.err.println("The variance of random noise for gene expression is less than 0");
                System.exit(1);
            }
            sigma_1t_sq = Math.sqrt(sigma_1t_sq);
            for (int indiv = 0; indiv < numIndividuals; ++indiv) {
                double epsilon_1tx = this.random.nextGaussian() * sigma_1t_sq;
                geneExpressionValues[t][indiv] = geneExpressionValues[t][indiv] + (float)epsilon_1tx;
            }
        }
        return geneExpressionValues;
    }

    public float[][] simuGeneExpression0(List<byte[][]> genotypeCodes, int startIndex, int endIndex, double age) {
        if (genotypeCodes == null || genotypeCodes.isEmpty()) {
            return new float[0][0];
        }
        int numGenes = genotypeCodes.size();
        int totalIndividuals = genotypeCodes.get(0)[0].length;
        int effectiveIndividuals = endIndex - startIndex;
        float[][] geneExpressionValues = new float[numGenes][effectiveIndividuals];
        double fx = this.calculateMeanExpressionProfile(age);
        int numEqtls = 0;
        for (int t = 0; t < numGenes; ++t) {
            byte[][] geneGenoData = genotypeCodes.get(t);
            numEqtls = geneGenoData.length;
            double[] r_ti_effects = new double[numEqtls];
            for (int i = 0; i < numEqtls; ++i) {
                r_ti_effects[i] = this.EQTL_SCALE;
            }
            double[] currentGeneIndividualGeneticValues = new double[totalIndividuals];
            for (int indiv = 0; indiv < totalIndividuals; ++indiv) {
                double sumGeneticEffect = 0.0;
                for (int i = 0; i < numEqtls; ++i) {
                    byte genotype;
                    if (geneGenoData[i] == null || geneGenoData[i].length <= indiv || (genotype = geneGenoData[i][indiv]) < 0) continue;
                    sumGeneticEffect += (double)genotype * fx * r_ti_effects[i];
                }
                if (indiv >= startIndex && indiv < endIndex) {
                    geneExpressionValues[t][indiv - startIndex] = (float)sumGeneticEffect;
                }
                currentGeneIndividualGeneticValues[indiv] = sumGeneticEffect;
            }
            double varGeneticComponent_t = this.calculatePopulationVariance(currentGeneIndividualGeneticValues);
            double sigma_1t_sq = varGeneticComponent_t / this.H_E_SQ_COMMON - varGeneticComponent_t;
            if (sigma_1t_sq <= 0.0) {
                System.err.println("The variance of random noise for gene expression is less than 0");
                System.exit(1);
            }
            sigma_1t_sq = Math.sqrt(sigma_1t_sq);
            for (int indiv = 0; indiv < effectiveIndividuals; ++indiv) {
                double epsilon_1tx = this.random.nextGaussian() * sigma_1t_sq;
                geneExpressionValues[t][indiv] = geneExpressionValues[t][indiv] + (float)epsilon_1tx;
            }
        }
        return geneExpressionValues;
    }

    public float[][] simuGeneExpression(List<byte[][]> genotypeCodes, int startIndex, int endIndex, double age) {
        if (genotypeCodes == null || genotypeCodes.isEmpty()) {
            return new float[0][0];
        }
        if (startIndex < 0 || endIndex <= startIndex) {
            throw new IllegalArgumentException("Invalid start/end indices.");
        }
        int numGenes = genotypeCodes.size();
        int totalIndividuals = genotypeCodes.get(0)[0].length;
        if (totalIndividuals == 0) {
            return new float[numGenes][0];
        }
        endIndex = Math.min(endIndex, totalIndividuals);
        int effectiveIndividuals = endIndex - startIndex;
        float[][] geneExpressionValues = new float[numGenes][effectiveIndividuals];
        double baseEffect = this.calculateMeanExpressionProfile(age) * this.EQTL_SCALE;
        double[] currentGeneIndividualGeneticValues = new double[totalIndividuals];
        for (int geneIndex = 0; geneIndex < numGenes; ++geneIndex) {
            double noiseStdDev;
            byte[][] geneGenoData = genotypeCodes.get(geneIndex);
            if (geneGenoData == null || geneGenoData.length == 0) continue;
            int numEqtls = geneGenoData.length;
            for (int individualIndex = 0; individualIndex < totalIndividuals; ++individualIndex) {
                double sumGeneticEffect = 0.0;
                for (int eqtlIndex = 0; eqtlIndex < numEqtls; ++eqtlIndex) {
                    byte genotype;
                    if (geneGenoData[eqtlIndex] == null || geneGenoData[eqtlIndex].length <= individualIndex || (genotype = geneGenoData[eqtlIndex][individualIndex]) < 0) continue;
                    sumGeneticEffect += (double)genotype * baseEffect;
                }
                currentGeneIndividualGeneticValues[individualIndex] = sumGeneticEffect;
                if (individualIndex < startIndex || individualIndex >= endIndex) continue;
                geneExpressionValues[geneIndex][individualIndex - startIndex] = (float)sumGeneticEffect;
            }
            double varGeneticComponent_t = this.calculatePopulationVariance(currentGeneIndividualGeneticValues);
            if (this.H_E_SQ_COMMON <= 0.0 || this.H_E_SQ_COMMON >= 1.0) {
                throw new IllegalStateException("Heritability (H_E_SQ_COMMON) must be between 0 and 1.");
            }
            double sigma_1t_sq = varGeneticComponent_t / this.H_E_SQ_COMMON - varGeneticComponent_t;
            if (sigma_1t_sq <= 0.0) {
                sigma_1t_sq = 0.0;
            }
            if (!((noiseStdDev = Math.sqrt(sigma_1t_sq)) > 0.0)) continue;
            int i = 0;
            while (i < effectiveIndividuals) {
                double noise = this.random.nextGaussian() * noiseStdDev;
                float[] fArray = geneExpressionValues[geneIndex];
                int n = i++;
                fArray[n] = fArray[n] + (float)noise;
            }
        }
        return geneExpressionValues;
    }

    public float[][] simuGeneExpressionTotal(float[][] geneticExpressionValues, int geneNum, boolean useStandard) {
        if (geneticExpressionValues == null || geneticExpressionValues.length == 0) {
            return new float[0][0];
        }
        int numIndividuals = 0;
        if (geneNum > 0 && geneticExpressionValues[0] != null) {
            numIndividuals = geneticExpressionValues[0].length;
        }
        DoubleArrayList allValues = new DoubleArrayList();
        for (int t = 0; t < geneticExpressionValues.length; ++t) {
            for (int indiv = 0; indiv < numIndividuals; ++indiv) {
                allValues.add(geneticExpressionValues[t][indiv]);
            }
        }
        float[][] totalExpressionValues = new float[geneNum][numIndividuals];
        double mean = Descriptive.mean(allValues);
        double sd = Descriptive.sampleVariance(allValues, mean);
        sd = Math.sqrt(sd);
        if (useStandard) {
            mean = 0.0;
            sd = 1.0;
        }
        for (int t = 0; t < geneNum; ++t) {
            for (int indiv = 0; indiv < numIndividuals; ++indiv) {
                double randNorm = this.random.nextGaussian();
                totalExpressionValues[t][indiv] = (float)(sd * randNorm + mean);
            }
        }
        return totalExpressionValues;
    }

    public float[] simuLiability(List<byte[][]> genotypeCodes) {
        return this.simulateLiabilityOptimized(genotypeCodes, this.C_COMMON);
    }

    public float[] simulateLiabilityOptimized(List<byte[][]> genotypeCodes, double age) {
        if (genotypeCodes == null || genotypeCodes.isEmpty()) {
            return new float[0];
        }
        int numGenes = genotypeCodes.size();
        int numIndividuals = 0;
        for (byte[][] geneGenotype : genotypeCodes) {
            if (geneGenotype == null || geneGenotype.length <= 0 || geneGenotype[0] == null || geneGenotype[0].length <= 0) continue;
            numIndividuals = geneGenotype[0].length;
            break;
        }
        if (numIndividuals == 0) {
            return new float[0];
        }
        if (this.H_G_SQ_LIABILITY == 0.0) {
            float[] liabilities = new float[numIndividuals];
            for (int i = 0; i < numIndividuals; ++i) {
                liabilities[i] = (float)this.random.nextGaussian();
            }
            return liabilities;
        }
        double[] totalGeneticComponent = new double[numIndividuals];
        double[] totalEnvironmentalComponent = new double[numIndividuals];
        double meanExpressionProfile = this.calculateMeanExpressionProfile(age);
        double[] currentGeneGeneticValues = new double[numIndividuals];
        for (int geneIndex = 0; geneIndex < numGenes; ++geneIndex) {
            byte[][] geneGenoData = genotypeCodes.get(geneIndex);
            if (geneGenoData == null || geneGenoData.length == 0) continue;
            int numEqtls = geneGenoData.length;
            double[] eqtlEffectSizes = new double[numEqtls];
            for (int eqtlIndex = 0; eqtlIndex < numEqtls; ++eqtlIndex) {
                double effect = 0.5;
                eqtlEffectSizes[eqtlIndex] = Math.abs(effect * this.EQTL_SCALE);
            }
            Arrays.fill(currentGeneGeneticValues, 0.0);
            for (int individualIndex = 0; individualIndex < numIndividuals; ++individualIndex) {
                double sumGeneticEffect = 0.0;
                for (int eqtlIndex = 0; eqtlIndex < numEqtls; ++eqtlIndex) {
                    byte genotype;
                    if (geneGenoData[eqtlIndex] == null || geneGenoData[eqtlIndex].length <= individualIndex || (genotype = geneGenoData[eqtlIndex][individualIndex]) <= 0) continue;
                    sumGeneticEffect += (double)genotype * meanExpressionProfile * eqtlEffectSizes[eqtlIndex];
                }
                currentGeneGeneticValues[individualIndex] = sumGeneticEffect;
            }
            double varGeneticComponentForGene = this.calculatePopulationVariance(currentGeneGeneticValues);
            if (varGeneticComponentForGene <= 0.0 || this.H_E_SQ_COMMON == 0.0) continue;
            double environmentalVariance = varGeneticComponentForGene / this.H_E_SQ_COMMON - varGeneticComponentForGene;
            if (environmentalVariance <= 0.0) {
                System.err.println("Warning: Variance of random noise for gene expression is non-positive for gene " + geneIndex);
                continue;
            }
            double stdDevEnvironmentalNoise = Math.sqrt(environmentalVariance);
            int individualIndex = 0;
            while (individualIndex < numIndividuals) {
                int n = individualIndex;
                totalGeneticComponent[n] = totalGeneticComponent[n] + currentGeneGeneticValues[individualIndex] * this.W_T_LIABILITY;
                double environmentalNoise = this.random.nextGaussian() * stdDevEnvironmentalNoise;
                int n2 = individualIndex++;
                totalEnvironmentalComponent[n2] = totalEnvironmentalComponent[n2] + environmentalNoise * this.W_T_LIABILITY;
            }
        }
        double varTotalGeneticLiability = this.calculatePopulationVariance(totalGeneticComponent);
        double varTotalEnvironmentalLiability = this.calculatePopulationVariance(totalEnvironmentalComponent);
        double finalNoiseVariance = 0.0;
        if (this.H_G_SQ_LIABILITY > 0.0) {
            finalNoiseVariance = varTotalGeneticLiability * (1.0 - this.H_G_SQ_LIABILITY) / this.H_G_SQ_LIABILITY - varTotalEnvironmentalLiability;
        }
        double stdDevFinalNoise = 0.0;
        if (finalNoiseVariance > 0.0) {
            stdDevFinalNoise = Math.sqrt(finalNoiseVariance);
        } else {
            System.err.println("Warning: The variance of random noise for liability is non-positive.");
        }
        float[] liabilities = new float[numIndividuals];
        for (int i = 0; i < numIndividuals; ++i) {
            double finalNoise = stdDevFinalNoise > 0.0 ? this.random.nextGaussian() * stdDevFinalNoise : 0.0;
            liabilities[i] = (float)(totalGeneticComponent[i] + totalEnvironmentalComponent[i] + finalNoise);
        }
        return liabilities;
    }

    public static void main(String[] args) {
        int numGenes = 100;
        int numIndividuals = 100000;
        int maxEqtlsPerGene = 5;
        Random random = new Random();
        GeneExpressionLiabilitySimulator simulator = new GeneExpressionLiabilitySimulator(0.05, 0.25, 0.1, 1.0, random);
        ArrayList<byte[][]> genotypeCodes = new ArrayList<byte[][]>();
        for (int g = 0; g < numGenes; ++g) {
            int numEqtlsForThisGene = random.nextInt(maxEqtlsPerGene) + 1;
            byte[][] geneData = new byte[numEqtlsForThisGene][numIndividuals];
            for (int e = 0; e < numEqtlsForThisGene; ++e) {
                for (int i = 0; i < numIndividuals; ++i) {
                    geneData[e][i] = (byte)random.nextInt(3);
                }
            }
            genotypeCodes.add(geneData);
        }
        double age = 20.0;
        DoubleList errorVariances = new DoubleList();
        System.out.println("--- Simulating Genetic Component of Gene Expression (Function 1) ---");
        float[][] geneticExpr = simulator.simuGeneExpression(genotypeCodes, age);
        System.out.println("Generated genetic expression for " + geneticExpr.length + " genes and " + (geneticExpr.length > 0 && geneticExpr[0] != null ? geneticExpr[0].length : 0) + " individuals.");
        System.out.println("Error variances (sigma_1t^2) for each gene: " + errorVariances);
        if (geneticExpr.length > 0 && geneticExpr[0] != null && geneticExpr[0].length > 0) {
            System.out.println("Example genetic expression (Gene 0, Indiv 0): " + geneticExpr[0][0]);
        }
        System.out.println();
        System.out.println("--- Simulating Total Gene Expression (Function 2) ---");
        float[][] totalExpr = simulator.simuGeneExpressionTotal(geneticExpr, numGenes * 10, true);
        System.out.println("Generated total expression for " + totalExpr.length + " genes and " + (totalExpr.length > 0 && totalExpr[0] != null ? totalExpr[0].length : 0) + " individuals.");
        if (totalExpr.length > 0 && totalExpr[0] != null && totalExpr[0].length > 0) {
            System.out.println("Example total expression (Gene 0, Indiv 0): " + totalExpr[0][0]);
            if (geneticExpr.length > 0 && geneticExpr[0] != null && geneticExpr[0].length > 0 && errorVariances.size() > 0) {
                double gene0ErrVar = errorVariances.get(0);
                if (!Double.isNaN(gene0ErrVar) && gene0ErrVar > 0.0 && !Double.isInfinite(gene0ErrVar)) {
                    System.out.println("Difference (should be epsilon_1,0,0): " + (totalExpr[0][0] - geneticExpr[0][0]));
                } else {
                    System.out.println("Error variance for gene 0 is " + gene0ErrVar + ", difference may not be a simple epsilon.");
                }
            }
        }
        System.out.println();
        System.out.println("--- Simulating Disease Liability (Function 3) ---");
        float[] liabilities = simulator.simulateLiabilityOptimized(genotypeCodes, age);
        System.out.println("Generated liabilities for " + liabilities.length + " individuals.");
        if (liabilities.length > 0) {
            System.out.println("Example liability (Indiv 0): " + liabilities[0]);
        }
        System.out.println();
        System.out.println("--- Testing Edge Case: Heritability = 0 ---");
        double original_H_E_SQ_COMMON = 0.05;
    }
}

