/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.simulation;

import edu.sysu.pmglab.container.list.DoubleList;
import edu.sysu.pmglab.kgga.command.SetupApplication;
import edu.sysu.pmglab.kgga.command.setting.PhenotypeCausalSetting;
import edu.sysu.pmglab.kgga.command.setting.PhenotypeVariantSetting;
import java.util.Random;
import java.util.stream.IntStream;

public class LiabilitySimulator {
    double[] confoundingLiabilities;
    private final Random random;

    public LiabilitySimulator(Random random) {
        this.random = random;
    }

    private double calculatePopulationVariance(double[] data) {
        if (data == null || data.length == 0) {
            return 0.0;
        }
        int n = data.length;
        double sum = 0.0;
        for (double val : data) {
            sum += val;
        }
        double mean = sum / (double)n;
        double sumSqDiff = 0.0;
        for (double val : data) {
            sumSqDiff += Math.pow(val - mean, 2.0);
        }
        return sumSqDiff / (double)n;
    }

    private double calculatePopulationVariance(float[] data) {
        if (data == null || data.length == 0) {
            return 0.0;
        }
        int n = data.length;
        double sum = 0.0;
        float[] fArray = data;
        int n2 = fArray.length;
        for (int i = 0; i < n2; ++i) {
            double val = fArray[i];
            sum += val;
        }
        double mean = sum / (double)n;
        double sumSqDiff = 0.0;
        float[] fArray2 = data;
        int n3 = fArray2.length;
        for (int i = 0; i < n3; ++i) {
            double val = fArray2[i];
            sumSqDiff += Math.pow(val - mean, 2.0);
        }
        return sumSqDiff / (double)n;
    }

    public float[] simuLiabilityP1(PhenotypeVariantSetting phenotype1Variants, float[][] genotypeCodes, int[] modeVariantNum, double[] availableVar) {
        if (genotypeCodes == null) {
            return new float[0];
        }
        int numIndividuals = genotypeCodes[0].length;
        if (numIndividuals == 0) {
            return new float[0];
        }
        float[] liabilities = new float[numIndividuals];
        double H2_P1 = phenotype1Variants.getHeritability();
        double varConfoundingP1 = phenotype1Variants.getConfounding();
        if (H2_P1 == 0.0) {
            if (varConfoundingP1 == 0.0) {
                for (int indiv2 = 0; indiv2 < numIndividuals; ++indiv2) {
                    liabilities[indiv2] = (float)this.random.nextGaussian();
                }
            } else {
                this.confoundingLiabilities = new double[numIndividuals];
                double stdConfounding = Math.sqrt(varConfoundingP1);
                double envorConfounding = Math.sqrt(1.0 - varConfoundingP1);
                for (int indiv3 = 0; indiv3 < numIndividuals; ++indiv3) {
                    this.confoundingLiabilities[indiv3] = this.random.nextGaussian() * stdConfounding;
                    liabilities[indiv3] = (float)(this.random.nextGaussian() * envorConfounding + this.confoundingLiabilities[indiv3]);
                }
                SetupApplication.GlobalLogger.info("The confounding variance, environmental variance are {} and {}, respectively to meet the heritability of 0.", (Object)varConfoundingP1, (Object)(1.0 - varConfoundingP1));
            }
            return liabilities;
        }
        IntStream.range(0, numIndividuals).parallel().forEach(indiv -> {
            float genotype2;
            int i;
            float genotype1;
            int j;
            double sumGeneticEffect = 0.0;
            for (int j2 = genotypeCodes.length - modeVariantNum[0]; j2 < genotypeCodes.length; ++j2) {
                float genotype = genotypeCodes[j2][indiv];
                if (Float.isNaN(genotype)) continue;
                sumGeneticEffect += (double)genotype;
            }
            int start = genotypeCodes.length - modeVariantNum[1];
            int end = genotypeCodes.length - modeVariantNum[0];
            for (j = start; j < end; ++j) {
                genotype1 = genotypeCodes[j][indiv];
                if (Float.isNaN(genotype1)) continue;
                for (i = j + 1; i < end; ++i) {
                    genotype2 = genotypeCodes[i][indiv];
                    if (Float.isNaN(genotype2)) continue;
                    sumGeneticEffect += (double)(genotype1 * genotype2);
                }
            }
            start = genotypeCodes.length - modeVariantNum[2];
            end = genotypeCodes.length - modeVariantNum[1];
            for (j = start; j < end; ++j) {
                genotype1 = genotypeCodes[j][indiv];
                if (Float.isNaN(genotype1)) continue;
                for (i = j + 1; i < end; ++i) {
                    genotype2 = genotypeCodes[i][indiv];
                    if (Float.isNaN(genotype2)) continue;
                    for (int k = i + 1; k < end; ++k) {
                        float genotype3 = genotypeCodes[k][indiv];
                        if (Float.isNaN(genotype3)) continue;
                        sumGeneticEffect += (double)(genotype1 * genotype2 * genotype3);
                    }
                }
            }
            liabilities[indiv] = (float)sumGeneticEffect;
        });
        double varGeneticLiabilityP1 = this.calculatePopulationVariance(liabilities);
        double confoundingP1 = Math.sqrt(varConfoundingP1 * varGeneticLiabilityP1 / H2_P1);
        double environmentalP1 = varGeneticLiabilityP1 * (1.0 - H2_P1 - varConfoundingP1) / H2_P1;
        if (availableVar != null && availableVar.length > 1) {
            availableVar[0] = varGeneticLiabilityP1;
            availableVar[1] = environmentalP1;
            availableVar[2] = confoundingP1;
        }
        environmentalP1 = Math.sqrt(environmentalP1);
        SetupApplication.GlobalLogger.info("The genetic variance, environmental variance are {} and {}, respectively to meet the heritability of {}.", varGeneticLiabilityP1, environmentalP1 * environmentalP1, H2_P1);
        if (environmentalP1 <= 0.0) {
            System.err.println("The variance of random noise for liability is less than 0");
            System.exit(1);
        }
        if (confoundingP1 > 0.0) {
            this.confoundingLiabilities = new double[numIndividuals];
        }
        for (int indiv4 = 0; indiv4 < numIndividuals; ++indiv4) {
            double epsilon_2x;
            if (Double.isNaN(liabilities[indiv4])) continue;
            if (confoundingP1 > 0.0) {
                this.confoundingLiabilities[indiv4] = this.random.nextGaussian();
                epsilon_2x = this.random.nextGaussian() * environmentalP1 + this.confoundingLiabilities[indiv4] * confoundingP1;
            } else {
                epsilon_2x = this.random.nextGaussian() * environmentalP1;
            }
            int n = indiv4;
            liabilities[n] = liabilities[n] + (float)epsilon_2x;
        }
        if (availableVar != null) {
            availableVar[3] = this.calculatePopulationVariance(liabilities);
        }
        return liabilities;
    }

    public float[] simuLiabilityP2(PhenotypeCausalSetting causalSetting, PhenotypeVariantSetting phenotype2Variants, float[][] genotypeCodes, int[] modeVariantNumShared, int[] modeVariantNumUnique, double[] availableVar, int sharedSusceptibilityVarNum, float[] availableLiability) {
        if (genotypeCodes == null) {
            return new float[0];
        }
        int numIndividuals = genotypeCodes[0].length;
        if (numIndividuals == 0) {
            return new float[0];
        }
        float[] liabilities = new float[numIndividuals];
        double H2_P2 = phenotype2Variants.getHeritability();
        double varConfoundingP2 = phenotype2Variants.getConfounding();
        if (H2_P2 == 0.0) {
            if (varConfoundingP2 == 0.0) {
                for (int indiv2 = 0; indiv2 < numIndividuals; ++indiv2) {
                    liabilities[indiv2] = (float)this.random.nextGaussian();
                }
            } else {
                this.confoundingLiabilities = new double[numIndividuals];
                double stdConfounding = Math.sqrt(varConfoundingP2);
                double envorConfounding = Math.sqrt(1.0 - varConfoundingP2);
                for (int indiv3 = 0; indiv3 < numIndividuals; ++indiv3) {
                    this.confoundingLiabilities[indiv3] = this.random.nextGaussian() * stdConfounding;
                    liabilities[indiv3] = (float)(this.random.nextGaussian() * envorConfounding + this.confoundingLiabilities[indiv3]);
                }
                SetupApplication.GlobalLogger.info("The confounding variance, environmental variance are {} and {}, respectively to meet the heritability of 0.", (Object)varConfoundingP2, (Object)(1.0 - varConfoundingP2));
            }
            return liabilities;
        }
        IntStream.range(0, numIndividuals).parallel().forEach(indiv -> {
            float genotype2;
            int i;
            float genotype1;
            int j;
            double sumGeneticEffect = 0.0;
            for (int j2 = genotypeCodes.length - modeVariantNumUnique[0]; j2 < genotypeCodes.length; ++j2) {
                float genotype = genotypeCodes[j2][indiv];
                if (Float.isNaN(genotype)) continue;
                sumGeneticEffect += (double)genotype;
            }
            int start = genotypeCodes.length - modeVariantNumUnique[1];
            int end = genotypeCodes.length - modeVariantNumUnique[0];
            for (j = start; j < end; ++j) {
                genotype1 = genotypeCodes[j][indiv];
                if (Float.isNaN(genotype1)) continue;
                for (i = j + 1; i < end; ++i) {
                    genotype2 = genotypeCodes[i][indiv];
                    if (Float.isNaN(genotype2)) continue;
                    sumGeneticEffect += (double)(genotype1 * genotype2);
                }
            }
            start = genotypeCodes.length - modeVariantNumUnique[2];
            end = genotypeCodes.length - modeVariantNumUnique[1];
            for (j = start; j < end; ++j) {
                genotype1 = genotypeCodes[j][indiv];
                if (Float.isNaN(genotype1)) continue;
                for (i = j + 1; i < end; ++i) {
                    genotype2 = genotypeCodes[i][indiv];
                    if (Float.isNaN(genotype2)) continue;
                    for (int k = i + 1; k < end; ++k) {
                        float genotype3 = genotypeCodes[k][indiv];
                        if (Float.isNaN(genotype3)) continue;
                        sumGeneticEffect += (double)(genotype1 * genotype2 * genotype3);
                    }
                }
            }
            liabilities[indiv] = (float)sumGeneticEffect;
        });
        double beta = 1.0;
        double varGeneticLiabilityP2 = this.calculatePopulationVariance(liabilities);
        double retainedHeritabilityP2 = H2_P2 - causalSetting.getDirectPleiotropyHeritability() - causalSetting.getRandPleiotropyHeritability();
        double varLiabilityP2 = varGeneticLiabilityP2 / retainedHeritabilityP2;
        double proportion = causalSetting.getPleiotropyIVProportion();
        double causalEffect = causalSetting.getCausalEffect();
        double meanEta = 0.0;
        double varEta = 0.0;
        boolean hasPlieo = false;
        if (proportion > 0.0) {
            meanEta = causalSetting.getDirectPleiotropyHeritability() * varLiabilityP2 / proportion / availableVar[0];
            meanEta = Math.sqrt(meanEta);
            varEta = causalSetting.getRandPleiotropyHeritability() * varLiabilityP2 / proportion / availableVar[0];
            hasPlieo = true;
            double sdEta = Math.sqrt(varEta);
            double[] plieos = new double[sharedSusceptibilityVarNum];
            for (int j = 0; j < plieos.length; ++j) {
                plieos[j] = this.random.nextGaussian();
                plieos[j] = meanEta + plieos[j] * sdEta;
            }
            IntStream.range(0, numIndividuals).parallel().forEach(indiv -> {
                float genotype2;
                int i;
                float genotype1;
                int j;
                for (j = 0; j < modeVariantNumShared[0]; ++j) {
                    float genotype = genotypeCodes[j][indiv];
                    if (Float.isNaN(genotype)) continue;
                    int n = indiv;
                    liabilities[n] = (float)((double)liabilities[n] + plieos[j] * (double)genotype);
                }
                for (j = modeVariantNumShared[0]; j < modeVariantNumShared[1]; ++j) {
                    genotype1 = genotypeCodes[j][indiv];
                    if (Float.isNaN(genotype1)) continue;
                    for (i = j + 1; i < modeVariantNumShared[1]; ++i) {
                        genotype2 = genotypeCodes[i][indiv];
                        if (Float.isNaN(genotype2)) continue;
                        int n = indiv;
                        liabilities[n] = (float)((double)liabilities[n] + plieos[j] * (double)genotype1 * (double)genotype2);
                    }
                }
                for (j = modeVariantNumShared[1]; j < modeVariantNumShared[2]; ++j) {
                    genotype1 = genotypeCodes[j][indiv];
                    if (Float.isNaN(genotype1)) continue;
                    for (i = j + 1; i < modeVariantNumShared[2]; ++i) {
                        genotype2 = genotypeCodes[i][indiv];
                        if (Float.isNaN(genotype2)) continue;
                        for (int k = i + 1; k < modeVariantNumShared[2]; ++k) {
                            float genotype3 = genotypeCodes[k][indiv];
                            if (Float.isNaN(genotype3)) continue;
                            int n = indiv;
                            liabilities[n] = (float)((double)liabilities[n] + plieos[j] * (double)genotype1 * (double)genotype2 * (double)genotype3);
                        }
                    }
                }
            });
        }
        double confoundingP2 = Math.sqrt(varConfoundingP2 * varLiabilityP2);
        double environmentalP2 = varLiabilityP2 * (1.0 - H2_P2 - varConfoundingP2);
        environmentalP2 = Math.sqrt(environmentalP2);
        SetupApplication.GlobalLogger.info("The genetic variance, environmental variance are {} and {}, respectively to meet the heritability of {}.", varGeneticLiabilityP2, environmentalP2 * environmentalP2, H2_P2);
        if (environmentalP2 <= 0.0) {
            System.err.println("The variance of random noise for liability is less than 0");
            System.exit(1);
        }
        for (int indiv4 = 0; indiv4 < numIndividuals; ++indiv4) {
            if (Double.isNaN(liabilities[indiv4])) continue;
            double epsilon_2x = confoundingP2 > 0.0 ? this.random.nextGaussian() * environmentalP2 + this.confoundingLiabilities[indiv4] * confoundingP2 : this.random.nextGaussian() * environmentalP2;
            liabilities[indiv4] = (float)(causalEffect * (double)availableLiability[indiv4] + beta * (double)liabilities[indiv4] + epsilon_2x);
        }
        return liabilities;
    }

    public float[] simuLiabilityP2(PhenotypeCausalSetting causalSetting, PhenotypeVariantSetting phenotype2Variants, float[][] genotypeCodes, int[] modeVariantNumShared, int[] modeVariantNumUnique, float[] availableLiability, int sharedSusceptibilityVarNum, double[] availableVar) {
        if (genotypeCodes == null) {
            return new float[0];
        }
        int numIndividuals = genotypeCodes[0].length;
        if (numIndividuals == 0) {
            return new float[0];
        }
        float[] liabilities = new float[numIndividuals];
        double H2_P2 = phenotype2Variants.getHeritability();
        double varConfoundingP2 = phenotype2Variants.getConfounding();
        if (H2_P2 == 0.0) {
            if (varConfoundingP2 == 0.0) {
                for (int indiv2 = 0; indiv2 < numIndividuals; ++indiv2) {
                    liabilities[indiv2] = (float)this.random.nextGaussian();
                }
            } else {
                double stdConfounding = Math.sqrt(varConfoundingP2);
                double envorConfounding = Math.sqrt(1.0 - varConfoundingP2);
                for (int indiv3 = 0; indiv3 < numIndividuals; ++indiv3) {
                    liabilities[indiv3] = (float)(this.random.nextGaussian() * envorConfounding + this.confoundingLiabilities[indiv3] * stdConfounding);
                }
                SetupApplication.GlobalLogger.info("The confounding variance, environmental variance are {} and {}, respectively to meet the heritability of {}.", varConfoundingP2, 1.0 - varConfoundingP2, H2_P2);
            }
            return liabilities;
        }
        IntStream.range(0, numIndividuals).parallel().forEach(indiv -> {
            float genotype2;
            int i;
            float genotype1;
            int j;
            double sumGeneticEffect = 0.0;
            for (int j2 = genotypeCodes.length - modeVariantNumUnique[0]; j2 < genotypeCodes.length; ++j2) {
                float genotype = genotypeCodes[j2][indiv];
                if (Float.isNaN(genotype)) continue;
                sumGeneticEffect += (double)genotype;
            }
            int start = genotypeCodes.length - modeVariantNumUnique[1];
            int end = genotypeCodes.length - modeVariantNumUnique[0];
            for (j = start; j < end; ++j) {
                genotype1 = genotypeCodes[j][indiv];
                if (Float.isNaN(genotype1)) continue;
                for (i = j + 1; i < end; ++i) {
                    genotype2 = genotypeCodes[i][indiv];
                    if (Float.isNaN(genotype2)) continue;
                    sumGeneticEffect += (double)(genotype1 * genotype2);
                }
            }
            start = genotypeCodes.length - modeVariantNumUnique[2];
            end = genotypeCodes.length - modeVariantNumUnique[1];
            for (j = start; j < end; ++j) {
                genotype1 = genotypeCodes[j][indiv];
                if (Float.isNaN(genotype1)) continue;
                for (i = j + 1; i < end; ++i) {
                    genotype2 = genotypeCodes[i][indiv];
                    if (Float.isNaN(genotype2)) continue;
                    for (int k = i + 1; k < end; ++k) {
                        float genotype3 = genotypeCodes[k][indiv];
                        if (Float.isNaN(genotype3)) continue;
                        sumGeneticEffect += (double)(genotype1 * genotype2 * genotype3);
                    }
                }
            }
            liabilities[indiv] = (float)sumGeneticEffect;
        });
        double H2_P1_2 = causalSetting.getCausalHeritability();
        double causalEffect = causalSetting.getCausalEffect();
        double varLiabilityP2 = causalEffect * causalEffect * availableVar[3] / H2_P1_2;
        double proportion = causalSetting.getPleiotropyIVProportion();
        double varGeneticLiabilityP2 = this.calculatePopulationVariance(liabilities);
        double directPleioH2ToP2 = causalSetting.getDirectPleiotropyHeritability();
        double randPleioH2ToP2 = causalSetting.getRandPleiotropyHeritability();
        double meanEta = 0.0;
        double varEta = 0.0;
        boolean hasPlieo = false;
        if (proportion > 0.0) {
            meanEta = Math.sqrt(directPleioH2ToP2 * varLiabilityP2 / (proportion * availableVar[0]));
            varEta = randPleioH2ToP2 * varLiabilityP2 / (proportion * availableVar[0]);
            hasPlieo = true;
            double sdEta = Math.sqrt(varEta);
            double[] plieos = new double[sharedSusceptibilityVarNum];
            for (int j = 0; j < plieos.length; ++j) {
                plieos[j] = this.random.nextGaussian();
                plieos[j] = meanEta + plieos[j] * sdEta;
            }
            IntStream.range(0, numIndividuals).parallel().forEach(indiv -> {
                float genotype2;
                int i;
                float genotype1;
                int j;
                for (j = 0; j < modeVariantNumShared[0]; ++j) {
                    float genotype = genotypeCodes[j][indiv];
                    if (Float.isNaN(genotype)) continue;
                    int n = indiv;
                    liabilities[n] = (float)((double)liabilities[n] + plieos[j] * (double)genotype);
                }
                for (j = modeVariantNumShared[0]; j < modeVariantNumShared[1]; ++j) {
                    genotype1 = genotypeCodes[j][indiv];
                    if (Float.isNaN(genotype1)) continue;
                    for (i = j + 1; i < modeVariantNumShared[1]; ++i) {
                        genotype2 = genotypeCodes[i][indiv];
                        if (Float.isNaN(genotype2)) continue;
                        int n = indiv;
                        liabilities[n] = (float)((double)liabilities[n] + plieos[j] * (double)genotype1 * (double)genotype2);
                    }
                }
                for (j = modeVariantNumShared[1]; j < modeVariantNumShared[2]; ++j) {
                    genotype1 = genotypeCodes[j][indiv];
                    if (Float.isNaN(genotype1)) continue;
                    for (i = j + 1; i < modeVariantNumShared[2]; ++i) {
                        genotype2 = genotypeCodes[i][indiv];
                        if (Float.isNaN(genotype2)) continue;
                        for (int k = i + 1; k < modeVariantNumShared[2]; ++k) {
                            float genotype3 = genotypeCodes[k][indiv];
                            if (Float.isNaN(genotype3)) continue;
                            int n = indiv;
                            liabilities[n] = (float)((double)liabilities[n] + plieos[j] * (double)genotype1 * (double)genotype2 * (double)genotype3);
                        }
                    }
                }
            });
        }
        double totalGeneticLiabilityP2 = H2_P2 * varLiabilityP2;
        double beta2 = totalGeneticLiabilityP2 - availableVar[0] * ((Math.pow(causalEffect + meanEta, 2.0) + varEta) * proportion + causalEffect * causalEffect * (1.0 - proportion));
        beta2 = Math.sqrt(beta2 / varGeneticLiabilityP2);
        double confoundingP2 = Math.sqrt(varConfoundingP2 * varLiabilityP2) - causalEffect * availableVar[2];
        double environmentalP2 = varLiabilityP2 - (totalGeneticLiabilityP2 + Math.pow(varConfoundingP2 + causalEffect * availableVar[2], 2.0) + causalEffect * causalEffect * availableVar[1]);
        if (environmentalP2 <= 0.0) {
            System.err.println("The variance of random noise for liability is less than 0");
            System.exit(1);
        }
        SetupApplication.GlobalLogger.info("The genetic variance, confounding variance, environmental variance are {} {} and {}, respectively to meet the heritability of {}.", varGeneticLiabilityP2, varConfoundingP2, environmentalP2, H2_P2);
        environmentalP2 = Math.sqrt(environmentalP2);
        double beta = Math.sqrt(beta2);
        for (int indiv4 = 0; indiv4 < numIndividuals; ++indiv4) {
            if (Double.isNaN(liabilities[indiv4])) continue;
            double epsilon_2x = confoundingP2 > 0.0 ? this.random.nextGaussian() * environmentalP2 + this.confoundingLiabilities[indiv4] * confoundingP2 : this.random.nextGaussian() * environmentalP2;
            liabilities[indiv4] = (float)(causalEffect * (double)availableLiability[indiv4] + beta * (double)liabilities[indiv4] + epsilon_2x);
        }
        return liabilities;
    }

    public static void main(String[] args) {
        int numGenes = 100;
        int numIndividuals = 100000;
        int maxEqtlsPerGene = 5;
        Random random = new Random();
        LiabilitySimulator simulator = new LiabilitySimulator(random);
        int numEqtlsForThisGene = 100;
        float[][] geneData = new float[numEqtlsForThisGene][numIndividuals];
        for (int e = 0; e < numEqtlsForThisGene; ++e) {
            for (int i = 0; i < numIndividuals; ++i) {
                geneData[e][i] = random.nextInt(3);
            }
        }
        double age = 20.0;
        DoubleList errorVariances = new DoubleList();
        System.out.println("--- Simulating Disease Liability (Function 3) ---");
        float[] liabilities = simulator.simuLiabilityP1(null, geneData, new int[]{20, 90, 100}, null);
        System.out.println("Generated liabilities for " + liabilities.length + " individuals.");
        if (liabilities.length > 0) {
            System.out.println("Example liability (Indiv 0): " + liabilities[0]);
        }
        System.out.println();
        System.out.println("--- Testing Edge Case: Heritability = 0 ---");
        double original_H_E_SQ_COMMON = 0.05;
    }
}

