/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.stat;

import edu.sysu.pmglab.stat.Summary;
import java.util.ArrayList;

public class ANOVA {
    double[] factor;
    double[] phenotypes;
    double[][] data;
    double ssb;
    double ssw;
    int dfb;
    int dfw;
    double msb;
    double msw;
    double fStatistic;
    double pVal;
    int minCell;

    public double getPVal() {
        return this.pVal;
    }

    public ANOVA(int minCell) {
        this.minCell = minCell;
    }

    public double getFStatistic() {
        return this.fStatistic;
    }

    public int getDfb() {
        return this.dfb;
    }

    public int getDfw() {
        return this.dfw;
    }

    public void setConfig(double[] factor, double[] phenotypes) {
        this.factor = factor;
        this.phenotypes = phenotypes;
    }

    public void calculate() {
        int i;
        ArrayList phes = new ArrayList(3);
        for (i = 0; i < 3; ++i) {
            phes.add(new ArrayList());
        }
        for (i = 0; i < this.factor.length; ++i) {
            if (!(this.factor[i] >= 0.0) || !(this.factor[i] <= 2.0)) continue;
            ((ArrayList)phes.get((int)this.factor[i])).add(this.phenotypes[i]);
        }
        boolean[] flags = new boolean[3];
        for (int i2 = 0; i2 < 3; ++i2) {
            flags[i2] = !((ArrayList)phes.get(i2)).isEmpty();
        }
        int size = (flags[0] ? 1 : 0) + (flags[1] ? 1 : 0) + (flags[2] ? 1 : 0);
        if (size < 2) {
            this.pVal = Double.NaN;
            this.dfw = 0;
            this.dfb = 0;
            this.fStatistic = Double.NaN;
        } else {
            this.data = new double[size][];
            int index = 0;
            for (int i3 = 0; i3 < 3; ++i3) {
                if (!flags[i3]) continue;
                this.data[index] = ((ArrayList)phes.get(i3)).stream().mapToDouble(Double::doubleValue).toArray();
                ++index;
            }
            this.performAnova(this.data);
        }
    }

    private double mean(double[] data) {
        double sum = 0.0;
        for (double num : data) {
            sum += num;
        }
        return sum / (double)data.length;
    }

    private double variance(double[] data, double mean) {
        double sum = 0.0;
        for (double num : data) {
            sum += Math.pow(num - mean, 2.0);
        }
        return sum / (double)(data.length - 1);
    }

    public void performAnova(double[][] groups2) {
        int totalSampleSize = 0;
        double grandMean = 0.0;
        this.ssb = 0.0;
        this.ssw = 0.0;
        for (double[] group : groups2) {
            totalSampleSize += group.length;
            grandMean += this.mean(group) * (double)group.length;
        }
        grandMean /= (double)totalSampleSize;
        for (double[] group : groups2) {
            double groupMean = this.mean(group);
            this.ssb += (double)group.length * Math.pow(groupMean - grandMean, 2.0);
            if (group.length == 1) continue;
            this.ssw += this.variance(group, groupMean) * (double)(group.length - 1);
        }
        this.dfb = groups2.length - 1;
        this.dfw = totalSampleSize - groups2.length;
        this.msb = this.ssb / (double)this.dfb;
        this.msw = this.ssw / (double)this.dfw;
        this.fStatistic = this.msb / this.msw;
        this.pVal = Summary.calculateFPValue(this.fStatistic, this.dfb, this.dfw);
    }

    public static void main(String[] args) {
        double[] factor = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 2.0};
        double[] data = new double[]{2.0, 2.0, 2.0, 2.0, 1.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0};
        ANOVA anova = new ANOVA(0);
        anova.setConfig(factor, data);
        anova.calculate();
        System.out.println(anova.getPVal());
        System.out.println(anova.getFStatistic());
        System.out.println(anova.getDfb());
        System.out.println(anova.getDfw());
        System.out.println(anova.msb);
        System.out.println(anova.msw);
        System.out.println(anova.ssb);
        System.out.println(anova.ssw);
    }
}

