/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.stat;

import edu.sysu.pmglab.container.list.DoubleList;
import edu.sysu.pmglab.gtb.GTBReader;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.genome.coordinate.Chromosome;
import edu.sysu.pmglab.stat.CauchyDistribution;
import edu.sysu.pmglab.stat.FisherExact;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;

public class CCT {
    public static double calculate(DoubleList pvals, double[] weights) throws IllegalArgumentException {
        pvals.removeIf(pv -> pv >= 1.0 || pv <= 0.0 || Double.isNaN(pv));
        if (pvals.isEmpty()) {
            return Double.NaN;
        }
        double[] array = pvals.toArray();
        return CCT.calculate(array, weights);
    }

    public static double calculate(double[] pvals, double[] weights) throws IllegalArgumentException {
        for (double pval : pvals) {
            if (!Double.isNaN(pval)) continue;
            throw new IllegalArgumentException("Cannot have NAs in the p-values!");
        }
        for (double pval : pvals) {
            if (!(pval < 0.0) && !(pval > 1.0)) continue;
            throw new IllegalArgumentException("All p-values must be between 0 and 1!");
        }
        boolean isZero = false;
        boolean isOne = false;
        for (double pval : pvals) {
            if (pval == 0.0) {
                isZero = true;
            }
            if (pval != 1.0) continue;
            isOne = true;
        }
        if (isZero && isOne) {
            throw new IllegalArgumentException("Cannot have both 0 and 1 p-values!");
        }
        if (isZero) {
            return 0.0;
        }
        if (isOne) {
            System.out.println("Warning: There are p-values that are exactly 1!");
            return 1.0;
        }
        if (weights == null) {
            weights = new double[pvals.length];
            Arrays.fill(weights, 1.0 / (double)pvals.length);
        } else {
            if (weights.length != pvals.length) {
                throw new IllegalArgumentException("The length of weights should be the same as that of the p-values!");
            }
            for (double weight : weights) {
                if (!(weight < 0.0)) continue;
                throw new IllegalArgumentException("All the weights must be positive!");
            }
            double sumWeights = 0.0;
            for (double weight : weights) {
                sumWeights += weight;
            }
            for (int i = 0; i < weights.length; ++i) {
                weights[i] = weights[i] / sumWeights;
            }
        }
        boolean[] isSmall = new boolean[pvals.length];
        for (int i = 0; i < pvals.length; ++i) {
            isSmall[i] = pvals[i] < 1.0E-16;
        }
        double cctStat = 0.0;
        for (int i = 0; i < pvals.length; ++i) {
            if (isSmall[i]) {
                cctStat += weights[i] / pvals[i] / Math.PI;
                continue;
            }
            cctStat += weights[i] * Math.tan((0.5 - pvals[i]) * Math.PI);
        }
        if (cctStat > 1.0E15) {
            return 1.0 / cctStat / Math.PI;
        }
        return 1.0 - CauchyDistribution.cdf(cctStat);
    }

    public static void main(String[] args) throws IOException {
        Variant var;
        double[] pvals = new double[]{0.05, 0.01, 0.2};
        double[] weights = new double[]{0.3, 0.4, 0.3};
        try {
            double result = CCT.calculate(pvals, weights);
            System.out.println("Calculated p-value: " + result);
        }
        catch (IllegalArgumentException e) {
            System.out.println(e.getMessage());
        }
        FisherExact fe = new FisherExact(10000);
        System.out.println(fe.getTwoTailedP(1, 442, 0, 493));
        String path = "/Volumes/SSD/kggaTest/association_0219_maf/VariantAssocTask0/variants.annot.hg38.gtb";
        String outputPath = "/Volumes/SSD/kggaTest/association_0219_maf/VariantAssocTask0/cct.txt";
        GTBReader reader = new GTBReader(path);
        BufferedWriter writer = new BufferedWriter(new FileWriter(outputPath));
        writer.write("CHR\tBP\tPOS\n");
        while ((var = reader.read()) != null) {
            if (Double.isNaN((Double)var.getProperty("Assoc@CCT_P"))) continue;
            double cct = (Double)var.getProperty("Assoc@CCT_P");
            Chromosome chr = var.getChromosome();
            int pos = var.getPosition();
            writer.write(chr.getIndex() + 1 + "\t" + pos + "\t" + String.valueOf(cct) + "\n");
        }
        writer.close();
    }
}

