/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.stat;

import cern.jet.stat.Probability;

public class CochranArmitage {
    int[][] x;
    double[] weights;
    String alternative = "one-sided";
    double z;
    double pval;

    public CochranArmitage() {
    }

    public CochranArmitage(int[][] x, double[] weights, String alternative) {
        this.x = x;
        this.weights = weights;
        this.alternative = alternative;
    }

    public void setX(int[][] x) {
        this.x = x;
    }

    public void setWeights(double[] weights) {
        this.weights = weights;
    }

    public void setAlternative(String alternative) {
        this.alternative = alternative;
    }

    public int[][] transpose(int[][] matrix) {
        int rows = matrix.length;
        int cols = matrix[0].length;
        int[][] transposed = new int[cols][rows];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                transposed[j][i] = matrix[i][j];
            }
        }
        return transposed;
    }

    public void calculate() {
        int i;
        if (this.weights == null) {
            this.weights = new double[this.x[0].length];
            for (int i2 = 0; i2 < this.x[0].length; ++i2) {
                this.weights[i2] = i2;
            }
        }
        if (this.x[0].length != this.weights.length) {
            System.err.println("The number of columns for x and the length of weighs need to be the same");
        }
        if (!this.alternative.equals("one-sided") && !this.alternative.equals("two-sided")) {
            System.err.println("alternative must be one of \"two-sided\", \"one-sided\"(default).");
        }
        this.x = this.transpose(this.x);
        double[] nidot = new double[this.x.length];
        double n = 0.0;
        for (int i3 = 0; i3 < this.x.length; ++i3) {
            nidot[i3] = 0.0;
            for (int j = 0; j < this.x[i3].length; ++j) {
                int n2 = i3;
                nidot[n2] = nidot[n2] + (double)this.x[i3][j];
            }
            n += nidot[i3];
        }
        double Rbar = 0.0;
        for (int i4 = 0; i4 < this.weights.length; ++i4) {
            Rbar += nidot[i4] * this.weights[i4];
        }
        Rbar /= n;
        double s2 = 0.0;
        for (int i5 = 0; i5 < this.weights.length; ++i5) {
            s2 += nidot[i5] * Math.pow(this.weights[i5] - Rbar, 2.0);
        }
        double pdot1 = 0.0;
        for (i = 0; i < this.x.length; ++i) {
            pdot1 += (double)this.x[i][0];
        }
        pdot1 /= n;
        this.z = 0.0;
        for (i = 0; i < this.x.length; ++i) {
            this.z += (double)this.x[i][0] * (this.weights[i] - Rbar);
        }
        this.z /= Math.sqrt(pdot1 * (1.0 - pdot1) * s2);
        if (this.alternative.equals("one-sided")) {
            this.pval = 1.0 - Probability.normal(Math.abs(this.z));
        }
        if (this.alternative.equals("two-sided")) {
            this.pval = 2.0 * (1.0 - Probability.normal(Math.abs(this.z)));
        }
    }

    public double getZ() {
        return this.z;
    }

    public double getPval() {
        return this.pval;
    }

    public static void main(String[] args) {
        CochranArmitage test2 = new CochranArmitage();
        int[][] x = new int[][]{{20, 20, 20}, {10, 20, 30}};
        double[] weights = new double[]{0.0, 1.0, 2.0};
        test2.setX(x);
        test2.setWeights(weights);
        test2.setAlternative("two-sided");
        test2.calculate();
        System.out.println(test2.getZ());
        System.out.println(test2.getPval());
    }
}

