/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.stat;

import cern.jet.random.Binomial;
import cern.jet.random.engine.DRand;
import cern.jet.stat.Gamma;
import cern.jet.stat.Probability;

public class ContingencyTable {
    public static final int PHI_COEFFICIENT = 1;
    public static final int FISHER_1TAILED = 2;
    public static final int FISHER_2TAILED = 4;
    private static final int WIDTH = 7;
    private static final int DECIMALS = 3;

    public static void main(String[] args) throws Exception {
        boolean tests = false;
        Object filename = null;
        long[][] counts = new long[][]{{2L, 9582L}, {460L, 9582L}};
        double s = ContingencyTable.pearsonChiSquared22(counts);
        System.out.println(Probability.chiSquareComplemented(1.0, s));
        System.out.println(ContingencyTable.fisherExact22(counts, 2, 2, 2));
        System.out.println(ContingencyTable.chiSquareTest(counts));
        System.out.println(ContingencyTable.binomialPValueGreater(34.0, 3116.0, 0.011921459));
        System.out.println(ContingencyTable.binomialPValueTwoTailed(49.0, 235.0, 0.16666666666666666));
        System.out.println(Probability.poissonComplemented(0, 0.02));
        long[][] counts1 = new long[][]{{460L, 9582L}, {460L, 9582L}};
        System.out.println(ContingencyTable.chiSquareTest(counts1));
        System.out.println(Probability.chiSquareComplemented(2.0, ContingencyTable.chiSquareTest(counts1)));
    }

    public static double chiSquareTest(long[][] counts) {
        int nRows = counts.length;
        int nCols = counts[0].length;
        double[] rowSum = new double[nRows];
        double[] colSum = new double[nCols];
        double total = 0.0;
        for (int row = 0; row < nRows; ++row) {
            for (int col = 0; col < nCols; ++col) {
                int n = row;
                rowSum[n] = rowSum[n] + (double)counts[row][col];
                int n2 = col;
                colSum[n2] = colSum[n2] + (double)counts[row][col];
                total += (double)counts[row][col];
            }
        }
        double sumSq = 0.0;
        double expected = 0.0;
        for (int row = 0; row < nRows; ++row) {
            for (int col = 0; col < nCols; ++col) {
                expected = rowSum[row] * colSum[col] / total;
                sumSq += ((double)counts[row][col] - expected) * ((double)counts[row][col] - expected) / expected;
            }
        }
        double p = Probability.chiSquareComplemented((nRows - 1) * (nCols - 1), sumSq);
        return p;
    }

    public static final double pearsonChiSquared22(long[][] readCountsInt) {
        double chiSquared = readCountsInt[0][0] * readCountsInt[1][1] - readCountsInt[0][1] * readCountsInt[1][0];
        chiSquared *= chiSquared;
        chiSquared /= (double)(readCountsInt[0][0] + readCountsInt[0][1]);
        chiSquared /= (double)(readCountsInt[1][0] + readCountsInt[1][1]);
        chiSquared /= (double)(readCountsInt[0][0] + readCountsInt[1][0]);
        chiSquared /= (double)(readCountsInt[0][1] + readCountsInt[1][1]);
        return chiSquared *= (double)(readCountsInt[0][0] + readCountsInt[0][1] + readCountsInt[1][0] + readCountsInt[1][1]);
    }

    public static final double fisherExact22(long[][] contigencyTable22, int rowNum, int colNum, int tails) {
        int A;
        int k;
        int j;
        int i;
        int j2;
        int i2;
        int[] Rs = new int[rowNum];
        int[] Cs = new int[colNum];
        int totalAccount = 0;
        for (i2 = 0; i2 < rowNum; ++i2) {
            for (j2 = 0; j2 < colNum; ++j2) {
                int n = i2;
                Rs[n] = Rs[n] + (int)contigencyTable22[i2][j2];
                totalAccount += (int)contigencyTable22[i2][j2];
            }
        }
        for (i2 = 0; i2 < colNum; ++i2) {
            for (j2 = 0; j2 < rowNum; ++j2) {
                int n = i2;
                Cs[n] = Cs[n] + (int)contigencyTable22[j2][i2];
            }
        }
        int minIndex = 0;
        int minData = 0;
        long[] tmpArray = null;
        for (i = 0; i < rowNum; ++i) {
            minData = Rs[i];
            minIndex = i;
            for (j = i; j < rowNum; ++j) {
                if (minData <= Rs[j]) continue;
                minData = Rs[j];
                minIndex = j;
            }
            if (minIndex == i) continue;
            Rs[minIndex] = Rs[i];
            Rs[i] = minData;
            tmpArray = new long[colNum];
            for (k = 0; k < colNum; ++k) {
                tmpArray[k] = contigencyTable22[minIndex][k];
                contigencyTable22[minIndex][k] = contigencyTable22[i][k];
                contigencyTable22[i][k] = tmpArray[k];
            }
        }
        for (i = 0; i < colNum; ++i) {
            minData = Cs[i];
            minIndex = i;
            for (j = i; j < colNum; ++j) {
                if (minData <= Cs[j]) continue;
                minData = Cs[j];
                minIndex = j;
            }
            if (minIndex == i) continue;
            Cs[minIndex] = Cs[i];
            Cs[i] = minData;
            tmpArray = new long[rowNum];
            for (k = 0; k < rowNum; ++k) {
                tmpArray[k] = contigencyTable22[k][minIndex];
                contigencyTable22[k][minIndex] = contigencyTable22[k][i];
                contigencyTable22[k][i] = tmpArray[k];
            }
        }
        int possibleA = Math.min(Rs[0], Cs[0]) + 1;
        double[] np = new double[possibleA];
        np[0] = Gamma.logGamma(Rs[1] + 1) + Gamma.logGamma(Cs[1] + 1) - Gamma.logGamma(totalAccount + 1) - Gamma.logGamma(Cs[1] - Rs[0] + 1);
        double observedP = 0.0;
        double tail2P = 0.0;
        double tail1DownP = 0.0;
        double tail1UpP = 0.0;
        for (A = 1; A < possibleA; ++A) {
            double D = Math.log(Rs[1] - Cs[0] + A);
            double B = Math.log(Rs[0] - A + 1);
            double C = Math.log(Cs[0] - A + 1);
            np[A] = np[A - 1] + B + C - (Math.log(A) + D);
        }
        for (A = 0; A < possibleA; ++A) {
            np[A] = Math.exp(np[A]);
        }
        observedP = np[(int)contigencyTable22[0][0]];
        for (A = 0; A < possibleA; ++A) {
            if ((long)A < contigencyTable22[0][0]) {
                tail1DownP += np[A];
            } else if ((long)A > contigencyTable22[0][0]) {
                tail1UpP += np[A];
            }
            if (!(np[A] <= observedP)) continue;
            tail2P += np[A];
        }
        tail1DownP += np[(int)contigencyTable22[0][0]];
        tail1UpP += np[(int)contigencyTable22[0][0]];
        if (tails == 2) {
            return tail2P > 1.0 ? 1.0 : tail2P;
        }
        if (tails == 1) {
            return Math.min(tail1UpP > 1.0 ? 1.0 : tail2P, tail1UpP > 1.0 ? 1.0 : tail1UpP);
        }
        return tail2P;
    }

    public static double binomialPValueGreater(double k, double n, double p) {
        if (n == 0.0 || p <= 0.0) {
            return Double.NaN;
        }
        double pval = 1.0;
        Binomial b = new Binomial((int)Math.ceil(n), p, new DRand());
        pval = b.cdf((int)Math.ceil(k) - 1);
        return 1.0 - pval;
    }

    public static double binomialPValueTwoTailed(double k, double n, double p) {
        if (n == 0.0) {
            return Double.NaN;
        }
        double pval = 1.0;
        Binomial b = new Binomial((int)Math.ceil(n), p, new DRand());
        pval = 1.0 - b.cdf((int)Math.ceil(k) - 1);
        return pval += 1.0 - b.cdf((int)Math.ceil(k));
    }
}

