/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.stat;

import edu.sysu.pmglab.analysis.GenomeRegion;
import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.list.DoubleList;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.executor.Context;
import edu.sysu.pmglab.executor.ITask;
import edu.sysu.pmglab.executor.Status;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.genome.coordinate.Chromosome;
import edu.sysu.pmglab.stat.FisherExact;
import edu.sysu.pmglab.stat.Summary;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.REngine.REngineException;
import org.rosuda.REngine.Rserve.RConnection;
import org.rosuda.REngine.Rserve.RserveException;

public class DynamicScanWindows {
    int[] windowLength = new int[]{1500, 2000, 2500, 3000};
    int[] varInRegion = new int[]{10, 20, 30, 40, 50};
    List<Variant> variantsTmp;
    private static final DynamicScanWindows instance = new DynamicScanWindows();
    String chromName;
    RConnection rcon;
    List<GenomeRegion> resultRegions;
    List<Region> result;
    InetSocketAddress rServer;
    String rHost;
    int rPort;
    int lengthThreshold;
    int variantSizeThreshold;
    String caseMeta;
    String controlMeta;
    GenomeRegion originalRegion;
    boolean useScan = false;
    int scale = 10000;
    String TestType;
    float ratio = 0.6f;
    float cutoff = 0.9f;
    float nonZeroRatio = 0.2f;
    boolean correction = true;

    public void setVariantSizeThreshold(int variantSizeThreshold) {
        this.variantSizeThreshold = variantSizeThreshold;
    }

    public void setVarInRegion(int[] varInRegion) {
        Arrays.sort(varInRegion);
        this.varInRegion = varInRegion;
    }

    public void setFDRCutoff(float cutoff) {
        this.cutoff = cutoff;
    }

    public void setRatio(float ratio) {
        this.ratio = ratio;
    }

    private DynamicScanWindows() {
    }

    public static DynamicScanWindows getInstance() {
        return instance;
    }

    public boolean isUseScan() {
        return this.useScan;
    }

    public int getScale() {
        return this.scale;
    }

    public void setWindowLength(int[] windowLength) {
        this.windowLength = windowLength;
    }

    public void setLengthThreshold(int lengthThreshold) {
        this.lengthThreshold = lengthThreshold;
        this.useScan = true;
    }

    public void setRServer(InetSocketAddress address) throws RserveException {
        this.rServer = address;
        this.rHost = this.rServer.getHostName();
        this.rPort = this.rServer.getPort();
        this.rcon = new RConnection(this.rHost, this.rPort);
    }

    public void setTestType(String testType) {
        this.TestType = testType;
    }

    public void setTask(List<Variant> variantsTmp, GenomeRegion originalRegion) {
        this.variantsTmp = variantsTmp;
        this.originalRegion = originalRegion;
        this.chromName = variantsTmp.get(0).getChromosome().getName();
        if (this.resultRegions == null) {
            this.resultRegions = new List();
        } else {
            this.resultRegions.clear();
            this.resultRegions = new List();
        }
    }

    public void setMeta(String caseMeta, String controlMeta) {
        this.caseMeta = caseMeta;
        this.controlMeta = controlMeta;
    }

    public List<GenomeRegion> getResultRegions() {
        return this.resultRegions;
    }

    public void executeWithVarSize() throws REngineException, REXPMismatchException {
        if (this.result != null) {
            this.result.clear();
        }
        List<Region> regions = new List<Region>();
        StringBuilder regionLabel = null;
        List<Variant> regionVariants = new List<Variant>();
        boolean flag = false;
        for (int varSize : this.varInRegion) {
            int startPos;
            int endPos;
            int index2;
            int index1;
            int regionEnd;
            int regionSize;
            int regionStart = -1;
            for (Variant var : this.variantsTmp) {
                if (regionStart < 0 || regionVariants.size() == varSize || var.getPosition() - regionStart > this.lengthThreshold) {
                    if (!regionVariants.isEmpty()) {
                        Region region = new Region(this.originalRegion.getLabel(), this.originalRegion.getType());
                        switch (this.TestType) {
                            case "RankSum": {
                                flag = region.rankSum(this.rcon, regionVariants, this.caseMeta, this.controlMeta, this.nonZeroRatio);
                                break;
                            }
                            case "ChiTest": {
                                region.chiTest(regionVariants);
                            }
                        }
                        if (!flag) {
                            regionVariants.clear();
                            continue;
                        }
                        regionSize = regionVariants.size();
                        regionEnd = regionVariants.get(regionSize - 1).getPosition();
                        regionLabel.append(regionEnd);
                        region.setLength(regionEnd - regionStart + 1);
                        region.setType(this.originalRegion.getType());
                        regions.add(region);
                        index1 = regionLabel.indexOf("-");
                        index2 = regionLabel.indexOf(":");
                        regionVariants.clear();
                        endPos = Integer.parseInt(regionLabel.substring(index1 + 1));
                        startPos = Integer.parseInt(regionLabel.substring(index2 + 1, index1));
                        region.setCoordinate(Chromosome.get(this.chromName), startPos, endPos);
                    }
                    regionStart = var.getPosition();
                    regionLabel = new StringBuilder(this.chromName + ":" + regionStart + "-");
                }
                regionVariants.add(var);
            }
            if (regionVariants.isEmpty() || regionVariants.size() == 1) continue;
            Region region = new Region(this.originalRegion.getLabel(), this.originalRegion.getType());
            switch (this.TestType) {
                case "RankSum": {
                    flag = region.rankSum(this.rcon, regionVariants, this.caseMeta, this.controlMeta, this.nonZeroRatio);
                    break;
                }
                case "ChiTest": {
                    region.chiTest(regionVariants);
                }
            }
            if (!flag) {
                regionVariants.clear();
                continue;
            }
            regionSize = regionVariants.size();
            regionEnd = regionVariants.get(regionSize - 1).getPosition();
            regionLabel.append(regionEnd);
            region.setLength(regionEnd - regionStart + 1);
            region.setType(this.originalRegion.getType());
            regions.add(region);
            index1 = regionLabel.indexOf("-");
            index2 = regionLabel.indexOf(":");
            regionVariants.clear();
            endPos = Integer.parseInt(regionLabel.substring(index1 + 1));
            startPos = Integer.parseInt(regionLabel.substring(index2 + 1, index1));
            region.setCoordinate(Chromosome.get(this.chromName), startPos, endPos);
        }
        this.getNewResults(regions);
    }

    public void executeWithRegionLength() throws REngineException, REXPMismatchException {
        if (this.result != null) {
            this.result.clear();
        }
        List<Region> regions = new List<Region>();
        StringBuilder regionLabel = null;
        List<Variant> regionVariants = new List<Variant>();
        boolean flag = false;
        for (int windowLen : this.windowLength) {
            int startPos;
            int endPos;
            int index2;
            int index1;
            int regionEnd;
            int regionSize;
            int regionStart = -1;
            for (Variant var : this.variantsTmp) {
                if (regionStart < 0 || var.getPosition() - regionStart > windowLen) {
                    if (!regionVariants.isEmpty()) {
                        Region region = new Region(this.originalRegion.getLabel(), this.originalRegion.getType());
                        switch (this.TestType) {
                            case "RankSum": {
                                flag = region.rankSum(this.rcon, regionVariants, this.caseMeta, this.controlMeta, this.nonZeroRatio);
                                break;
                            }
                            case "ChiTest": {
                                region.chiTest(regionVariants);
                            }
                        }
                        if (!flag) {
                            regionVariants.clear();
                            continue;
                        }
                        regionSize = regionVariants.size();
                        regionEnd = regionVariants.get(regionSize - 1).getPosition();
                        regionLabel.append(regionEnd);
                        region.setLength(regionEnd - regionStart + 1);
                        region.setType(this.originalRegion.getType());
                        regions.add(region);
                        index1 = regionLabel.indexOf("-");
                        index2 = regionLabel.indexOf(":");
                        regionVariants.clear();
                        endPos = Integer.parseInt(regionLabel.substring(index1 + 1));
                        startPos = Integer.parseInt(regionLabel.substring(index2 + 1, index1));
                        region.setCoordinate(Chromosome.get(this.chromName), startPos, endPos);
                    }
                    regionStart = var.getPosition();
                    regionLabel = new StringBuilder(this.chromName + ":" + regionStart + "-");
                }
                regionVariants.add(var);
            }
            if (regionVariants.isEmpty() || regionVariants.size() == 1) continue;
            Region region = new Region(this.originalRegion.getLabel(), this.originalRegion.getType());
            switch (this.TestType) {
                case "RankSum": {
                    flag = region.rankSum(this.rcon, regionVariants, this.caseMeta, this.controlMeta, this.nonZeroRatio);
                    break;
                }
                case "ChiTest": {
                    region.chiTest(regionVariants);
                }
            }
            if (!flag) {
                regionVariants.clear();
                continue;
            }
            regionSize = regionVariants.size();
            regionEnd = regionVariants.get(regionSize - 1).getPosition();
            regionLabel.append(regionEnd);
            region.setLength(regionEnd - regionStart + 1);
            region.setType(this.originalRegion.getType());
            regions.add(region);
            index1 = regionLabel.indexOf("-");
            index2 = regionLabel.indexOf(":");
            regionVariants.clear();
            endPos = Integer.parseInt(regionLabel.substring(index1 + 1));
            startPos = Integer.parseInt(regionLabel.substring(index2 + 1, index1));
            region.setCoordinate(Chromosome.get(this.chromName), startPos, endPos);
        }
        this.getNewResults(regions);
    }

    public void getNewResults(List<Region> regions) {
        this.result = DynamicScanWindows.excludeRegions(regions, this.ratio, this.cutoff);
        this.result.sort((Comparator<Region>)new Comparator<GenomeRegion>(){

            @Override
            public int compare(GenomeRegion o1, GenomeRegion o2) {
                return Integer.compare(o1.start, o2.start);
            }
        });
        this.retype(this.result);
        for (int i = 0; i < this.result.size(); ++i) {
            Region tmp = this.result.get(i);
            List<Variant> tmpVariants = tmp.getVariants();
            GenomeRegion gr = new GenomeRegion(tmp.getLabel(), tmp.getType());
            gr.setCoordinate(tmp.getChromID(), tmp.getStart(), tmp.getEnd());
            gr.setStartPointer(tmp.getStartPointer());
            gr.setEndPointer(tmp.getEndPointer());
            gr.setOutcomeVarPointers(tmp.getOutcomeVarPointers());
            switch (this.TestType) {
                case "CHiTest": {
                    gr.setP(tmp.pvalue);
                    break;
                }
            }
            for (Variant var : tmpVariants) {
                gr.addVariant(var);
            }
            this.resultRegions.add(gr);
        }
        this.result.clear();
        this.variantsTmp.clear();
    }

    public void retype(List<Region> regions) {
        int windowIndex = 1;
        for (Region region : regions) {
            region.windowIndex = windowIndex;
            region.setType(windowIndex * this.scale + region.getType());
            ++windowIndex;
        }
    }

    public void changeGeneSubRegionLength(Map<Integer, Map<Integer, int[]>> geneSubRegionLength, IndexableSet<String> geneSymbMap) {
        Map<Integer, int[]> typeLength = geneSubRegionLength.get(Integer.parseInt(this.originalRegion.getLabel()));
        if (typeLength == null) {
            return;
        }
        for (GenomeRegion gr : this.resultRegions) {
            typeLength.put(gr.getType(), new int[]{gr.getEnd() - gr.getStart() + 1, gr.getStart(), gr.getEnd()});
        }
    }

    public static List<Region> excludeRegions(List<Region> regions, float ratio, float cutoff) {
        List<Region> result = new List<Region>();
        if (regions.isEmpty()) {
            return result;
        }
        regions.sort(new Comparator<Region>(){

            @Override
            public int compare(Region o1, Region o2) {
                int pValueComparison = Double.compare(o1.pvalue, o2.pvalue);
                if (pValueComparison != 0) {
                    return pValueComparison;
                }
                return Integer.compare(o1.getVariants().size(), o2.getVariants().size());
            }
        });
        while (!regions.isEmpty()) {
            double[] pV = DynamicScanWindows.getPValues(regions);
            double fdr = DynamicScanWindows.getInstance().correction ? Summary.benjaminiHochbergFDR((double)cutoff, pV) : (double)cutoff;
            Region target = regions.get(0);
            if (target.pvalue > fdr) break;
            regions.remove(target);
            result.add(target);
            DynamicScanWindows.removeRepeatRegion(regions, target, ratio);
        }
        regions.clear();
        return result;
    }

    public static boolean needRemove(Region region, Region target, float ratio) {
        int start = target.start;
        int end = target.end;
        int tmpStart = region.start;
        int tmpEnd = region.end;
        int len = end - start;
        int tmpLen = tmpEnd - tmpStart;
        boolean flag = region.equals(target);
        int overlapStart = Math.max(start, tmpStart);
        int overlapEnd = Math.min(end, tmpEnd);
        int overlapLen = Math.max(0, overlapEnd - overlapStart);
        if (tmpStart >= start && tmpEnd <= end) {
            return true;
        }
        if (tmpStart < start && tmpEnd > end) {
            return (float)overlapLen / (float)tmpLen >= ratio || flag;
        }
        if (tmpStart <= start && start < tmpEnd) {
            return (float)overlapLen / (float)tmpLen >= ratio || flag || (float)overlapLen / (float)len >= ratio;
        }
        if (tmpStart <= end && end < tmpEnd) {
            return (float)overlapLen / (float)tmpLen >= ratio || flag || (float)overlapLen / (float)len >= ratio;
        }
        if (tmpEnd < start || tmpStart > end) {
            return false;
        }
        return flag;
    }

    public static void removeRepeatRegion(List<Region> regionList, Region target, float ratio) {
        for (Region region : regionList) {
            if (!DynamicScanWindows.needRemove(region, target, ratio)) continue;
            regionList.remove(region);
        }
    }

    public static void main(String[] args) {
        List<Region> regions = new List<Region>();
        Region a = new Region("a", 1);
        a.setCoordinate(Chromosome.get(1), 50, 100);
        regions.add(a);
        Region aa = new Region("a", 1);
        aa.setCoordinate(Chromosome.get(1), 50, 100);
        regions.add(aa);
        Region b = new Region("b", 1);
        b.setCoordinate(Chromosome.get(1), 70, 90);
        regions.add(b);
        Region c = new Region("c", 1);
        c.setCoordinate(Chromosome.get(1), 51, 101);
        regions.add(c);
        Region d = new Region("d", 1);
        d.setCoordinate(Chromosome.get(1), 45, 89);
        regions.add(d);
        Region e = new Region("e", 1);
        e.setCoordinate(Chromosome.get(1), 101, 200);
        regions.add(e);
        Region f = new Region("f", 1);
        f.setCoordinate(Chromosome.get(1), 70, 110);
        regions.add(f);
        DynamicScanWindows.removeRepeatRegion(regions, a, 0.8f);
    }

    public static double[] getPValues(List<Region> regions) {
        int size = regions.size();
        double[] pV = new double[size];
        for (int i = 0; i < size; ++i) {
            pV[i] = regions.get((int)i).pvalue;
        }
        return pV;
    }

    public static boolean endCondition(List<Region> regions, double cutoff) {
        if (regions.isEmpty()) {
            return true;
        }
        boolean flag = true;
        double[] pV = DynamicScanWindows.getPValues(regions);
        double fdr = Summary.benjaminiHochbergFDR(cutoff, pV);
        for (Region region : regions) {
            if (!(region.pvalue < fdr)) continue;
            return false;
        }
        return flag;
    }

    public boolean judgeByLength(List<Variant> variants) {
        int start = variants.get(0).getPosition();
        int end = variants.get(variants.size() - 1).getPosition();
        return end - start + 1 > this.lengthThreshold;
    }

    public boolean judgeBySize(List<Variant> variantsTmp) {
        return variantsTmp.size() > this.variantSizeThreshold;
    }

    public boolean judge(Map<Integer, Map<Integer, int[]>> geneSubRegionLength, GenomeRegion gene) {
        Map<Integer, int[]> typeLength = geneSubRegionLength.get(Integer.parseInt(gene.getLabel()));
        if (typeLength == null) {
            return false;
        }
        if (typeLength.size() == 1) {
            return false;
        }
        int[] length = typeLength.get(gene.getType());
        if (length == null) {
            return false;
        }
        return length[0] > this.lengthThreshold;
    }

    public boolean scanSignificant() {
        return !this.resultRegions.isEmpty();
    }

    public void useFDRCorrection(boolean useFDRCorrection) {
        this.correction = useFDRCorrection;
    }

    public static class DynamicScanThread
    implements ITask {
        int[] windowLength;
        int[] varInRegion;
        List<Variant> variantsTmp;
        String chromName;
        RConnection rcon;
        List<GenomeRegion> resultRegions;
        List<Region> result;
        InetSocketAddress rServer;
        String rHost;
        int rPort;
        int lengthThreshold;
        int variantSizeThreshold;
        String caseMeta;
        String controlMeta;
        GenomeRegion originalRegion;
        boolean useScan;
        int scale;
        String TestType;
        float ratio;
        float cutoff;
        float nonZeroRatio;
        boolean scanBySizeORLength;
        boolean correction = true;

        public DynamicScanThread() {
            this.windowLength = instance.windowLength;
            this.varInRegion = instance.varInRegion;
            this.rServer = instance.rServer;
            this.rPort = instance.rPort;
            this.rcon = instance.rcon;
            this.rHost = instance.rHost;
            this.lengthThreshold = instance.lengthThreshold;
            this.variantSizeThreshold = instance.variantSizeThreshold;
            this.caseMeta = instance.caseMeta;
            this.controlMeta = instance.controlMeta;
            this.useScan = instance.useScan;
            this.scale = instance.scale;
            this.TestType = instance.TestType;
            this.ratio = instance.ratio;
            this.cutoff = instance.cutoff;
            this.nonZeroRatio = instance.nonZeroRatio;
        }

        public void setTask(List<Variant> variantsTmp, GenomeRegion originalRegion, boolean scanBySizeORLength) {
            this.variantsTmp = variantsTmp.clone();
            this.originalRegion = originalRegion;
            this.chromName = this.variantsTmp.get(0).getChromosome().getName();
            this.resultRegions = new List();
            this.scanBySizeORLength = scanBySizeORLength;
        }

        @Override
        public void execute(Status status, Context context) throws Exception, Error {
            this.rcon = new RConnection(this.rHost, this.rPort);
            if (this.scanBySizeORLength) {
                this.executeWithVarSize();
            } else {
                this.executeWithRegionLength();
            }
            this.fireTaskComplete();
        }

        protected void fireTaskComplete() {
        }

        public List<GenomeRegion> getResultRegions() {
            return this.resultRegions;
        }

        public void executeWithVarSize() throws REngineException, REXPMismatchException {
            if (this.result != null) {
                this.result.clear();
            }
            List<Region> regions = new List<Region>();
            StringBuilder regionLabel = null;
            List<Variant> regionVariants = new List<Variant>();
            int minSize = this.varInRegion[0];
            int minLength = this.windowLength[0];
            int maxPos = this.variantsTmp.get(this.variantsTmp.size() - 1).getPosition();
            boolean flag = false;
            for (int varSize : this.varInRegion) {
                int startPos;
                int endPos;
                int index2;
                int index1;
                int regionEnd;
                int regionSize;
                int regionStart = -1;
                for (int i = 0; i < this.variantsTmp.size(); ++i) {
                    Variant var = this.variantsTmp.get(i);
                    if (regionStart < 0 || regionVariants.size() == varSize && this.variantsTmp.size() - i >= minSize) {
                        if (!regionVariants.isEmpty()) {
                            Region region = new Region(this.originalRegion.getLabel(), this.originalRegion.getType());
                            switch (this.TestType) {
                                case "RankSum": {
                                    flag = region.rankSum(this.rcon, regionVariants, this.caseMeta, this.controlMeta, this.nonZeroRatio);
                                    break;
                                }
                                case "ChiTest": {
                                    region.chiTest(regionVariants);
                                }
                            }
                            if (!flag) {
                                regionVariants.clear();
                                continue;
                            }
                            regionSize = regionVariants.size();
                            regionEnd = regionVariants.get(regionSize - 1).getPosition();
                            regionLabel.append(regionEnd);
                            region.setLength(regionEnd - regionStart + 1);
                            region.setType(this.originalRegion.getType());
                            regions.add(region);
                            index1 = regionLabel.indexOf("-");
                            index2 = regionLabel.indexOf(":");
                            regionVariants.clear();
                            endPos = Integer.parseInt(regionLabel.substring(index1 + 1));
                            startPos = Integer.parseInt(regionLabel.substring(index2 + 1, index1));
                            region.setCoordinate(Chromosome.get(this.chromName), startPos, endPos);
                        }
                        regionStart = var.getPosition();
                        regionLabel = new StringBuilder(this.chromName + ":" + regionStart + "-");
                    }
                    regionVariants.add(var);
                }
                if (regionVariants.isEmpty() || regionVariants.size() == 1) continue;
                Region region = new Region(this.originalRegion.getLabel(), this.originalRegion.getType());
                switch (this.TestType) {
                    case "RankSum": {
                        flag = region.rankSum(this.rcon, regionVariants, this.caseMeta, this.controlMeta, this.nonZeroRatio);
                        break;
                    }
                    case "ChiTest": {
                        region.chiTest(regionVariants);
                    }
                }
                if (!flag) {
                    regionVariants.clear();
                    continue;
                }
                regionSize = regionVariants.size();
                regionEnd = regionVariants.get(regionSize - 1).getPosition();
                regionLabel.append(regionEnd);
                region.setLength(regionEnd - regionStart + 1);
                region.setType(this.originalRegion.getType());
                regions.add(region);
                index1 = regionLabel.indexOf("-");
                index2 = regionLabel.indexOf(":");
                regionVariants.clear();
                endPos = Integer.parseInt(regionLabel.substring(index1 + 1));
                startPos = Integer.parseInt(regionLabel.substring(index2 + 1, index1));
                region.setCoordinate(Chromosome.get(this.chromName), startPos, endPos);
            }
            this.getNewResults(regions);
            this.rcon.close();
        }

        public void executeWithRegionLength() throws REngineException, REXPMismatchException {
            if (this.result != null) {
                this.result.clear();
            }
            List<Region> regions = new List<Region>();
            StringBuilder regionLabel = null;
            List<Variant> regionVariants = new List<Variant>();
            boolean flag = false;
            for (int windowLen : this.windowLength) {
                int startPos;
                int endPos;
                int index2;
                int index1;
                int regionEnd;
                int regionSize;
                int regionStart = -1;
                for (Variant var : this.variantsTmp) {
                    if (regionStart < 0 || var.getPosition() - regionStart > windowLen) {
                        if (!regionVariants.isEmpty()) {
                            Region region = new Region(this.originalRegion.getLabel(), this.originalRegion.getType());
                            switch (this.TestType) {
                                case "RankSum": {
                                    flag = region.rankSum(this.rcon, regionVariants, this.caseMeta, this.controlMeta, this.nonZeroRatio);
                                    break;
                                }
                                case "ChiTest": {
                                    region.chiTest(regionVariants);
                                }
                            }
                            if (!flag) {
                                regionVariants.clear();
                                continue;
                            }
                            regionSize = regionVariants.size();
                            regionEnd = regionVariants.get(regionSize - 1).getPosition();
                            regionLabel.append(regionEnd);
                            region.setLength(regionEnd - regionStart + 1);
                            region.setType(this.originalRegion.getType());
                            regions.add(region);
                            index1 = regionLabel.indexOf("-");
                            index2 = regionLabel.indexOf(":");
                            regionVariants.clear();
                            endPos = Integer.parseInt(regionLabel.substring(index1 + 1));
                            startPos = Integer.parseInt(regionLabel.substring(index2 + 1, index1));
                            region.setCoordinate(Chromosome.get(this.chromName), startPos, endPos);
                        }
                        regionStart = var.getPosition();
                        regionLabel = new StringBuilder(this.chromName + ":" + regionStart + "-");
                    }
                    regionVariants.add(var);
                }
                if (regionVariants.isEmpty() || regionVariants.size() == 1) continue;
                Region region = new Region(this.originalRegion.getLabel(), this.originalRegion.getType());
                switch (this.TestType) {
                    case "RankSum": {
                        flag = region.rankSum(this.rcon, regionVariants, this.caseMeta, this.controlMeta, this.nonZeroRatio);
                        break;
                    }
                    case "ChiTest": {
                        region.chiTest(regionVariants);
                    }
                }
                if (!flag) {
                    regionVariants.clear();
                    continue;
                }
                regionSize = regionVariants.size();
                regionEnd = regionVariants.get(regionSize - 1).getPosition();
                regionLabel.append(regionEnd);
                region.setLength(regionEnd - regionStart + 1);
                region.setType(this.originalRegion.getType());
                regions.add(region);
                index1 = regionLabel.indexOf("-");
                index2 = regionLabel.indexOf(":");
                regionVariants.clear();
                endPos = Integer.parseInt(regionLabel.substring(index1 + 1));
                startPos = Integer.parseInt(regionLabel.substring(index2 + 1, index1));
                region.setCoordinate(Chromosome.get(this.chromName), startPos, endPos);
            }
            this.getNewResults(regions);
        }

        public void getNewResults(List<Region> regions) {
            this.result = DynamicScanThread.excludeRegions(regions, this.ratio, this.cutoff);
            this.result.sort((Comparator<Region>)new Comparator<GenomeRegion>(){

                @Override
                public int compare(GenomeRegion o1, GenomeRegion o2) {
                    return Integer.compare(o1.start, o2.start);
                }
            });
            this.retype(this.result);
            for (int i = 0; i < this.result.size(); ++i) {
                Region tmp = this.result.get(i);
                List<Variant> tmpVariants = tmp.getVariants();
                GenomeRegion gr = new GenomeRegion(tmp.getLabel(), tmp.getType());
                gr.setCoordinate(tmp.getChromID(), tmp.getStart(), tmp.getEnd());
                gr.setStartPointer(tmp.getStartPointer());
                gr.setEndPointer(tmp.getEndPointer());
                gr.setOutcomeVarPointers(tmp.getOutcomeVarPointers());
                switch (this.TestType) {
                    case "CHiTest": {
                        gr.setP(tmp.pvalue);
                        break;
                    }
                }
                for (Variant var : tmpVariants) {
                    gr.addVariant(var);
                }
                this.resultRegions.add(gr);
            }
            this.result.clear();
            this.variantsTmp.clear();
        }

        public void retype(List<Region> regions) {
            int windowIndex = 1;
            for (Region region : regions) {
                region.windowIndex = windowIndex;
                region.setType(windowIndex * this.scale + region.getType());
                ++windowIndex;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void changeGeneSubRegionLength(Map<Integer, Map<Integer, int[]>> geneSubRegionLength, IndexableSet<String> geneSymbMap) {
            Map<Integer, int[]> typeLength = geneSubRegionLength.get(Integer.parseInt(this.originalRegion.getLabel()));
            if (typeLength == null) {
                return;
            }
            Map<Integer, Map<Integer, int[]>> map = geneSubRegionLength;
            synchronized (map) {
                for (GenomeRegion gr : this.resultRegions) {
                    typeLength.put(gr.getType(), new int[]{gr.getEnd() - gr.getStart() + 1, gr.getStart(), gr.getEnd()});
                }
            }
        }

        public static List<Region> excludeRegions(List<Region> regions, float ratio, float cutoff) {
            List<Region> result = new List<Region>();
            if (regions.isEmpty()) {
                return result;
            }
            regions.sort(new Comparator<Region>(){

                @Override
                public int compare(Region o1, Region o2) {
                    int pValueComparison = Double.compare(o1.pvalue, o2.pvalue);
                    if (pValueComparison != 0) {
                        return pValueComparison;
                    }
                    return Integer.compare(o1.getVariants().size(), o2.getVariants().size());
                }
            });
            while (!regions.isEmpty()) {
                double[] pV = DynamicScanThread.getPValues(regions);
                double fdr = DynamicScanWindows.getInstance().correction ? Summary.benjaminiHochbergFDR((double)cutoff, pV) : (double)cutoff;
                Region target = regions.get(0);
                if (target.pvalue > fdr) break;
                regions.remove(target);
                result.add(target);
                DynamicScanThread.removeRepeatRegion(regions, target, ratio);
            }
            regions.clear();
            return result;
        }

        public static boolean needRemove(Region region, Region target, float ratio) {
            int start = target.start;
            int end = target.end;
            int tmpStart = region.start;
            int tmpEnd = region.end;
            int len = end - start;
            int tmpLen = tmpEnd - tmpStart;
            boolean flag = region.equals(target);
            int overlapStart = Math.max(start, tmpStart);
            int overlapEnd = Math.min(end, tmpEnd);
            int overlapLen = Math.max(0, overlapEnd - overlapStart);
            if (tmpStart >= start && tmpEnd <= end) {
                return true;
            }
            if (tmpStart < start && tmpEnd > end) {
                return (float)overlapLen / (float)tmpLen >= ratio || flag;
            }
            if (tmpStart <= start && start < tmpEnd) {
                return (float)overlapLen / (float)tmpLen >= ratio || flag || (float)overlapLen / (float)len >= ratio;
            }
            if (tmpStart <= end && end < tmpEnd) {
                return (float)overlapLen / (float)tmpLen >= ratio || flag || (float)overlapLen / (float)len >= ratio;
            }
            if (tmpEnd < start || tmpStart > end) {
                return false;
            }
            return flag;
        }

        public static void removeRepeatRegion(List<Region> regionList, Region target, float ratio) {
            for (Region region : regionList) {
                if (!DynamicScanThread.needRemove(region, target, ratio)) continue;
                regionList.remove(region);
            }
        }

        public static double[] getPValues(List<Region> regions) {
            int size = regions.size();
            double[] pV = new double[size];
            for (int i = 0; i < size; ++i) {
                pV[i] = regions.get((int)i).pvalue;
            }
            return pV;
        }

        public static boolean endCondition(List<Region> regions, double cutoff) {
            if (regions.isEmpty()) {
                return true;
            }
            boolean flag = true;
            double[] pV = DynamicScanThread.getPValues(regions);
            double fdr = Summary.benjaminiHochbergFDR(cutoff, pV);
            for (Region region : regions) {
                if (!(region.pvalue < fdr)) continue;
                return false;
            }
            return flag;
        }

        public boolean judgeByLength(List<Variant> variants) {
            int start = variants.get(0).getPosition();
            int end = variants.get(variants.size() - 1).getPosition();
            return end - start + 1 > this.lengthThreshold;
        }

        public boolean judgeBySize(List<Variant> variantsTmp) {
            return variantsTmp.size() > this.variantSizeThreshold;
        }

        public boolean judge(Map<Integer, Map<Integer, int[]>> geneSubRegionLength, GenomeRegion gene) {
            Map<Integer, int[]> typeLength = geneSubRegionLength.get(Integer.parseInt(gene.getLabel()));
            if (typeLength == null) {
                return false;
            }
            if (typeLength.size() == 1) {
                return false;
            }
            int[] length = typeLength.get(gene.getType());
            if (length == null) {
                return false;
            }
            return length[0] > this.lengthThreshold;
        }

        public boolean scanSignificant() {
            return !this.resultRegions.isEmpty();
        }

        public void useFDRCorrection(boolean useFDRCorrection) {
            this.correction = useFDRCorrection;
        }
    }

    public static class Region
    extends GenomeRegion {
        double pvalue;
        int hashCode;
        int windowIndex;
        int length;
        int[] table;
        double[] caseAC;
        double[] popAC;

        public Region(String regionLabel, int type) {
            super(regionLabel, type);
        }

        public void setLength(int length) {
            this.length = length;
        }

        public int getLength() {
            return this.length;
        }

        public void setTable(int[] table) {
            this.table = table;
        }

        public boolean rankSum(RConnection rcon, List<Variant> variants, String caseMeta, String controlMeta, float nonZeroRatio) throws REngineException {
            this.hashCode = variants.hashCode();
            this.getVariants().addAll(variants);
            int size = variants.size();
            double[] caseAC = new double[size];
            double[] controlAC = new double[size];
            float nonZeroCount = 0.0f;
            for (int i = 0; i < size; ++i) {
                Variant variant = variants.get(i);
                caseAC[i] = ((Number)variant.getProperty(caseMeta)).doubleValue();
                controlAC[i] = ((Number)variant.getProperty(controlMeta)).doubleValue();
                if (!(caseAC[i] + controlAC[i] > 0.0)) continue;
                nonZeroCount += 1.0f;
            }
            this.caseAC = caseAC;
            this.popAC = controlAC;
            if (nonZeroCount / (float)size < nonZeroRatio) {
                this.pvalue = 1.0;
                return false;
            }
            rcon.assign("x1", caseAC);
            rcon.assign("x2", controlAC);
            try {
                this.pvalue = rcon.eval("wilcox.test(x1, x2 , alternative = \"greater\", paired  = T, exact = F)$p.value").asDouble();
            }
            catch (Exception e) {
                this.pvalue = 1.0;
            }
            return true;
        }

        public void chiTest(List<Variant> regionVariants) throws REngineException, REXPMismatchException {
            this.pvalue = this.getPValueByACAT(regionVariants);
        }

        public int[] calculateContingencyTables(List<Variant> variants) {
            int case_alt = 0;
            int case_ref = 0;
            int control_alt = 0;
            int control_ref = 0;
            double adj_alt = 0.0;
            double adj_ref = 0.0;
            for (Variant var : variants) {
                int refHot_case = (Integer)var.getProperty("GTYSUM@RefHomGtyNum_CASE");
                int het_case = (Integer)var.getProperty("GTYSUM@HetGtyNum_CASE");
                int altHot_case = (Integer)var.getProperty("GTYSUM@AltHomGtyNum_CASE");
                int missing_case = (Integer)var.getProperty("GTYSUM@MissingGtyNum_CASE");
                int refHot_control = (Integer)var.getProperty("GTYSUM@RefHomGtyNum_CONTROL");
                int het_control = (Integer)var.getProperty("GTYSUM@HetGtyNum_CONTROL");
                int altHot_control = (Integer)var.getProperty("GTYSUM@AltHomGtyNum_CONTROL");
                int missing_control = (Integer)var.getProperty("GTYSUM@MissingGtyNum_CONTROL");
                int case_Num = refHot_case + het_case + altHot_case - missing_case;
                int control_Num = refHot_control + het_control + altHot_control - missing_control;
                double adj_freq = ((Number)var.getProperty("GTYSUM@ADJ_FREQ")).doubleValue();
                case_ref += refHot_case * 2 + het_case;
                case_alt += altHot_case * 2 + het_case;
                control_ref += refHot_control * 2 + het_control;
                control_alt += altHot_control * 2 + het_control;
            }
            return new int[]{case_alt, case_ref, control_alt, control_ref};
        }

        public double getPValueByACATInR(RConnection rcon, List<Variant> variants) throws REngineException, REXPMismatchException {
            double T = 0.0;
            DoubleList pList = new DoubleList();
            for (Variant variant : variants) {
                int[] table = this.getTableInVar(variant);
                double p = this.getPValue(rcon, table);
                pList.add(p);
            }
            for (int i = 0; i < pList.size(); ++i) {
                double pV = pList.get(i);
                T += Math.tan((0.5 - pV) * Math.PI) / (double)pList.size();
            }
            return 0.5 - Math.atan(T) / Math.PI;
        }

        public double getPValueByACAT(List<Variant> variants) throws REngineException, REXPMismatchException {
            int[] resultTable = new int[4];
            double T = 0.0;
            DoubleList pList = new DoubleList();
            FisherExact fe = new FisherExact(50000);
            for (Variant variant : variants) {
                int[] table = this.getTableInVar(variant);
                for (int i = 0; i < table.length; ++i) {
                    int n = i;
                    resultTable[n] = resultTable[n] + table[i];
                }
                double p = fe.getRightTailedP(table[0], table[1], table[2], table[3]);
                pList.add(p);
            }
            this.setTable(resultTable);
            for (int i = 0; i < pList.size(); ++i) {
                double pV = pList.get(i);
                T += Math.tan((0.5 - pV) * Math.PI) / (double)pList.size();
            }
            return 0.5 - Math.atan(T) / Math.PI;
        }

        public double getPValue(RConnection rcon, int[] table) throws REngineException, REXPMismatchException {
            rcon.assign("table", table);
            rcon.eval("observed <- matrix(table, nrow = 2, byrow = FALSE)");
            rcon.eval("colnames(observed) <- c(\"CASE\", \"CONTROL\")");
            rcon.eval("rownames(observed) <- c(\"ALT\", \"REF\")");
            rcon.eval("p <- fisher.test(observed,alternative=\"greater\")$p.value");
            return rcon.eval("p").asDouble();
        }

        public int[] getTableInVar(Variant var) {
            int case_alt = 0;
            int case_ref = 0;
            int control_alt = 0;
            int control_ref = 0;
            int refHot_case = (Integer)var.getProperty("GTYSUM@RefHomGtyNum_CASE");
            int het_case = (Integer)var.getProperty("GTYSUM@HetGtyNum_CASE");
            int altHot_case = (Integer)var.getProperty("GTYSUM@AltHomGtyNum_CASE");
            int missing_case = (Integer)var.getProperty("GTYSUM@MissingGtyNum_CASE");
            int refHot_control = (Integer)var.getProperty("GTYSUM@RefHomGtyNum_CONTROL");
            int het_control = (Integer)var.getProperty("GTYSUM@HetGtyNum_CONTROL");
            int altHot_control = (Integer)var.getProperty("GTYSUM@AltHomGtyNum_CONTROL");
            int missing_control = (Integer)var.getProperty("GTYSUM@MissingGtyNum_CONTROL");
            return new int[]{case_alt += altHot_case * 2 + het_case, case_ref += refHot_case * 2 + het_case, control_alt += altHot_control * 2 + het_control, control_ref += refHot_control * 2 + het_control};
        }
    }
}

