/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.stat;

import cern.colt.list.IntArrayList;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.linalg.EigenvalueDecomposition;

public enum EffectiveNumberEstimator {
    INSTANCE;


    public static double[] calculateEffectiveIndexesDiff(DoubleMatrix2D corrMat, int[] indexes) {
        int i;
        int size = indexes.length;
        double[] effIndexes = new double[size];
        effIndexes[0] = 1.0;
        if (indexes.length == 1) {
            return effIndexes;
        }
        IntArrayList selectedSampleIndex = new IntArrayList();
        selectedSampleIndex.add(indexes[0]);
        for (i = 1; i < size; ++i) {
            selectedSampleIndex.add(indexes[i]);
            effIndexes[i] = EffectiveNumberEstimator.calculateEffectSampleSize(corrMat, selectedSampleIndex);
        }
        for (i = size - 1; i > 0; --i) {
            effIndexes[i] = effIndexes[i] - effIndexes[i - 1];
        }
        return effIndexes;
    }

    public static double calculateEffectSampleSize(DoubleMatrix2D corrMat, IntArrayList selectedSampleIndex) {
        int newSampleSize = corrMat.rows();
        if (selectedSampleIndex == null) {
            selectedSampleIndex = new IntArrayList();
            for (int i = 0; i < newSampleSize; ++i) {
                selectedSampleIndex.add(i);
            }
        }
        if (selectedSampleIndex.isEmpty()) {
            return 0.0;
        }
        newSampleSize = selectedSampleIndex.size();
        double[][] subMatrix = new double[newSampleSize][newSampleSize];
        newSampleSize = selectedSampleIndex.size();
        for (int i = 0; i < newSampleSize; ++i) {
            subMatrix[i][i] = 1.0;
            for (int j = i + 1; j < newSampleSize; ++j) {
                subMatrix[i][j] = corrMat.getQuick(selectedSampleIndex.getQuick(i), selectedSampleIndex.getQuick(j));
                subMatrix[i][j] = Math.abs(subMatrix[i][j]);
                subMatrix[j][i] = subMatrix[i][j];
            }
        }
        if (newSampleSize == 1) {
            return 1.0;
        }
        double effectSampleSize = newSampleSize;
        long time = System.nanoTime();
        DenseDoubleMatrix2D poweredCorrMat = new DenseDoubleMatrix2D(subMatrix);
        EigenvalueDecomposition ed = new EigenvalueDecomposition(poweredCorrMat);
        DoubleMatrix1D eVR = ed.getRealEigenvalues();
        for (int i = 0; i < newSampleSize; ++i) {
            if (Double.isNaN(eVR.get(i))) {
                System.err.println("NaN error for eigen values!");
            }
            if (!(eVR.getQuick(i) > 1.0)) continue;
            effectSampleSize -= eVR.getQuick(i) - 1.0;
        }
        time = System.nanoTime() - time;
        return effectSampleSize;
    }
}

