/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.stat;

public class FisherExact {
    private double[] f;
    int maxSize;

    public FisherExact(int maxSize) {
        this.maxSize = maxSize;
        this.f = new double[maxSize + 1];
        this.f[0] = 0.0;
        for (int i = 1; i <= this.maxSize; ++i) {
            this.f[i] = this.f[i - 1] + Math.log(i);
        }
    }

    public final double getP(int a, int b, int c, int d) {
        int n = a + b + c + d;
        if (n > this.maxSize) {
            return Double.NaN;
        }
        double p = this.f[a + b] + this.f[c + d] + this.f[a + c] + this.f[b + d] - (this.f[a] + this.f[b] + this.f[c] + this.f[d] + this.f[n]);
        return Math.exp(p);
    }

    public final double getCumlativeP(int a, int b, int c, int d) {
        int i;
        int min;
        int n = a + b + c + d;
        if (n > this.maxSize) {
            return Double.NaN;
        }
        double p = 0.0;
        p += this.getP(a, b, c, d);
        if (a * d >= b * c) {
            min = c < b ? c : b;
            for (i = 0; i < min; ++i) {
                p += this.getP(++a, --b, --c, ++d);
            }
        }
        if (a * d < b * c) {
            min = a < d ? a : d;
            for (i = 0; i < min; ++i) {
                double pTemp = this.getP(--a, ++b, ++c, --d);
                p += pTemp;
            }
        }
        return p;
    }

    public final double getRightTailedP(int a, int b, int c, int d) {
        int n = a + b + c + d;
        if (n > this.maxSize) {
            return Double.NaN;
        }
        double p = 0.0;
        p += this.getP(a, b, c, d);
        int min = c < b ? c : b;
        for (int i = 0; i < min; ++i) {
            p += this.getP(++a, --b, --c, ++d);
        }
        return p;
    }

    public final double getLeftTailedP(int a, int b, int c, int d) {
        int n = a + b + c + d;
        if (n > this.maxSize) {
            return Double.NaN;
        }
        double p = 0.0;
        p += this.getP(a, b, c, d);
        int min = a < d ? a : d;
        for (int i = 0; i < min; ++i) {
            double pTemp = this.getP(--a, ++b, ++c, --d);
            p += pTemp;
        }
        return p;
    }

    public final double getTwoTailedP(int a, int b, int c, int d) {
        int i;
        int n = a + b + c + d;
        if (n > this.maxSize) {
            return Double.NaN;
        }
        double p = 0.0;
        double baseP = this.getP(a, b, c, d);
        int initialA = a;
        int initialB = b;
        int initialC = c;
        int initialD = d;
        p += baseP;
        int min = c < b ? c : b;
        for (i = 0; i < min; ++i) {
            double tempP;
            if (!((tempP = this.getP(++a, --b, --c, ++d)) <= baseP)) continue;
            p += tempP;
        }
        a = initialA;
        b = initialB;
        c = initialC;
        d = initialD;
        min = a < d ? a : d;
        for (i = 0; i < min; ++i) {
            double pTemp;
            if (!((pTemp = this.getP(--a, ++b, ++c, --d)) <= baseP)) continue;
            p += pTemp;
        }
        return p;
    }

    public static double[] getOddsRatioAnd95thConfidenceInterval(double a, double b, double c, double d) {
        if (a == 0.0 || b == 0.0 || c == 0.0 || d == 0.0) {
            a += 0.5;
            b += 0.5;
            c += 0.5;
            d += 0.5;
        }
        double oddsRatio = a * d / (b * c);
        double inner = 1.96 * Math.sqrt(1.0 / a + 1.0 / b + 1.0 / c + 1.0 / d);
        double lnOR = Math.log(oddsRatio);
        double upper = Math.pow(Math.E, lnOR + inner);
        double lower = Math.pow(Math.E, lnOR - inner);
        return new double[]{oddsRatio, lower, upper};
    }

    public static double getOddsRatio(double a, double b, double c, double d) {
        return a * d / (b * c);
    }

    public static void main(String[] args) {
        int[][] argInts = new int[3][4];
        argInts[0] = new int[]{1, 2, 1, 10};
        argInts[1] = new int[]{10, 20, 10, 100};
        argInts[2] = new int[]{8, 2, 4, 6};
        FisherExact fe = new FisherExact(200);
        for (int i = 0; i < argInts.length; ++i) {
            System.out.println("\na=" + argInts[i][0] + " b=" + argInts[i][1] + " c=" + argInts[i][2] + " d=" + argInts[i][3]);
            double twoTailedP = fe.getTwoTailedP(argInts[i][0], argInts[i][1], argInts[i][2], argInts[i][3]);
            System.out.println("twoTailedP = " + twoTailedP);
            double leftTailedP = fe.getLeftTailedP(argInts[i][0], argInts[i][1], argInts[i][2], argInts[i][3]);
            System.out.println("leftTailedP = " + leftTailedP);
            double rightTailedP = fe.getRightTailedP(argInts[i][0], argInts[i][1], argInts[i][2], argInts[i][3]);
            System.out.println("rightTailedP = " + rightTailedP);
            double[] orLowerUpper = FisherExact.getOddsRatioAnd95thConfidenceInterval(argInts[i][0], argInts[i][1], argInts[i][2], argInts[i][3]);
            System.out.println("OR = " + orLowerUpper[0]);
            System.out.println("Lower = " + orLowerUpper[1]);
            System.out.println("Upper = " + orLowerUpper[2]);
        }
    }
}

