/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.stat;

import java.util.Arrays;

public enum HardyWeinbergCalculator {
    INSTANCE;


    public static double hwCalculate(int obsAA, int obsAB, int obsBB) {
        int diplotypes = obsAA + obsAB + obsBB;
        int rare = obsAA * 2 + obsAB;
        int hets = obsAB;
        if (rare > diplotypes) {
            rare = 2 * diplotypes - rare;
        }
        if (hets > rare) {
            return -1.0;
        }
        if (diplotypes == 0) {
            return 1.0;
        }
        double[] tailProbs = new double[rare + 1];
        Arrays.fill(tailProbs, 0.0);
        double rareD = rare;
        rareD = ((double)diplotypes - rareD / 2.0) / (double)diplotypes;
        int mid = (int)((double)rare * rareD);
        if ((rare & 1 ^ mid & 1) != 0) {
            ++mid;
        }
        int het = mid;
        int hom_r = (rare - mid) / 2;
        int hom_c = diplotypes - het - hom_r;
        tailProbs[mid] = 1.0;
        double sum = tailProbs[mid];
        for (het = mid; het > 1; het -= 2) {
            tailProbs[het - 2] = tailProbs[het] * (double)het * ((double)het - 1.0) / (4.0 * ((double)hom_r + 1.0) * ((double)hom_c + 1.0));
            sum += tailProbs[het - 2];
            ++hom_r;
            ++hom_c;
        }
        het = mid;
        hom_r = (rare - mid) / 2;
        hom_c = diplotypes - het - hom_r;
        for (het = mid; het <= rare - 2; het += 2) {
            tailProbs[het + 2] = tailProbs[het] * 4.0 * (double)hom_r * (double)hom_c / (((double)het + 2.0) * ((double)het + 1.0));
            sum += tailProbs[het + 2];
            --hom_r;
            --hom_c;
        }
        int z = 0;
        while (z < tailProbs.length) {
            int n = z++;
            tailProbs[n] = tailProbs[n] / sum;
        }
        double top = tailProbs[hets];
        for (int i = hets + 1; i <= rare; ++i) {
            top += tailProbs[i];
        }
        double otherSide = tailProbs[hets];
        for (int i = hets - 1; i >= 0; --i) {
            otherSide += tailProbs[i];
        }
        if (top > 0.5 && otherSide > 0.5) {
            return 1.0;
        }
        if (top < otherSide) {
            return top * 2.0;
        }
        return otherSide * 2.0;
    }

    public static void main(String[] args) {
        try {
            System.out.println(HardyWeinbergCalculator.hwCalculate(0, 408, 0));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

