/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.stat;

import cern.colt.list.DoubleArrayList;
import cern.jet.stat.Descriptive;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.commons.math3.distribution.TDistribution;
import org.apache.commons.math3.random.RandomDataGenerator;
import org.apache.commons.math3.stat.StatUtils;
import org.apache.commons.math3.stat.regression.OLSMultipleLinearRegression;

public class Linear2ThresholdEstimator {
    private final double[] y;
    private final double[][] X;
    private final double[][] sortedX;
    private final double[][] Z;
    private final int N;
    private final int m;
    private final int p;
    private double tauMinProportion = 0.1;
    private int numBootstrapReplications = 999;
    private int numQuantilesForC = 100;

    public Linear2ThresholdEstimator(double[] y, double[][] X_orig, double[][] Z_orig) {
        int i;
        this.y = (double[])y.clone();
        this.X = new double[X_orig.length][];
        this.sortedX = new double[X_orig.length][];
        for (i = 0; i < X_orig.length; ++i) {
            if (X_orig[i] == null) continue;
            this.X[i] = (double[])X_orig[i].clone();
            this.sortedX[i] = (double[])X_orig[i].clone();
            Arrays.sort(this.sortedX[i]);
        }
        this.N = y.length;
        if (X_orig.length != this.N) {
            throw new IllegalArgumentException("X length mismatch with Y");
        }
        int n = this.m = this.N > 0 && X_orig[0] != null ? X_orig[0].length : 0;
        if (this.m == 0 && this.N > 0) {
            throw new IllegalArgumentException("X cannot be empty or have zero dimension if N > 0");
        }
        if (Z_orig != null) {
            if (Z_orig.length != this.N) {
                throw new IllegalArgumentException("Z length mismatch with Y");
            }
            this.Z = new double[Z_orig.length][];
            for (i = 0; i < Z_orig.length; ++i) {
                if (Z_orig[i] == null) continue;
                this.Z[i] = (double[])Z_orig[i].clone();
            }
            this.p = this.N > 0 && Z_orig[0] != null ? Z_orig[0].length : 0;
        } else {
            this.Z = null;
            this.p = 0;
        }
    }

    public void setTauMinProportion(double tau) {
        this.tauMinProportion = tau;
    }

    public void setNumBootstrapReplications(int num) {
        this.numBootstrapReplications = num;
    }

    public void setNumQuantilesForC(int numQuantiles) {
        this.numQuantilesForC = Math.max(10, numQuantiles);
    }

    private int countGreaterEqualSorted(double[] sorted_x_row, double c_val) {
        if (sorted_x_row == null || sorted_x_row.length == 0) {
            return 0;
        }
        int low = 0;
        int high = sorted_x_row.length - 1;
        int firstGeIndex = sorted_x_row.length;
        while (low <= high) {
            int mid = low + (high - low) / 2;
            if (sorted_x_row[mid] >= c_val) {
                firstGeIndex = mid;
                high = mid - 1;
                continue;
            }
            low = mid + 1;
        }
        return sorted_x_row.length - firstGeIndex;
    }

    private List<Double> createCGrid() {
        if (this.N == 0 || this.m == 0) {
            return Collections.emptyList();
        }
        HashSet<Double> uniqueXValuesSet = new HashSet<Double>();
        for (int i = 0; i < this.N; ++i) {
            if (this.X[i] == null) continue;
            for (int j = 0; j < this.m; ++j) {
                uniqueXValuesSet.add(this.X[i][j]);
            }
        }
        if (uniqueXValuesSet.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Double> sortedUniqueXValues = new ArrayList<Double>(uniqueXValuesSet);
        Collections.sort(sortedUniqueXValues);
        ArrayList<Double> c_grid = new ArrayList<Double>();
        if (sortedUniqueXValues.size() <= this.numQuantilesForC) {
            return sortedUniqueXValues;
        }
        if (this.numQuantilesForC == 1) {
            c_grid.add((Double)sortedUniqueXValues.get(sortedUniqueXValues.size() / 2));
        } else {
            for (int k = 0; k < this.numQuantilesForC; ++k) {
                double fraction = (double)k / ((double)this.numQuantilesForC - 1.0);
                int index = (int)Math.round(fraction * ((double)sortedUniqueXValues.size() - 1.0));
                index = Math.max(0, Math.min(index, sortedUniqueXValues.size() - 1));
                c_grid.add((Double)sortedUniqueXValues.get(index));
            }
        }
        HashSet tempSet = new HashSet(c_grid);
        c_grid = new ArrayList(tempSet);
        Collections.sort(c_grid);
        return c_grid;
    }

    private ModelFitDetails estimateParametersInternal(double[] currentY, double[][] fixedSortedX, double[][] fixedZ, boolean isBootstrapRun) {
        List<Double> c_grid = this.createCGrid();
        ArrayList<Integer> d_grid = new ArrayList<Integer>();
        for (int d_val = 1; d_val <= this.m; ++d_val) {
            d_grid.add(d_val);
        }
        if (c_grid.isEmpty() && this.N > 0 && this.m > 0 || d_grid.isEmpty() && this.m > 0) {
            return new ModelFitDetails();
        }
        ModelFitDetails overallBestFit = new ModelFitDetails();
        int numRegressorsForOLS = 1 + this.p;
        int innerThreads = Math.max(1, Runtime.getRuntime().availableProcessors() / (isBootstrapRun ? 4 : 2));
        if (innerThreads > c_grid.size() || c_grid.size() < 5) {
            innerThreads = 1;
        }
        if (innerThreads > 1) {
            ExecutorService cExecutor = Executors.newFixedThreadPool(innerThreads);
            ArrayList<Future<ModelFitDetails>> cFutures = new ArrayList<Future<ModelFitDetails>>();
            for (double d : c_grid) {
                Callable<ModelFitDetails> cTask = () -> {
                    ModelFitDetails localBestFitForC = new ModelFitDetails();
                    int[] counts_for_this_c = new int[this.N];
                    for (int i = 0; i < this.N; ++i) {
                        counts_for_this_c[i] = this.countGreaterEqualSorted(fixedSortedX[i], c_candidate);
                    }
                    Iterator iterator2 = d_grid.iterator();
                    while (iterator2.hasNext()) {
                        int d_candidate = (Integer)iterator2.next();
                        double[][] regressors = new double[this.N][numRegressorsForOLS];
                        int countRegime1 = 0;
                        for (int i = 0; i < this.N; ++i) {
                            boolean D_val = counts_for_this_c[i] >= d_candidate;
                            regressors[i][0] = (double)D_val;
                            if (!D_val) continue;
                            ++countRegime1;
                        }
                        int countRegime0 = this.N - countRegime1;
                        if (!isBootstrapRun ? (double)countRegime0 < (double)this.N * this.tauMinProportion || (double)countRegime1 < (double)this.N * this.tauMinProportion : countRegime0 == 0 || countRegime1 == 0) continue;
                        boolean D_is_constant = true;
                        if (this.N > 0) {
                            double firstD = regressors[0][0];
                            for (int i = 1; i < this.N; ++i) {
                                if (regressors[i][0] == firstD) continue;
                                D_is_constant = false;
                                break;
                            }
                        }
                        if (D_is_constant && this.N > 0) continue;
                        if (this.p > 0 && fixedZ != null) {
                            for (int i = 0; i < this.N; ++i) {
                                if (fixedZ[i] == null) continue;
                                System.arraycopy(fixedZ[i], 0, regressors[i], 1, this.p);
                            }
                        }
                        try {
                            OLSMultipleLinearRegression ols = new OLSMultipleLinearRegression();
                            ols.setNoIntercept(false);
                            ols.newSampleData(currentY, regressors);
                            double ssr = ols.calculateResidualSumOfSquares();
                            if (!(ssr < localBestFitForC.ssr)) continue;
                            localBestFitForC.ssr = ssr;
                            localBestFitForC.c_hat = c_candidate;
                            localBestFitForC.d_hat = d_candidate;
                            double[] beta = ols.estimateRegressionParameters();
                            localBestFitForC.b_hat = beta[0];
                            localBestFitForC.k_hat = beta[1];
                            if (this.p > 0) {
                                localBestFitForC.z_hat = new double[this.p];
                                System.arraycopy(beta, 2, localBestFitForC.z_hat, 0, this.p);
                            } else {
                                localBestFitForC.z_hat = new double[0];
                            }
                            double[] stdErrors = ols.estimateRegressionParametersStandardErrors();
                            if (stdErrors.length > 1) {
                                localBestFitForC.k_stdErr = stdErrors[1];
                                if (localBestFitForC.k_stdErr > 1.0E-12 && !Double.isNaN(localBestFitForC.k_stdErr) && !Double.isInfinite(localBestFitForC.k_stdErr)) {
                                    localBestFitForC.k_tStat = localBestFitForC.k_hat / localBestFitForC.k_stdErr;
                                    continue;
                                }
                                localBestFitForC.k_tStat = Double.NaN;
                                continue;
                            }
                            localBestFitForC.k_stdErr = Double.NaN;
                            localBestFitForC.k_tStat = Double.NaN;
                        }
                        catch (Exception exception) {}
                    }
                    return localBestFitForC;
                };
                cFutures.add(cExecutor.submit(cTask));
            }
            cExecutor.shutdown();
            try {
                for (Future future : cFutures) {
                    ModelFitDetails fitFromTask = (ModelFitDetails)future.get();
                    if (fitFromTask == null || !(fitFromTask.ssr < overallBestFit.ssr)) continue;
                    overallBestFit = fitFromTask;
                }
            }
            catch (Exception e) {
                System.err.println("Error in parallel c_candidate (estimateInternal): " + e.getMessage());
            }
        } else {
            for (double c_candidate : c_grid) {
                int[] nArray = new int[this.N];
                for (int i = 0; i < this.N; ++i) {
                    nArray[i] = this.countGreaterEqualSorted(fixedSortedX[i], c_candidate);
                }
                Iterator iterator2 = d_grid.iterator();
                while (iterator2.hasNext()) {
                    int d_candidate = (Integer)iterator2.next();
                    double[][] regressors = new double[this.N][numRegressorsForOLS];
                    int countRegime1 = 0;
                    for (int i = 0; i < this.N; ++i) {
                        boolean D_val = nArray[i] >= d_candidate;
                        regressors[i][0] = (double)D_val;
                        if (!D_val) continue;
                        ++countRegime1;
                    }
                    int countRegime0 = this.N - countRegime1;
                    if (!isBootstrapRun ? (double)countRegime0 < (double)this.N * this.tauMinProportion || (double)countRegime1 < (double)this.N * this.tauMinProportion : countRegime0 == 0 || countRegime1 == 0) continue;
                    boolean D_is_constant = true;
                    if (this.N > 0) {
                        double firstD = regressors[0][0];
                        for (int i = 1; i < this.N; ++i) {
                            if (regressors[i][0] == firstD) continue;
                            D_is_constant = false;
                            break;
                        }
                    }
                    if (D_is_constant && this.N > 0) continue;
                    if (this.p > 0 && fixedZ != null) {
                        for (int i = 0; i < this.N; ++i) {
                            if (fixedZ[i] == null) continue;
                            System.arraycopy(fixedZ[i], 0, regressors[i], 1, this.p);
                        }
                    }
                    try {
                        OLSMultipleLinearRegression ols = new OLSMultipleLinearRegression();
                        ols.setNoIntercept(false);
                        ols.newSampleData(currentY, regressors);
                        double ssr = ols.calculateResidualSumOfSquares();
                        if (!(ssr < overallBestFit.ssr)) continue;
                        overallBestFit.ssr = ssr;
                        overallBestFit.c_hat = c_candidate;
                        overallBestFit.d_hat = d_candidate;
                        double[] beta = ols.estimateRegressionParameters();
                        overallBestFit.b_hat = beta[0];
                        overallBestFit.k_hat = beta[1];
                        if (this.p > 0) {
                            overallBestFit.z_hat = new double[this.p];
                            System.arraycopy(beta, 2, overallBestFit.z_hat, 0, this.p);
                        } else {
                            overallBestFit.z_hat = new double[0];
                        }
                        double[] stdErrors = ols.estimateRegressionParametersStandardErrors();
                        if (stdErrors.length > 1) {
                            overallBestFit.k_stdErr = stdErrors[1];
                            if (overallBestFit.k_stdErr > 1.0E-12 && !Double.isNaN(overallBestFit.k_stdErr) && !Double.isInfinite(overallBestFit.k_stdErr)) {
                                overallBestFit.k_tStat = overallBestFit.k_hat / overallBestFit.k_stdErr;
                                continue;
                            }
                            overallBestFit.k_tStat = Double.NaN;
                            continue;
                        }
                        overallBestFit.k_stdErr = Double.NaN;
                        overallBestFit.k_tStat = Double.NaN;
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return overallBestFit;
    }

    public ThresholdModelResult estimateParametersAndTestAsymptotic() {
        ModelFitDetails initialFit = this.estimateParametersInternal(this.y, this.sortedX, this.Z, false);
        ThresholdModelResult finalResult = new ThresholdModelResult();
        if (initialFit.ssr == Double.POSITIVE_INFINITY || Double.isNaN(initialFit.k_hat)) {
            System.err.println("Failed: initial fit.");
            finalResult.ssr = initialFit.ssr;
            finalResult.pValueK = Double.NaN;
            return finalResult;
        }
        finalResult.b_hat = initialFit.b_hat;
        finalResult.k_hat = initialFit.k_hat;
        finalResult.z_hat = initialFit.z_hat != null ? (double[])initialFit.z_hat.clone() : null;
        finalResult.c_hat = initialFit.c_hat;
        finalResult.d_hat = initialFit.d_hat;
        finalResult.ssr = initialFit.ssr;
        finalResult.k_stdErr = initialFit.k_stdErr;
        finalResult.k_tStat = initialFit.k_tStat;
        if (Double.isNaN(finalResult.k_tStat)) {
            System.err.println("k_tStat is NaN from initial fit. Cannot perform asymptotic-like test.");
            finalResult.pValueK = Double.NaN;
            return finalResult;
        }
        double observedWaldStatistic = finalResult.k_tStat * finalResult.k_tStat;
        List simulatedWaldStats = Collections.synchronizedList(new ArrayList());
        System.out.println("NOTE: A true Hansen-style asymptotic p-value for this specific model  (I(count(X >= c) >= d)) with a discrete 'd' and continuous 'c'  requires specialized econometric derivation and is beyond a straightforward code conversion. The existing t-statistic bootstrap is a robust and accepted method, though computationally intensive.");
        System.out.println("To significantly speed up beyond the current 75s for N=3000, m=200, options are:");
        System.out.println("1. Further reduce numBootstrapReplications (e.g., to 99 or 199) accepting wider CI for p-value.");
        System.out.println("2. Further reduce numQuantilesForC (e.g., to 20-30) accepting coarser search for c_hat.");
        System.out.println("3. Implement a highly optimized linear algebra library or offload to GPU (very advanced).");
        System.out.println("4. If running 5000 datasets, consider distributing datasets across multiple machines/nodes.");
        System.out.println("No simple, universally accepted 'fast asymptotic test' plug-in exists for this exact model structure.");
        if (!Double.isNaN(finalResult.k_tStat)) {
            TDistribution tDist = new TDistribution(this.N - (1 + this.p + 1));
            double naive_p_value = 2.0 * (1.0 - tDist.cumulativeProbability(Math.abs(finalResult.k_tStat)));
            System.out.println("NAIVE (INCORRECT) p-value based on final t-stat (ignores search): " + String.format("%.4e", naive_p_value));
        }
        finalResult.pValueK = Double.NaN;
        return finalResult;
    }

    public ThresholdModelResult estimateParametersAndTest() {
        double[] y_residuals_H0_local;
        double[] z0_hat_H0;
        double b0_hat_H0;
        ModelFitDetails initialFit = this.estimateParametersInternal(this.y, this.sortedX, this.Z, false);
        ThresholdModelResult finalResult = new ThresholdModelResult();
        if (initialFit.ssr == Double.POSITIVE_INFINITY || Double.isNaN(initialFit.k_hat)) {
            System.err.println("Failed to find suitable (c,d) or k_hat for initial estimation.");
            finalResult.ssr = initialFit.ssr;
            finalResult.pValueK = Double.NaN;
            return finalResult;
        }
        finalResult.b_hat = initialFit.b_hat;
        finalResult.k_hat = initialFit.k_hat;
        finalResult.z_hat = initialFit.z_hat != null ? (double[])initialFit.z_hat.clone() : null;
        finalResult.c_hat = initialFit.c_hat;
        finalResult.d_hat = initialFit.d_hat;
        finalResult.ssr = initialFit.ssr;
        finalResult.k_stdErr = initialFit.k_stdErr;
        finalResult.k_tStat = initialFit.k_tStat;
        OLSMultipleLinearRegression olsH0 = new OLSMultipleLinearRegression();
        olsH0.setNoIntercept(false);
        if (this.p > 0) {
            if (this.Z == null) {
                throw new IllegalStateException("p > 0 but Z is null for H0 model");
            }
            olsH0.newSampleData(this.y, this.Z);
            double[] betaH0 = olsH0.estimateRegressionParameters();
            b0_hat_H0 = betaH0[0];
            z0_hat_H0 = new double[this.p];
            System.arraycopy(betaH0, 1, z0_hat_H0, 0, this.p);
            y_residuals_H0_local = olsH0.estimateResiduals();
        } else {
            b0_hat_H0 = StatUtils.mean(this.y);
            z0_hat_H0 = new double[]{};
            y_residuals_H0_local = new double[this.N];
            for (int i = 0; i < this.N; ++i) {
                y_residuals_H0_local[i] = this.y[i] - b0_hat_H0;
            }
        }
        double meanResidualsH0 = StatUtils.mean(y_residuals_H0_local);
        int i = 0;
        while (i < this.N) {
            int n = i++;
            y_residuals_H0_local[n] = y_residuals_H0_local[n] - meanResidualsH0;
        }
        double final_b0_hat_H0 = b0_hat_H0;
        double[] final_z0_hat_H0 = z0_hat_H0;
        double[] final_y_residuals_H0 = y_residuals_H0_local;
        List<Double> bootstrap_t_stats = Collections.synchronizedList(new ArrayList());
        int numThreads = Math.max(1, Runtime.getRuntime().availableProcessors() / 2);
        ExecutorService executor = Executors.newFixedThreadPool(numThreads);
        ArrayList futures = new ArrayList();
        for (int b = 0; b < this.numBootstrapReplications; ++b) {
            Callable<Double> task = () -> {
                RandomDataGenerator localRandomGen = new RandomDataGenerator();
                double[] y_boot = new double[this.N];
                for (int i = 0; i < this.N; ++i) {
                    double residual_boot = final_y_residuals_H0[localRandomGen.nextInt(0, this.N - 1)];
                    y_boot[i] = final_b0_hat_H0 + residual_boot;
                    if (this.p <= 0) continue;
                    for (int j = 0; j < this.p; ++j) {
                        if (this.Z[i] == null) continue;
                        int n = i;
                        y_boot[n] = y_boot[n] + this.Z[i][j] * final_z0_hat_H0[j];
                    }
                }
                ModelFitDetails bootFit = this.estimateParametersInternal(y_boot, this.sortedX, this.Z, true);
                return bootFit.k_tStat;
            };
            futures.add(executor.submit(task));
        }
        executor.shutdown();
        int successfulBootstraps = 0;
        try {
            for (Future future : futures) {
                Double t_boot = (Double)future.get();
                if (t_boot == null || Double.isNaN(t_boot) || Double.isInfinite(t_boot)) continue;
                bootstrap_t_stats.add(t_boot);
                ++successfulBootstraps;
            }
        }
        catch (Exception e) {
            System.err.println("Error during bootstrap: " + e.getMessage());
            e.printStackTrace();
            finalResult.pValueK = Double.NaN;
            return finalResult;
        }
        if (this.numBootstrapReplications > 0 && (double)successfulBootstraps < (double)this.numBootstrapReplications * 0.8) {
            System.err.println("Warning: Bootstrap failures (" + successfulBootstraps + "/" + this.numBootstrapReplications + ")");
        }
        if (Double.isNaN(finalResult.k_tStat) || bootstrap_t_stats.isEmpty()) {
            finalResult.pValueK = Double.NaN;
        } else {
            long countExceeding = bootstrap_t_stats.stream().filter(t_b -> Math.abs(t_b) >= Math.abs(finalResult.k_tStat)).count();
            finalResult.pValueK = ((double)countExceeding + 1.0) / ((double)bootstrap_t_stats.size() + 1.0);
        }
        return finalResult;
    }

    public static void main(String[] args) {
        int N_samples = 3000;
        int m_dim = 200;
        int p_dim = 2;
        RandomDataGenerator rng = new RandomDataGenerator();
        rng.reSeed(12345L);
        double[] y_data = new double[N_samples];
        double[][] X_data = new double[N_samples][m_dim];
        double[][] Z_data = p_dim > 0 ? new double[N_samples][p_dim] : (double[][])null;
        double b_true = 1.0;
        double k_true = 1.0;
        double c_true = 0.8;
        int d_true = 40;
        double error_std_dev = 0.5;
        double[] z_true = null;
        if (p_dim > 0) {
            z_true = new double[p_dim];
            z_true[0] = 2.0;
            if (p_dim > 1) {
                z_true[1] = -1.0;
            }
        }
        System.out.println("--- Generating Test Data ---");
        System.out.println("N_samples: " + N_samples + ", m_dim: " + m_dim + ", p_dim: " + p_dim);
        System.out.println("True params: b=" + b_true + ", k=" + k_true + ", c=" + c_true + ", d=" + d_true + (p_dim > 0 && z_true != null ? ", z=" + Arrays.toString(z_true) : "") + ", error_std_dev=" + error_std_dev);
        DoubleArrayList x = new DoubleArrayList();
        DoubleArrayList y = new DoubleArrayList();
        for (int i = 0; i < N_samples; ++i) {
            int j;
            for (j = 0; j < m_dim; ++j) {
                X_data[i][j] = rng.nextUniform(0.0, 1.0);
            }
            if (p_dim > 0 && Z_data != null) {
                for (j = 0; j < p_dim; ++j) {
                    Z_data[i][j] = rng.nextGaussian(0.0, 1.0);
                }
            }
            int count_X_ge_c = 0;
            for (double x_val : X_data[i]) {
                if (!(x_val >= c_true)) continue;
                ++count_X_ge_c;
            }
            boolean I_val = count_X_ge_c >= d_true;
            x.add(k_true * (double)I_val);
            double y_val = b_true + k_true * (double)I_val + rng.nextGaussian(0.0, error_std_dev);
            if (p_dim > 0 && Z_data != null && Z_data[i] != null && z_true != null) {
                for (int j2 = 0; j2 < p_dim; ++j2) {
                    y_val += Z_data[i][j2] * z_true[j2];
                }
            }
            y_data[i] = y_val;
            y.add(y_val);
        }
        double meanX = Descriptive.mean(x);
        double meanY = Descriptive.mean(y);
        double varX = Descriptive.sampleVariance(x, meanX);
        double varY = Descriptive.sampleVariance(y, meanY);
        System.out.println("Heritablity: " + varX / varY);
        Linear2ThresholdEstimator estimator = new Linear2ThresholdEstimator(y_data, X_data, Z_data);
        estimator.setTauMinProportion(0.05);
        estimator.setNumQuantilesForC(50);
        estimator.setNumBootstrapReplications(199);
        System.out.println("\n--- Starting Estimation ---");
        System.out.println("Settings: tau=" + estimator.tauMinProportion + ", numCQuantiles=" + estimator.numQuantilesForC + ", numBootstrap=" + estimator.numBootstrapReplications);
        long startTime = System.currentTimeMillis();
        ThresholdModelResult result = estimator.estimateParametersAndTest();
        long endTime = System.currentTimeMillis();
        System.out.println("Estimation finished in " + (endTime - startTime) + " ms.");
        System.out.println("\n--- Estimation Results ---");
        System.out.println(result);
        System.out.println("\n--- Calling Asymptotic-like Test (Placeholder/Demo) ---");
        long startTimeAsp = System.currentTimeMillis();
        ThresholdModelResult resultAsymptotic = estimator.estimateParametersAndTestAsymptotic();
        long endTimeAsp = System.currentTimeMillis();
        System.out.println("Asymptotic-like (Placeholder) finished in " + (endTimeAsp - startTimeAsp) + " ms (Note: p-value is illustrative only).");
        System.out.println("\n--- Asymptotic-like (Placeholder) Results ---");
        System.out.println(resultAsymptotic);
        System.out.println("\nTrue params for comparison: b=" + String.format("%.4f", b_true) + ", k=" + String.format("%.4f", k_true) + ", c=" + String.format("%.4f", c_true) + ", d=" + d_true + (p_dim > 0 && z_true != null ? ", z=" + Arrays.stream(z_true).mapToObj(val -> String.format("%.4f", val)).collect(Collectors.joining(", ", "[", "]")) : ""));
    }

    private static class ModelFitDetails {
        public double b_hat = Double.NaN;
        public double k_hat = Double.NaN;
        public double[] z_hat;
        public double c_hat = Double.NaN;
        public int d_hat = -1;
        public double ssr = Double.POSITIVE_INFINITY;
        public double k_stdErr = Double.NaN;
        public double k_tStat = Double.NaN;
    }

    public static class ThresholdModelResult {
        public double b_hat = Double.NaN;
        public double k_hat = Double.NaN;
        public double[] z_hat;
        public double c_hat = Double.NaN;
        public int d_hat = -1;
        public double ssr = Double.POSITIVE_INFINITY;
        public double k_stdErr = Double.NaN;
        public double k_tStat = Double.NaN;
        public double pValueK = Double.NaN;

        public String toString() {
            String z_hat_str = "N/A";
            if (this.z_hat != null && this.z_hat.length > 0) {
                z_hat_str = Arrays.stream(this.z_hat).mapToObj(val -> String.format("%.4f", val)).collect(Collectors.joining(", "));
            }
            return "ThresholdModelResult{\nb_hat=" + String.format("%.4f", this.b_hat) + ", \nk_hat=" + String.format("%.4f", this.k_hat) + ", \nz_hat=[" + z_hat_str + "], \nc_hat=" + String.format("%.4f", this.c_hat) + ", \nd_hat=" + this.d_hat + ", \nssr=" + String.format("%.4f", this.ssr) + ", \nk_stdErr=" + String.format("%.4f", this.k_stdErr) + ", \nk_tStat=" + String.format("%.4f", this.k_tStat) + ", \npValueK (Bootstrap)=" + (Double.isNaN(this.pValueK) ? "NaN" : String.format("%.4f", this.pValueK)) + "\n}";
        }
    }
}

