/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.stat;

import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import cern.colt.matrix.linalg.QRDecomposition;
import cern.jet.stat.Probability;
import edu.sysu.pmglab.stat.Summary;
import java.util.Arrays;

public class LinearRegression {
    private DoubleMatrix2D beta;
    private double sse;
    private double sst;
    double[] weights;
    double[] residuals;
    double[] se;
    double[] tValues;
    double[][] x;
    double[] y;
    boolean addIntercept = false;

    public LinearRegression() {
    }

    public double[] getSE() {
        return this.se;
    }

    public void addIntercept() {
        if (!this.addIntercept) {
            this.addIntercept = true;
            double[][] newX = new double[this.x.length][this.x[0].length + 1];
            for (int i = 0; i < this.x.length; ++i) {
                newX[i][0] = 1.0;
                System.arraycopy(this.x[i], 0, newX[i], 1, this.x[0].length);
            }
            this.x = newX;
        }
    }

    public void setX(double[][] x) {
        this.x = x;
        if (x == null || x.length == 0 || x[0].length == 0) {
            System.err.println("No independent variables!!!");
            return;
        }
        for (double[] xx : x) {
            if (xx[0] == 1.0) continue;
            System.err.println("The first column of X values must be 1 to consider the intercept for logistic regression!!!");
        }
    }

    public void setY(double[] y) {
        this.y = y;
        if (y == null || y.length == 0) {
            System.err.println("No dependent variables!!!");
            return;
        }
        for (double v : y) {
            if (v == 0.0 || v == 1.0) continue;
            System.err.println("Y values must be 0  or 1 for logistic regression!!!");
        }
    }

    public void reset(double[][] x, double[] y, boolean addIntercept) {
        this.addIntercept = addIntercept;
        if (!addIntercept) {
            this.x = x;
        } else {
            double[][] newX = new double[x.length][x[0].length + 1];
            for (int i = 0; i < x.length; ++i) {
                newX[i][0] = 1.0;
                System.arraycopy(x[i], 0, newX[i], 1, x[0].length);
            }
            this.x = newX;
        }
        this.y = y;
    }

    public LinearRegression(double[][] x, double[] y, boolean addIntercept) {
        this.addIntercept = addIntercept;
        if (!addIntercept) {
            this.x = x;
        } else {
            double[][] newX = new double[x.length][x[0].length + 1];
            for (int i = 0; i < x.length; ++i) {
                newX[i][0] = 1.0;
                System.arraycopy(x[i], 0, newX[i], 1, x[0].length);
            }
            this.x = newX;
        }
        this.y = y;
    }

    public void fit() {
        if (this.x.length != this.y.length) {
            throw new IllegalArgumentException("Matrix dimensions don't agree");
        }
        int n = this.y.length;
        int p = this.x[0].length;
        DenseDoubleMatrix2D matrixX = new DenseDoubleMatrix2D(this.x);
        DenseDoubleMatrix2D matrixY = new DenseDoubleMatrix2D(n, 1);
        for (int i = 0; i < n; ++i) {
            ((DoubleMatrix2D)matrixY).setQuick(i, 0, this.y[i]);
        }
        QRDecomposition qr = new QRDecomposition(matrixX);
        this.beta = qr.solve(matrixY);
        double sum = 0.0;
        for (double yi : this.y) {
            sum += yi;
        }
        double mean = sum / (double)n;
        this.sst = 0.0;
        for (double yi : this.y) {
            double dev = yi - mean;
            this.sst += dev * dev;
        }
        DoubleMatrix2D residuals = ((DoubleMatrix2D)matrixX).zMult(this.beta, null, 1.0, 0.0, false, false);
        this.sse = 0.0;
        for (int i = 0; i < n; ++i) {
            double resid = this.y[i] - residuals.getQuick(i, 0);
            this.sse += resid * resid;
        }
    }

    public double[] calculateStandardErrors() {
        int n = this.y.length;
        int p = this.x[0].length;
        double mse = this.sse / (double)(n - p);
        Algebra algebra = Algebra.DEFAULT;
        DenseDoubleMatrix2D matrixX = new DenseDoubleMatrix2D(this.x);
        DoubleMatrix2D xTX = matrixX.viewDice().zMult(matrixX, null);
        for (int i = 0; i < p; ++i) {
            xTX.setQuick(i, i, xTX.getQuick(i, i) + 1.0E-6);
        }
        DoubleMatrix2D xTX_inv = algebra.inverse(xTX);
        double[] standardErrors = new double[p];
        double sqrtMse = Math.sqrt(mse);
        for (int i = 0; i < p; ++i) {
            standardErrors[i] = sqrtMse * Math.sqrt(xTX_inv.getQuick(i, i));
        }
        return standardErrors;
    }

    public double[] calculateTValues() {
        this.se = this.calculateStandardErrors();
        this.tValues = new double[this.beta.rows()];
        for (int i = 0; i < this.beta.rows(); ++i) {
            this.tValues[i] = this.beta.getQuick(i, 0) / this.se[i];
        }
        return this.tValues;
    }

    public double[] getTValues() {
        return this.tValues;
    }

    public double[] calculatePValues() {
        int n = this.y.length;
        int p = this.x[0].length;
        this.tValues = this.calculateTValues();
        double[] pValues = new double[this.tValues.length];
        for (int i = 0; i < this.tValues.length; ++i) {
            pValues[i] = 2.0 * (1.0 - Probability.studentT(n - p, Math.abs(this.tValues[i])));
        }
        return pValues;
    }

    public double[] getResiduals() {
        return this.residuals;
    }

    public boolean robustLinearRegression(double[] Y, double[][] X2, int iterN, int methodID) {
        this.weights = new double[Y.length];
        Arrays.fill(this.weights, 1.0);
        return this.robustLinearRegression(Y, X2, this.weights, iterN, methodID);
    }

    public double[] getWeights() {
        return this.weights;
    }

    public boolean robustLinearRegression(double[] Y, double[][] X2, double[] W, int iterN, int methodID) {
        int iterI = 0;
        int size = W.length;
        double MINDIFF = 1.0E-6;
        double maxDiff = 0.0;
        double sd = Summary.sd(Y);
        double c = 1.345 * sd;
        if (methodID == 2) {
            c = 4.685 * sd;
        }
        boolean success = false;
        double[] coef = new double[X2[0].length];
        double[] coefSD = new double[X2[0].length];
        this.residuals = new double[Y.length];
        this.weightedLeastSquaresArray(Y, X2, W, coef, coefSD, this.residuals);
        double[] tmpCoef = new double[X2[0].length];
        System.arraycopy(coef, 0, tmpCoef, 0, tmpCoef.length);
        double[] tmpResi = new double[size];
        while (iterI < iterN) {
            int i;
            for (i = 0; i < size; ++i) {
                tmpResi[i] = Math.abs(this.residuals[i]);
            }
            sd = Summary.stddevNadw(Y, this.weights);
            switch (methodID) {
                case 2: {
                    c = 4.685 * sd;
                    break;
                }
                case 1: {
                    c = 1.345 * sd;
                }
            }
            block10: for (i = 0; i < size; ++i) {
                switch (methodID) {
                    case 2: {
                        if (Math.abs(this.residuals[i]) <= c) {
                            W[i] = this.residuals[i] / c;
                            W[i] = W[i] * W[i];
                            W[i] = 1.0 - W[i];
                            W[i] = W[i] * W[i];
                            continue block10;
                        }
                        W[i] = 0.0;
                        continue block10;
                    }
                    case 1: {
                        if (Math.abs(this.residuals[i]) <= c) {
                            W[i] = 1.0;
                            continue block10;
                        }
                        W[i] = c / Math.abs(this.residuals[i]);
                        continue block10;
                    }
                    default: {
                        W[i] = 1.0;
                    }
                }
            }
            this.weightedLeastSquaresArray(Y, X2, W, coef, coefSD, this.residuals);
            maxDiff = Math.abs(coef[0] - tmpCoef[0]);
            for (i = 1; i < tmpCoef.length; ++i) {
                double tempDiff = Math.abs(coef[i] - tmpCoef[i]);
                if (!(tempDiff > maxDiff)) continue;
                maxDiff = tempDiff;
            }
            if (maxDiff <= MINDIFF) {
                success = true;
                break;
            }
            System.arraycopy(coef, 0, tmpCoef, 0, tmpCoef.length);
            System.arraycopy(W, 0, this.weights, 0, W.length);
            ++iterI;
        }
        return success;
    }

    public boolean weightedLeastSquaresArray(double[] Y, double[][] X2, double[] W, double[] coef, double[] coefSD, double[] residual) {
        int k;
        int j;
        int i;
        int M = Y.length;
        int N = X2[0].length;
        int NDF = M - N;
        double[] fitY = new double[M];
        if (NDF < 1) {
            return false;
        }
        double[][] covar = new double[N][N];
        double[] B = new double[N];
        for (i = 0; i < N; ++i) {
            for (j = 0; j < N; ++j) {
                covar[i][j] = 0.0;
            }
        }
        for (i = 0; i < N; ++i) {
            for (j = 0; j < N; ++j) {
                covar[i][j] = 0.0;
                for (int k2 = 0; k2 < M; ++k2) {
                    covar[i][j] = covar[i][j] + W[k2] * X2[k2][i] * X2[k2][j];
                }
            }
            B[i] = 0.0;
            for (int k3 = 0; k3 < M; ++k3) {
                B[i] = B[i] + W[k3] * X2[k3][i] * Y[k3];
            }
        }
        if (!this.symmetricMatrixInvert(covar)) {
            return false;
        }
        for (i = 0; i < N; ++i) {
            coef[i] = 0.0;
            for (j = 0; j < N; ++j) {
                coef[i] = coef[i] + covar[i][j] * B[j];
            }
        }
        double TSS = 0.0;
        double RSS = 0.0;
        double YBAR = 0.0;
        double WSUM = 0.0;
        for (k = 0; k < M; ++k) {
            YBAR += W[k] * Y[k];
            WSUM += W[k];
        }
        YBAR /= WSUM;
        for (k = 0; k < M; ++k) {
            fitY[k] = 0.0;
            for (int i2 = 0; i2 < N; ++i2) {
                fitY[k] = fitY[k] + coef[i2] * X2[k][i2];
            }
            residual[k] = fitY[k] - Y[k];
            TSS += W[k] * (Y[k] - YBAR) * (Y[k] - YBAR);
            RSS += W[k] * residual[k] * residual[k];
        }
        double SSQ = RSS / (double)NDF;
        double RYSQ = 1.0 - RSS / TSS;
        double FReg = 9999999.0;
        if (RYSQ < 0.9999999) {
            FReg = RYSQ / (1.0 - RYSQ) * (double)NDF / (double)(N - 1);
        }
        double SDV = Math.sqrt(SSQ);
        for (int i3 = 0; i3 < N; ++i3) {
            for (int j2 = 0; j2 < N; ++j2) {
                covar[i3][j2] = covar[i3][j2] * SSQ;
            }
            coefSD[i3] = Math.sqrt(covar[i3][i3]);
        }
        return true;
    }

    public boolean symmetricMatrixInvert(double[][] V) {
        int L;
        int M;
        int N = V.length;
        double[] t = new double[N];
        double[] Q = new double[N];
        double[] R = new double[N];
        for (M = 0; M < N; ++M) {
            R[M] = 1.0;
        }
        int K = 0;
        for (M = 0; M < N; ++M) {
            double Big = 0.0;
            for (L = 0; L < N; ++L) {
                double AB = Math.abs(V[L][L]);
                if (!(AB > Big) || R[L] == 0.0) continue;
                Big = AB;
                K = L;
            }
            if (Big == 0.0) {
                return false;
            }
            R[K] = 0.0;
            Q[K] = 1.0 / V[K][K];
            t[K] = 1.0;
            V[K][K] = 0.0;
            if (K != 0) {
                for (L = 0; L < K; ++L) {
                    t[L] = V[L][K];
                    Q[L] = R[L] == 0.0 ? V[L][K] * Q[K] : -V[L][K] * Q[K];
                    V[L][K] = 0.0;
                }
            }
            if (K + 1 < N) {
                for (L = K + 1; L < N; ++L) {
                    t[L] = R[L] != 0.0 ? V[K][L] : -V[K][L];
                    Q[L] = -V[K][L] * Q[K];
                    V[K][L] = 0.0;
                }
            }
            for (L = 0; L < N; ++L) {
                for (K = L; K < N; ++K) {
                    V[L][K] = V[L][K] + t[L] * Q[K];
                }
            }
        }
        M = N;
        L = N - 1;
        for (K = 1; K < N; ++K) {
            --M;
            --L;
            for (int J = 0; J <= L; ++J) {
                V[M][J] = V[J][M];
            }
        }
        return true;
    }

    public double beta(int j) {
        return this.beta.get(j, 0);
    }

    public double R2() {
        return 1.0 - this.sse / this.sst;
    }

    public static void main(String[] args) {
        double[][] x = new double[][]{{1.0, 10.0, 4343.0}, {1.0, 20.0, 4356.0}, {1.0, 40.0, 123.0}, {1.0, 80.0, 14343.0}, {1.0, 160.0, 2567.0}, {1.0, 200.0, 1321.0}};
        double[] y = new double[]{243.0, 483.0, 508.0, 1503.0, 1764.0, 2129.0};
        LinearRegression regression = new LinearRegression(x, y, false);
        regression.fit();
        double p = regression.calculatePValues()[1];
        double[] tValues = regression.calculateTValues();
        double[] se = regression.getSE();
        System.out.printf("%.2f + %.2f beta1 + %.2f beta2  (R^2 = %.2f)\n", regression.beta(0), regression.beta(1), regression.beta(2), regression.R2());
        for (int i = 0; i < tValues.length; ++i) {
            System.out.println(tValues[i] + "__" + se[i]);
        }
        System.out.println(p);
    }
}

