/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.stat;

import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import cern.jet.stat.Probability;
import edu.sysu.pmglab.stat.Summary;
import java.util.Arrays;

public class LinearRegressionGty {
    public double[] weights;
    public double[] residuals;
    public double[] se;
    public double[] tValues;
    private DoubleMatrix2D beta;
    private double sse;
    private double sst;
    private double[][] x;
    private double[] y;
    private boolean addIntercept = false;
    private double[][] xtx;
    private double[] xty;
    private DoubleMatrix2D xtx_inv;

    public LinearRegressionGty() {
    }

    public LinearRegressionGty(double[][] x, double[] y, boolean addIntercept) {
        this.reset(x, y, addIntercept);
    }

    public double[] getSE() {
        return this.se;
    }

    public void addIntercept() {
        if (!this.addIntercept && this.x != null) {
            this.addIntercept = true;
            double[][] newX = new double[this.x.length][this.x[0].length + 1];
            for (int i = 0; i < this.x.length; ++i) {
                newX[i][0] = 1.0;
                System.arraycopy(this.x[i], 0, newX[i], 1, this.x[0].length);
            }
            this.x = newX;
        }
    }

    public void setX(double[][] x) {
        this.x = x;
        if (x == null || x.length == 0 || x[0].length == 0) {
            System.err.println("No independent variables!!!");
            return;
        }
        if (this.addIntercept && x[0][0] != 1.0) {
            System.err.println("The first column of X values should be 1 for the intercept when addIntercept is true.");
        }
    }

    public void setY(double[] y) {
        this.y = y;
        if (y == null || y.length == 0) {
            System.err.println("No dependent variables!!!");
        }
    }

    public void reset(double[][] x, double[] y, boolean addIntercept) {
        this.addIntercept = addIntercept;
        if (!addIntercept) {
            this.x = x;
        } else if (x[0].length > 0 && x[0][0] == 1.0) {
            this.x = x;
        } else {
            double[][] newX = new double[x.length][x[0].length + 1];
            for (int i = 0; i < x.length; ++i) {
                newX[i][0] = 1.0;
                System.arraycopy(x[i], 0, newX[i], 1, x[0].length);
            }
            this.x = newX;
        }
        this.y = y;
        this.xtx_inv = null;
        this.beta = null;
        this.se = null;
        this.tValues = null;
    }

    public void fit() {
        int i;
        int j;
        int i2;
        if (this.x == null || this.y == null || this.x.length != this.y.length) {
            throw new IllegalArgumentException("Input data is not set correctly or dimensions don't agree.");
        }
        int n = this.y.length;
        if (n == 0) {
            return;
        }
        int p = this.x[0].length;
        if (this.xtx == null || this.xtx.length != p) {
            this.xtx = new double[p][p];
            this.xty = new double[p];
        }
        for (i2 = 0; i2 < p; ++i2) {
            Arrays.fill(this.xtx[i2], 0.0);
        }
        Arrays.fill(this.xty, 0.0);
        for (i2 = 0; i2 < n; ++i2) {
            double[] xi = this.x[i2];
            double yi = this.y[i2];
            for (j = 0; j < p; ++j) {
                int n2 = j;
                this.xty[n2] = this.xty[n2] + yi * xi[j];
            }
            for (j = 0; j < p; ++j) {
                for (int k = j; k < p; ++k) {
                    double[] dArray = this.xtx[j];
                    int n3 = k;
                    dArray[n3] = dArray[n3] + xi[j] * xi[k];
                }
            }
        }
        for (int j2 = 1; j2 < p; ++j2) {
            for (int k = 0; k < j2; ++k) {
                this.xtx[j2][k] = this.xtx[k][j2];
            }
        }
        DenseDoubleMatrix2D xtxMatrix = new DenseDoubleMatrix2D(this.xtx);
        for (i = 0; i < p; ++i) {
            xtxMatrix.setQuick(i, i, xtxMatrix.getQuick(i, i) + 1.0E-6);
        }
        this.xtx_inv = Algebra.DEFAULT.inverse(xtxMatrix);
        this.beta = new DenseDoubleMatrix2D(p, 1);
        for (i = 0; i < p; ++i) {
            double beta_i = 0.0;
            for (j = 0; j < p; ++j) {
                beta_i += this.xtx_inv.getQuick(i, j) * this.xty[j];
            }
            this.beta.setQuick(i, 0, beta_i);
        }
        double sum = 0.0;
        for (double val : this.y) {
            sum += val;
        }
        double mean = sum / (double)n;
        this.sst = 0.0;
        for (double val : this.y) {
            double dev = val - mean;
            this.sst += dev * dev;
        }
        this.sse = 0.0;
        if (this.residuals == null || this.residuals.length != n) {
            this.residuals = new double[n];
        }
        for (int i3 = 0; i3 < n; ++i3) {
            double resid;
            double y_hat = 0.0;
            double[] xi = this.x[i3];
            for (int j3 = 0; j3 < p; ++j3) {
                y_hat += this.beta.getQuick(j3, 0) * xi[j3];
            }
            this.residuals[i3] = resid = this.y[i3] - y_hat;
            this.sse += resid * resid;
        }
    }

    public double[] calculateStandardErrors() {
        if (this.beta == null || this.xtx_inv == null) {
            throw new IllegalStateException("The 'fit()' method must be called before calculating standard errors.");
        }
        int n = this.y.length;
        int p = this.x[0].length;
        if (n <= p) {
            this.se = new double[p];
            Arrays.fill(this.se, Double.NaN);
            return this.se;
        }
        double mse = this.sse / (double)(n - p);
        if (this.se == null || this.se.length != p) {
            this.se = new double[p];
        }
        double sqrtMse = Math.sqrt(mse);
        for (int i = 0; i < p; ++i) {
            double var_diag = this.xtx_inv.getQuick(i, i);
            this.se[i] = var_diag < 0.0 ? Double.NaN : sqrtMse * Math.sqrt(var_diag);
        }
        return this.se;
    }

    public double[] calculateTValues() {
        if (this.beta == null) {
            throw new IllegalStateException("The 'fit()' method must be called before calculating t-values.");
        }
        if (this.se == null) {
            this.calculateStandardErrors();
        }
        if (this.tValues == null || this.tValues.length != this.beta.rows()) {
            this.tValues = new double[this.beta.rows()];
        }
        for (int i = 0; i < this.beta.rows(); ++i) {
            this.tValues[i] = this.beta.getQuick(i, 0) / this.se[i];
        }
        return this.tValues;
    }

    public double[] calculatePValues() {
        if (this.beta == null) {
            throw new IllegalStateException("The 'fit()' method must be called before calculating p-values.");
        }
        int n = this.y.length;
        int p = this.x[0].length;
        this.calculateTValues();
        double[] pValues = new double[this.tValues.length];
        int df = n - p;
        if (df <= 0) {
            Arrays.fill(pValues, Double.NaN);
            return pValues;
        }
        for (int i = 0; i < this.tValues.length; ++i) {
            pValues[i] = 2.0 * Probability.studentT(df, -Math.abs(this.tValues[i]));
        }
        return pValues;
    }

    public double[] getResiduals() {
        return this.residuals;
    }

    public double[] getTValues() {
        return this.tValues;
    }

    public boolean robustLinearRegression(double[] Y, double[][] X2, int iterN, int methodID) {
        this.weights = new double[Y.length];
        Arrays.fill(this.weights, 1.0);
        return this.robustLinearRegression(Y, X2, this.weights, iterN, methodID);
    }

    public double[] getWeights() {
        return this.weights;
    }

    public boolean robustLinearRegression(double[] Y, double[][] X2, double[] W, int iterN, int methodID) {
        int size = W.length;
        double MINDIFF = 1.0E-6;
        boolean success = false;
        double[] coef = new double[X2[0].length];
        double[] coefSD = new double[X2[0].length];
        this.residuals = new double[Y.length];
        this.weightedLeastSquaresArray(Y, X2, W, coef, coefSD, this.residuals);
        double[] tmpCoef = new double[X2[0].length];
        System.arraycopy(coef, 0, tmpCoef, 0, tmpCoef.length);
        for (int iterI = 0; iterI < iterN; ++iterI) {
            int i;
            double c;
            double sd = Summary.stddevNadw(Y, this.weights);
            switch (methodID) {
                case 2: {
                    c = 4.685 * sd;
                    break;
                }
                case 1: {
                    c = 1.345 * sd;
                    break;
                }
                default: {
                    c = Double.POSITIVE_INFINITY;
                }
            }
            block9: for (i = 0; i < size; ++i) {
                switch (methodID) {
                    case 2: {
                        if (Math.abs(this.residuals[i]) <= c) {
                            double term = this.residuals[i] / c;
                            term *= term;
                            term = 1.0 - term;
                            W[i] = term * term;
                            continue block9;
                        }
                        W[i] = 0.0;
                        continue block9;
                    }
                    case 1: {
                        if (Math.abs(this.residuals[i]) <= c) {
                            W[i] = 1.0;
                            continue block9;
                        }
                        W[i] = c / Math.abs(this.residuals[i]);
                        continue block9;
                    }
                    default: {
                        W[i] = 1.0;
                    }
                }
            }
            this.weightedLeastSquaresArray(Y, X2, W, coef, coefSD, this.residuals);
            double maxDiff = Math.abs(coef[0] - tmpCoef[0]);
            for (i = 1; i < tmpCoef.length; ++i) {
                double tempDiff = Math.abs(coef[i] - tmpCoef[i]);
                if (!(tempDiff > maxDiff)) continue;
                maxDiff = tempDiff;
            }
            if (maxDiff <= MINDIFF) {
                success = true;
                break;
            }
            System.arraycopy(coef, 0, tmpCoef, 0, tmpCoef.length);
            System.arraycopy(W, 0, this.weights, 0, W.length);
        }
        return success;
    }

    public boolean weightedLeastSquaresArray(double[] Y, double[][] X2, double[] W, double[] coef, double[] coefSD, double[] residual) {
        int k;
        int j;
        int i;
        int M = Y.length;
        int N = X2[0].length;
        int NDF = M - N;
        if (NDF < 1) {
            return false;
        }
        double[][] covar = new double[N][N];
        double[] B = new double[N];
        for (i = 0; i < N; ++i) {
            for (j = 0; j < N; ++j) {
                covar[i][j] = 0.0;
                for (int k2 = 0; k2 < M; ++k2) {
                    double[] dArray = covar[i];
                    int n = j;
                    dArray[n] = dArray[n] + W[k2] * X2[k2][i] * X2[k2][j];
                }
            }
            B[i] = 0.0;
            for (int k3 = 0; k3 < M; ++k3) {
                int n = i;
                B[n] = B[n] + W[k3] * X2[k3][i] * Y[k3];
            }
        }
        if (!this.symmetricMatrixInvert(covar)) {
            return false;
        }
        for (i = 0; i < N; ++i) {
            coef[i] = 0.0;
            for (j = 0; j < N; ++j) {
                int n = i;
                coef[n] = coef[n] + covar[i][j] * B[j];
            }
        }
        double TSS = 0.0;
        double RSS = 0.0;
        double YBAR = 0.0;
        double WSUM = 0.0;
        for (k = 0; k < M; ++k) {
            YBAR += W[k] * Y[k];
            WSUM += W[k];
        }
        YBAR /= WSUM;
        for (k = 0; k < M; ++k) {
            double fitY = 0.0;
            for (int i2 = 0; i2 < N; ++i2) {
                fitY += coef[i2] * X2[k][i2];
            }
            residual[k] = fitY - Y[k];
            TSS += W[k] * (Y[k] - YBAR) * (Y[k] - YBAR);
            RSS += W[k] * residual[k] * residual[k];
        }
        double SSQ = RSS / (double)NDF;
        for (int i3 = 0; i3 < N; ++i3) {
            int j2 = 0;
            while (j2 < N) {
                double[] dArray = covar[i3];
                int n = j2++;
                dArray[n] = dArray[n] * SSQ;
            }
            coefSD[i3] = Math.sqrt(covar[i3][i3]);
        }
        return true;
    }

    public boolean symmetricMatrixInvert(double[][] V) {
        int M;
        int N = V.length;
        double[] t = new double[N];
        double[] Q = new double[N];
        double[] R = new double[N];
        int K = 0;
        for (M = 0; M < N; ++M) {
            R[M] = 1.0;
        }
        for (M = 0; M < N; ++M) {
            int L;
            double Big = 0.0;
            for (L = 0; L < N; ++L) {
                double AB = Math.abs(V[L][L]);
                if (!(AB > Big) || R[L] == 0.0) continue;
                Big = AB;
                K = L;
            }
            if (Big == 0.0) {
                return false;
            }
            R[K] = 0.0;
            Q[K] = 1.0 / V[K][K];
            t[K] = 1.0;
            V[K][K] = 0.0;
            for (L = 0; L < N; ++L) {
                if (L == K) continue;
                t[L] = V[L][K];
                Q[L] = (R[L] == 0.0 ? V[L][K] : -V[L][K]) * Q[K];
                V[L][K] = 0.0;
            }
            for (L = 0; L < N; ++L) {
                for (int J = L; J < N; ++J) {
                    double[] dArray = V[L];
                    int n = J;
                    dArray[n] = dArray[n] + t[L] * Q[J];
                }
            }
        }
        for (int L = 1; L < N; ++L) {
            for (int J = 0; J < L; ++J) {
                V[J][L] = V[L][J];
            }
        }
        return true;
    }

    public double beta(int j) {
        return this.beta.get(j, 0);
    }

    public double R2() {
        if (this.sst == 0.0) {
            return 1.0;
        }
        return 1.0 - this.sse / this.sst;
    }

    public static void main(String[] args) {
        double[][] x_data = new double[][]{{2.0, 10.0}, {0.0, 20.0}, {1.0, 40.0}, {2.0, 80.0}, {1.0, 160.0}, {0.0, 200.0}, {1.0, 15.0}, {2.0, 25.0}, {0.0, 55.0}, {1.0, 92.0}, {2.0, 180.0}, {0.0, 210.0}};
        double[] y_data = new double[]{243.0, 483.0, 508.0, 1503.0, 1764.0, 2129.0, 350.0, 560.0, 750.0, 1600.0, 1850.0, 2200.0};
        System.out.println("Testing Optimized LinearRegressionGty...");
        LinearRegressionGty regression = new LinearRegressionGty(x_data, y_data, true);
        long startTime = System.nanoTime();
        regression.fit();
        long endTime = System.nanoTime();
        double[] pValues = regression.calculatePValues();
        double[] tValues = regression.getTValues();
        double[] se = regression.getSE();
        System.out.println("Fit time: " + (double)(endTime - startTime) / 1000000.0 + " ms");
        System.out.printf("Model: y = %.2f + %.2f * gty + %.2f * cov1 (R^2 = %.3f)\n", regression.beta(0), regression.beta(1), regression.beta(2), regression.R2());
        System.out.println("\n--- Coefficients ---");
        System.out.println("Param\tBeta\tStdErr\tT-value\tP-value");
        System.out.printf("Int\t%.3f\t%.3f\t%.3f\t%.4f\n", regression.beta(0), se[0], tValues[0], pValues[0]);
        System.out.printf("Gty\t%.3f\t%.3f\t%.3f\t%.4f\n", regression.beta(1), se[1], tValues[1], pValues[1]);
        System.out.printf("Cov1\t%.3f\t%.3f\t%.3f\t%.4f\n", regression.beta(2), se[2], tValues[2], pValues[2]);
    }
}

