/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.stat;

import cern.colt.list.DoubleArrayList;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import cern.colt.matrix.linalg.CholeskyDecomposition;
import cern.jet.stat.Probability;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class LogisticRegression {
    int nP;
    int nInd;
    double[] coef;
    DoubleMatrix2D covarianceMatrix;
    double[] Y;
    double[][] X;
    boolean toDebug = false;
    BufferedWriter debugOut;
    double priorCorrectionFactor = 1.0;
    int maxIterTime = 50;
    double tolerateDiff = 1.0E-5;

    public LogisticRegression() {
        this.nP = 0;
        this.nInd = 0;
    }

    public void setCoef(double[] coef) {
        this.coef = coef;
    }

    public void reset(double[][] X2, double[] Y, boolean addIntercept) {
        if (!addIntercept) {
            this.setX(X2);
        } else {
            double[][] newX = new double[X2.length][X2[0].length + 1];
            for (int i = 0; i < X2.length; ++i) {
                newX[i][0] = 1.0;
                System.arraycopy(X2[i], 0, newX[i], 1, X2[0].length);
            }
            this.X = newX;
        }
        this.nP = X2[0].length;
        this.setY(Y);
    }

    public LogisticRegression(double[][] X2, double[] Y, boolean addIntercept) {
        if (!addIntercept) {
            this.setX(X2);
        } else {
            double[][] newX = new double[X2.length][X2[0].length + 1];
            for (int i = 0; i < X2.length; ++i) {
                newX[i][0] = 1.0;
                System.arraycopy(X2[i], 0, newX[i], 1, X2[0].length);
            }
            this.X = newX;
        }
        this.nP = X2[0].length;
        this.setY(Y);
    }

    public void addIntercept() {
        double[][] newX = new double[this.X.length][this.X[0].length + 1];
        for (int i = 0; i < this.X.length; ++i) {
            newX[i][0] = 1.0;
            System.arraycopy(this.X[i], 0, newX[i], 1, this.X[0].length);
        }
        this.X = newX;
        this.nP = this.X[0].length;
    }

    public void reset() {
        this.nP = 0;
        this.nInd = 0;
    }

    public double[][] getX() {
        return this.X;
    }

    public void setX(double[][] X2) {
        this.X = X2;
        if (X2 == null || X2.length == 0 || X2[0].length == 0) {
            System.err.println("No independent variables!!!");
            return;
        }
        for (double[] x : X2) {
            if (x[0] == 1.0) continue;
            System.err.println("The first column of X values must be 1 to consider the intercept for logistic regression!!!");
        }
        this.nP = X2[0].length;
    }

    public double[] getY() {
        return this.Y;
    }

    public void setY(double[] Y) {
        this.Y = Y;
        if (Y == null || Y.length == 0) {
            System.err.println("No dependent variables!!!");
            return;
        }
        for (double v : Y) {
            if (v == 0.0 || v == 1.0) continue;
            System.err.println("Y values must be 0  or 1 for logistic regression!!!");
        }
        this.nInd = Y.length;
    }

    public double getPriorCorrectionFactor() {
        return this.priorCorrectionFactor;
    }

    public void setPriorCorrectionFactor(double priorCorrectionFactor) {
        int caseNum = 0;
        int controlNum = 0;
        for (int i = 0; i < this.Y.length; ++i) {
            if (this.Y[i] == 0.0) {
                ++controlNum;
                continue;
            }
            ++caseNum;
        }
        priorCorrectionFactor /= 1.0 - priorCorrectionFactor;
        this.priorCorrectionFactor = priorCorrectionFactor = (double)caseNum / priorCorrectionFactor / (double)controlNum;
    }

    public void setVariables(List<double[]> indivList) {
        int varNum;
        int n = indivList.size();
        if (n == 0) {
            return;
        }
        DoubleArrayList tmpY = new DoubleArrayList();
        ArrayList tmpX = new ArrayList();
        this.nP = varNum = indivList.get(0).length;
        this.nInd = indivList.size();
        this.Y = new double[this.nInd];
        this.X = new double[this.nInd][this.nP];
        for (int i = 0; i < n; ++i) {
            double[] cells = indivList.get(i);
            this.Y[i] = cells[varNum - 1];
            this.X[i][0] = 1.0;
            System.arraycopy(cells, 0, this.X[i], 1, varNum - 1);
        }
    }

    public void standardiseIndependent() {
        int j;
        int i;
        double[] xMean = new double[this.nP];
        double[] xSD = new double[this.nP];
        Arrays.fill(xMean, 0.0);
        Arrays.fill(xSD, 0.0);
        for (i = 0; i < this.nInd; ++i) {
            for (j = 1; j < this.nP; ++j) {
                int n = j;
                xMean[n] = xMean[n] + this.X[i][j];
                int n2 = j;
                xSD[n2] = xSD[n2] + this.X[i][j] * this.X[i][j];
            }
        }
        xMean[0] = 0.0;
        xSD[0] = 1.0;
        for (int j2 = 1; j2 < this.nP; ++j2) {
            xMean[j2] = xMean[j2] / (double)this.nInd;
            xSD[j2] = this.nInd > 1 ? Math.sqrt(Math.abs(xSD[j2] - (double)this.nInd * xMean[j2] * xMean[j2]) / (double)(this.nInd - 1)) : 0.0;
        }
        for (i = 0; i < this.nInd; ++i) {
            for (j = 1; j < this.nP; ++j) {
                if (xSD[j] == 0.0) continue;
                this.X[i][j] = (this.X[i][j] - xMean[j]) / xSD[j];
            }
        }
    }

    public boolean fitLM0() throws Exception {
        int j;
        if (this.Y == null || this.Y.length == 0) {
            System.err.println("No dependent variables!!!");
            return false;
        }
        this.nInd = this.Y.length;
        if (this.X == null || this.X.length == 0 || this.X[0].length == 0) {
            System.err.println("No independent variables!!!");
            return false;
        }
        this.nP = this.X[0].length;
        this.coef = new double[this.nP];
        Arrays.fill(this.coef, 0.0);
        if (this.toDebug) {
            this.debugOut = new BufferedWriter(new FileWriter("debug.txt"));
            for (int i = 0; i < this.nInd; ++i) {
                this.debugOut.write(String.valueOf(this.Y[i]));
                for (int j2 = 1; j2 < this.nP; ++j2) {
                    this.debugOut.write("\t" + this.X[i][j2]);
                }
                this.debugOut.write(10);
            }
            this.debugOut.close();
        }
        boolean converge = false;
        int it = 0;
        double[] p = new double[this.nInd];
        double[] V = new double[this.nInd];
        this.covarianceMatrix = new DenseDoubleMatrix2D(this.nP, this.nP);
        double[][] T2 = new double[this.nP][this.nInd];
        double[] t3 = new double[this.nInd];
        double[] ncoef = new double[this.nP];
        Algebra algebra = new Algebra();
        double delta = 0.0;
        while (!converge) {
            int j3;
            int i;
            for (i = 0; i < this.nInd; ++i) {
                double t = 0.0;
                for (j = 0; j < this.nP; ++j) {
                    t += this.coef[j] * this.X[i][j];
                }
                p[i] = 1.0 / (1.0 + Math.exp(-t));
                V[i] = p[i] * (1.0 - p[i]);
            }
            for (j3 = 0; j3 < this.nP; ++j3) {
                for (int k = j3; k < this.nP; ++k) {
                    double sum = 0.0;
                    for (int i2 = 0; i2 < this.nInd; ++i2) {
                        sum += this.X[i2][j3] * V[i2] * this.X[i2][k];
                    }
                    this.covarianceMatrix.setQuick(j3, k, sum);
                    this.covarianceMatrix.setQuick(k, j3, sum);
                }
            }
            this.covarianceMatrix = algebra.inverse(this.covarianceMatrix);
            for (i = 0; i < this.nP; ++i) {
                Arrays.fill(T2[i], 0.0);
            }
            for (i = 0; i < this.nP; ++i) {
                for (j = 0; j < this.nInd; ++j) {
                    for (int k = 0; k < this.nP; ++k) {
                        double[] dArray = T2[i];
                        int n = j;
                        dArray[n] = dArray[n] + this.covarianceMatrix.getQuick(i, k) * this.X[j][k];
                    }
                }
            }
            for (i = 0; i < this.nInd; ++i) {
                t3[i] = this.Y[i] - p[i];
            }
            Arrays.fill(ncoef, 0.0);
            for (j3 = 0; j3 < this.nP; ++j3) {
                for (int i3 = 0; i3 < this.nInd; ++i3) {
                    int n = j3;
                    ncoef[n] = ncoef[n] + T2[j3][i3] * t3[i3];
                }
            }
            delta = 0.0;
            for (j3 = 0; j3 < this.nP; ++j3) {
                delta += Math.abs(ncoef[j3]);
                int n = j3;
                this.coef[n] = this.coef[n] + ncoef[j3];
            }
            if (delta < this.tolerateDiff) {
                converge = true;
            }
            if (++it <= this.maxIterTime || converge) continue;
            return false;
        }
        if (this.toDebug) {
            int endIndex = this.nP - 1;
            System.out.print("Beta\n");
            for (j = 0; j < endIndex; ++j) {
                System.out.print(this.coef[j]);
                System.out.print("\t");
            }
            System.out.println(this.coef[endIndex]);
            System.out.print("Std. Error\n");
            for (j = 0; j < endIndex; ++j) {
                System.out.print(Math.sqrt(this.covarianceMatrix.getQuick(j, j)));
                System.out.print("\t");
            }
            System.out.println(Math.sqrt(this.covarianceMatrix.getQuick(endIndex, endIndex)));
            System.out.print(this.getModelPValue() + "\n");
        }
        return true;
    }

    public boolean fitLM() throws Exception {
        if (this.Y == null || this.Y.length == 0) {
            System.err.println("No dependent variables!!!");
            return false;
        }
        this.nInd = this.Y.length;
        if (this.X == null || this.X.length == 0 || this.X[0].length == 0) {
            System.err.println("No independent variables!!!");
            return false;
        }
        this.nP = this.X[0].length;
        this.coef = new double[this.nP];
        Arrays.fill(this.coef, 0.0);
        boolean converge = false;
        int it = 0;
        double[] p = new double[this.nInd];
        double[] V = new double[this.nInd];
        this.covarianceMatrix = new DenseDoubleMatrix2D(this.nP, this.nP);
        double[][] T2 = new double[this.nP][this.nInd];
        double[] t3 = new double[this.nInd];
        double[] ncoef = new double[this.nP];
        Algebra algebra = new Algebra();
        double delta = 0.0;
        while (!converge) {
            int i;
            int i2;
            double sum;
            int j;
            for (int i3 = 0; i3 < this.nInd; ++i3) {
                double t = 0.0;
                for (j = 0; j < this.nP; ++j) {
                    t += this.coef[j] * this.X[i3][j];
                }
                p[i3] = 1.0 / (1.0 + Math.exp(-t));
                V[i3] = p[i3] * (1.0 - p[i3]);
            }
            this.covarianceMatrix.assign(0.0);
            for (int j2 = 0; j2 < this.nP; ++j2) {
                for (int k = j2; k < this.nP; ++k) {
                    sum = 0.0;
                    for (i2 = 0; i2 < this.nInd; ++i2) {
                        sum += this.X[i2][j2] * V[i2] * this.X[i2][k];
                    }
                    this.covarianceMatrix.setQuick(j2, k, sum);
                    if (j2 == k) continue;
                    this.covarianceMatrix.setQuick(k, j2, sum);
                }
            }
            DoubleMatrix2D invCovarianceMatrix = algebra.inverse(this.covarianceMatrix);
            for (i = 0; i < this.nP; ++i) {
                for (int j3 = 0; j3 < this.nInd; ++j3) {
                    sum = 0.0;
                    for (int k = 0; k < this.nP; ++k) {
                        sum += invCovarianceMatrix.getQuick(i, k) * this.X[j3][k];
                    }
                    T2[i][j3] = sum;
                }
            }
            for (i = 0; i < this.nInd; ++i) {
                t3[i] = this.Y[i] - p[i];
            }
            for (j = 0; j < this.nP; ++j) {
                sum = 0.0;
                for (i2 = 0; i2 < this.nInd; ++i2) {
                    sum += T2[j][i2] * t3[i2];
                }
                ncoef[j] = sum;
            }
            delta = 0.0;
            for (j = 0; j < this.nP; ++j) {
                delta += Math.abs(ncoef[j]);
                int n = j;
                this.coef[n] = this.coef[n] + ncoef[j];
            }
            if (delta < this.tolerateDiff) {
                converge = true;
            }
            if (++it <= this.maxIterTime || converge) continue;
            return false;
        }
        return true;
    }

    public boolean fitLM4() throws Exception {
        int j;
        int i;
        if (this.Y == null || this.Y.length == 0) {
            System.err.println("No dependent variables!!!");
            return false;
        }
        this.nInd = this.Y.length;
        if (this.X == null || this.X.length == 0 || this.X[0].length == 0) {
            System.err.println("No independent variables!!!");
            return false;
        }
        this.nP = this.X[0].length;
        this.coef = new double[this.nP];
        Arrays.fill(this.coef, 0.0);
        boolean converge = false;
        int it = 0;
        double[] p = new double[this.nInd];
        double[] V = new double[this.nInd];
        this.covarianceMatrix = new DenseDoubleMatrix2D(this.nP, this.nP);
        double[][] T2 = new double[this.nP][this.nInd];
        double[] t3 = new double[this.nInd];
        double[] ncoef = new double[this.nP];
        Algebra algebra = new Algebra();
        double delta = 0.0;
        double[][] XT = new double[this.nP][this.nInd];
        for (i = 0; i < this.nP; ++i) {
            for (j = 0; j < this.nInd; ++j) {
                XT[i][j] = this.X[j][i];
            }
        }
        while (!converge) {
            int j2;
            for (i = 0; i < this.nInd; ++i) {
                double t = 0.0;
                for (j = 0; j < this.nP; ++j) {
                    t += this.coef[j] * this.X[i][j];
                }
                p[i] = 1.0 / (1.0 + Math.exp(-t));
                V[i] = p[i] * (1.0 - p[i]);
            }
            for (j2 = 0; j2 < this.nP; ++j2) {
                for (int k = j2; k < this.nP; ++k) {
                    double sum = 0.0;
                    for (int i2 = 0; i2 < this.nInd; ++i2) {
                        sum += XT[j2][i2] * V[i2] * this.X[i2][k];
                    }
                    this.covarianceMatrix.setQuick(j2, k, sum);
                    this.covarianceMatrix.setQuick(k, j2, sum);
                }
            }
            this.covarianceMatrix = algebra.inverse(this.covarianceMatrix);
            for (i = 0; i < this.nP; ++i) {
                Arrays.fill(T2[i], 0.0);
            }
            for (i = 0; i < this.nP; ++i) {
                for (j = 0; j < this.nInd; ++j) {
                    for (int k = 0; k < this.nP; ++k) {
                        double[] dArray = T2[i];
                        int n = j;
                        dArray[n] = dArray[n] + this.covarianceMatrix.getQuick(i, k) * this.X[j][k];
                    }
                }
            }
            for (i = 0; i < this.nInd; ++i) {
                t3[i] = this.Y[i] - p[i];
            }
            Arrays.fill(ncoef, 0.0);
            for (j2 = 0; j2 < this.nP; ++j2) {
                for (int i3 = 0; i3 < this.nInd; ++i3) {
                    int n = j2;
                    ncoef[n] = ncoef[n] + T2[j2][i3] * t3[i3];
                }
            }
            delta = 0.0;
            for (j2 = 0; j2 < this.nP; ++j2) {
                delta += Math.abs(ncoef[j2]);
                int n = j2;
                this.coef[n] = this.coef[n] + ncoef[j2];
            }
            if (delta < this.tolerateDiff) {
                converge = true;
            }
            if (++it <= this.maxIterTime || converge) continue;
            return false;
        }
        return true;
    }

    public boolean fitLM5() {
        if (this.Y == null || this.Y.length == 0) {
            System.err.println("No dependent variables!!!");
            return false;
        }
        int nInd = this.Y.length;
        if (this.X == null || this.X.length == 0 || this.X[0].length == 0) {
            System.err.println("No independent variables!!!");
            return false;
        }
        this.nP = this.X[0].length;
        this.coef = new double[this.nP];
        Arrays.fill(this.coef, 0.0);
        boolean converge = false;
        int it = 0;
        double[] p = new double[nInd];
        double[] V = new double[nInd];
        this.covarianceMatrix = new DenseDoubleMatrix2D(this.nP, this.nP);
        double[] t3 = new double[nInd];
        double[] ncoef = new double[this.nP];
        Algebra algebra = new Algebra();
        while (!converge) {
            int i;
            int i2;
            for (i2 = 0; i2 < nInd; ++i2) {
                double t = 0.0;
                for (int j = 0; j < this.nP; ++j) {
                    t += this.coef[j] * this.X[i2][j];
                }
                p[i2] = 1.0 / (1.0 + Math.exp(-t));
                V[i2] = p[i2] * (1.0 - p[i2]);
            }
            this.covarianceMatrix.assign(0.0);
            for (i2 = 0; i2 < nInd; ++i2) {
                double vi = V[i2];
                double[] Xi = this.X[i2];
                for (int j = 0; j < this.nP; ++j) {
                    double xj = Xi[j] * vi;
                    for (int k = j; k < this.nP; ++k) {
                        double val = xj * Xi[k];
                        this.covarianceMatrix.setQuick(j, k, this.covarianceMatrix.getQuick(j, k) + val);
                        if (j == k) continue;
                        this.covarianceMatrix.setQuick(k, j, this.covarianceMatrix.getQuick(k, j) + val);
                    }
                }
            }
            try {
                CholeskyDecomposition chol = new CholeskyDecomposition(this.covarianceMatrix);
                DenseDoubleMatrix2D identityMatrix = new DenseDoubleMatrix2D(this.nP, this.nP);
                identityMatrix.assign(0.0);
                for (int i3 = 0; i3 < this.nP; ++i3) {
                    identityMatrix.setQuick(i3, i3, 1.0);
                }
                this.covarianceMatrix = chol.solve(identityMatrix);
            }
            catch (IllegalArgumentException e) {
                this.covarianceMatrix = algebra.inverse(this.covarianceMatrix);
            }
            for (int i4 = 0; i4 < nInd; ++i4) {
                t3[i4] = this.Y[i4] - p[i4];
            }
            double[] temp = new double[this.nP];
            Arrays.fill(temp, 0.0);
            for (i = 0; i < nInd; ++i) {
                double t3_i = t3[i];
                double[] Xi = this.X[i];
                for (int j = 0; j < this.nP; ++j) {
                    int n = j;
                    temp[n] = temp[n] + Xi[j] * t3_i;
                }
            }
            Arrays.fill(ncoef, 0.0);
            for (i = 0; i < this.nP; ++i) {
                for (int k = 0; k < this.nP; ++k) {
                    int n = i;
                    ncoef[n] = ncoef[n] + this.covarianceMatrix.getQuick(i, k) * temp[k];
                }
            }
            double delta = 0.0;
            for (int j = 0; j < this.nP; ++j) {
                delta += Math.abs(ncoef[j]);
                int n = j;
                this.coef[n] = this.coef[n] + ncoef[j];
            }
            if (delta < this.tolerateDiff) {
                converge = true;
            }
            if (++it <= this.maxIterTime) continue;
            return false;
        }
        return true;
    }

    public double getLnLk() {
        double lnlk = 0.0;
        for (int i = 0; i < this.nInd; ++i) {
            double t = 0.0;
            for (int j = 0; j < this.nP; ++j) {
                t += this.coef[j] * this.X[i][j];
            }
            lnlk += this.Y[i] == 1.0 ? Math.log(1.0 / (1.0 + Math.exp(-t))) : Math.log(1.0 - 1.0 / (1.0 + Math.exp(-t)));
        }
        return lnlk;
    }

    public double getModelPValue() throws Exception {
        double pi0 = 0.0;
        for (int i = 0; i < this.nInd; ++i) {
            pi0 += this.Y[i];
        }
        double null_LL = (double)this.nInd * ((pi0 /= (double)this.nInd) * Math.log(pi0 / (1.0 - pi0)) + Math.log(1.0 - pi0));
        double chiSqure = 2.0 * (this.getLnLk() - null_LL);
        double pValue = 1.0;
        pValue = Probability.chiSquareComplemented(this.nP - 1, chiSqure);
        return pValue;
    }

    public double[] calcDevianceResiduals() {
        double[] expectedVs = new double[this.nInd];
        double pi0 = 0.0;
        for (int i = 0; i < this.nInd; ++i) {
            expectedVs[i] = this.coef[0];
            for (int j = 1; j < this.coef.length; ++j) {
                int n = i;
                expectedVs[n] = expectedVs[n] + this.coef[j] * this.X[i][j];
            }
            expectedVs[i] = Math.exp(expectedVs[i]);
            expectedVs[i] = expectedVs[i] / (1.0 + expectedVs[i]);
            if (this.Y[i] == 1.0) {
                expectedVs[i] = Math.sqrt(-2.0 * Math.log(expectedVs[i]));
                continue;
            }
            if (this.Y[i] != 0.0) continue;
            expectedVs[i] = -Math.sqrt(-2.0 * Math.log(1.0 - expectedVs[i]));
        }
        return expectedVs;
    }

    public double getCoefPValue(int testParameter) throws Exception {
        double[] var = this.getVar();
        double se = Math.sqrt(var[testParameter]);
        double Z = this.coef[testParameter] / se;
        return Probability.chiSquareComplemented(1.0, Z * Z);
    }

    public double getCoefPValueWithTTest(int testParameter) throws Exception {
        double[] var = this.getVar();
        double se = Math.sqrt(var[testParameter]);
        double Z = this.coef[testParameter] / se;
        return 2.0 * (1.0 - Probability.normal(Math.abs(Z)));
    }

    public double getCoef(int testParameter) throws Exception {
        return this.coef[testParameter];
    }

    public double getNagelkerkeRSquare() {
        double pi0 = 0.0;
        for (int i = 0; i < this.nInd; ++i) {
            pi0 += this.Y[i];
        }
        double null_LL = (double)this.nInd * ((pi0 /= (double)this.nInd) * Math.log(pi0 / (1.0 - pi0)) + Math.log(1.0 - pi0));
        double r = 1.0 - Math.pow(Math.exp(null_LL - this.getLnLk()), 2.0 / (double)this.nInd);
        return r /= 1.0 - Math.pow(Math.exp(null_LL), 2.0 / (double)this.nInd);
    }

    public double[] getVar() {
        double[] var = new double[this.nP];
        for (int i = 0; i < this.nP; ++i) {
            var[i] = this.covarianceMatrix.getQuick(i, i);
        }
        return var;
    }

    public double[] getOR() {
        double[] OR = new double[this.nP];
        for (int i = 0; i < this.nP; ++i) {
            OR[i] = Math.exp(this.coef[i]);
        }
        return OR;
    }

    public double[] getZv() {
        double[] Zv = new double[this.nP];
        double[] sd = this.getSE();
        for (int i = 0; i < this.nP; ++i) {
            Zv[i] = this.coef[i] / sd[i];
        }
        return Zv;
    }

    public double[][] getConfidenceInterval() {
        double[][] confidenceInterval = new double[this.nP][2];
        double[] SDs = this.getSE();
        for (int i = 0; i < this.nP; ++i) {
            double lower;
            double sd = SDs[i];
            double upper = this.coef[i] + 1.96 * sd;
            confidenceInterval[i][0] = lower = this.coef[i] - 1.96 * sd;
            confidenceInterval[i][1] = upper;
        }
        return confidenceInterval;
    }

    public double[][] getORConfidenceInterval() {
        double[][] confidenceInterval = new double[this.nP][2];
        double[] SDs = this.getSE();
        for (int i = 0; i < this.nP; ++i) {
            double sd = SDs[i];
            double lower = Math.exp(this.coef[i] - 1.96 * sd);
            double upper = Math.exp(this.coef[i] + 1.96 * sd);
            confidenceInterval[i][0] = lower;
            confidenceInterval[i][1] = upper;
        }
        return confidenceInterval;
    }

    public double getGivenProbability(double[] scores) {
        double p = this.coef[0];
        for (int i = 1; i < this.coef.length; ++i) {
            p += this.coef[i] * scores[i];
        }
        p = 1.0 + this.priorCorrectionFactor * Math.exp(-p);
        return 1.0 / p;
    }

    public double[] getSE() {
        double[] var = new double[this.nP];
        for (int i = 0; i < this.nP; ++i) {
            var[i] = Math.sqrt(this.covarianceMatrix.getQuick(i, i));
        }
        return var;
    }

    public double[] getCoefs() {
        return this.coef;
    }

    public String toString() {
        int j;
        double[] coef_SE = this.getSE();
        int df = this.nP;
        StringBuffer result = new StringBuffer();
        if (this.coef == null) {
            return result.append(": No model built yet.").toString();
        }
        result.append("\nCoefficients...\nVariable      Coeff.      td. Error       z value      Pr(>|z|)\n");
        try {
            for (j = 1; j < this.nP; ++j) {
                result.append(String.format("%8.0f", Float.valueOf(j)));
                result.append(" " + String.format("%10.4f", this.coef[j]));
                result.append(" " + String.format("%10.4f", coef_SE[j]));
                result.append(" " + String.format("%10.4f", this.coef[j] / coef_SE[j]));
                result.append(" " + String.format("%10.4f", Probability.chiSquareComplemented(1.0, Math.pow(this.coef[j] / coef_SE[j], 2.0))));
                result.append("\n");
            }
            result.append("Intercept ");
            result.append(" " + String.format("%10.4f", this.coef[0]));
            result.append(" " + String.format("%10.4f", coef_SE[0]));
            result.append(" " + String.format("%10.4f", this.coef[0] / coef_SE[0]));
            result.append(" " + String.format("%10.4f", Probability.chiSquareComplemented(1.0, Math.pow(this.coef[0] / coef_SE[0], 2.0))));
            result.append("\n");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        result.append("\nOdds Ratios...\nVariable         O.R.\n");
        for (j = 1; j < this.nP; ++j) {
            result.append(String.format("%8.0f", Float.valueOf(j)));
            double ORc = Math.exp(this.coef[j]);
            result.append(" " + (ORc > 1.0E10 ? "" + ORc : String.format("%12.4f", ORc)));
            result.append("\n");
        }
        result.append("Significance of the model with these variable(s) ");
        result.append(" p-value ");
        try {
            result.append(this.getModelPValue());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        result.append("\n");
        return result.toString();
    }

    public static void main(String[] args) throws Exception {
        int nrow = 10000;
        int ncol = 10;
        Random random = new Random(1000L);
        double[][] X2 = new double[nrow][ncol];
        double[] Y = new double[nrow];
        for (int i = 0; i < nrow; ++i) {
            for (int j = 0; j < ncol; ++j) {
                X2[i][j] = random.nextDouble();
            }
        }
        long l = System.currentTimeMillis();
        LogisticRegression logisticRegression = new LogisticRegression(X2, Y, true);
        logisticRegression.fitLM0();
        double[] coef = logisticRegression.getCoefs();
        double p = logisticRegression.getCoefPValueWithTTest(1);
        System.out.println(Arrays.toString(coef));
        System.out.println(p);
        System.out.println(Arrays.toString(logisticRegression.getSE()));
        System.out.println(Arrays.toString(logisticRegression.getOR()));
        System.out.println(Arrays.deepToString((Object[])logisticRegression.getORConfidenceInterval()));
        System.out.println(System.currentTimeMillis() - l);
        l = System.currentTimeMillis();
        logisticRegression = new LogisticRegression(X2, Y, true);
        logisticRegression.fitLM4();
        coef = logisticRegression.getCoefs();
        p = logisticRegression.getCoefPValueWithTTest(1);
        System.out.println(Arrays.toString(coef));
        System.out.println(p);
        System.out.println(Arrays.toString(logisticRegression.getSE()));
        System.out.println(Arrays.toString(logisticRegression.getOR()));
        System.out.println(Arrays.deepToString((Object[])logisticRegression.getORConfidenceInterval()));
        System.out.println(System.currentTimeMillis() - l);
        System.out.println("\n----------------------------");
        l = System.currentTimeMillis();
        logisticRegression = new LogisticRegression(X2, Y, true);
        logisticRegression.fitLM5();
        coef = logisticRegression.getCoefs();
        p = logisticRegression.getCoefPValueWithTTest(1);
        System.out.println(Arrays.toString(coef));
        System.out.println(p);
        System.out.println(Arrays.toString(logisticRegression.getSE()));
        System.out.println(Arrays.toString(logisticRegression.getOR()));
        System.out.println(Arrays.deepToString((Object[])logisticRegression.getORConfidenceInterval()));
        System.out.println(System.currentTimeMillis() - l);
    }
}

