/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.stat;

import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import cern.colt.matrix.linalg.CholeskyDecomposition;
import cern.jet.stat.Probability;
import java.io.BufferedWriter;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class LogisticRegressionGty {
    int nP;
    int nInd;
    double[] coef;
    DoubleMatrix2D covarianceMatrix;
    double[] Y;
    double[][] X;
    boolean toDebug = false;
    BufferedWriter debugOut;
    double priorCorrectionFactor = 1.0;
    int maxIterTime = 50;
    double tolerateDiff = 1.0E-5;
    private double[] bufP;
    private double[] bufV;
    private double[] bufT3;
    private double[] bufTemp;
    private double[] bufNcoef;
    private double[] covUpperBuf;
    private int covUpperDim = -1;
    private int[] covUpperBase;
    private DenseDoubleMatrix2D identityMatrix;
    private static final Algebra ALG = new Algebra();
    private double[] outVar;
    private double[] outSE;
    private double[] outOR;
    private double[] outZv;
    private double[][] outCI;
    private double[][] outORCI;
    private long covEpoch = 0L;
    private long coefEpoch = 0L;
    private long varEpoch = -1L;
    private long seEpoch = -1L;
    private long orEpoch = -1L;
    private long zvEpoch = -1L;
    private long ciEpoch = -1L;
    private long orciEpoch = -1L;

    public LogisticRegressionGty() {
        this.nP = 0;
        this.nInd = 0;
    }

    public void setCoef(double[] coef) {
        this.coef = coef;
        ++this.coefEpoch;
        this.orciEpoch = -1L;
        this.ciEpoch = -1L;
        this.zvEpoch = -1L;
        this.orEpoch = -1L;
    }

    public LogisticRegressionGty(double[][] X2, double[] Y, boolean addIntercept) {
        if (!addIntercept) {
            this.setX(X2);
        } else {
            double[][] newX = new double[X2.length][X2[0].length + 1];
            for (int i = 0; i < X2.length; ++i) {
                newX[i][0] = 1.0;
                System.arraycopy(X2[i], 0, newX[i], 1, X2[0].length);
            }
            this.X = newX;
        }
        this.nP = this.X[0].length;
        this.setY(Y);
    }

    public void addIntercept() {
        double[][] newX = new double[this.X.length][this.X[0].length + 1];
        for (int i = 0; i < this.X.length; ++i) {
            newX[i][0] = 1.0;
            System.arraycopy(this.X[i], 0, newX[i], 1, this.X[0].length);
        }
        this.X = newX;
        this.nP = this.X[0].length;
        this.invalidateBuffersOnDimChange();
    }

    private void invalidateBuffersOnDimChange() {
        this.bufP = null;
        this.bufV = null;
        this.bufT3 = null;
        this.bufTemp = null;
        this.bufNcoef = null;
        this.covUpperBuf = null;
        this.covUpperDim = -1;
        this.covUpperBase = null;
        this.outZv = null;
        this.outOR = null;
        this.outSE = null;
        this.outVar = null;
        this.outORCI = null;
        this.outCI = this.outORCI;
        this.identityMatrix = null;
        this.covarianceMatrix = null;
        this.orciEpoch = -1L;
        this.ciEpoch = -1L;
        this.zvEpoch = -1L;
        this.orEpoch = -1L;
        this.seEpoch = -1L;
        this.varEpoch = -1L;
    }

    private void invalidateBuffersOnRowChange() {
        this.bufP = null;
        this.bufV = null;
        this.bufT3 = null;
    }

    public double[][] getX() {
        return this.X;
    }

    public void setX(double[][] X2) {
        this.X = X2;
        if (X2 == null || X2.length == 0 || X2[0].length == 0) {
            System.err.println("No independent variables!!!");
            return;
        }
        for (double[] x : X2) {
            if (x[0] == 1.0) continue;
            System.err.println("The first column of X values must be 1 to consider the intercept for logistic regression!!!");
        }
        if (this.nP != X2[0].length) {
            this.nP = X2[0].length;
            this.invalidateBuffersOnDimChange();
        }
    }

    public double[] getY() {
        return this.Y;
    }

    public void setY(double[] Y) {
        this.Y = Y;
        if (Y == null || Y.length == 0) {
            System.err.println("No dependent variables!!!");
            return;
        }
        for (double v : Y) {
            if (v == 0.0 || v == 1.0) continue;
            System.err.println("Y values must be 0 or 1 for logistic regression!!!");
        }
        if (this.nInd != Y.length) {
            this.nInd = Y.length;
            this.invalidateBuffersOnRowChange();
        }
    }

    public double getPriorCorrectionFactor() {
        return this.priorCorrectionFactor;
    }

    public void setPriorCorrectionFactor(double priorCorrectionFactor) {
        int caseNum = 0;
        int controlNum = 0;
        for (int i = 0; i < this.Y.length; ++i) {
            if (this.Y[i] == 0.0) {
                ++controlNum;
                continue;
            }
            ++caseNum;
        }
        priorCorrectionFactor /= 1.0 - priorCorrectionFactor;
        this.priorCorrectionFactor = priorCorrectionFactor = (double)caseNum / priorCorrectionFactor / (double)controlNum;
    }

    public void setVariables(List<double[]> indivList) {
        int n = indivList.size();
        if (n == 0) {
            return;
        }
        this.nP = indivList.get(0).length;
        this.nInd = indivList.size();
        this.Y = new double[this.nInd];
        this.X = new double[this.nInd][this.nP];
        for (int i = 0; i < n; ++i) {
            double[] cells = indivList.get(i);
            this.Y[i] = cells[this.nP - 1];
            this.X[i][0] = 1.0;
            System.arraycopy(cells, 0, this.X[i], 1, this.nP - 1);
        }
        this.invalidateBuffersOnDimChange();
    }

    public void standardiseIndependent() {
        int j;
        int i;
        double[] xMean = new double[this.nP];
        double[] xSD = new double[this.nP];
        for (i = 0; i < this.nInd; ++i) {
            for (j = 1; j < this.nP; ++j) {
                int n = j;
                xMean[n] = xMean[n] + this.X[i][j];
                int n2 = j;
                xSD[n2] = xSD[n2] + this.X[i][j] * this.X[i][j];
            }
        }
        xMean[0] = 0.0;
        xSD[0] = 1.0;
        for (int j2 = 1; j2 < this.nP; ++j2) {
            xMean[j2] = xMean[j2] / (double)this.nInd;
            xSD[j2] = this.nInd > 1 ? Math.sqrt(Math.abs(xSD[j2] - (double)this.nInd * xMean[j2] * xMean[j2]) / (double)(this.nInd - 1)) : 0.0;
        }
        for (i = 0; i < this.nInd; ++i) {
            for (j = 1; j < this.nP; ++j) {
                if (xSD[j] == 0.0) continue;
                this.X[i][j] = (this.X[i][j] - xMean[j]) / xSD[j];
            }
        }
    }

    public boolean fitLM5() throws Exception {
        if (this.Y == null || this.Y.length == 0) {
            System.err.println("No dependent variables!!!");
            return false;
        }
        int nInd = this.Y.length;
        if (this.X == null || this.X.length == 0 || this.X[0].length == 0) {
            System.err.println("No independent variables!!!");
            return false;
        }
        this.nP = this.X[0].length;
        if (this.coef == null || this.coef.length != this.nP) {
            this.coef = new double[this.nP];
        } else {
            Arrays.fill(this.coef, 0.0);
        }
        if (this.bufP == null || this.bufP.length < nInd) {
            this.bufP = new double[nInd];
        }
        if (this.bufV == null || this.bufV.length < nInd) {
            this.bufV = new double[nInd];
        }
        if (this.bufT3 == null || this.bufT3.length < nInd) {
            this.bufT3 = new double[nInd];
        }
        if (this.bufTemp == null || this.bufTemp.length != this.nP) {
            this.bufTemp = new double[this.nP];
        }
        if (this.bufNcoef == null || this.bufNcoef.length != this.nP) {
            this.bufNcoef = new double[this.nP];
        }
        if (this.covUpperDim != this.nP || this.covUpperBuf == null) {
            this.covUpperDim = this.nP;
            this.covUpperBuf = new double[this.nP * (this.nP + 1) / 2];
            this.covUpperBase = new int[this.nP];
            int base = 0;
            for (int r = 0; r < this.nP; ++r) {
                this.covUpperBase[r] = base;
                base += this.nP - r;
            }
        }
        if (this.covarianceMatrix == null || this.covarianceMatrix.rows() != this.nP || this.covarianceMatrix.columns() != this.nP) {
            this.covarianceMatrix = new DenseDoubleMatrix2D(this.nP, this.nP);
        }
        if (this.identityMatrix == null || this.identityMatrix.rows() != this.nP || this.identityMatrix.columns() != this.nP) {
            this.identityMatrix = new DenseDoubleMatrix2D(this.nP, this.nP);
            for (int i = 0; i < this.nP; ++i) {
                this.identityMatrix.setQuick(i, i, 1.0);
            }
        }
        boolean converge = false;
        int it = 0;
        boolean smallDim = this.nP <= 8;
        double[] localCoef = this.coef;
        while (!converge) {
            int i;
            double[] Xi;
            int i2;
            if (smallDim) {
                for (i2 = 0; i2 < nInd; ++i2) {
                    double pi;
                    double[] Xi2 = this.X[i2];
                    double t = localCoef[0];
                    switch (this.nP) {
                        case 8: {
                            t += localCoef[7] * Xi2[7];
                        }
                        case 7: {
                            t += localCoef[6] * Xi2[6];
                        }
                        case 6: {
                            t += localCoef[5] * Xi2[5];
                        }
                        case 5: {
                            t += localCoef[4] * Xi2[4];
                        }
                        case 4: {
                            t += localCoef[3] * Xi2[3];
                        }
                        case 3: {
                            t += localCoef[2] * Xi2[2];
                        }
                        case 2: {
                            t += localCoef[1] * Xi2[1];
                        }
                    }
                    this.bufP[i2] = pi = t >= 0.0 ? 1.0 / (1.0 + Math.exp(-t)) : Math.exp(t) / (1.0 + Math.exp(t));
                    this.bufV[i2] = pi * (1.0 - pi);
                }
            } else {
                for (i2 = 0; i2 < nInd; ++i2) {
                    double pi;
                    double[] Xi3 = this.X[i2];
                    double t = localCoef[0];
                    for (int j = 1; j < this.nP; ++j) {
                        t += localCoef[j] * Xi3[j];
                    }
                    this.bufP[i2] = pi = t >= 0.0 ? 1.0 / (1.0 + Math.exp(-t)) : Math.exp(t) / (1.0 + Math.exp(t));
                    this.bufV[i2] = pi * (1.0 - pi);
                }
            }
            Arrays.fill(this.covUpperBuf, 0.0);
            if (smallDim) {
                block37: for (i2 = 0; i2 < nInd; ++i2) {
                    double vi = this.bufV[i2];
                    Xi = this.X[i2];
                    switch (this.nP) {
                        case 8: {
                            int base;
                            double g = Xi[1];
                            double c2 = Xi[2];
                            double c3 = Xi[3];
                            double c4 = Xi[4];
                            double c5 = Xi[5];
                            double c6 = Xi[6];
                            double c7 = Xi[7];
                            int n = base = this.covUpperBase[0];
                            this.covUpperBuf[n] = this.covUpperBuf[n] + vi;
                            int n2 = base + 1;
                            this.covUpperBuf[n2] = this.covUpperBuf[n2] + vi * g;
                            int n3 = base + 2;
                            this.covUpperBuf[n3] = this.covUpperBuf[n3] + vi * c2;
                            int n4 = base + 3;
                            this.covUpperBuf[n4] = this.covUpperBuf[n4] + vi * c3;
                            int n5 = base + 4;
                            this.covUpperBuf[n5] = this.covUpperBuf[n5] + vi * c4;
                            int n6 = base + 5;
                            this.covUpperBuf[n6] = this.covUpperBuf[n6] + vi * c5;
                            int n7 = base + 6;
                            this.covUpperBuf[n7] = this.covUpperBuf[n7] + vi * c6;
                            int n8 = base + 7;
                            this.covUpperBuf[n8] = this.covUpperBuf[n8] + vi * c7;
                            base = this.covUpperBase[1];
                            double gv = g * vi;
                            int n9 = base;
                            this.covUpperBuf[n9] = this.covUpperBuf[n9] + gv * g;
                            int n10 = base + 1;
                            this.covUpperBuf[n10] = this.covUpperBuf[n10] + gv * c2;
                            int n11 = base + 2;
                            this.covUpperBuf[n11] = this.covUpperBuf[n11] + gv * c3;
                            int n12 = base + 3;
                            this.covUpperBuf[n12] = this.covUpperBuf[n12] + gv * c4;
                            int n13 = base + 4;
                            this.covUpperBuf[n13] = this.covUpperBuf[n13] + gv * c5;
                            int n14 = base + 5;
                            this.covUpperBuf[n14] = this.covUpperBuf[n14] + gv * c6;
                            int n15 = base + 6;
                            this.covUpperBuf[n15] = this.covUpperBuf[n15] + gv * c7;
                            base = this.covUpperBase[2];
                            double c2v = c2 * vi;
                            int n16 = base;
                            this.covUpperBuf[n16] = this.covUpperBuf[n16] + c2v * c2;
                            int n17 = base + 1;
                            this.covUpperBuf[n17] = this.covUpperBuf[n17] + c2v * c3;
                            int n18 = base + 2;
                            this.covUpperBuf[n18] = this.covUpperBuf[n18] + c2v * c4;
                            int n19 = base + 3;
                            this.covUpperBuf[n19] = this.covUpperBuf[n19] + c2v * c5;
                            int n20 = base + 4;
                            this.covUpperBuf[n20] = this.covUpperBuf[n20] + c2v * c6;
                            int n21 = base + 5;
                            this.covUpperBuf[n21] = this.covUpperBuf[n21] + c2v * c7;
                            base = this.covUpperBase[3];
                            double c3v = c3 * vi;
                            int n22 = base;
                            this.covUpperBuf[n22] = this.covUpperBuf[n22] + c3v * c3;
                            int n23 = base + 1;
                            this.covUpperBuf[n23] = this.covUpperBuf[n23] + c3v * c4;
                            int n24 = base + 2;
                            this.covUpperBuf[n24] = this.covUpperBuf[n24] + c3v * c5;
                            int n25 = base + 3;
                            this.covUpperBuf[n25] = this.covUpperBuf[n25] + c3v * c6;
                            int n26 = base + 4;
                            this.covUpperBuf[n26] = this.covUpperBuf[n26] + c3v * c7;
                            base = this.covUpperBase[4];
                            double c4v = c4 * vi;
                            int n27 = base;
                            this.covUpperBuf[n27] = this.covUpperBuf[n27] + c4v * c4;
                            int n28 = base + 1;
                            this.covUpperBuf[n28] = this.covUpperBuf[n28] + c4v * c5;
                            int n29 = base + 2;
                            this.covUpperBuf[n29] = this.covUpperBuf[n29] + c4v * c6;
                            int n30 = base + 3;
                            this.covUpperBuf[n30] = this.covUpperBuf[n30] + c4v * c7;
                            base = this.covUpperBase[5];
                            double c5v = c5 * vi;
                            int n31 = base;
                            this.covUpperBuf[n31] = this.covUpperBuf[n31] + c5v * c5;
                            int n32 = base + 1;
                            this.covUpperBuf[n32] = this.covUpperBuf[n32] + c5v * c6;
                            int n33 = base + 2;
                            this.covUpperBuf[n33] = this.covUpperBuf[n33] + c5v * c7;
                            base = this.covUpperBase[6];
                            double c6v = c6 * vi;
                            int n34 = base;
                            this.covUpperBuf[n34] = this.covUpperBuf[n34] + c6v * c6;
                            int n35 = base + 1;
                            this.covUpperBuf[n35] = this.covUpperBuf[n35] + c6v * c7;
                            int n36 = base = this.covUpperBase[7];
                            this.covUpperBuf[n36] = this.covUpperBuf[n36] + c7 * vi * c7;
                            continue block37;
                        }
                        case 7: {
                            int base;
                            double g = Xi[1];
                            double c2 = Xi[2];
                            double c3 = Xi[3];
                            double c4 = Xi[4];
                            double c5 = Xi[5];
                            double c6 = Xi[6];
                            int n = base = this.covUpperBase[0];
                            this.covUpperBuf[n] = this.covUpperBuf[n] + vi;
                            int n37 = base + 1;
                            this.covUpperBuf[n37] = this.covUpperBuf[n37] + vi * g;
                            int n38 = base + 2;
                            this.covUpperBuf[n38] = this.covUpperBuf[n38] + vi * c2;
                            int n39 = base + 3;
                            this.covUpperBuf[n39] = this.covUpperBuf[n39] + vi * c3;
                            int n40 = base + 4;
                            this.covUpperBuf[n40] = this.covUpperBuf[n40] + vi * c4;
                            int n41 = base + 5;
                            this.covUpperBuf[n41] = this.covUpperBuf[n41] + vi * c5;
                            int n42 = base + 6;
                            this.covUpperBuf[n42] = this.covUpperBuf[n42] + vi * c6;
                            base = this.covUpperBase[1];
                            double gv = g * vi;
                            int n43 = base;
                            this.covUpperBuf[n43] = this.covUpperBuf[n43] + gv * g;
                            int n44 = base + 1;
                            this.covUpperBuf[n44] = this.covUpperBuf[n44] + gv * c2;
                            int n45 = base + 2;
                            this.covUpperBuf[n45] = this.covUpperBuf[n45] + gv * c3;
                            int n46 = base + 3;
                            this.covUpperBuf[n46] = this.covUpperBuf[n46] + gv * c4;
                            int n47 = base + 4;
                            this.covUpperBuf[n47] = this.covUpperBuf[n47] + gv * c5;
                            int n48 = base + 5;
                            this.covUpperBuf[n48] = this.covUpperBuf[n48] + gv * c6;
                            base = this.covUpperBase[2];
                            double c2v = c2 * vi;
                            int n49 = base;
                            this.covUpperBuf[n49] = this.covUpperBuf[n49] + c2v * c2;
                            int n50 = base + 1;
                            this.covUpperBuf[n50] = this.covUpperBuf[n50] + c2v * c3;
                            int n51 = base + 2;
                            this.covUpperBuf[n51] = this.covUpperBuf[n51] + c2v * c4;
                            int n52 = base + 3;
                            this.covUpperBuf[n52] = this.covUpperBuf[n52] + c2v * c5;
                            int n53 = base + 4;
                            this.covUpperBuf[n53] = this.covUpperBuf[n53] + c2v * c6;
                            base = this.covUpperBase[3];
                            double c3v = c3 * vi;
                            int n54 = base;
                            this.covUpperBuf[n54] = this.covUpperBuf[n54] + c3v * c3;
                            int n55 = base + 1;
                            this.covUpperBuf[n55] = this.covUpperBuf[n55] + c3v * c4;
                            int n56 = base + 2;
                            this.covUpperBuf[n56] = this.covUpperBuf[n56] + c3v * c5;
                            int n57 = base + 3;
                            this.covUpperBuf[n57] = this.covUpperBuf[n57] + c3v * c6;
                            base = this.covUpperBase[4];
                            double c4v = c4 * vi;
                            int n58 = base;
                            this.covUpperBuf[n58] = this.covUpperBuf[n58] + c4v * c4;
                            int n59 = base + 1;
                            this.covUpperBuf[n59] = this.covUpperBuf[n59] + c4v * c5;
                            int n60 = base + 2;
                            this.covUpperBuf[n60] = this.covUpperBuf[n60] + c4v * c6;
                            base = this.covUpperBase[5];
                            double c5v = c5 * vi;
                            int n61 = base;
                            this.covUpperBuf[n61] = this.covUpperBuf[n61] + c5v * c5;
                            int n62 = base + 1;
                            this.covUpperBuf[n62] = this.covUpperBuf[n62] + c5v * c6;
                            int n63 = base = this.covUpperBase[6];
                            this.covUpperBuf[n63] = this.covUpperBuf[n63] + c6 * vi * c6;
                            continue block37;
                        }
                        case 6: {
                            int base;
                            double g = Xi[1];
                            double c2 = Xi[2];
                            double c3 = Xi[3];
                            double c4 = Xi[4];
                            double c5 = Xi[5];
                            int n = base = this.covUpperBase[0];
                            this.covUpperBuf[n] = this.covUpperBuf[n] + vi;
                            int n64 = base + 1;
                            this.covUpperBuf[n64] = this.covUpperBuf[n64] + vi * g;
                            int n65 = base + 2;
                            this.covUpperBuf[n65] = this.covUpperBuf[n65] + vi * c2;
                            int n66 = base + 3;
                            this.covUpperBuf[n66] = this.covUpperBuf[n66] + vi * c3;
                            int n67 = base + 4;
                            this.covUpperBuf[n67] = this.covUpperBuf[n67] + vi * c4;
                            int n68 = base + 5;
                            this.covUpperBuf[n68] = this.covUpperBuf[n68] + vi * c5;
                            base = this.covUpperBase[1];
                            double gv = g * vi;
                            int n69 = base;
                            this.covUpperBuf[n69] = this.covUpperBuf[n69] + gv * g;
                            int n70 = base + 1;
                            this.covUpperBuf[n70] = this.covUpperBuf[n70] + gv * c2;
                            int n71 = base + 2;
                            this.covUpperBuf[n71] = this.covUpperBuf[n71] + gv * c3;
                            int n72 = base + 3;
                            this.covUpperBuf[n72] = this.covUpperBuf[n72] + gv * c4;
                            int n73 = base + 4;
                            this.covUpperBuf[n73] = this.covUpperBuf[n73] + gv * c5;
                            base = this.covUpperBase[2];
                            double c2v = c2 * vi;
                            int n74 = base;
                            this.covUpperBuf[n74] = this.covUpperBuf[n74] + c2v * c2;
                            int n75 = base + 1;
                            this.covUpperBuf[n75] = this.covUpperBuf[n75] + c2v * c3;
                            int n76 = base + 2;
                            this.covUpperBuf[n76] = this.covUpperBuf[n76] + c2v * c4;
                            int n77 = base + 3;
                            this.covUpperBuf[n77] = this.covUpperBuf[n77] + c2v * c5;
                            base = this.covUpperBase[3];
                            double c3v = c3 * vi;
                            int n78 = base;
                            this.covUpperBuf[n78] = this.covUpperBuf[n78] + c3v * c3;
                            int n79 = base + 1;
                            this.covUpperBuf[n79] = this.covUpperBuf[n79] + c3v * c4;
                            int n80 = base + 2;
                            this.covUpperBuf[n80] = this.covUpperBuf[n80] + c3v * c5;
                            base = this.covUpperBase[4];
                            double c4v = c4 * vi;
                            int n81 = base;
                            this.covUpperBuf[n81] = this.covUpperBuf[n81] + c4v * c4;
                            int n82 = base + 1;
                            this.covUpperBuf[n82] = this.covUpperBuf[n82] + c4v * c5;
                            int n83 = base = this.covUpperBase[5];
                            this.covUpperBuf[n83] = this.covUpperBuf[n83] + c5 * vi * c5;
                            continue block37;
                        }
                        case 5: {
                            int base;
                            double g = Xi[1];
                            double c2 = Xi[2];
                            double c3 = Xi[3];
                            double c4 = Xi[4];
                            int n = base = this.covUpperBase[0];
                            this.covUpperBuf[n] = this.covUpperBuf[n] + vi;
                            int n84 = base + 1;
                            this.covUpperBuf[n84] = this.covUpperBuf[n84] + vi * g;
                            int n85 = base + 2;
                            this.covUpperBuf[n85] = this.covUpperBuf[n85] + vi * c2;
                            int n86 = base + 3;
                            this.covUpperBuf[n86] = this.covUpperBuf[n86] + vi * c3;
                            int n87 = base + 4;
                            this.covUpperBuf[n87] = this.covUpperBuf[n87] + vi * c4;
                            base = this.covUpperBase[1];
                            double gv = g * vi;
                            int n88 = base;
                            this.covUpperBuf[n88] = this.covUpperBuf[n88] + gv * g;
                            int n89 = base + 1;
                            this.covUpperBuf[n89] = this.covUpperBuf[n89] + gv * c2;
                            int n90 = base + 2;
                            this.covUpperBuf[n90] = this.covUpperBuf[n90] + gv * c3;
                            int n91 = base + 3;
                            this.covUpperBuf[n91] = this.covUpperBuf[n91] + gv * c4;
                            base = this.covUpperBase[2];
                            double c2v = c2 * vi;
                            int n92 = base;
                            this.covUpperBuf[n92] = this.covUpperBuf[n92] + c2v * c2;
                            int n93 = base + 1;
                            this.covUpperBuf[n93] = this.covUpperBuf[n93] + c2v * c3;
                            int n94 = base + 2;
                            this.covUpperBuf[n94] = this.covUpperBuf[n94] + c2v * c4;
                            base = this.covUpperBase[3];
                            double c3v = c3 * vi;
                            int n95 = base;
                            this.covUpperBuf[n95] = this.covUpperBuf[n95] + c3v * c3;
                            int n96 = base + 1;
                            this.covUpperBuf[n96] = this.covUpperBuf[n96] + c3v * c4;
                            int n97 = base = this.covUpperBase[4];
                            this.covUpperBuf[n97] = this.covUpperBuf[n97] + c4 * vi * c4;
                            continue block37;
                        }
                        case 4: {
                            int base;
                            double g = Xi[1];
                            double c2 = Xi[2];
                            double c3 = Xi[3];
                            int n = base = this.covUpperBase[0];
                            this.covUpperBuf[n] = this.covUpperBuf[n] + vi;
                            int n98 = base + 1;
                            this.covUpperBuf[n98] = this.covUpperBuf[n98] + vi * g;
                            int n99 = base + 2;
                            this.covUpperBuf[n99] = this.covUpperBuf[n99] + vi * c2;
                            int n100 = base + 3;
                            this.covUpperBuf[n100] = this.covUpperBuf[n100] + vi * c3;
                            base = this.covUpperBase[1];
                            double gv = g * vi;
                            int n101 = base;
                            this.covUpperBuf[n101] = this.covUpperBuf[n101] + gv * g;
                            int n102 = base + 1;
                            this.covUpperBuf[n102] = this.covUpperBuf[n102] + gv * c2;
                            int n103 = base + 2;
                            this.covUpperBuf[n103] = this.covUpperBuf[n103] + gv * c3;
                            base = this.covUpperBase[2];
                            double c2v = c2 * vi;
                            int n104 = base;
                            this.covUpperBuf[n104] = this.covUpperBuf[n104] + c2v * c2;
                            int n105 = base + 1;
                            this.covUpperBuf[n105] = this.covUpperBuf[n105] + c2v * c3;
                            int n106 = base = this.covUpperBase[3];
                            this.covUpperBuf[n106] = this.covUpperBuf[n106] + c3 * vi * c3;
                            continue block37;
                        }
                        case 3: {
                            int base;
                            double g = Xi[1];
                            double c2 = Xi[2];
                            int n = base = this.covUpperBase[0];
                            this.covUpperBuf[n] = this.covUpperBuf[n] + vi;
                            int n107 = base + 1;
                            this.covUpperBuf[n107] = this.covUpperBuf[n107] + vi * g;
                            int n108 = base + 2;
                            this.covUpperBuf[n108] = this.covUpperBuf[n108] + vi * c2;
                            int n109 = base = this.covUpperBase[1];
                            this.covUpperBuf[n109] = this.covUpperBuf[n109] + g * vi * g;
                            int n110 = base + 1;
                            this.covUpperBuf[n110] = this.covUpperBuf[n110] + g * vi * c2;
                            int n111 = base = this.covUpperBase[2];
                            this.covUpperBuf[n111] = this.covUpperBuf[n111] + c2 * vi * c2;
                            continue block37;
                        }
                        case 2: {
                            int base;
                            double g = Xi[1];
                            int n = base = this.covUpperBase[0];
                            this.covUpperBuf[n] = this.covUpperBuf[n] + vi;
                            int n112 = base + 1;
                            this.covUpperBuf[n112] = this.covUpperBuf[n112] + vi * g;
                            int n113 = base = this.covUpperBase[1];
                            this.covUpperBuf[n113] = this.covUpperBuf[n113] + g * vi * g;
                            continue block37;
                        }
                        case 1: {
                            int n = this.covUpperBase[0];
                            this.covUpperBuf[n] = this.covUpperBuf[n] + vi;
                        }
                    }
                }
            } else {
                for (i2 = 0; i2 < nInd; ++i2) {
                    double vi = this.bufV[i2];
                    double[] Xi4 = this.X[i2];
                    double gty = Xi4[1];
                    int p = this.covUpperBase[0];
                    int n = p++;
                    this.covUpperBuf[n] = this.covUpperBuf[n] + vi;
                    int n114 = p++;
                    this.covUpperBuf[n114] = this.covUpperBuf[n114] + vi * gty;
                    for (int c = 2; c < this.nP; ++c) {
                        int n115 = p++;
                        this.covUpperBuf[n115] = this.covUpperBuf[n115] + vi * Xi4[c];
                    }
                    p = this.covUpperBase[1];
                    double gty_vi = gty * vi;
                    int n116 = p++;
                    this.covUpperBuf[n116] = this.covUpperBuf[n116] + gty_vi * gty;
                    for (int c = 2; c < this.nP; ++c) {
                        int n117 = p++;
                        this.covUpperBuf[n117] = this.covUpperBuf[n117] + gty_vi * Xi4[c];
                    }
                    for (int r = 2; r < this.nP; ++r) {
                        p = this.covUpperBase[r];
                        double xrvi = Xi4[r] * vi;
                        for (int c = r; c < this.nP; ++c) {
                            int n118 = p++;
                            this.covUpperBuf[n118] = this.covUpperBuf[n118] + xrvi * Xi4[c];
                        }
                    }
                }
            }
            for (int r = 0; r < this.nP; ++r) {
                int p = this.covUpperBase[r];
                int c = r;
                while (c < this.nP) {
                    double v = this.covUpperBuf[p];
                    this.covarianceMatrix.setQuick(r, c, v);
                    if (r != c) {
                        this.covarianceMatrix.setQuick(c, r, v);
                    }
                    ++c;
                    ++p;
                }
            }
            try {
                CholeskyDecomposition chol = new CholeskyDecomposition(this.covarianceMatrix);
                this.covarianceMatrix = chol.isSymmetricPositiveDefinite() ? chol.solve(this.identityMatrix) : ALG.inverse(this.covarianceMatrix);
            }
            catch (Exception e) {
                this.covarianceMatrix = ALG.inverse(this.covarianceMatrix);
            }
            for (i = 0; i < nInd; ++i) {
                this.bufT3[i] = this.Y[i] - this.bufP[i];
            }
            Arrays.fill(this.bufTemp, 0.0);
            if (smallDim) {
                for (i = 0; i < nInd; ++i) {
                    double t3i = this.bufT3[i];
                    Xi = this.X[i];
                    switch (this.nP) {
                        case 8: {
                            this.bufTemp[7] = this.bufTemp[7] + Xi[7] * t3i;
                        }
                        case 7: {
                            this.bufTemp[6] = this.bufTemp[6] + Xi[6] * t3i;
                        }
                        case 6: {
                            this.bufTemp[5] = this.bufTemp[5] + Xi[5] * t3i;
                        }
                        case 5: {
                            this.bufTemp[4] = this.bufTemp[4] + Xi[4] * t3i;
                        }
                        case 4: {
                            this.bufTemp[3] = this.bufTemp[3] + Xi[3] * t3i;
                        }
                        case 3: {
                            this.bufTemp[2] = this.bufTemp[2] + Xi[2] * t3i;
                        }
                        case 2: {
                            this.bufTemp[1] = this.bufTemp[1] + Xi[1] * t3i;
                        }
                        case 1: {
                            this.bufTemp[0] = this.bufTemp[0] + t3i;
                        }
                    }
                }
            } else {
                for (i = 0; i < nInd; ++i) {
                    double t3i = this.bufT3[i];
                    Xi = this.X[i];
                    this.bufTemp[0] = this.bufTemp[0] + t3i;
                    for (int j = 1; j < this.nP; ++j) {
                        int n = j;
                        this.bufTemp[n] = this.bufTemp[n] + Xi[j] * t3i;
                    }
                }
            }
            Arrays.fill(this.bufNcoef, 0.0);
            for (int r = 0; r < this.nP; ++r) {
                double sum = 0.0;
                for (int c = 0; c < this.nP; ++c) {
                    sum += this.covarianceMatrix.getQuick(r, c) * this.bufTemp[c];
                }
                this.bufNcoef[r] = sum;
            }
            double delta = 0.0;
            int j = 0;
            while (j < this.nP) {
                double dj = this.bufNcoef[j];
                delta += Math.abs(dj);
                int n = j++;
                this.coef[n] = this.coef[n] + dj;
            }
            if (delta < this.tolerateDiff) {
                converge = true;
            }
            if (++it <= this.maxIterTime) continue;
            return false;
        }
        ++this.covEpoch;
        ++this.coefEpoch;
        this.orciEpoch = -1L;
        this.ciEpoch = -1L;
        this.zvEpoch = -1L;
        this.orEpoch = -1L;
        this.seEpoch = -1L;
        this.varEpoch = -1L;
        return true;
    }

    public double getLnLk() {
        double lnlk = 0.0;
        for (int i = 0; i < this.nInd; ++i) {
            double t = this.coef[0];
            for (int j = 1; j < this.nP; ++j) {
                t += this.coef[j] * this.X[i][j];
            }
            double p = t >= 0.0 ? 1.0 / (1.0 + Math.exp(-t)) : Math.exp(t) / (1.0 + Math.exp(t));
            lnlk += this.Y[i] == 1.0 ? Math.log(p) : Math.log(1.0 - p);
        }
        return lnlk;
    }

    public double getModelPValue() throws Exception {
        double pi0 = 0.0;
        for (int i = 0; i < this.nInd; ++i) {
            pi0 += this.Y[i];
        }
        double null_LL = (double)this.nInd * ((pi0 /= (double)this.nInd) * Math.log(pi0 / (1.0 - pi0)) + Math.log(1.0 - pi0));
        double chiSqure = 2.0 * (this.getLnLk() - null_LL);
        return Probability.chiSquareComplemented(this.nP - 1, chiSqure);
    }

    public double[] calcDevianceResiduals() {
        double[] expectedVs = new double[this.nInd];
        for (int i = 0; i < this.nInd; ++i) {
            double eta = this.coef[0];
            for (int j = 1; j < this.coef.length; ++j) {
                eta += this.coef[j] * this.X[i][j];
            }
            double p = 1.0 / (1.0 + Math.exp(-eta));
            expectedVs[i] = this.Y[i] == 1.0 ? Math.sqrt(-2.0 * Math.log(p)) : -Math.sqrt(-2.0 * Math.log(1.0 - p));
        }
        return expectedVs;
    }

    public double getCoefPValue(int testParameter) throws Exception {
        double[] var = this.getVar();
        double se = Math.sqrt(var[testParameter]);
        double Z = this.coef[testParameter] / se;
        return Probability.chiSquareComplemented(1.0, Z * Z);
    }

    public double getCoefPValueWithTTest(int testParameter) throws Exception {
        double[] var = this.getVar();
        double se = Math.sqrt(var[testParameter]);
        double Z = this.coef[testParameter] / se;
        return 2.0 * Probability.normal(-Math.abs(Z));
    }

    public double getCoef(int testParameter) throws Exception {
        return this.coef[testParameter];
    }

    public double getNagelkerkeRSquare() {
        double pi0 = 0.0;
        for (int i = 0; i < this.nInd; ++i) {
            pi0 += this.Y[i];
        }
        double null_LL = (double)this.nInd * ((pi0 /= (double)this.nInd) * Math.log(pi0 / (1.0 - pi0)) + Math.log(1.0 - pi0));
        double r = 1.0 - Math.pow(Math.exp(null_LL - this.getLnLk()), 2.0 / (double)this.nInd);
        return r /= 1.0 - Math.pow(Math.exp(null_LL), 2.0 / (double)this.nInd);
    }

    public double[] getVar() {
        if (this.outVar == null || this.outVar.length != this.nP || this.varEpoch != this.covEpoch) {
            if (this.outVar == null || this.outVar.length != this.nP) {
                this.outVar = new double[this.nP];
            }
            for (int i = 0; i < this.nP; ++i) {
                this.outVar[i] = this.covarianceMatrix.getQuick(i, i);
            }
            this.varEpoch = this.covEpoch;
            this.orciEpoch = -1L;
            this.ciEpoch = -1L;
            this.zvEpoch = -1L;
            this.seEpoch = -1L;
        }
        return this.outVar;
    }

    public double[] getSE() {
        if (this.outSE == null || this.outSE.length != this.nP || this.seEpoch != this.covEpoch) {
            double[] var = this.getVar();
            if (this.outSE == null || this.outSE.length != this.nP) {
                this.outSE = new double[this.nP];
            }
            for (int i = 0; i < this.nP; ++i) {
                this.outSE[i] = Math.sqrt(var[i]);
            }
            this.seEpoch = this.covEpoch;
            this.orciEpoch = -1L;
            this.ciEpoch = -1L;
            this.zvEpoch = -1L;
        }
        return this.outSE;
    }

    public double[] getOR() {
        if (this.outOR == null || this.outOR.length != this.nP || this.orEpoch != this.coefEpoch) {
            if (this.outOR == null || this.outOR.length != this.nP) {
                this.outOR = new double[this.nP];
            }
            for (int i = 0; i < this.nP; ++i) {
                this.outOR[i] = Math.exp(this.coef[i]);
            }
            this.orEpoch = this.coefEpoch;
        }
        return this.outOR;
    }

    public double[] getZv() {
        if (this.outZv == null || this.outZv.length != this.nP || this.zvEpoch != Math.max(this.coefEpoch, this.covEpoch)) {
            double[] se = this.getSE();
            if (this.outZv == null || this.outZv.length != this.nP) {
                this.outZv = new double[this.nP];
            }
            for (int i = 0; i < this.nP; ++i) {
                this.outZv[i] = this.coef[i] / se[i];
            }
            this.zvEpoch = Math.max(this.coefEpoch, this.covEpoch);
        }
        return this.outZv;
    }

    public double[][] getConfidenceInterval() {
        if (this.outCI == null || this.outCI.length != this.nP || this.ciEpoch != Math.max(this.coefEpoch, this.covEpoch)) {
            double[] se = this.getSE();
            if (this.outCI == null || this.outCI.length != this.nP) {
                this.outCI = new double[this.nP][2];
            }
            for (int i = 0; i < this.nP; ++i) {
                double s = se[i];
                this.outCI[i][0] = this.coef[i] - 1.96 * s;
                this.outCI[i][1] = this.coef[i] + 1.96 * s;
            }
            this.ciEpoch = Math.max(this.coefEpoch, this.covEpoch);
        }
        return this.outCI;
    }

    public double[][] getORConfidenceInterval() {
        if (this.outORCI == null || this.outORCI.length != this.nP || this.orciEpoch != Math.max(this.coefEpoch, this.covEpoch)) {
            double[] se = this.getSE();
            if (this.outORCI == null || this.outORCI.length != this.nP) {
                this.outORCI = new double[this.nP][2];
            }
            for (int i = 0; i < this.nP; ++i) {
                double s = se[i];
                this.outORCI[i][0] = Math.exp(this.coef[i] - 1.96 * s);
                this.outORCI[i][1] = Math.exp(this.coef[i] + 1.96 * s);
            }
            this.orciEpoch = Math.max(this.coefEpoch, this.covEpoch);
        }
        return this.outORCI;
    }

    public double getGivenProbability(double[] scores) {
        double p = this.coef[0];
        for (int i = 1; i < this.coef.length; ++i) {
            p += this.coef[i] * scores[i];
        }
        p = 1.0 + this.priorCorrectionFactor * Math.exp(-p);
        return 1.0 / p;
    }

    public double[] getCoefs() {
        return this.coef;
    }

    public String toString() {
        int j;
        double[] coef_SE = this.getSE();
        StringBuilder result = new StringBuilder();
        if (this.coef == null) {
            return result.append(": No model built yet.").toString();
        }
        result.append("\nCoefficients...\n").append("Variable      Coeff.      td. Error       z value      Pr(>|z|)\n");
        try {
            for (j = 1; j < this.nP; ++j) {
                result.append(String.format("%8.0f", Float.valueOf(j)));
                result.append(" ").append(String.format("%10.4f", this.coef[j]));
                result.append(" ").append(String.format("%10.4f", coef_SE[j]));
                result.append(" ").append(String.format("%10.4f", this.coef[j] / coef_SE[j]));
                result.append(" ").append(String.format("%10.4f", Probability.chiSquareComplemented(1.0, Math.pow(this.coef[j] / coef_SE[j], 2.0))));
                result.append("\n");
            }
            result.append("Intercept ");
            result.append(" ").append(String.format("%10.4f", this.coef[0]));
            result.append(" ").append(String.format("%10.4f", coef_SE[0]));
            result.append(" ").append(String.format("%10.4f", this.coef[0] / coef_SE[0]));
            result.append(" ").append(String.format("%10.4f", Probability.chiSquareComplemented(1.0, Math.pow(this.coef[0] / coef_SE[0], 2.0))));
            result.append("\n");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        result.append("\nOdds Ratios...\n").append("Variable         O.R.\n");
        for (j = 1; j < this.nP; ++j) {
            result.append(String.format("%8.0f", Float.valueOf(j)));
            double ORc = Math.exp(this.coef[j]);
            result.append(" ").append(ORc > 1.0E10 ? "" + ORc : String.format("%12.4f", ORc));
            result.append("\n");
        }
        result.append("Significance of the model with these variable(s) ");
        result.append(" p-value ");
        try {
            result.append(this.getModelPValue());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        result.append("\n");
        return result.toString();
    }

    public void reset(double[][] X2, double[] Y, boolean addIntercept) {
        if (!addIntercept) {
            this.setX(X2);
        } else {
            double[][] newX = new double[X2.length][X2[0].length + 1];
            for (int i = 0; i < X2.length; ++i) {
                newX[i][0] = 1.0;
                System.arraycopy(X2[i], 0, newX[i], 1, X2[0].length);
            }
            this.X = newX;
            this.nP = this.X[0].length;
        }
        this.setY(Y);
    }

    public void reset() {
        this.nP = 0;
        this.nInd = 0;
        this.coef = null;
        this.covarianceMatrix = null;
        this.Y = null;
        this.X = null;
        this.invalidateBuffersOnDimChange();
    }

    public static void main(String[] args) throws Exception {
        int nrow = 10000;
        int ncol = 3;
        Random random = new Random(1000L);
        double[][] X2 = new double[nrow][ncol];
        double[] Y = new double[nrow];
        for (int i = 0; i < nrow; ++i) {
            X2[i][0] = random.nextInt(3);
            for (int j = 1; j < ncol; ++j) {
                X2[i][j] = random.nextDouble();
            }
            Y[i] = random.nextInt(2);
        }
        System.out.println("Testing Optimized LogisticRegressionGty...");
        long l = System.currentTimeMillis();
        LogisticRegressionGty logisticRegression = new LogisticRegressionGty(X2, Y, true);
        logisticRegression.fitLM5();
        double[] coefs = logisticRegression.getCoefs();
        double p = logisticRegression.getCoefPValueWithTTest(1);
        System.out.println("Fit time: " + (System.currentTimeMillis() - l) + " ms");
        System.out.println("Coefficients: " + Arrays.toString(coefs));
        System.out.println("P-value (Genotype): " + p);
        System.out.println("SE: " + Arrays.toString(logisticRegression.getSE()));
        System.out.println("OR: " + Arrays.toString(logisticRegression.getOR()));
    }
}

