/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.stat;

import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.executor.ThreadQueue;
import edu.sysu.pmglab.stat.LinearRegression;
import edu.sysu.pmglab.stat.Summary;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;

public enum RobustRegression {
    INSTANCE;


    public boolean iterativeWeighter(double[] data, double[] finalWeights, int maxIterN) {
        int tissueSizeOrg = data.length;
        LinearRegression linReg = new LinearRegression();
        boolean success = false;
        List<double[]> indexY = new List<double[]>();
        DoubleArrayListComparator cp = new DoubleArrayListComparator(0);
        double[] coef = new double[2];
        double MINDIFF = 1.0E-8;
        Arrays.fill(coef, 0.0);
        for (int j = 0; j < tissueSizeOrg; ++j) {
            if (Double.isNaN(data[j])) continue;
            indexY.add(new double[]{data[j], j});
        }
        int tissueSize = indexY.size();
        if (tissueSize < 2) {
            return success;
        }
        indexY.sort(cp);
        double[][] x = new double[tissueSize][2];
        double[] y = new double[tissueSize];
        double[] weights0 = new double[tissueSize];
        double[] weights1 = new double[tissueSize];
        Arrays.fill(weights0, 1.0);
        for (int j = 0; j < tissueSize; ++j) {
            y[j] = ((double[])indexY.get(j))[0];
            x[j][0] = 1.0;
            x[j][1] = j + 1;
        }
        int iter = 0;
        do {
            int j;
            for (j = 0; j < tissueSize; ++j) {
                y[j] = ((double[])indexY.get(j))[0];
            }
            double median = Summary.mean(y, weights0, true);
            double sd = Summary.stddev(y, weights0);
            for (j = 0; j < tissueSize; ++j) {
                y[j] = (y[j] - median) / sd;
                if (!(y[j] <= 0.0)) continue;
            }
            success = linReg.robustLinearRegression(y, x, 100, 1);
            if (!success) {
                // empty if block
            }
            System.arraycopy(linReg.getWeights(), 0, weights1, 0, weights1.length);
            Summary.standWeight(weights1);
            double maxDiff = Math.abs(weights0[0] - weights1[0]);
            for (int i = 1; i < weights0.length; ++i) {
                double diff = Math.abs(weights0[i] - weights1[i]);
                if (!(diff > maxDiff)) continue;
                maxDiff = diff;
            }
            if (maxDiff < MINDIFF) break;
            System.arraycopy(weights1, 0, weights0, 0, weights0.length);
        } while (++iter < maxIterN);
        if (iter >= maxIterN) {
            return false;
        }
        System.arraycopy(linReg.getWeights(), 0, weights0, 0, weights0.length);
        double[] residual = linReg.getResiduals();
        for (int j = 0; j < tissueSize; ++j) {
            finalWeights[(int)((double[])indexY.get((int)j))[1]] = weights0[j];
        }
        return success;
    }

    public void removeOutlierRow(List<String> regionLabelTrunc, List<double[]> scoreListTrunc, int startColIndex, int threadNum) {
        int size = scoreListTrunc.size();
        int colNum = scoreListTrunc.get(0).length;
        HashSet outlierIndexes = new HashSet();
        ThreadQueue threadPool = new ThreadQueue(threadNum);
        double baseWeight = 0.01;
        int j = startColIndex;
        while (j < colNum) {
            int finalJ = j++;
            threadPool.addTask((status, context1) -> {
                int i;
                double[] weights = new double[size];
                double[] values2 = new double[size];
                Arrays.fill(weights, Double.NaN);
                for (i = 0; i < size; ++i) {
                    values2[i] = ((double[])scoreListTrunc.get(i))[finalJ];
                }
                INSTANCE.iterativeWeighter(values2, weights, 100);
                for (i = 0; i < size; ++i) {
                    if (weights[i] > baseWeight) continue;
                    ThreadQueue threadQueue = threadPool;
                    synchronized (threadQueue) {
                        outlierIndexes.add(i);
                        continue;
                    }
                }
            });
        }
        threadPool.close();
        if (!outlierIndexes.isEmpty()) {
            List<String> regionLabelTrunc0 = new List<String>();
            List<double[]> scoreListTrunc0 = new List<double[]>();
            for (int i = 0; i < size; ++i) {
                if (outlierIndexes.contains(i)) continue;
                regionLabelTrunc0.add(regionLabelTrunc.get(i));
                scoreListTrunc0.add(scoreListTrunc.get(i));
            }
            regionLabelTrunc.clear();
            scoreListTrunc.clear();
            regionLabelTrunc.addAll(regionLabelTrunc0);
            scoreListTrunc.addAll(scoreListTrunc0);
        }
    }

    static class DoubleArrayListComparator
    implements Comparator<double[]> {
        int index;

        public DoubleArrayListComparator(int index) {
            this.index = index;
        }

        @Override
        public int compare(double[] arg0, double[] arg1) {
            return Double.compare(arg0[this.index], arg1[this.index]);
        }
    }
}

